/*****************************************************************************/
/*****************************************************************************/
/* pth_rtsig.c                                                               */
/*                                                                           */
/* Support for Posix rt signals over Linux. In a separate source as the      */
/* Linux kernel headers clash with glibc :-(                                 */
/*                                                                           */
/* Copyright (c) 1999, K A Fraser                                            */
/*****************************************************************************/
/*****************************************************************************/

#define __KERNEL__
#include <linux/unistd.h>
#include <sys/types.h>
#include <linux/types.h>
#include <sys/times.h>
#include <linux/signal.h>
#include <linux/errno.h>
#undef __KERNEL__


/*
 * rt_sigprocmask: Posix.1 (1996) rt version of sigprocmask().
 */
_syscall4(int,                rt_sigprocmask, 
          int,                how, 
          sigset_t *,         set, 
          sigset_t *,         oset,
          size_t,             sigsetsize);

/*
 * rt_sigaction: Posix.1 (1996) rt version of sigaction().
 */
_syscall4(int,                rt_sigaction,
          int,                sig,
          struct sigaction *, act,
          struct sigaction *, oact,
          size_t,             sigsetsize);


typedef void sigfunc_rt(int, siginfo_t *, void *);

int set_rt_sighandler(int signum, sigfunc_rt *func)
{
    sigset_t set;
    struct sigaction act;
    int ret;

    /*
     * Set up the sigaction structure.
     */
    act.sa_handler = (void *)func;
    sigemptyset(&(act.sa_mask));
    act.sa_flags = SA_SIGINFO | SA_INTERRUPT;

    /*
     * Tell the kernel about it.
     */
    if ( (ret = rt_sigaction(signum, &act, NULL, sizeof(sigset_t))) < 0 )
    {
        printf("rt_sigaction error: %s (%d)\n", strerror(errno), errno);
    }

    /*
     * Unblock the signal.
     */
    sigemptyset(&set);
    sigaddset((sigset_t*)(((caddr_t)&set)+4), signum);
    rt_sigprocmask(SIG_UNBLOCK, &set, NULL, sizeof(sigset_t));

    return(ret);
}

