/*
 * All modifications are copyright (c) 2000, K A Fraser.
 * 
 * Please note the original copyright and license details below.
 */

/*
 * Copyright (C) 1997 Massachusetts Institute of Technology 
 *
 * This software is being provided by the copyright holders under the
 * following license. By obtaining, using and/or copying this software,
 * you agree that you have read, understood, and will comply with the
 * following terms and conditions:
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose and without fee or royalty is
 * hereby granted, provided that the full text of this NOTICE appears on
 * ALL copies of the software and documentation or portions thereof,
 * including modifications, that you make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS. COPYRIGHT
 * HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE OR
 * DOCUMENTATION.
 *
 * The name and trademarks of copyright holders may NOT be used in
 * advertising or publicity pertaining to the software without specific,
 * written prior permission. Title to copyright in this software and any
 * associated documentation will at all times remain with copyright
 * holders. See the file AUTHORS which should have accompanied this software
 * for a list of all copyright holders.
 *
 * This file may be derived from previously copyrighted software. This
 * copyright applies only to those changes made by the copyright
 * holders listed in the AUTHORS file. The rest of this file is covered by
 * the copyright notices, if any, listed below.
 */

/* This code is pretty messy.  Should rewrite */
/* Make sure that you update prev_val */

#include "dpf-internal.h"

Atom dpf_active[DPF_MAXFILT];/* pointer to last node in active filters */
Atom dpf_base;           /* base of the tree */

static int dpf_overlap;

static Atom dpf_merge(Atom dpf, union ir *ir, int pid);

extern void *dpf_ret_zero;
int (*dpf_iptr)(uint8 *msg, unsigned nbytes);

/* Create an atom: many of these fields can be filled in to 0 by default. */
static Atom 
mkatom(Atom parent, Atom *orp, Atom or, Atom child, int refcnt, int pid, union ir ir) 
{
    Atom a;
    
    /* Should have a more efficient allocation mechanism */
    a = (Atom)malloc(sizeof *a);
    if ( !a ) 
    {
        printf("mkatom: could not malloc memory for atom\n");
        return NULL;
    }
    memset(a, 0, sizeof *a);
    
    a->parent = parent;
    a->orp = orp;
    a->or = or;
    a->child = child;
    
    a->ht = 0;
    
    a->refcnt = refcnt;
    a->pid = pid;
    
    a->ir = ir;
    
    return a;
}

/* returns 1 on equality, -1 on lhs equality, 0 on inequality. */
static int isequal(Atom a, union ir *ir2) 
{
    union ir *ir1 = &a->ir;
    
    if ( ir1->eq.op != ir2->eq.op ) return 0;
    
    /* is an eq? */
    if ( dpf_iseq(ir1->eq.op) ) 
    {
        /* check for structural equality */
        return (ir1->eq.offset != ir2->eq.offset || 
                ir1->eq.mask != ir2->eq.mask ||
                ir1->eq.nbits != ir2->eq.nbits) ? 
            0 : ((ir1->eq.val == ir2->eq.val) ? 1 : -1);
    }
    else if ( dpf_isshifti(ir1->eq.op) )
    {
        return (ir1->shifti.shift == ir2->shifti.shift &&
                ir1->shifti.ext   == ir2->shifti.ext);
    }
    demand(dpf_isshift(ir1->eq.op), bogus op!);
    
    /* is a shift */
    return (ir1->shift.shift  == ir2->shift.shift &&
            ir1->shift.offset == ir2->shift.offset &&
            ir1->shift.mask   == ir2->shift.mask &&
            ir1->shift.nbits  == ir2->shift.nbits &&
            ir1->shift.ext    == ir2->shift.ext);
}

/*
 * Create a string of atoms from IR. Returns the last one and pointer
 * to first. 
 */
static Atom swizzle(union ir *ir, int pid, Atom *first, int alignment) 
{
    Atom a, n;

    for ( n = *first = a = 0; ir->eq.op != DPF_OP_END; ir++, a = n )  
    {
        n = mkatom(a, 0, 0, 0, 1, 0, *ir);
        if ( !n ) return NULL;
        
        if ( a )
        {
            a->child = n;
        }
        else
        {
            *first = n;
        }
        
        if ( dpf_isshift(ir->eq.op) )
        {
            alignment = dpf_compute_shift_alignment(&n->ir, alignment);
        }
        else if ( dpf_isshifti(ir->eq.op) )
        {
            alignment = dpf_compute_shifti_alignment(&n->ir, alignment);
        }
    }
    if ( !n ) return 0;
    n->pid = pid;
    return n;
}

/* Insert the rest of the tree in. */
/* 
 * Brain-dead hash function at the moment.  Should be selecting
 * between them. 
 */
static inline unsigned hash(Ht ht, uint32 val) 
{
    return val & (ht->htsz - 1);
}

Atom ht_lookup(Ht ht, uint32 val) {
    Atom hte;

    for ( hte = ht->ht[hash(ht, val)]; hte; hte = hte->or )
    {
        if ( hte->ir.eq.val == val ) break;
    }
    return hte;
}

/* Standard thing: hash into ht.  At some point we would rehash. */
static Atom ht_insert(Atom a, int pid, union ir ir) {
	Atom hte, *p;
	Ht ht;

	ht = a->ht;
	demand(ht, bogus ht);
	demand(!a->child, bogus child!);

	if(!(hte = ht_lookup(ht, ir.eq.val))) { 
		p = &ht->ht[hash(ht, ir.eq.val)];
		hte = mkatom(a, 0, 0, 0, 1, pid, ir);
		if (!hte)
		  return NULL;

		hte->orp = p;
		if(*p) {
			hte->or = *p;
			(*p)->orp = &hte->or;
			demand(hte->orp == p, bogus p);
		}
		*p = hte;
		ht->ent++;
	}
	return hte;
}

static void delete_or(Atom a) {
	/* remove from the list. */
	if((*a->orp = a->or))
		a->or->orp = a->orp;
}

/* insert b before/after a */
enum { BEFORE, AFTER };
static void create_or(Atom a, Atom new, int where) {
	Atom p;

	if(where == AFTER) {
		if(a->or)	
			a->or->orp = &new->or;
		new->or = a->or;
		new->orp = &a->or;
		a->or = new;
		new->parent = a->parent;
	/* there is someone before us: insert new after them */
	} else if(a->orp) {
		create_or(*a->orp, new, AFTER);
		return;
	/* only need to worry about insertions of first atom in list. */
	} else {
		new->or = a;
		a->orp = &new->or;

		/* handle case where we are the first atom. */
		if(!(p = new->parent = a->parent)) {
			if(a == dpf_base)
				dpf_base = new;
		} else if(p->child) {
			demand(p->child==a, bogus child!);
			p->child = new;
		}
	}
}

/* Delete ht entry - complication from the ht organization. */
static void ht_delete(Ht ht, uint32 val) {
	Atom hte;

	hte = ht_lookup(ht, val);
	demand(hte, deleting a bogus hte);
	ht->ent--;

	delete_or(hte);
}


/* Install ir in the hash table, or create a new one if necessary. */
static int ht_newht(Atom a) {
	Ht ht;
	Atom hte, child;

	/* create a hash table */
	a->ht = ht = (Ht)malloc(sizeof *ht);
        memset(ht, 0, sizeof *ht);
	ht->htsz = DPF_INITIAL_HTSZ;
	ht->ent = 0;
	ht->coll = 1;	/* conservative (for the moment). */

	child = a->child;
	a->child = 0;

	/* insert the first element & set ptr to a. */
	hte = ht_insert(a, a->pid, a->ir);
	if (!hte)
	  return -1;
	hte->refcnt = a->refcnt - 1;

	hte->child = child;

	/* update child links */
	for(; child; child = child->or) {
		demand(child->parent == a, bogus parent!);
		child->parent = hte;
	}

	if(a->pid) {
		demand(dpf_active[a->pid], bogus pid);
		dpf_active[a->pid] = hte;
		a->pid = 0;
	}
	return 0;
}

/* 
 * Insert before or with smaller nbits; used to enforce "longest
 * match" in the presence of atom coalescing.
 */
static void insert_or(Atom a, Atom new) {
	Atom succ;

	new->orp = 0;
	for ( succ = 0; a; succ = a, a = a->or )
        {
            /* insert new before a */
            if ( a->ir.eq.nbits < new->ir.eq.nbits )  
            {
                create_or(a, new, BEFORE);
                return;
            }
        }
	create_or(succ, new, AFTER);
}

/*
 * If they are an eq & use the same mask, but compare to a different 
 * 	constants, create a hash table.
 * If there are or nodes, check against them
 * Otherwise, add as an or node.
 * Returns NULL on error;
 *
 * [ TODO ]
 * During insertion we aggregate checkpoints.  A checkpoint is the
 * value of the largest offset of straightline code that we are
 * guarenteed to execute.  The algorithm for finding it is:
 *	1. Everytime we encounter an or-list, a hash table, a shift
 *	or a pid, we set the checkpoint ptr to it.
 *
 *	2. When we finish inserting a node (either we run out of ir
 *	and insert a short filter or we encounter a ht/or-list and 
 * 	swizzle in the rest) we update the last ckpt to hold the new 
 * 	information:
 *		the promoted node's offset becomes the old ckpt's, the ckpt's 
 *	 	become the promoted nodes offset and the swizzled list (if
 * 		any) is assigned the offset of its last node.

		Is this node a checkpoint?
		if(a->or || a->ht || dpf_isshift(a->ir.eq.op) || a->pid)
			ckpt = a;
 */

static Atom dpf_merge(Atom a, union ir *ir, int pid) 
{
    Atom succ, last, first, hte, first_or;
    int res, alignment;
    
    alignment = DPF_MSG_ALIGN;
    succ = 0;
    res = -2;

    for ( ; a && ir->eq.op != DPF_OP_END; succ = a, a = a->child, ir++ ) 
    {
        /* Walk down or's, checking for match. */
        for ( first_or = a; a != NULL; succ = a, a = a->or )
        { 
            if ( (res = isequal(a, ir)) ) break;
        }
        
        /* if new alignment, update. */
        if ( a && dpf_isshift(a->ir.eq.op) )  alignment = a->ir.shift.align;
        if ( a && dpf_isshifti(a->ir.eq.op) ) alignment = a->ir.shifti.align;

        /* 
         * Insert an OR branch.  To ensure that longest match
         * is met, we sort the or's based on the number of
         * bytes loaded from the message.
         */
        if ( !res ) 
        {
            last = swizzle(ir, pid, &first, alignment);
            insert_or(first_or, first);
            return last;
        }
        
        /* Don't have to create an or branch. */
        a->refcnt++;
        
        /* Matched: continue to the next node. */
        if ( res == 1 && !a->ht ) continue;
        
        /* Create ht and insert a. */
        if ( !a->ht && (ht_newht(a) < 0) ) return NULL;
        
        /* continue merging, unless there is no more. */
        if ( (hte = ht_lookup(a->ht, ir->eq.val)) ) 
        {
            hte->refcnt++; 
            a = hte;
        } 
        else 
        {
            /* create an entry for this atom. */
            a = ht_insert(a, 0, *ir);

            /* string together the rest */
            if ( (last = swizzle(ir+1, pid, &a->child, alignment)) ) 
            {
                a->child->parent = a;
                return last;
            } 
            else 
            {
                a->pid = pid;
                return a;
            }
        }
    }
    
    /* Long filter */
    if ( !a ) 
    {
        /* Merged all the way down. */
        if ( ir->eq.op == DPF_OP_END ) 
        {
            dpf_overlap = 1;
            return succ;
        }
        last = swizzle(ir, pid, &first, alignment);
        
        if ( !succ )
        {
            /* There are no entries in the trie: insert it. */
            dpf_base = first;
        }
        else 
        {
            succ->child = first;
            first->parent = succ;
        }
        return last;
        /* Short filter. */
    } 
    else 
    {
        demand(succ, nil filter);
        
        /* filter overlap? */
        if ( succ->pid )
        {
            dpf_overlap = 1;
        }
        else
        {
            succ->pid = pid;
        }

        return succ;
    }
}

/* delete filter from tree. */
int dpf_delete(unsigned pid) 
{
    Atom a, p, succ;
    static void *freelist[DPF_MAXELEM * 2 + 2]; /* Yikes! Keep stack small! */
    void **fl = freelist;
    Ht ht;

    if ( pid >= DPF_MAXFILT || !(a = dpf_active[pid]) )  return DPF_BOGUSID;
	
    /* nuke the pid. */
    if ( !dpf_overlap ) a->pid = 0;	

    /* Walk up the tree, deleting every entry. */
    for ( succ = 0; a; succ = a, a = p ) 
    {
        p = a->parent;
        a->refcnt--;

        /* if it becomes a hash table with one entry, coalesce. */
        if((ht = a->ht) && ht->ent == 1) {
            int i, n;
            Atom c, child;
            
            /* find the remaining entry. */
            for(c = 0, i = 0, n = ht->htsz; i < n; i++) {
                if(!ht->ht[i])
                    continue;
                demand(!c, should only have one entry!);
                demand(!ht->ht[i]->or, should not be chained!);
                
                c = ht->ht[i];
            }
            demand(a->refcnt == c->refcnt, bogus refcnt);
            
            child = a->child = c->child;
            
            /* update parent links */
            for(; child; child = child->or) {
                demand(child->parent == c, bogus parent!);
                child->parent = a;
            }
            
            if((a->pid = c->pid)) {
                demand(dpf_active[c->pid] == c, bogus active);
                dpf_active[c->pid] = a;
            }
            a->ir = c->ir;
		
            /* free ht, etc. */
            free(a->ht);
            free(c);
            
            a->ht = 0;
            
            /* no more nodes: delete it */
        } else if(!a->refcnt) {
            demand(!a->ht, should not be able to have a ht);
            
            /* delete ht entry */
            if(p && p->ht)
                ht_delete(p->ht, a->ir.eq.val);
            /* delete from or list */
			else if(a->orp) {
                            if(a->orp && *a->orp != a)
                                fatal(bogus);
                            demand(!a->or || a->or->orp == &a->or, bogus);
                            delete_or(a);
                            /* could be rightmost */
			} else if(p) {
                            demand(p->child == a, bogus child);
                            if((p->child = a->or))
                                a->or->orp = 0;
			}
            demand(!a->pid, freeing an atom with pid!);
            *fl++ = a;
        }
    }
    
    /* make sure to mark as nil. */
    if ( succ == dpf_base && !succ->refcnt ) 
    {
        if ( !(dpf_base = succ->or) )
        {
            dpf_iptr = dpf_ret_zero;
        }
        else
        {
            dpf_base->orp = 0;
        }
    }
    else if(!dpf_overlap)
        dpf_iptr = dpf_compile(dpf_base);
    
    /* free all elements */
    for(; fl > freelist; ) {
        fl--;
        free(*fl);
    }
    
    dpf_active[pid] = 0;

    return pid;
}


int dpf_insert(struct dpf_ir *irp, unsigned pid) 
{
	/* scratch memory to hold copied filter */
        static struct dpf_ir ir; /* Yikes! Keep stack small! */

	if ( pid >= DPF_MAXFILT || dpf_active[pid] ) return DPF_BOGUSID;

	/* copy in the header */
        memcpy(&ir, irp, offsetof(struct dpf_ir, ir)); 
	/* copy in the elements */
        memcpy(&ir.ir[0], &irp->ir[0], irp->irn * sizeof irp->ir[0]);

	ir.ir[ir.irn].eq.op = DPF_OP_END;
	dpf_coalesce(&ir);

	/* 
	 * Now merge it in with the main tree.  (*DANGER*): we handle 
	 * the case where dpf_base is nil deep in the code. 
	 */
	dpf_overlap = 0;
	dpf_active[pid] = dpf_merge(dpf_base, &ir.ir[0], pid);
	if (!dpf_active[pid])
	  return DPF_NOMEM;

	if(!dpf_overlap) 
        {
            dpf_iptr = dpf_compile(dpf_base);
	} 
        else 
        {
		if(dpf_delete(pid) < 0)
			fatal(Should not fail);
		dpf_overlap = 0;
		pid = DPF_OVERLAP;
                dpf_iptr = dpf_compile(dpf_base);
	}
        
	return(0);
}

void dpf_init(void)
{
    gen_ret_zero();
    dpf_iptr = dpf_ret_zero;
}
