/*
 * All modifications are copyright (c) 2000, K A Fraser.
 * 
 * Please note the original copyright and license details below.
 */

/*
 * Copyright (C) 1997 Massachusetts Institute of Technology 
 *
 * This software is being provided by the copyright holders under the
 * following license. By obtaining, using and/or copying this software,
 * you agree that you have read, understood, and will comply with the
 * following terms and conditions:
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose and without fee or royalty is
 * hereby granted, provided that the full text of this NOTICE appears on
 * ALL copies of the software and documentation or portions thereof,
 * including modifications, that you make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS. COPYRIGHT
 * HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE OR
 * DOCUMENTATION.
 *
 * The name and trademarks of copyright holders may NOT be used in
 * advertising or publicity pertaining to the software without specific,
 * written prior permission. Title to copyright in this software and any
 * associated documentation will at all times remain with copyright
 * holders. See the file AUTHORS which should have accompanied this software
 * for a list of all copyright holders.
 *
 * This file may be derived from previously copyrighted software. This
 * copyright applies only to those changes made by the copyright
 * holders listed in the AUTHORS file. The rest of this file is covered by
 * the copyright notices, if any, listed below.
 */

#include "dpf-internal.h"

void dpf_begin(struct dpf_ir *ir) 
{
    memset(ir, 0, sizeof *ir);
}

static inline void *alloc(struct dpf_ir *ir) 
{
    if ( ir->irn >= DPF_MAXELEM ) fatal(Code size exceeded. Increase DPF_MAX.);
    return &ir->ir[ir->irn++];
}

void dpf_mkeq(struct dpf_ir *ir, uint8 nbits, uint16 offset, 
              uint32 mask, uint32 val) 
{
    struct eq *eq = alloc(ir);
    eq->op     = DPF_OP_EQ;
    eq->offset = offset + ir->moffset;
    eq->val    = val;
    eq->mask   = mask;
    eq->nbits  = nbits;
}

void dpf_mkshift(struct dpf_ir *ir, uint8 nbits, uint16 offset, 
                 uint32 mask, uint8 shift, uint8 ext) 
{
    struct shift *s = alloc(ir);
    s->op     = DPF_OP_SHIFT;
    s->shift  = shift;
    s->offset = offset + ir->moffset;
    s->mask   = mask;
    s->nbits  = nbits;
    s->ext    = ext;
}

void dpf_shifti(struct dpf_ir *ir, uint16 offset, uint8 ext) 
{ 
    if ( ext & SHIFT ) ir->moffset += offset;
    if ( ext & ~SHIFT )
    {
        struct shifti *s = alloc(ir);
        s->op     = DPF_OP_SHIFTI;
        s->shift  = offset;
        s->ext    = ext & ~SHIFT;
    }
}
