/*
 *  usd_conn.h
 *  ----------
 *
 *  Somewhere to put the state required per-connection in the USD version
 *  
 *  TJD May '99 
 *  Modifications copyright (c) 1999-2000, Ian Pratt & K A Fraser
 *
 *  Please read the FIRMWARE-LICENSE file distributed with this source file
 *  for details of the license agreement.
 */

#ifndef _USD_CONN_H_
#define _USD_CONN_H_

#define USD_CHANNELS 64  
/* This should be a power of 2, >= 32.
 * MAX we have space for in cmd space is 512 
 */

/*
 *  The per-context data we have to DMA from the host
 */
typedef struct conn_ctxt_host_part {
    /* Where this USD can DMA to and from  */
    tg_hostaddr_t host_range_base;
    U32 host_range_length;
    /* IP */
    U32 ipSourceAddr;
    U32 ipDestAddr;
    /* TCP/UDP -- first two 16-byte fields in either case */
    U16 sourcePort;
    U16 destPort;

    /* TX2/RX2 stuff */
    U16      rx2_ring_size;  
    U16      tx2_ring_size;
    U32      pad;
    tg_hostaddr_t tx2_ring_ptr;
    tg_hostaddr_t tx2_csm_ptr;
    tg_hostaddr_t rx2_ring_ptr;

} conn_ctxt_host_part_t;


/*
 *  We're going to use the 2k communications region to support commands
 *  from the 256 interfaces.  The region should be pointed at the
 *  area between 2k and 4k onf the Tigon's external RAM.
 * 
 *  Host->NIC interface is located between 2k and 4k.
 */

#define USD_CMD_BASE 0x800
#define usd_cmd_p ((VOLATILE U32 *) USD_CMD_BASE) /* cmds are 32 bits */

/*******//* USD2 stuff *//***************************************************/

typedef struct {
  U16 tx_prod;
  U16 tx_ref;
  U16 free_prod;
  U16 rx_ref;
  U16 tx_cons;   // don't poll this from user side !
  U16 rx_prod;   // don't poll this from user side !
} usd2_ctrl_t;

#define USD2_CTRL_BASE (0x800 + 64*4)
#define usd2_ctrl_p ((VOLATILE usd2_ctrl_t *) USD2_CTRL_BASE)

/**************************************************************************/

/*
 * The MTU is no longer set by the host: We need to allocate TX buffer
 * space in 1-MTU chunks for each transmitting USD, so we can't have
 * large frames any more :( 
 */
#define MTU 0x600

#endif  /* _USD_CONN_H_ */

