/*
 *  tx2.c
 *  -----
 *
 *  Support for NEW per-connection TX interface (TX2).
 *
 *  Copyright (c) 1999, Ian Pratt
 *  Modifications copyright (c) 1999-2000, K A Fraser
 *
 *  Please read the FIRMWARE-LICENSE file distributed with this source file
 *  for details of the license agreement.
 *
 *  $Id: tx2.c,v 1.23 2000/07/04 13:29:41 kaf24 Exp iap10 $
 */

#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"
#define UNALIGNED_LOAD_32(_x) (((U16*)(_x))[0] << 16 | ((U16*)(_x))[1])
#include "nic.h"
#include "proto.h"
#include "ring.h"
#include "usd_conn.h"
#include "assert.h"
#include "usd2_util.h"

//static inline tgDmaDescr_t * get_next_rd_dma_low_descr( tgDmaDescr_t * ddp );
static inline U32 q_bd_to_nic_low(tg_hostaddr_t host_addr, U32 nic_addr, U32 len, 
             U16 type, U16 id, U32 index, U32 state);
static inline int tx2_upload_bds_all_contig( int chan, int didx, U32 sidx, int num );
static inline int tx2_upload_bds_dst_contig( int chan, int didx, U32 tx_bd_q, int num );


#define SCHED_SLOP (TG_TICK_1US * 100U)


/** All of this code runs on CPU B **/




void h_max_tx_comp_B( void )
{
  tgMacDescr_t * md;
  pkt_t * bufaddr;
  int buf;

  /*
   * KAF (28/10/99): should we service all completed MAC tx's while
   * we're here? It's not necessary, since the event bit won't clear until
   * we catch up with the consumer. However, it might improve performance?
   */

  md   = trp->local_mem_conf.mac_tx_descr_ref;

  // What TX buffer number was this? 
  bufaddr = (pkt_t *) md->w0;
  buf = bufaddr - nicbfp->tx2_buf;

  NIC_TRACE(TRACE_TYPE_TX2_TRACE, "2TXCompl", 0xA000, 
            md,bufaddr,buf,nicbfp->tx2_buf_len[ buf ]);

  nicbfp->tx2_pkts_sent++;
  
#if 0

  ASSERT(buf < TX2_PKT_BUFS);

  nicbfp->tx2_ever_used |= (1<<buf);

  NIC_UTRACE("2TXCompl", 0xA001, 
            nicbfp->tx2_free_bufs,bufaddr,buf,nicbfp->tx2_buf_len[ buf ]);
  NIC_UTRACE("2TXComp2", 0xA002, 
	     trp->local_mem_conf.mac_tx_descr_consumer,
	     trp->local_mem_conf.mac_tx_descr_producer,
	     trp->local_mem_conf.mac_tx_descr_ref,
	     0);
  NIC_UTRACE("2TXComp3", 0xA003, 
	     md->w0, md->w1, 0, 0);
	     
  NIC_UTRACE("2TXComp4", 0xA004, 
	    trp->mac_control.mac_tx_state,
	    trp->local_mem_conf.tx_buf_producer,
	    trp->local_mem_conf.tx_buf_consumer,
	    trp->local_mem_conf.tx_buf_next
	    );
#endif

//#define TX_BLAST_TEST 

#ifdef TX_BLAST_TEST
  {  
    tgMacDescr_t * xmd;
    int i;
    static int blaston = 0;

    if( !blaston && 
        (trp->local_mem_conf.mac_tx_descr_producer - &tdp->tx_mac_ring[0] )
	== 64 )
      {
	blaston = 1;
	NIC_UUTRACE("BlastON", 0xdead, 
	     0, 0, 0, 0);
      }

    if( blaston )
      {
	int cc;

	xmd = trp->local_mem_conf.mac_tx_descr_next;
      
	xmd->w0 = (U32)nicbfp->tx2_buf[ buf ]; // nic address
	xmd->w1 = nicbfp->tx2_buf_len[ buf ] ; // pkt length
	
	trp->local_mem_conf.mac_tx_descr_producer = xmd + 1;

	// and exit
	trp->local_mem_conf.mac_tx_descr_ref = ++md; // auto-truncate

#if 0
	cc = tsp->gen_com.tx_blast_rate_control;
        for ( i = 0; i < cc ; i++ ) ;
#endif

	return;
      }
  }

#endif


  // free this tx buffer now the data has been sent successfully
  nicbfp->tx2_free_bufs |= 1<<buf;

  trp->local_mem_conf.mac_tx_descr_ref = ++md; // auto-truncate

  if ( trp->local_mem_conf.mac_tx_descr_consumer == 
       trp->local_mem_conf.mac_tx_descr_producer )
  {
      // No more packets for the wire just now, so clear the data LED. 
      trp->gen_control.misc_local_control &= ~TG_MLC_LED_DATA;
  }



  // XXX don't want to do this every time!
  (*tx2_select_pkt_for_upload_stub)();
}
void h_max_tx_comp_B_end( void ){}
void_fn_t h_max_tx_comp_B_stub;


void 
tx2_select_pkt_for_upload( void )
{
  U32 buf, chan, copy_tx_bd_next, len, i;
  tgDmaDescr_t *dd_prod, *ndd_prod, *dd_ref;
  tx2_descr_t * fd;

top:

  buf = pri( nicbfp->tx2_free_bufs, ~0 );

  if( buf == 0 )
    {
      // No space. Bail.
      goto nospace;
    }

  buf --;  // turn this into a bit position


  // Priority Based Scheduling. Please rewrite me!!!!
  // Proper scheduling algorithm should have the following properties:
  //      1. Give x bytes every y ms guarantees
  //      2. Provide an "extra time" capability that is shared fairly
  //      3. Ideally, give priority to connections that have not sent
  //         anything for a while and are "in credit". This will reduce
  //         latency for message passing type applications.

#ifdef TX_PRI_SCHED

  // Priority scheduler
  chan = find_first_set( nicbfp->tx2_bds_rdy, nicbfp->max_ctxt_id_b );

#endif

#ifdef TX_RR_SCHED  
  // per-packet Round Robin scheduler
  // XXX currently only works with 32 channels

  chan = pri( nicbfp->tx2_bds_rdy[0], nicbfp->sched_mask );

  if( chan == 0 )
    {
      nicbfp->sched_mask = ~0;
      chan = pri( nicbfp->tx2_bds_rdy[0], nicbfp->sched_mask );
    }

  if ( chan != 0 ) nicbfp->sched_mask = (1 << (chan-1)) -1 ;

#endif

#ifdef TX_SHAPER_SCHED
  // XXX currently only works with 32 channels
  {
    U32 tmp;


    NIC_TRACEV( TRACE_TYPE_TX2_SCHED,"TXSel", 0x1234,
		nicbfp->tx2_bds_rdy[0],
		nicbfp->tx2_bds_allowed[0], 
		nicbfp->sched_mask,
		0);

    tmp = nicbfp->tx2_bds_allowed[0] & nicbfp->sched_mask;
    chan = pri( nicbfp->tx2_bds_rdy[0], tmp );

    if( chan == 0 )
      {
	nicbfp->sched_mask = ~0;
	chan = pri( nicbfp->tx2_bds_rdy[0], nicbfp->tx2_bds_allowed[0] );
      }

    if ( chan != 0 ) nicbfp->sched_mask = (1 << (chan-1)) -1 ;
  }
#endif


  if( chan == 0 )
    {
      // No work. Bail.
      goto nowork;
    }

  chan--;  // turn this into a normal channel number;


  // see how many frags this pkt is

  dd_prod = trp->host_dma_assist.read_chan_lo_pri_producer; 
  // no `next available' producer on lo pri channel 
  
  dd_ref  = trp->host_dma_assist.read_chan_lo_pri_ref;
  // ref is cached non-volatile value of what we've ACK'ed up to
 
  copy_tx_bd_next = nicbfp->tx2_ctxt[chan].tx_bd_next;


  NIC_TRACE(TRACE_TYPE_TX2_TRACE, "2SPok", 0x9000,
            chan, buf, dd_prod,  copy_tx_bd_next );


  for(len=0,i=0;i<TX2_MAX_FRAGS;i++)
    {
      // due to stupid design we're only going to use 31 of the 32 slots
      ndd_prod = get_next_rd_dma_low_descr( dd_prod );
      
      // frag descriptor.
      fd = &(nicp->tx2_descr[chan][copy_tx_bd_next % TX2_NUM_BDs ]);

      // consume this frag descriptor
      copy_tx_bd_next = (copy_tx_bd_next + 1) & 0xffff;

      if( ndd_prod != dd_ref)
	{
	  // there is space for this frag. (lets hope the whole pkt fits)

	  // Check that the client is allowed to DMA this area

	  if( fd->host_buf < nicbfp->tx2_ctxt[chan].host_range_base ||
	      (fd->host_buf + fd->length) > 
	              (nicbfp->tx2_ctxt[chan].host_range_base + 
	              nicbfp->tx2_ctxt[chan].host_range_length) )
              goto error_abort;


	  // Fill out the DMA record

	  fill_in_dma_record(dd_prod,
		       fd->host_buf,
		       ((U32)nicbfp->tx2_buf[buf])+len,
		       fd->length,
		       (fd->flags & TX2_DESCR_FLAGS_EOP)?
		           TIGON_TYPE_SEND_DATA_LAST:TIGON_TYPE_SEND_DATA, 
		       chan, 
		       buf, 
		       TX2_DMA_TO_NIC_FRAG_STATE );
	  
	  len += fd->length;
	    
	  dd_prod = ndd_prod;  // advance dd_prod

	  if (fd->flags & TX2_DESCR_FLAGS_EOP)
	    {
	      U32 in_q;

              // set the total buffer length
              nicbfp->tx2_buf_len[buf] = len;

	      // make a note of which bd is effectively the consumer ptr
	      nicbfp->tx2_buf_consumer[buf] = copy_tx_bd_next;

              NIC_TRACE(TRACE_TYPE_TX2_TRACE, "2SPeop", 0x9001, 
                        chan, buf, i,  len );
      

              if( len > TX2_MAX_PKT_LEN )
                  goto error_abort;

              // claim this buffer 
              nicbfp->tx2_free_bufs &= ~(1<<buf);  

              // we made it. The whole pkt fitted so hit Fire!
              trp->host_dma_assist.read_chan_lo_pri_producer = ndd_prod;

              // note that we've dealt with these BDs
              nicbfp->tx2_ctxt[chan].tx_bd_next = copy_tx_bd_next;

              NIC_TRACEV(TRACE_TYPE_TX2_TRACE, "2SPeop2", 0xa001,
                        copy_tx_bd_next, nicbfp->tx2_ctxt[chan].tx_bd_rdy_eop,
                        is_bit_set(nicbfp->tx2_bds_rdy, chan), 0);

              if( copy_tx_bd_next == nicbfp->tx2_ctxt[chan].tx_bd_rdy_eop )
                  clear_bit( nicbfp->tx2_bds_rdy, chan );

#ifdef TX_SHAPER_SCHED
	      nicbfp->tx2_ctxt[chan].credit -= len;
	      

NIC_TRACEV(TRACE_TYPE_TX2_SCHED,"TXSSS",0,
	   chan,
	   nicbfp->tx2_ctxt[chan].credit,
	   nicbfp->tx2_ctxt[chan].last_credit, len);

	      if( nicbfp->tx2_ctxt[chan].credit < 0 )
		{ // bankrupt!
		  U32 tmp, now;
			    
		  nicbfp->tx2_ctxt[chan].credit += 
		    (((U32)nicbfp->tx2_ctxt[chan].credit_inc)<<10); // in KB

		  tmp = nicbfp->tx2_ctxt[chan].last_credit + 
		    (((U32)nicbfp->tx2_ctxt[chan].time_inc)<<8); //256uS

		  now = trp->gen_control.timer ;
		  if( U32S_GT(tmp, now) ) // tmp is in the future
		    {
		      NIC_TRACE(TRACE_TYPE_TX2_SCHED, "TXstall", chan,
				nicbfp->tx2_ctxt[chan].last_credit,
				tmp,
				nicbfp->tx2_ctxt[chan].credit,
				tmp-now );

		      nicbfp->tx2_ctxt[chan].last_credit = tmp;

		      if( U32S_GT(tmp, now + SCHED_SLOP ) ) 
			{
			  // if we're sufficiently far in the future STALL
			  
			  if( spq_insert(tmp, chan) == 1 )
			    {
			      // if we have changed the head
			      trp->gen_control.timer_ref_b = tmp;
			      
			      NIC_TRACE(TRACE_TYPE_TX2_SCHED, "TXsetTim", chan,
					nicbfp->tx2_ctxt[chan].last_credit,
					tmp,
					nicbfp->tx2_ctxt[chan].credit,
					0);
			    }			  
			  clear_bit(nicbfp->tx2_bds_allowed, chan);
			}
		      
		    }
		  else
		    {
		      // this is the case for slow TX'ers

		      NIC_TRACE(TRACE_TYPE_TX2_SCHED, "TXcont", chan,
			     nicbfp->tx2_ctxt[chan].last_credit,
			     tmp,
			     nicbfp->tx2_ctxt[chan].credit,
			     now-tmp);
		      

		      nicbfp->tx2_ctxt[chan].last_credit = now;
		    }

		}
#endif
              // This has potentialy freed up space in the BD fifo for
              // this channel. 

	      in_q = (nicbfp->tx2_ctxt[chan].tx_bd_q -
		copy_tx_bd_next) & 0xffff;
	     
	      if( in_q < (TX2_NUM_BDs/2) &&
		  is_bit_set_and_clear( nicbfp->tx2_bds_unseen, chan ) )
		{ 
		  // if space > 50%
		  
		  if( (*tx2_upload_bds_stub)(chan, 
			nicbfp->tx2_ctxt[chan].cache_tx_prod ) == ERROR )
		    {
                        goto bail;
		    }
		}


              // see if we can do any more work -- go back to the scheduler
              goto top;
	    }
	}
      else
	{
	  // no dma assist slots! Abort everything!

	  // XXXX How do we get back in to tx2_select_pkt... when
	  // assist slots become available?  The fact that we enter
	  // this routine upon MacTXComplete events will probably bail
	  // us out, but we can't rely on it.

	  //	  NIC_TRACE(TRACE_TYPE_TX2_DEBUG, "2SPdmFu!", 0x7701,
	  NIC_UTRACE("2SPdmFu!", 0x7701,
		    nicbfp->bd_dmas_in_q,
		    nicbfp->tx2_free_bufs,
		    0,0);

	  //PANIC();
	  return;
	}


    }  /* end of frags loop */

 error_abort:

  // if we got here, there must have been more than 3 frags,
  // an over length packet, or an illegal DMA address.

  // We should signal to the client that something went wrong, but for now
  // we just junk the fifo and hope to resync. XXX

  NIC_UUTRACE("2SelTMF!",chan,i,len,fd->host_buf,fd->length);
  NIC_UUTRACE("2SelTM2!",chan,3,TX2_MAX_PKT_LEN,
              nicbfp->tx2_ctxt[chan].host_range_base, 
              nicbfp->tx2_ctxt[chan].host_range_length);

  nicbfp->tx2_ctxt[chan].tx_bd_next = nicbfp->tx2_ctxt[chan].tx_bd_rdy_eop;
  PANIC();  // XXXX debug
  goto top; // try again


 nospace:
  NIC_TRACE(TRACE_TYPE_TX2_TRACE, "2SelPkNS", 0x7701,
            0,0,0,0);
  return;
  

 nowork:
  NIC_TRACE(TRACE_TYPE_TX2_TRACE, "2SelPkNW", 0x7702,
            0,0,0,0);

 bail:
  return;
  
}
void tx2_select_pkt_for_upload_end(void) {}
void_fn_t tx2_select_pkt_for_upload_stub;

void
h_dma_rd_asst_lo_B(void)  
{
  /* runs on CPU B. Called after completion of a TX2 Read DMA
	e.g. after reading a BD or Frag from host
  */

  struct tg_dma_descr *ddp, *dd_cons;

  ddp     = trp->host_dma_assist.read_chan_lo_pri_ref;
  dd_cons = trp->host_dma_assist.read_chan_lo_pri_consumer;

  NIC_TRACEV(TRACE_TYPE_TX2_TRACE, "2DmaCpXX", 0x62609,
            trp->host_dma.dma_rd_state,
            trp->host_dma_assist.assist_state,
            trp->host_dma.dma_rd_loc_addr,
            trp->host_dma.dma_rd_len);

  NIC_TRACEV(TRACE_TYPE_TX2_TRACE, "2DmaCp", 0x62600,
            trp->host_dma_assist.read_chan_lo_pri_producer,
            trp->host_dma_assist.read_chan_lo_pri_consumer,
            ddp,
            (ddp - tdp->rd_dma_lo_ring));

  NIC_TRACE(TRACE_TYPE_TX2_TRACE, "2DmaCpD0", 0x62800,
            *(U32 *)ddp,		/* host addr */
            *((U32 *)ddp + 1),	/* host addr */
            *((U32 *)ddp + 2),	/* nic addr */
            *((U32 *)ddp + 3));	/* reserved & len */

  NIC_TRACEV(TRACE_TYPE_TX2_TRACE, "2DmaCpD1", 0x62900,
            *((U32 *)ddp + 4),	/* state */
            *((U32 *)ddp + 5),	/* reserved & cksum addr */
            *((U32 *)ddp + 6),	/* type */
            *((U32 *)ddp + 7));	/* index */

    // not a race since this is single threaded....
    // this should clear the event
  trp->host_dma_assist.read_chan_lo_pri_ref = ddp+1;

    if( ddp->type == TIGON_TYPE_SEND_BD )
      {
	int chan, didx, len, num, i, eop, old_rdy;
	tx2_descr_t * fd;

	nicbfp->bd_dmas_in_q--; // one less in the queue

	chan = ddp->usd_id;
	didx = ddp->index;
	len  = ddp->len;

	num  = len / sizeof( tx2_descr_t );

	NIC_TRACEV(TRACE_TYPE_TX2_TRACE, "2DCpRec", 0x62601,
                  chan, didx, len, num );

	NIC_TRACEV(TRACE_TYPE_TX2_TRACE, "2DCpRecX", 0x62601,
                  chan, didx, &(nicp->tx2_descr[chan][didx]),
                  ddp->nic_addr );

	fd = &(nicp->tx2_descr[chan][didx]);

	for(eop=0, i=1; i<=num; i++, fd++)
	  {
	    NIC_TRACE(TRACE_TYPE_TX2_TRACE, "2DCpRes", 0x62602,
                      fd, fd->host_buf, fd->length, fd->flags );


             if( fd->flags & TX2_DESCR_FLAGS_EOP )
	       eop = i;

	  }

	old_rdy = nicbfp->tx2_ctxt[chan].tx_bd_rdy;  

	nicbfp->tx2_ctxt[chan].tx_bd_rdy += num;


	if( eop )
	  {
	    // we got an EOP in this batch
	    nicbfp->tx2_ctxt[chan].tx_bd_rdy_eop = old_rdy + eop;

	    // may already be set, but doesn't matter
	    set_bit( nicbfp->tx2_bds_rdy, chan );

	    // Let's work on the optimistic assumption that there's a
	    // free TX buffer and call scheduler.
	    // We should return PDQ if not.

	    (*tx2_select_pkt_for_upload_stub)();

	  }

	NIC_TRACEV(TRACE_TYPE_TX2_TRACE, "2DcpQQ", 0x007,
                  chan, 
                  nicbfp->tx2_ctxt[chan].tx_bd_q, 
                  nicbfp->tx2_ctxt[chan].tx_bd_rdy,
                  nicbfp->tx2_ctxt[chan].tx_bd_rdy_eop);       
	
	return;
      }
    else if( ddp->type == TIGON_TYPE_SEND_DATA )
      {
	// we don't even need to receive an assist event for these,
	// as we only need to know when the whole packet has arrived
	return;
      }
    else if( ddp->type == TIGON_TYPE_SEND_DATA_LAST )
      {
	// Now we have the whole packet, run the TX packet filter,
	// then add it to the TX MAC DMA queue.  Note that the assist
	// queue can never over run, so just do it.

	tgMacDescr_t * md;
	int buf = ddp->index;
	int chan = ddp->usd_id;
	int cons;
	  
	
	NIC_TRACE(TRACE_TYPE_TX2_TRACE, "2PcpMac", 0x62600,
                  buf,chan,
                  nicbfp->tx2_buf[ buf ],nicbfp->tx2_buf_len[ buf ]);
#if 0
        {
            static U8 x = 253;
            if ( ++x == 254 ) x = 0;
            (nicbfp->tx2_buf[buf])[6]=x;
        }
#endif
	// XXXX implement packet filter!
#if 0
        if ( chan == 1 )
        {
            static unsigned int expected_i = 0;
            unsigned int j, i = UNALIGNED_LOAD_32(ddp->nic_addr);
            j = ((i&0xff000000)>>24) | ((i&0x00ff0000)>> 8) | 
                ((i&0x0000ff00)<< 8) | ((i&0x000000ff)<<24);
            if ( j != expected_i )
            {
                NIC_UTRACE("XXXDrop", 0xdeadbeef,
                           expected_i, j, 0, i);
            }
            else
            {
                NIC_UTRACE("Okay", 0xdeadbeef,
                           expected_i, j, 0, i);
            }
            expected_i = j+1;
        }
#endif

	// should never return zero
	md = trp->local_mem_conf.mac_tx_descr_next;

	NIC_TRACEV(TRACE_TYPE_TX2_TRACE, "2PcpMac2", 0x62600,
                  md,
                  trp->local_mem_conf.mac_tx_descr_producer,
                  trp->local_mem_conf.mac_tx_descr_consumer,
                  trp->local_mem_conf.mac_tx_descr_ref );

	// setup both words. default flags are fine
	md->w0 = (U32)nicbfp->tx2_buf[ buf ]; // nic address
	md->w1 = nicbfp->tx2_buf_len[ buf ] ; // pkt length

	// kick the TX producer
	trp->local_mem_conf.mac_tx_descr_producer = md + 1;

#if 0
	NIC_UTRACE("2Sndpkt", 0xB001,
		   md,
		   trp->local_mem_conf.mac_tx_descr_producer,
		   trp->local_mem_conf.mac_tx_descr_consumer,
		   trp->local_mem_conf.mac_tx_descr_ref );

	NIC_UTRACE("2Sndpk2", 0xB002,
		   nicbfp->tx2_free_bufs,
		   md->w0,
		   md->w1,
		   0);

	NIC_UTRACE("2Sndpk3", 0xB003, 
		   trp->mac_control.mac_tx_state,
		   trp->local_mem_conf.tx_buf_producer,
		   trp->local_mem_conf.tx_buf_consumer,
		   trp->local_mem_conf.tx_buf_next
		   );

#endif


	cons = nicbfp->tx2_buf_consumer[ buf ];	

	// new shared memory way with REF support
	usd2_ctrl_p[chan].tx_cons = cons;

	nicbfp->tx2_ctxt[chan].tx_bd_done = cons;

	//	if( ((cons - nicbfp->tx2_ctxt[chan].cache_tx_ref)&0xffff) >=0 )
	// XXX Hack
	//	if( !is_bit_set( tsp->gen_com.tx2_interrupts_active, chan ) &&

	if( nicbfp->tx2_ctxt[chan].irq_primed &&
	    ((nicbfp->tx2_ctxt[chan].cache_tx_prod-cons) & 0xffff) <= 
	    ((nicbfp->tx2_ctxt[chan].cache_tx_prod-
	      nicbfp->tx2_ctxt[chan].cache_tx_ref) & 0xffff) )

	  {
	    // interrupt host
	    set_bit( tsp->gen_com.tx2_interrupts_active, chan );
	    trp->gen_control.misc_local_control |= TG_MLC_SET_INTERRUPT;

	    nicbfp->tx2_ctxt[chan].irq_primed=0;

NIC_TRACE(TRACE_TYPE_TX2_IRQ,"TX2refX", 0x334, 
	  nicbfp->tx2_ctxt[chan].cache_tx_prod,
	  nicbfp->tx2_ctxt[chan].cache_tx_ref,
	  cons,
	  tsp->gen_com.tx2_interrupts_active[0]);

	  }	
	
        /*
         * Set the data LED...
         * Description of how the LED works:
         *   We simply toggle the LED when we have a new packet for the wire,
         *   and reset it when all work is done. Hopefully this should give
         *   a reasonable visual indication of the transfer packet rate.
         */
	//        trp->gen_control.misc_local_control ^= TG_MLC_LED_DATA;
        trp->gen_control.misc_local_control |= TG_MLC_LED_DATA;
	return;
      }
    else if ( ddp->type != TIGON_TYPE_NULL )
      {
	NIC_UTRACE("2Dma???", 0x62600,
                  trp->host_dma_assist.read_chan_lo_pri_producer,
                  trp->host_dma_assist.read_chan_lo_pri_consumer,
                  ddp,
                  (ddp - tdp->rd_dma_lo_ring));	
	PANIC();
      }

}

void h_dma_rd_asst_lo_B_end(void) {}

void_fn_t h_dma_rd_asst_lo_B_stub;  


static inline U32 
q_bd_to_nic_low(tg_hostaddr_t host_addr, U32 nic_addr, U32 len, 
             U16 type, U16 id, U32 index, U32 state) 
{
  // runs on CPU B

  tgDmaDescr_t *dd_prod, *ndd_prod, *dd_ref;

  dd_prod = trp->host_dma_assist.read_chan_lo_pri_producer; 
  // no `next available' producer on lo pri channel 
    
  dd_ref  = trp->host_dma_assist.read_chan_lo_pri_ref;
  // ref is what we've ACK'ed up to
 
  ndd_prod = get_next_rd_dma_low_descr( dd_prod );
  // due to stupid design we're only going to use 31 of the 32 slots

  if( ndd_prod != dd_ref)
    {
      // Must be space. Do DMA
      
      fill_in_dma_record( dd_prod,
			  host_addr, nic_addr, len, 
			  type, id, index, state );

      trp->host_dma_assist.read_chan_lo_pri_producer = ndd_prod; // fire!

      nicbfp->bd_dmas_in_q++;

      return OK;
    }
  else
    {
      nicbfp->nicDmaReadRingFull++; 

      NIC_TRACE(TRACE_TYPE_TX2_DEBUG, "2QrDbdFu", 0x21500, 
		trp->host_dma_assist.read_chan_lo_pri_producer,
		trp->host_dma_assist.read_chan_lo_pri_consumer,
		trp->host_dma_assist.read_chan_lo_pri_ref,
		nicbfp->nicDmaReadRingFull);      

      return ERROR;     
    }
}


static inline int
tx2_upload_bds_all_contig( int chan, int didx, U32 sidx, int num )
{
  // returns OK or ERROR

  tg_hostaddr_t src;

  NIC_TRACEV(TRACE_TYPE_TX2_TRACE,"2upallc", 0x007, 
	     chan, didx, sidx, num);

  //NIC_UTRACE("2upallc", 0x007, 
  //     chan, didx, sidx, num);

  src = nicbfp->tx2_ctxt[chan].tx2_ring_ptr;
  src += sidx * sizeof(tx2_descr_t);

  /* q_bd_to_nic_low(tg_hostaddr_t host_addr, U32 nic_addr, U32 len, 
             U16 type, U16 id, U32 index, U32 state)  */

  if( q_bd_to_nic_low( src, 
		    (U32)&(nicp->tx2_descr[chan][didx]),
		    sizeof(tx2_descr_t) * num,
		    TIGON_TYPE_SEND_BD,
		    chan,
		    didx,
		    TX2_DMA_TO_NIC_BD_STATE
		    ) )
    {
      return OK;
    }
  else
    {
      NIC_TRACE(TRACE_TYPE_TX2_DEBUG,"2upalFa!", 0x907, 
	     chan, didx, sidx, nicbfp->bd_dmas_in_q);
     
      return ERROR;
    }
}


static inline int 
tx2_upload_bds_dst_contig( int chan, int didx, U32 tx_bd_q, int num )
{
  // We know the destination for these descriptors is contiguous,
  // though we should be wary of the source wrapping.
  // We don't update any pointers here

  U32 tx_h_mask, queued, batch;
  U32 sidx, rc;

  NIC_TRACEV(TRACE_TYPE_TX2_TRACE,"2updstc", 0x007, 
	     chan, didx, tx_bd_q, num);

  tx_h_mask = nicbfp->tx2_ctxt[chan].tx_h_mask;

  queued = 0;

  sidx = tx_bd_q & tx_h_mask;  

  MIN_first_likely( batch, num, tx_h_mask + 1 - sidx );
  // batch = MIN( num, tx_h_mask + 1 - sidx );

top:
  rc = tx2_upload_bds_all_contig( chan, didx, sidx, batch );

  if( rc == OK && queued + batch == num )
    return queued + batch;

  if( rc == ERROR )
    return queued;

  sidx = 0;
  didx += batch;
  queued += batch;
  batch = num - batch;

  goto top;

}


int
tx2_upload_bds(int chan, U32 tx_h_prod)
{
  // where the client has kicked up to
  //U32 tx_h_prod = usd2_ctrl_p[chan].tx_prod;

  // where we've already queued up to
  U32 tx_bd_q = nicbfp->tx2_ctxt[chan].tx_bd_q; 

  NIC_TRACE(TRACE_TYPE_TX2_TRACE,"2upbds", 0x007, 
	     chan, tx_h_prod, tx_bd_q, (tx_h_prod - tx_bd_q) & 0xffff );       

#if 0 // stats
  NIC_TRACE(TRACE_TYPE_TX2_STATS,"2Cstats", 0x007, 
   (tx_h_prod - nicbfp->tx2_ctxt[chan].tx_bd_next) &0xffff ,
   (tx_bd_q - nicbfp->tx2_ctxt[chan].tx_bd_next) &0xfff,
   (nicbfp->tx2_ctxt[chan].tx_bd_rdy - nicbfp->tx2_ctxt[chan].tx_bd_next)&0xffff,
   nicbfp->tx2_free_bufs);

#endif


  if (tx_h_prod != tx_bd_q)
    {
      // There are BDs outstanding

      U32 tx_bd_next = nicbfp->tx2_ctxt[chan].tx_bd_next;
      
      U32 in_q = (tx_bd_q - tx_bd_next) & 0xffff;

      U32 space = TX2_NUM_BDs - in_q;

      U32 unseen = (tx_h_prod - tx_bd_q) & 0xffff;
	  
      if( unseen > space )
      	{
	  // Make a note that we still have unseen BDs on this channel. 
	  // A retry can be triggered by a successful TX resulting in
	  // an incrememnt to tx_bd_next

	  set_bit(nicbfp->tx2_bds_unseen, chan);

	  NIC_TRACE(TRACE_TYPE_TX2_TRACE,"2unseen", 0x007, 
		     in_q, space, unseen, nicbfp->tx2_bds_unseen);

	}

      if( space >0 )
	{
	  // We have space to move some in
	  U32 tomove, max1, batch, tx_bd_q_idx, queued, rc;
	  
	  MIN_first_likely(tomove, unseen, space); //tomove = MIN(unseen,space)

	  tx_bd_q_idx = tx_bd_q % TX2_NUM_BDs;

	  queued = 0;
	  max1 = TX2_NUM_BDs - tx_bd_q_idx;
	  MIN_first_likely(batch,tomove, max1); // batch = min(tomove, max1)

	  // We go around this loop once, or twice if a dest wrap occurs.
	  // The loop is here to enable tx2_upload_bds_dst_contig to be inlined

	top:
	  rc = tx2_upload_bds_dst_contig( chan, tx_bd_q_idx, 
					  tx_bd_q + queued, batch );

	  queued += rc;

	  if( queued == tomove )
	    {
	      // success - all BDs moved OK

	      nicbfp->tx2_ctxt[chan].tx_bd_q = (U16) (tx_bd_q + queued);

  NIC_TRACE(TRACE_TYPE_TX2_TRACE,"2upbdsQQ", 0x007, 
	     chan, tx_h_prod, nicbfp->tx2_ctxt[chan].tx_bd_q, 
	     queued );       

	      return OK;
	    }
	  
	  if( rc < batch )
	    {
	      // Must have run out of DMA assist slots
	      // Make a note so that we can trigger a thread to
	      // retry later
	      set_bit(nicbfp->tx2_bds_pend, chan);
	      nicbfp->tx2_ctxt[chan].tx_bd_q = (U16) (tx_bd_q + queued);

	      NIC_UTRACE("2upbdFa!",0xdead,0,0,0,0);

	      //PANIC();

	      return ERROR;
	    }

	  tx_bd_q_idx = 0;
	  batch = tomove - batch;  // the second batch
	  
	  goto top;
	}
      else
	{
	  // This channel is full already
	  NIC_TRACE(TRACE_TYPE_TX2_TRACE,"2upbdFu?", 0x009, 
		     tx_h_prod, tx_bd_q, space, 0);
	  return OK;
	}
    }
  else
    {
      // False Alarm
      
      /* We seem to get quite a lot of False Alarms, always when
         entering via the mailbox event poll routine. I don't
         understand quite why it happens so often, though I believe
         that an unlikley but  non-dangerous race is possible. 

	 This probably requires further investigation, but for now,
	 I've downgraded the trace from DEBUG to TRACE 
       */

      NIC_TRACE(TRACE_TYPE_TX2_TRACE,"2upbdFA?", 0x008, 
		usd2_ctrl_p[chan].tx_prod, tx_bd_q, 
		0, trp->gen_control.mailbox_event_b );
   

      return OK;
    }
}

void tx2_upload_bds_end(void) {}
int (*tx2_upload_bds_stub)(int chan, U32 tx_h_prod);

void 
h_tx2_mbox_poll(void)
{
    U32 e;
    U32 mbox_event;
    int max;

    /* Find out which mailboxes have been frobbed */
    mbox_event = trp->gen_control.mailbox_event_b;

    e = pri(mbox_event, TX2_MBOX_MASK );  // XXX 4 New mailboxes only ! USD2

    max = nicbfp->max_ctxt_id_b;  // `cache' volatile

    while(e)
      {
	int usd2mbox = e - ((32-USD2_NUM_MBOXS)+1); 
	int hint, chan;

	NIC_TRACEV(TRACE_TYPE_TX2_TRACE,"tx2event", 0x2, 
		   mbox_event, e, tsp->mailbox[e-1].mbox_low, usd2mbox);

#define HINT_MASK ( (~(USD2_NUM_MBOXS-1)) & (USD2_NUM_CHANS-1) )

	hint = ( tsp->mailbox[e-1].mbox_low & HINT_MASK ) |
	  usd2mbox;
	  
	chan = hint;

	NIC_TRACEV(TRACE_TYPE_TX2_TRACE,"tx2evenX", 0x2, 
		   chan, max, 0, 0);

        // It would be nice to batch together the Mbox bits that need
	// to be cleared and then do it at the end. However, we need
	// to do it here to avoid a classic race...

	trp->gen_control.mailbox_event_b = ( 1<<(e-1) );

	if ( chan > max )   // avoid a bogus hint
	  goto skip;

	do  // loop over all channels MUX'ed to this MBox
	  {
	    int rc;
	    U32 tmp, ntp, ntr;

	    // Any work to do here?

	    NIC_TRACE(TRACE_TYPE_TX2_TRACE,"tx2kick", 0x2, 
	       mbox_event, e, hint, chan);	    

	    tmp = ((U32*)&usd2_ctrl_p[chan])[0];

	    ntp = tmp>>16;
	    ntr = tmp&0xffff;
	      
	    if ( ntp != nicbfp->tx2_ctxt[chan].cache_tx_prod )
	      {
		int in_q;

		nicbfp->tx2_ctxt[chan].cache_tx_prod = ntp;
		
		in_q = (nicbfp->tx2_ctxt[chan].tx_bd_q - 
			nicbfp->tx2_ctxt[chan].tx_bd_done)
		  & 0xffff;
		
		if( in_q <= (TX2_NUM_BDs/2) )
		  {		       
		    // upoad any bd's
		    rc = (*tx2_upload_bds_stub)(chan, ntp );
		  }
		else
		  {
		    set_bit( nicbfp->tx2_bds_unseen, chan);
		  }
	      }

	
	    // horrid bug : what about writing ref to the same value!
	    // fix me sometime...
	    if ( ntr != nicbfp->tx2_ctxt[chan].cache_tx_ref )
	      {

              nicbfp->tx2_ctxt[chan].cache_tx_ref = ntr;

	      if( ((ntp-nicbfp->tx2_ctxt[chan].tx_bd_done) & 0xffff) <= 
		  ((ntp-ntr) & 0xffff) )
		{
		  // already in the zone!
		  set_bit( tsp->gen_com.tx2_interrupts_active, chan );
		  trp->gen_control.misc_local_control |= 
		    TG_MLC_SET_INTERRUPT;

		  nicbfp->tx2_ctxt[chan].irq_primed=0;

NIC_TRACE(TRACE_TYPE_TX2_IRQ,"TX2refZ", 0x334, 
	   ntp,
	   ntr,
	   nicbfp->tx2_ctxt[chan].tx_bd_done,
	   tsp->gen_com.tx2_interrupts_active[0]);


		}
	      else
		{
		  clear_bit( tsp->gen_com.tx2_interrupts_active, chan );

		  nicbfp->tx2_ctxt[chan].irq_primed=1;
NIC_TRACE(TRACE_TYPE_TX2_IRQ,"TX2refC", 0x334, 
	   ntp,
	   ntr,
	   nicbfp->tx2_ctxt[chan].tx_bd_done,
	   tsp->gen_com.tx2_interrupts_active[0]);

		}		  
	      }


	    // find next candidate

	    chan += USD2_NUM_MBOXS;
	    if( chan > max )
	      {
		chan = usd2mbox; // wrap to start
	      }

	  }
	while(chan != hint);  // do{}while  back to where we started ?

      skip:

#if 0
	if( nicbfp->bd_dmas_in_q > BD_DMAs_IN_Q_X_OFF )
	  {
	    // we have overstepped our rough limit
	    
	  }
#endif
	// reading the mbox event register should be pretty fast, so
	// we reread it rather than using a `cached copy'

	mbox_event = trp->gen_control.mailbox_event_b;

	e = pri(mbox_event, 0xf0000000 );  // XXX 4 New mailboxes only ! USD2
      } /* end of while(e) */
}
void 
h_tx2_mbox_poll_end(void) {}

/* Pointers for the scratchpad relocation */
void_fn_t h_tx2_mbox_poll_stub;


static void 
tx2_print_stats(void)
{
  int chan;

  NIC_TRACE(TRACE_TYPE_TX2_STATS,"*TXstatD", 0, 
	    trp->host_dma_assist.read_chan_lo_pri_producer
	      - tdp->rd_dma_lo_ring,
            trp->host_dma_assist.read_chan_lo_pri_consumer
	      - tdp->rd_dma_lo_ring,
            trp->host_dma_assist.read_chan_lo_pri_ref
	      - tdp->rd_dma_lo_ring,
	    (trp->host_dma_assist.read_chan_lo_pri_producer-
	    trp->host_dma_assist.read_chan_lo_pri_ref)&
	    (TG_DMA_ASSIST_DESCRS-1));

  //  NIC_TRACE(TRACE_TYPE_TX2_STATS,"TXstatS", 0, 
  NIC_UUTRACE("TXstatS", 0, 
	    nicbfp->bd_dmas_in_q,
	    TX2_PKT_BUFS - pop_count(nicbfp->tx2_free_bufs),
	    nicbfp->tx2_ever_used,
	    nicbfp->tx2_pkts_sent);

  nicbfp->tx2_pkts_sent =0; // grim hack.
  

  NIC_TRACE(TRACE_TYPE_TX2_STATS,"TXstatM", 0, 
	    trp->local_mem_conf.mac_tx_descr_producer,
	    trp->local_mem_conf.mac_tx_descr_consumer,
	    trp->local_mem_conf.mac_tx_descr_ref,
	    trp->local_mem_conf.mac_tx_descr_producer -
	    trp->local_mem_conf.mac_tx_descr_ref);


  NIC_TRACE(TRACE_TYPE_TX2_STATS,"TXstatB", 0, 
	    trp->mac_control.mac_tx_state,
	    trp->local_mem_conf.tx_buf_producer,
	    trp->local_mem_conf.tx_buf_consumer,
	    trp->local_mem_conf.tx_buf_next
	    );


  NIC_TRACE(TRACE_TYPE_TX2_STATS,"TXstatN", 0, 
	    trp->host_dma.dma_wr_state,
	    trp->host_dma.dma_rd_state,
	    nicbfp->tx2_free_bufs,
	    trp->gen_control.event_b
	    );

  for(chan=0;chan<=nicbfp->max_ctxt_id_b;chan++)
    { 
      U32 tx_h_prod, tx_bd_q;

      if( nicbfp->tx2_ctxt[chan].tx2_ring_ptr == 0 ) continue;

      tx_h_prod = usd2_ctrl_p[chan].tx_prod;
      tx_bd_q = nicbfp->tx2_ctxt[chan].tx_bd_q; 

      NIC_TRACE(TRACE_TYPE_TX2_STATS,"TXstat1", chan, 
		tx_h_prod,
		tx_bd_q,
		nicbfp->tx2_ctxt[chan].tx_bd_next,	
		usd2_ctrl_p[chan].tx_cons
		//		nicp->tx2_consumer[chan]
		);

      NIC_TRACE(TRACE_TYPE_TX2_STATS,"TXstat2", chan, 
       (tx_h_prod - nicbfp->tx2_ctxt[chan].tx_bd_next) &0xffff ,
       (tx_bd_q - nicbfp->tx2_ctxt[chan].tx_bd_next) &0xffff,
       (nicbfp->tx2_ctxt[chan].tx_bd_rdy - 
	nicbfp->tx2_ctxt[chan].tx_bd_next)&0xffff, 0);

#ifdef TX_SHAPER_SCHED
      NIC_TRACE(TRACE_TYPE_TX2_STATS,"TXstat3", chan, 
		is_bit_set(nicbfp->tx2_bds_rdy,chan),
		is_bit_set(nicbfp->tx2_bds_allowed,chan),
		nicbfp->sched_mask,
		//nicbfp->tx2_ctxt[chan].credit,
		nicbfp->tx2_ctxt[chan].last_credit
		);
#endif
  
    }
}


void
h_hf_timer(void)
{

#ifdef TX_SHAPER_SCHED
  {

    U32 nowplus = trp->gen_control.timer + SCHED_SLOP;

    //ASSERT( U32S_GE(trp->gen_control.timer, spq_head_key()) );
    //ASSERT( spq_entries() > 0 );
    
    do
      {

	NIC_TRACE(TRACE_TYPE_TX2_SCHED,"TXAdCred", spq_head_data(), 
		  spq_head_key(),
		  is_bit_set(nicbfp->tx2_bds_allowed, spq_head_data()),
		  spq_entries(),
		  0);

	// [USD2_NUM_CHANS] is used as sentinel for stats timer
	set_bit(nicbfp->tx2_bds_allowed, spq_head_data() ); 
	spq_remove_head();
      }
    while( spq_entries() && spq_head_test(nowplus) );

    NIC_TRACEV(TRACE_TYPE_TX2_SCHED,"TXheapDb", spq_entries(),
	      spq_head_data(),	      
	      nowplus,
	      spq_head_key(),
	      is_bit_set(nicbfp->tx2_bds_allowed, spq_head_data()) );

    if( U32S_LT( nicbfp->next_stats_time, nowplus ) )
      {
	tx2_print_stats();
	nicbfp->next_stats_time += (TG_TICK_1US * 1000000U);	

	spq_insert( nicbfp->next_stats_time, USD2_NUM_CHANS ); // XXX
	
	NIC_TRACEV(TRACE_TYPE_TX2_SCHED,"TXheapSt", spq_entries(),
		   spq_head_data(),	      
		   nowplus,
		   spq_head_key(),
		   is_bit_set(nicbfp->tx2_bds_allowed,spq_head_data()) );
      }

    //ASSERT( spq_entries() > 0 );
    
    trp->gen_control.timer_ref_b = spq_head_key();

    // assuming there was work other than TXStats, we may have
    // unblocked something
    (*tx2_select_pkt_for_upload_stub)();

  }
#else
  {
    U32 time;
    /* high frequency timer loop */

    /* reset timer */
    time = trp->gen_control.timer;
    trp->gen_control.timer_ref_b = time + (TG_TICK_1US * 500); 
    
    
    if( time > nicbfp->next_stats_time )
      {
	tx2_print_stats();
	nicbfp->next_stats_time = time + (TG_TICK_1US * 1000000);	
      }
  }
#endif
}

void h_hf_timer_end(void) {}
/* Pointers for the scratchpad relocation (CPU B)*/
void_fn_t hf_timer_stub;

void h_mac_tx2_attn(void)
{
  
  NIC_UTRACE("!MacTxAt", 0xdead, 
	     trp->mac_control.mac_tx_state,
	     trp->mac_control.mac_tx_config,
	     0,0
	     );
	     
  PANIC();
}



