/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: timer.c,v $
 * Revision 1.12  2000/03/31 12:18:50  iap10
 * *** empty log message ***
 *
 * Revision 1.10  1999/12/01 10:55:01  iap10
 * *** empty log message ***
 *
 * Revision 1.9  1999/11/01 15:32:44  iap10
 * *** empty log message ***
 *
 * Revision 1.8  1999/10/13 14:30:34  iap10
 * *** empty log message ***
 *
 * Revision 1.7  1999/09/24 11:09:33  iap10
 * before new send path
 *
 * Revision 1.6  1999/08/10 15:05:33  tjd21
 * First version by kaf.
 *
 * Revision 1.5  1999/07/12 13:17:40  tjd21
 * Scheduling in place, ready for multiple USDs
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 * 
 * $EndLog$
 */
/*
 * FILE timer.c
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/timer.c,v $
 * $Revision: 1.12 $ $Locker: iap10 $
 * $Date: 2000/03/31 12:18:50 $ $Author: iap10 $ $State: Exp $
 */

#ifndef __lint
static const char rcsid[] = "$Header: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/timer.c,v 1.12 2000/03/31 12:18:50 iap10 Exp iap10 $";
#endif /* __lint */

#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "trace.h"
#include "proto.h"
#include "link_if.h"
#include "dma.h"
#include "ring.h"
#include "timer.h"

#include "mac.h"
#include "zconf.h"
#include "link_op.h"
#include "led.h"
#include "assert.h"


void init_timer(void)
{
    NIC_TRACEV(TRACE_TYPE_TIMER, "initTm_A", 0x50100,
               TG_TICK_SLOW,0,0,0);

    /* init prescaler */
    if ( (trp->gen_control.misc_host_control & TG_MHC_TIGON_VERSION_MASK) !=
         TG_MHC_LSI_STANDARD_CELL_VERS_B )
    {
        PANIC();
    }

    trp->gen_control.misc_config =
        (trp->gen_control.misc_config & ~TG_MSC_TIMER_PRESCALER_MASK) |
        0x55;   /* for 86 Mhz */

    /* init timer values */
    trp->gen_control.timer_ref = trp->gen_control.timer + TG_TICK_SLOW;
}

#if 0
void init_timer_b(void)
{
    NIC_TRACEV(TRACE_TYPE_TIMER, "initTm_B", 0x50200,
               TG_TICK_FAST,0,0,0);
    trp->gen_control.timer_ref_b = trp->gen_control.timer + TG_TICK_FAST;
}
#endif
