/*
 *  rx2.c
 *  -----
 *
 *  Support for NEW per-connection TX interface (RX2).
 *
 *  Copyright (c) 1999, Ian Pratt
 *  Modifications copyright (c) 1999-2000, K A Fraser
 *
 *  Please read the FIRMWARE-LICENSE file distributed with this source file
 *  for details of the license agreement.
 *
 *  $Id: rx2.c,v 1.25 2000/03/31 12:18:50 iap10 Exp iap10 $
 */

#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "proto.h"
#include "ring.h"
#include "usd_conn.h"
#include "assert.h"
#include "usd2_util.h"

#include "mem.h"
#include "cksum.h"

#include "mac.h"
#include "link.h"
#include "link_op.h"
#include "link_if.h"
#include "zconf.h"
#include "mii.h"

# if 0
static inline void rx2_send_consumer_updates(void);
static inline U32 q_cons_to_host_high(tg_hostaddr_t host_addr, U32 nic_addr, U32 len, U16 type, U16 id, U32 index, U32 state);
static inline tgDmaDescr_t * get_next_rd_dma_high_descr( tgDmaDescr_t * ddp );
static inline tgDmaDescr_t * get_next_wr_dma_high_descr( tgDmaDescr_t * ddp );
#endif

static inline int rx2_upload_bds_all_contig( int chan, int didx, U32 sidx, int num );
static inline int rx2_upload_bds_dst_contig( int chan, int didx, U32 rx_bd_q, int num );

static void rx2_print_stats(void);

static inline
void clear_fired_rx2_ints(void)
{
    nicfp->rx2_interrupts_primed[0] &= ~tsp->gen_com.rx2_interrupts_active[0]; 
}

static inline U32 q_bd_to_nic_high(tg_hostaddr_t host_addr, U32 nic_addr, 
				   U32 len, U16 type, U16 id, 
				   U32 index, U32 state);

/** All of this code runs on CPU A **/

static void
install_new_filter( int id, int frag, int len )
{
  struct tg_event event;

  // this only deals with one frag at the moment

  // atomic w.r.t. incomming packets
  wcopy( (U32*)filter_buf, (U32*)scratch_pad_loc, len>>2 );

  nicp->new_filter_install_id = -1; // all frags installed, nothing in progress

  NIC_UTRACE("FltrInst", 0x2902, id, frag, len, scratch_pad_loc );

  event.TG_EVENT_w0 = (TG_EVENT_USD_FILTER_INSTALLED << TG_EVENT_EVENT_SHIFT)
    | id;
  must_enq_event(&event);
}

void rx2_poll( int chan )
{
  U32 tmp, nfp, nrp;
  int rc;
  
  tmp = ((U32*)&usd2_ctrl_p[chan])[1];
  
  nfp = tmp>>16;
  nrp = tmp&0xffff;
  
  NIC_TRACE(TRACE_TYPE_RX2_TRACE,"rx2kick2", 0x3, 
	    nfp, nicfp->rx2_ctxt[chan].cache_free_prod,
	    nrp, nicfp->rx2_ctxt[chan].cache_rx_ref);	    
  
  if ( nfp != nicfp->rx2_ctxt[chan].cache_free_prod )
    {
      int in_q;
      nicfp->rx2_ctxt[chan].cache_free_prod = nfp;
		  
      in_q = (nicfp->rx2_ctxt[chan].rx_bd_q - 
	      nicfp->rx2_ctxt[chan].rx_bd_done)
	& 0xffff;
		  
      if( in_q <= (RX2_NUM_BDs/2) )
	{			  
	  // upoad any bd's
	  rc = (*rx2_upload_bds_stub)(chan, nfp );
	}
      else
	{
	  set_bit( nicfp->rx2_bds_unseen, chan);
	}
                  
    }

  // horrid bug : what about writing ref to the same value!
  // fix me sometime...
  if ( nrp != nicfp->rx2_ctxt[chan].cache_rx_ref )
    {

      NIC_TRACEV(TRACE_TYPE_RX2_IRQ,"RX2refU", chan, 
		 nfp,
		 nrp,
		 nicfp->rx2_ctxt[chan].cache_rx_ref,
		 tsp->gen_com.rx2_interrupts_active[0]);

      nicfp->rx2_ctxt[chan].cache_rx_ref = nrp;

      if( ((nfp-nicfp->rx2_ctxt[chan].rx_bd_done) & 0xffff) <= 
	  ((nfp-nrp) & 0xffff) )
	{
	  // already in the zone!
	  set_bit( tsp->gen_com.rx2_interrupts_active, chan );
	  trp->gen_control.misc_local_control |= 
	    TG_MLC_SET_INTERRUPT;
	  clear_fired_rx2_ints();
                        
	  NIC_TRACE(TRACE_TYPE_RX2_IRQ, "RXHldInZ", chan,
		    nfp,
		    nrp,
		    nicfp->rx2_ctxt[chan].rx_bd_done,
		    nicfp->next_int);

	  NIC_TRACE(TRACE_TYPE_RX2_IRQ,"RX2refZ", chan, 
		    nfp,
		    nrp,
		    nicfp->rx2_ctxt[chan].rx_bd_done,
		    tsp->gen_com.rx2_interrupts_active[0]);
	}
      else
	{
	  clear_bit(tsp->gen_com.rx2_interrupts_active, chan);
	  set_bit(nicfp->rx2_interrupts_primed, chan);
                        
#ifdef RX_INT_HOLDOFF
	  nicfp->rx2_ctxt[chan].trigger_next_pkt = 1;
#endif
	  NIC_TRACE(TRACE_TYPE_RX2_IRQ, "RXHldOuZ", chan,
		    nfp,
		    nrp,
		    nicfp->rx2_ctxt[chan].rx_bd_done,
		    nicfp->next_int);
                        
                        
	  NIC_TRACE(TRACE_TYPE_RX2_IRQ,"RX2refC", chan, 
		    nfp,
		    nrp,
		    nicfp->rx2_ctxt[chan].rx_bd_done,
		    tsp->gen_com.rx2_interrupts_active[0]);
                        
	}		  
    }        
}
void rx2_poll_end(void){};
void (*rx2_poll_stub)(int);


//XXXX This needs rewriting at some point
void
h_mac_rx_comp_nohost(void)
{
  //U32 mdp_prod;
  //U32 buf_prod;
  //U32 tmp;

    NIC_TRACE(TRACE_TYPE_RECV, "#rNohst", 0x70500,
        nicfp->stats.ifHCInOctets,
        nicfp->stats.ifHCInUcastPkts,
        0,
        0);

    NIC_UTRACE("#rNohst", 0x70500,
        nicfp->stats.ifHCInOctets,
        nicfp->stats.ifHCInUcastPkts,
        0,
        0);

    PANIC();

#if 0
    /* save both producers so they don't change on us */
    mdp_prod = ROUNDDN((U32)trp->local_mem_conf.mac_rx_descr_producer, 8);
    buf_prod = trp->local_mem_conf.rx_buf_producer;

    /* calculate the number of rx descriptors that have completed
     * we're not really looking at the frames, so just account them all
     * to the unicast counter
     */
    tmp = mdp_prod - (U32)trp->local_mem_conf.mac_rx_descr_ref;
    if (tmp >= (TG_NUM_MAC_RX_DESCRS * sizeof(tgMacDescr_t)))
         tmp += (TG_NUM_MAC_RX_DESCRS * sizeof(tgMacDescr_t));
    tmp /= sizeof(tgMacDescr_t);
    nicfp->stats.ifHCInUcastPkts += tmp;

    /* calculate the amount of buffer space that has been consumed */
    tmp = buf_prod - trp->local_mem_conf.rx_buf_consumer;
    if (tmp >= NIC_RX_BUF_SIZE)
        tmp += NIC_RX_BUF_SIZE;
    nicfp->stats.ifHCInOctets += tmp;

    /* update our consumer and ref so we can proceed */
    trp->local_mem_conf.rx_buf_consumer = buf_prod;
    trp->local_mem_conf.mac_rx_descr_consumer = (tgMacDescr_t *)mdp_prod;
    trp->local_mem_conf.mac_rx_descr_ref = (tgMacDescr_t *)mdp_prod;

    RETURN(TG_FW_EVENT_NUM_MAC_RX_COMP);
#endif
}


inline int static
free_mac_descrs(  tgMacDescr_t *mdProd, tgMacDescr_t *mdCons)
{   

  U32 numOfFrames, mdFree;

  numOfFrames = mdProd - mdCons;
  if (numOfFrames < 0)  /* wrap */
    numOfFrames += TG_NUM_MAC_TX_DESCRS;
  
  mdFree = TG_NUM_MAC_TX_DESCRS - numOfFrames;

  return mdFree;
}

inline int static
free_mac_space(U32 bProd, U32 bCons)
{
  U32 bFree;

  if( bProd > bCons )
    {
      bFree = NIC_RX_BUF_SIZE - (bProd - bCons);
    }
  else
    bFree = (bCons-bProd);

  return bFree;
}




// runs on CPU A
void
h_mac_rx2_attn(void)
{
    U32 save_rx_state;
    U32 StartOfNeeded, mdFree, bFree;
    tgMacDescr_t *mdProd, *mdCons;
    U32 bProd, bCons;

    nicfp->stats.nicMacRxTotalAttns++;
    save_rx_state = trp->mac_control.mac_rx_state;

    NIC_UTRACE("#rMacATN", 0x80400, 
        save_rx_state,
        nicfp->stats.nicMacRxBufAttns,
        nicfp->stats.nicMacRxBufDescrAttns,
        link_ready);

    NIC_UTRACE("rMacATN0", 0x80401, 
	       trp->local_mem_conf.rx_buf_producer,
	       trp->local_mem_conf.rx_buf_consumer,
	       trp->local_mem_conf.mac_rx_descr_producer,
	       trp->local_mem_conf.mac_rx_descr_consumer);

    /* RX state attns are ordered from most time critical to least */
    if (save_rx_state & ( TG_MAC_RX_STATE_BUF_ATTN
			| TG_MAC_RX_STATE_IND_ATTN))
      {
        nicfp->stats.nicMacRxBufAttns++;

        /* Stop reception of new frames, clear ATTN bits */
	// XXXX This doesn't stop it immediately!!!!!!
        trp->mac_control.mac_rx_state = 
            (trp->mac_control.mac_rx_state & ~TG_MAC_RX_ATTN_MASK) |
            TG_MAC_RX_STATE_STOP_NEXT;

	// With Tigon 5, only way I can stop getting these events is to
	// disable RX_ATTN in main event register!

	event_mask &= ~TG_FW_EVENT_MAC_RX_ATTN;
	
	// make a note that we've stalled RX. Timer will restart

	nicfp->rx2_mac_rx_state = 1; 

	/* This little bugger could still be moving... */
	bProd = trp->local_mem_conf.rx_buf_producer;
	bCons = trp->local_mem_conf.rx_buf_consumer;

	/* bump the producer back to the start of the frame */
	(U32)mdProd =
	  ROUNDDN((U32)trp->local_mem_conf.mac_rx_descr_producer, 8);
  
	mdCons = trp->local_mem_conf.mac_rx_descr_consumer;

	bFree  = free_mac_space(bProd, bCons);
	mdFree = free_mac_descrs(mdProd, mdCons);
	
	/* This is the start of the packet that we expected to process next */
	StartOfNeeded = mdCons->w0 & TG_MAC_RX_W0_ADDR_MASK;

	NIC_UTRACE("rMacATN-", 0x80402, 
		mdFree, bFree, StartOfNeeded, bCons );

	NIC_UTRACE("rMacATNx", 0x80402, 
		   trp->mac_control.mac_rx_state,   
		   save_rx_state,
(trp->mac_control.mac_rx_state & ~TG_MAC_RX_ATTN_MASK) |
            TG_MAC_RX_STATE_STOP_NEXT
		   ,0);

#if 0
	if( bFree > NIC_RX_BUF_LO )  PANIC(); /* XXX sanity check */
	if( StartofNeeded != bCons ) PANIC(); /* XXX sanity check */
#endif

	/* Let's leave the damn thing turned off and wait for 
	   the slow ticker to reenable it later */

	return;
      }

    /* this bit is only set when the link state changes.
     * Once it goes down, it will stay down until link is re-established.
     */
    if (save_rx_state & TG_MAC_RX_STATE_LINK_STATE_ATTN) {

        /* clear attn  and fall through */
        nicfp->stats.nicMacRxLinkAttns++;
        trp->mac_control.mac_rx_state = 
            (trp->mac_control.mac_rx_state & ~TG_MAC_RX_ATTN_MASK) |
            TG_MAC_RX_STATE_LINK_STATE_ATTN;
	/* no sync */
	link_down_notify();
	return;
    }

    if (save_rx_state & TG_MAC_RX_STATE_NOT_SYNCED_ATTN) {
        nicfp->stats.nicMacRxSyncAttns++;
        link_down_notify();

        /* clear attn */
        trp->mac_control.mac_rx_state = 
            (trp->mac_control.mac_rx_state & ~TG_MAC_RX_ATTN_MASK ) |
            TG_MAC_RX_STATE_NOT_SYNCED_ATTN;

	return;
    }

    if (save_rx_state & TG_MAC_RX_STATE_AUTO_NEG_CHNGD)
      {
        nicfp->stats.nicMacRxConfigAttns++;
        ENABLE_MAC_RX();
        autoneg_8023z(save_rx_state);

        /* clear attn */
        trp->mac_control.mac_rx_state = 
            (trp->mac_control.mac_rx_state & ~TG_MAC_RX_ATTN_MASK) |
            TG_MAC_RX_STATE_AUTO_NEG_CHNGD;

	return;
    }

    if (save_rx_state & TG_MAC_RX_STATE_FIFO_OVERRUN) {
        ASSERT(0);
    }
    
    if (save_rx_state & TG_MAC_RX_STATE_XOFF_ATTN) {
        ASSERT(0);
    }

    if (save_rx_state & TG_MAC_RX_STATE_XON_ATTN) {
        ASSERT(0);
    }


    PANIC();
}
void h_mac_rx2_attn_end(void) {}
void_fn_t h_mac_rx2_attn_stub;

void
h_dma_wr_asst_hi_A(void)  
{
  /* runs on CPU A. 
  */

  struct tg_dma_descr *ddp, *dd_cons;



  ddp     = trp->host_dma_assist.write_chan_hi_pri_ref;
  dd_cons = trp->host_dma_assist.write_chan_hi_pri_consumer;

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3WRmCpXX", 0x62609,
            trp->host_dma.dma_wr_state,
            trp->host_dma_assist.assist_state,
            trp->host_dma.dma_wr_loc_addr,
            trp->host_dma.dma_wr_len);


  //  NIC_UTRACE( "3WRmCpXX", 0x62609,ddp->type,ddp->usd_id,ddp->index,ddp->len);

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3WRmCp", 0x62600,
            trp->host_dma_assist.write_chan_hi_pri_producer,
            trp->host_dma_assist.write_chan_hi_pri_consumer,
            ddp,
            (ddp - tdp->wr_dma_hi_ring));

  NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3WRmCpD0", 0x62800,
            *(U32 *)ddp,		/* host addr */
            *((U32 *)ddp + 1),	/* host addr */
            *((U32 *)ddp + 2),	/* nic addr */
            *((U32 *)ddp + 3));	/* reserved & len */

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3WRmCpD1", 0x62900,
            *((U32 *)ddp + 4),	/* state */
            *((U32 *)ddp + 5),	/* reserved & cksum addr */
            *((U32 *)ddp + 6),	/* type */
            *((U32 *)ddp + 7));	/* index */

    // not a race since this is single threaded....
    // this should clear the event
  trp->host_dma_assist.write_chan_hi_pri_ref = ddp+1;

    if( ddp->type == TIGON_TYPE_RECV_DATA )
      {
	  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3WRCpSDa", 0x62600,
		     ddp->usd_id,ddp->index,0,0);
		     
	// do nothing : FUTURE CANDIDATE FOR AVOIDANCE LOGIC!! XXX
	return;
      }
    else if( ddp->type == TIGON_TYPE_RECV_DATA_LAST )
      {
	int chan = ddp->usd_id;
	tgMacDescr_t * md = &tdp->rx_mac_ring[ddp->index];
	int end;

	/* I'd like to do nothing here and let all the clean up happen
	   in TIGON_TYPE_RECV_BD, but we can't because we need to use
	   the ddp->index field to convey different information... */

	// Here, index is the Mac RX Descr index

	// free up the space in the MAC RX buf	
	end = md->w0 + (md->w1 & TG_MAC_RX_W1_LEN_MASK);
	trp->local_mem_conf.rx_buf_consumer = end;

	NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3WRCpSDL", 0x62600,
		     chan,ddp->index,md,end);


	// free the MAC Descr
	trp->local_mem_conf.mac_rx_descr_consumer = md+1;
	
	/* After doing this, we should try to scan further 
	   up the MAC Descr list throwing away Error or Invalid 
	   bufs. */

	while( (md=trp->local_mem_conf.mac_rx_descr_consumer) != 
	       nicfp->mac_rx_descr_queued )
	  {
	    if( (md->w1 & TG_MAC_RX_W1_STATUS_MASK) == 0 )
	      {
		// this packet was OK
		break;
	      }

	    NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3WRCpSkp", 0x62600,
		      md, nicfp->mac_rx_descr_queued, 
		      md->w0, md->w1);

	    trp->local_mem_conf.mac_rx_descr_consumer++;
	    trp->local_mem_conf.rx_buf_consumer = md->w0;  // safe
	    
	  }

	return;
      }
    else if( ddp->type == TIGON_TYPE_RECV_BD_LAST )
      {
	int chan = ddp->usd_id;
	int in_q;
	int index = ddp->index;
	U32 now;

	NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3WCpRBDL", 0x62600,
		     chan,index,nicfp->rx2_ctxt[chan].cache_rx_ref,0);

	// NB. Index is used to carry the 16 bit host producer index here
	// --it's what we're supposed to update `rx_bd_done' to.
	nicfp->rx2_ctxt[chan].rx_bd_done = index;


	// new way without DMA. Don't Poll from host!
	usd2_ctrl_p[chan].rx_prod = index;

#if 1

#if 0
NIC_UTRACE("FUCK", 0xdead,
	   is_bit_set(nicfp->rx2_interrupts_primed, chan),
	   nicfp->rx2_ctxt[chan].cache_free_prod, index,
	   nicfp->rx2_ctxt[chan].cache_rx_ref);
#endif

        if( is_bit_set(nicfp->rx2_interrupts_primed, chan) &&
            (((nicfp->rx2_ctxt[chan].cache_free_prod-index) & 0xffff) <= 
             ((nicfp->rx2_ctxt[chan].cache_free_prod-
               nicfp->rx2_ctxt[chan].cache_rx_ref) & 0xffff)) )
            goto ref_equals_index;
#else
	// See if this has caused us to catch up with ref ptr
	if( nicfp->rx2_ctxt[chan].cache_rx_ref == index )
            goto ref_equals_index;  // out line
#endif

#ifdef RX_INT_HOLDOFF
	if( nicfp->rx2_ctxt[chan].trigger_next_pkt )
	  goto trigger_next;	  // out line
#endif

      finish_off_rx:  // the above 2 out-lines return here.

	in_q = (nicfp->rx2_ctxt[chan].rx_bd_q - 
		nicfp->rx2_ctxt[chan].rx_bd_done)
	        &0xffff;

	if( in_q <= (RX2_NUM_BDs/2) )
	  {
	    //  (*rx2_poll_stub)(chan);
	    if(is_bit_set_and_clear( nicfp->rx2_bds_unseen, chan) )
	      {	    	   
		(*rx2_upload_bds_stub)(chan, 
				       nicfp->rx2_ctxt[chan].cache_free_prod);
	      }
          }
	return;


	// We only ever GOTO this point, never fall through

      ref_equals_index:

	// interrupt host
	set_bit( tsp->gen_com.rx2_interrupts_active, chan );
	trp->gen_control.misc_local_control |= TG_MLC_SET_INTERRUPT;
        clear_fired_rx2_ints();

	nicfp->next_int += (1U<<30); // push into way into future
	NIC_TRACE(TRACE_TYPE_RX2_IRQ,"RX2refX", chan, 
		  nicfp->rx2_ctxt[chan].cache_free_prod,
		  nicfp->rx2_ctxt[chan].cache_rx_ref,
		  nicfp->rx2_ctxt[chan].rx_bd_done,
		  tsp->gen_com.rx2_interrupts_active[0]);
      
        NIC_TRACE(TRACE_TYPE_RX2_IRQ, "RXHldEvnt", chan,
                  0, nicfp->next_int, 
                  nicfp->rx2_ctxt[chan].trigger_next_pkt, 0);

	goto finish_off_rx;  // deliberately avoid trigger_next test

#ifdef RX_INT_HOLDOFF
      trigger_next:

	now = trp->gen_control.timer;

	nicfp->rx2_ctxt[chan].trigger_next_pkt = 0;
	set_bit( tsp->gen_com.rx2_interrupts_active, chan );

#define HOLDOFF 1000 // was 5000
	
	if( (S32) (nicfp->next_int - now) > HOLDOFF )
	  {
	    nicfp->next_int = now + (U32) HOLDOFF;       
	  }
	
       NIC_TRACE(TRACE_TYPE_RX2_IRQ, "RXHldTrig", chan,
                 now, nicfp->next_int, 0, 0);

	goto finish_off_rx; 
#endif

      } 
    else if( ddp->type == TIGON_TYPE_RECV_BD )
      {
	int chan = ddp->usd_id;
	
	// Candidate for Assist Avoidance !

	NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3WRCpRBD", 0x62600,
		     chan,ddp->index,0,0);

	return;
      }
    else if( ddp->type == TIGON_TYPE_EVENT )
      {
	NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3WRCpEvt", 0x62600,
		     ddp->usd_id,ddp->index,0,0);
	return;
      }
    else if( ddp->type == TIGON_TYPE_EVENT_PROD )
      {
	NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3WRCpEvP", 0x62600,
		     ddp->usd_id,ddp->index,0,0);

        grab_spin_lock();
	tsp->gen_com.event_interrupt = 1;
	trp->gen_control.misc_local_control |= TG_MLC_SET_INTERRUPT;
        clear_fired_rx2_ints();
        free_spin_lock();
	return;
      }
    else if ( ddp->type != TIGON_TYPE_NULL )
      {
	NIC_UTRACE("3WRDma?", 0x62600,
                  trp->host_dma_assist.write_chan_hi_pri_producer,
                  trp->host_dma_assist.write_chan_hi_pri_consumer,
                  ddp,
                  (ddp - tdp->wr_dma_hi_ring));	

	NIC_UTRACE("3WRDmaX1", 0x62600,
		   ddp->type, 0, 0, 0);


	PANIC();
	return;
      }

}

void h_dma_wr_asst_hi_A_end(void) {}

void_fn_t h_dma_wr_asst_hi_A_stub;  


static inline int 
download_bds( int chan, tgDmaDescr_t *dd_prod, tgDmaDescr_t *dd_ref,
	      int start, int end )
{
  tgDmaDescr_t *ndd_prod;
  
  int num, sidx, max1, batch1, batch2, host_dest;

  // due to stupid design we're only going to use 31 of the 32 slots
  ndd_prod = get_next_wr_dma_high_descr( dd_prod );

  if( ndd_prod == dd_ref)
    goto assist_abort;

  num = (end - start) &0xffff;

  sidx = start & (RX2_NUM_BDs-1);

  host_dest = nicfp->rx2_ctxt[chan].rx2_ring_ptr +
    ( (start & nicfp->rx2_ctxt[chan].rx_h_mask) * sizeof(rx2_descr_t) );

  max1 = RX2_NUM_BDs - sidx;

  MIN_first_likely( batch1, /* = */ num, max1 );

  fill_in_dma_record( dd_prod,
		      host_dest,
		      (U32)&(nicp->rx2_descr[chan][sidx]),
		      sizeof(rx2_descr_t) * batch1,
		      TIGON_TYPE_RECV_BD,
		      chan,
		      end,
		      RX2_DMA_TO_HOST_BD_STATE
		      );

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3DwnBD1", 0x62600,
	    chan,dd_prod->index,batch1,num);

  if(batch1 == num)
    {
      dd_prod->type = TIGON_TYPE_RECV_BD_LAST; // smack over top

      // We made it! The BDs fitted so hit Fire !!!!
      trp->host_dma_assist.write_chan_hi_pri_producer = ndd_prod;

      return OK;
    }


  // due to stupid design we're only going to use 31 of the 32 slots
  dd_prod  = ndd_prod;
  ndd_prod = get_next_wr_dma_high_descr( dd_prod );

  if( ndd_prod == dd_ref)
    goto assist_abort;

  batch2 = num - batch1;

  host_dest = nicfp->rx2_ctxt[chan].rx2_ring_ptr +
    ( ((start+batch1) & nicfp->rx2_ctxt[chan].rx_h_mask) * 
      sizeof(rx2_descr_t) );

  sidx = 0;

  fill_in_dma_record( dd_prod,
		      host_dest,
		      (U32)&(nicp->rx2_descr[chan][sidx]),
		      sizeof(rx2_descr_t) * batch2,
		      TIGON_TYPE_RECV_BD_LAST,
		      chan,
		      end,
		      RX2_DMA_TO_HOST_BD_STATE
		      );

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3DwnBD2", 0x62600,
	    chan,dd_prod->index,batch2,num);


  // We made it! The BDs fitted so hit Fire !!!!
  trp->host_dma_assist.write_chan_hi_pri_producer = ndd_prod;

  return OK;


assist_abort:
  nicfp->nicDmaWriteRingFull++;

  NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3DwBDFu!",
	    nicfp->nicDmaWriteRingFull,
	    chan,
	    trp->host_dma_assist.write_chan_hi_pri_producer,
	    trp->host_dma_assist.write_chan_hi_pri_consumer,
	    trp->host_dma_assist.write_chan_hi_pri_ref );
#if 0
  {
    print_assist_ring( "PrtWrHi", tdp->wr_dma_hi_ring,
		       trp->host_dma_assist.write_chan_hi_pri_ref,
		       trp->host_dma_assist.write_chan_hi_pri_producer
		       );

    print_assist_ring( "PrtWrLo", tdp->wr_dma_lo_ring,
		       trp->host_dma_assist.write_chan_lo_pri_ref,
		       trp->host_dma_assist.write_chan_lo_pri_producer
		       );

    print_assist_ring( "PrtRdHi", tdp->rd_dma_hi_ring,
		       trp->host_dma_assist.read_chan_hi_pri_ref,
		       trp->host_dma_assist.read_chan_hi_pri_producer
		       );

    print_assist_ring( "PrtRdLo", tdp->rd_dma_lo_ring,
		       trp->host_dma_assist.read_chan_lo_pri_ref,
		       trp->host_dma_assist.read_chan_lo_pri_producer
		       );

  }
#endif
  {
    int k=0;
    while( ! (trp->gen_control.event & TG_FW_EVENT_DMA_WR_ASST_HI) )
      {       
        int i;
	k++;
	for(i=0;i<15;i++);
      }
    
    NIC_TRACEV(TRACE_TYPE_RX2_DEBUG,"slotfree",0x12345,
	       k,
	       trp->host_dma_assist.write_chan_hi_pri_producer,
	       trp->host_dma_assist.write_chan_hi_pri_consumer,
	       trp->host_dma_assist.write_chan_hi_pri_ref );
  }



  return ERROR;
}


static inline int 
queue_for_delivery(int chan, int idx, U32 start, int hdrlen, int protolen)
{
  U32 copy_rx_bd_next, copy_rx_bd_rdy_eop;
  int i, remain;
  int thislen=0; // stop warning.
  tgDmaDescr_t *dd_prod, *ndd_prod, *dd_last, *dd_ref;


  copy_rx_bd_next      = nicfp->rx2_ctxt[chan].rx_bd_next;
  copy_rx_bd_rdy_eop   = nicfp->rx2_ctxt[chan].rx_bd_rdy_eop;

  dd_prod = trp->host_dma_assist.write_chan_hi_pri_producer; 
  // no `next available' producer on lo pri channel 
  
  // ref is cached non-volatile value of what we've ACK'ed up to
  dd_ref  = trp->host_dma_assist.write_chan_hi_pri_ref;

  // pointer to our current view of the last fragment
  dd_last = dd_prod; 

  // bytes remaining to be sent in this packet
  remain = protolen; 

  for(i=0; i<RX2_MAX_FRAGS; i++)
    {
      rx2_descr_t *fd;
      // due to stupid design we're only going to use 31 of the 32 slots
      ndd_prod = get_next_wr_dma_high_descr( dd_prod );
      
      // frag descriptor. 
      fd = &(nicp->rx2_descr[chan][copy_rx_bd_next % RX2_NUM_BDs ]);

      // we shouldn't have to worry about copy_rx_bd_next crossing
      // copy_rx_bd_rdy_eop since there MUST be an EOP bit set...
      // Check for sanity's sake...

      if( copy_rx_bd_next == copy_rx_bd_rdy_eop )
	goto screw_up;

      // consume this frag descriptor.
      copy_rx_bd_next = (copy_rx_bd_next + 1) & 0xffff;


      if( ndd_prod == dd_ref )
	{
	  nicfp->nicDmaWriteRingFull++;

	  NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3QfDvFu!", 
		    nicfp->nicDmaWriteRingFull,
		    chan,idx,0,0);

	  goto assist_abort;
	}

      if( i == 0 && fd->flags & RX2_DESCR_FLAGS_HDR )
	{
	  if( fd->length < hdrlen )
	    {
	      fd->flags |= RX2_DESCR_FLAGS_TRUNC;
	      thislen = fd->length;
	    }
	  else
	    {
	      thislen = hdrlen;
	      fd->length = hdrlen;   // update length field
	    }
	  remain -= hdrlen;
	}
      else 
	{
	  thislen = MIN( remain, fd->length );
	  fd->length = thislen;  // update length field

	  remain -= thislen;
      
	}
      
      // this BD has been used and is provisionally OK
      fd->flags |=  RX2_DESCR_FLAGS_DONE | RX2_DESCR_FLAGS_OK; 

      if( thislen > 0 )
	{
	  // we end up just skipping over any unused frags

	  // to start with, mark as RECV_DATA -- may get overwritten later 

	  fill_in_dma_record(dd_prod,
			     fd->host_buf,
			     start,
			     thislen,
			     TIGON_TYPE_RECV_DATA,
			     chan, 
			     idx,   // Mac RX Descr
			     RX2_DMA_TO_HOST_FRAG_STATE );

	  dd_last = dd_prod;
	  dd_prod = ndd_prod; // advance our copy

	  start += thislen;
	}
      
      
      // don't kick until everything is done
      
      if( fd->flags & RX2_DESCR_FLAGS_EOP )
	{
	  // now we need to queue the result 
	  
	  if( remain > 0 )
	    {
	      fd->flags |=  RX2_DESCR_FLAGS_TRUNC;
	      fd->flags &= ~RX2_DESCR_FLAGS_OK;
	    }
	  	  
	  // gross. Overwrite the last Assist entry we queued to
	  // indicate that it was the RECV_LAST

	  dd_last->type = TIGON_TYPE_RECV_DATA_LAST;
	  
	  // fire off this DMA
	  // use dd_prod, incase we didn't use the last frag
	  trp->host_dma_assist.write_chan_hi_pri_producer = dd_prod;

	  // note that we've queued these BDs for download
	  // NB we haven't finished with them yet!!!
	  nicfp->rx2_ctxt[chan].rx_bd_next = copy_rx_bd_next;

	  if( (copy_rx_bd_next & 7) == 0 ) // after every 8 (next is +1)
	    {
	      if( download_bds(chan, 
			       dd_prod, dd_ref,
			       nicfp->rx2_ctxt[chan].rx_bd_down_next,
			       copy_rx_bd_next) == OK )
		{
		  clear_bit(nicfp->rx2_dbds_lazy, chan);
		  nicfp->rx2_ctxt[chan].rx_bd_down_next = copy_rx_bd_next;
		}
	      else
		{
		  // if we run out of assist slots, just defer 
		  set_bit(nicfp->rx2_dbds_lazy, chan);

		  NIC_UTRACE("3DwnAFu!", 0x9101,
			     chan, nicfp->rx2_ctxt[chan].rx_bd_down_next, 
			     copy_rx_bd_next, copy_rx_bd_rdy_eop );

		  return ERROR;
		}
	    }
	  else
	    {
	      // defer
	      set_bit(nicfp->rx2_dbds_lazy, chan);	  
	    }

	  return OK;
	}

      /* Only get here if greater than one frag */
      if ( start > NIC_RX_BUF_END ) start -= NIC_RX_BUF_SIZE;

    } // end of for loop

  // if we get here, must have been too many frags

  NIC_UTRACE("3DlvTMF!", 0x9100,
	     i, copy_rx_bd_next, copy_rx_bd_rdy_eop, protolen );


  PANIC();  // XXXX implement me

  return OK;

assist_abort:

  NIC_UTRACE("3DlvAFu!", 0x9101,
	     i, copy_rx_bd_next, copy_rx_bd_rdy_eop, 0 );
  return ERROR;

screw_up:

  NIC_UTRACE("3DlvAXX!", 0x9101,
	     i, copy_rx_bd_next, copy_rx_bd_rdy_eop, 0 );

  PANIC();

  return ERROR; // keep compiler happy
}


int default_rx_filter(U32 start, int pktlen)
{
    /* Filter calling convention: return hdrlen in $6, protolen in $7 */
    __asm__ __volatile__ (
        "xori    $6,$0,14
         move    $7,%0"
        : : "r" (pktlen) );
    /* The compiler will hopefully not touch $6 or $7 before returning. */
    return 0;
}
void default_rx_filter_end(void){}


// This functions scans the RX FIFO trying to deliver packets.  As
// well as from the Event handler, its likely to be called by other
// routines, e.g. ASSIST COMPLETE when it's freed up some slots.

void h_mac_rx2_comp(void)
{
  int  count = 0;
  int  chan;
  char buf[RX2_MAX_FILTER_HDR];

  tgMacDescr_t *prod, *queued;

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3MacRxCp", 0x71600,
	     trp->local_mem_conf.rx_buf_producer,
	     trp->local_mem_conf.rx_buf_consumer,
	     trp->local_mem_conf.mac_rx_descr_producer,
	     trp->local_mem_conf.mac_rx_descr_consumer
	     );

  /* Has there really been a RX completion? */
  (U32)prod = ROUNDDN((U32)trp->local_mem_conf.mac_rx_descr_producer, 8);

  //cons = trp->local_mem_conf.mac_rx_descr_consumer;

  queued = nicfp->mac_rx_descr_queued;

  /* NB: We currently used a cached value of `prod' so that we don't
  hang around in this loop too long. */
  
  while( queued != prod )
    {
      U32    hstart = queued->w0;
      U32    start = queued->w0;
      int    len   = queued->w1 & TG_MAC_RX_W1_LEN_MASK;
      int    err   = queued->w1 & TG_MAC_RX_W1_STATUS_MASK; // any set == ERROR
      int    hdrlen, protolen;

      NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3McRxRes", 0x71601,
		start, len, err, queued);

      count++;

#if 0
      if(len>1024) 
	{
	  NIC_UTRACE("junkit",0,1,2,3,4);
	  goto junk_it;
	}
#endif
      
      if( !err )
	{
	  U32 copy_rx_bd_next, copy_rx_bd_rdy_eop;

	  /* XXX we could end up repeatedly reclassifying the same packet
	     if we're out of DMA Assist slots. Perhaps we should cache the
	     outcome of the classification in nicfp ???? */


	  if( start + RX2_MAX_FILTER_HDR > NIC_RX_BUF_END )
	    {
	      // we could use the cunning as hell scheme worked out by
	      // TJD.  My scheme is simpler & slower, but it happens
	      // infrequently anyway copy to a temporary buffer if
	      // wrap is a possibility

	      /* XXX KAF: okay, now actually does a split copy ( :-) )
	       * btw. a quick test shows this happens less than 1 in
	       * 10000 receives.  Therefore, this slow copy indeed
	       * seems an appropriate solution.  */

	      int first_len = NIC_RX_BUF_END - start;
	      memcpy( (U32*) buf, (U32*) start, first_len );
	      memcpy( (U32*) (buf + first_len), 
		      (U32*) NIC_RX_BUF, 
		      RX2_MAX_FILTER_HDR - first_len );
	      hstart = (U32) buf;
	    }

#if 0
	  { // MAC debugging stuff
	    static U8 seq;
	    U8 c = ((U8*)hstart)[6];
	    
	    if( c != seq )
	      {
		NIC_UUTRACE("SEQFUK",0xdead,c,seq,0,0);
	      }	  
	    seq = ++c;
	    if(seq>253)seq=0;
	    //((U8*)hstart)[6] = 0;
	  }
#endif

          /* After calling the filter, $6 contains the hlen, $7 the plen */
	  chan = nicfp->rx_filter(hstart, len);	  
          __asm__ __volatile__ (
              "move %0, $6
               move %1, $7"
              : "=r" (hdrlen), "=r" (protolen) : : "$6", "$7" );

	  NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3McRxRe2", 0x71601,
		    chan,hdrlen,protolen,0);
#if 0
          if ( chan == 1 )
          {
              static unsigned int expected_i = 0;
              unsigned int j, i = UNALIGNED_LOAD_32(start+hdrlen);
              j = ((i&0xff000000)>>24) | ((i&0x00ff0000)>> 8) | 
                  ((i&0x0000ff00)<< 8) | ((i&0x000000ff)<<24);
              if ( j != expected_i )
              {
                  NIC_UTRACE("XXXDrop", 0xdeadbeef,
                             expected_i, j, 0, i);
              }
              expected_i = j+1;
          }
#endif
	  copy_rx_bd_next     = nicfp->rx2_ctxt[chan].rx_bd_next;
	  copy_rx_bd_rdy_eop   = nicfp->rx2_ctxt[chan].rx_bd_rdy_eop;

      NIC_TRACEV(TRACE_TYPE_RX2_TRACE,"3McRxRe@", 
		usd2_ctrl_p[chan].free_prod,
		nicfp->rx2_ctxt[chan].rx_bd_q,
		nicfp->rx2_ctxt[chan].rx_bd_rdy_eop,
		nicfp->rx2_ctxt[chan].rx_bd_next,
		nicfp->rx2_ctxt[chan].rx_bd_done
		);	  

	  if( copy_rx_bd_rdy_eop != copy_rx_bd_next )
	    {
	      // We have some BD's available	      	    

	      int idx = queued - tdp->rx_mac_ring; // Mac RX Descr index

//#define DROP_COUNT	

#ifdef DROP_COUNT	      
	      if( nicfp->rx2_ctxt[chan].dropping > 0 )
		{
                    NIC_UTRACE("3McBAck", chan,
                    //NIC_TRACE(TRACE_TYPE_RX2_IRQ, "3McBack", chan,
			usd2_ctrl_p[chan].free_prod,
			nicfp->rx2_ctxt[chan].rx_bd_q,
			nicfp->rx2_ctxt[chan].rx_bd_done,
			nicfp->rx2_ctxt[chan].dropping
			);
                    NIC_UTRACE("2McBk2", chan,
                               nicfp->rx2_ctxt[chan].rx_bd_rdy_eop,
                               nicfp->rx2_ctxt[chan].rx_bd_next,0,0);


		  nicfp->rx2_ctxt[chan].dropping = 0;
		}
#endif
	      if( queue_for_delivery(chan, idx, start, hdrlen, protolen) 
		  == OK )
		{
		  // success! round the loop again...

		  nicfp->nicMacRxOK++;

		  queued = get_next_mac_rx_descr(queued);
		  continue;

		}
	      else
		{
		  // Damn - must be out of assist slots can't queue
		  // this packet now. Break out of loop and wait for
		  // this function to be called again, either as an
		  // MAC RX Event or directly by Assist handler if
		  // assist space is free

		  break;
		}

	      // Can't get here!!! We either exited or went to top.
	    }
	  else
	    { 
	      // No BDs available on this channel...

#if 0
                NIC_UTRACE("McRxDrp1", chan,
                           usd2_ctrl_p[chan].free_prod,
                           nicfp->rx2_ctxt[chan].rx_bd_q,
                           nicfp->rx2_ctxt[chan].rx_bd_rdy_eop,
                           nicfp->rx2_ctxt[chan].rx_bd_done);

	      NIC_UTRACE("McRxDrp2", chan,
			 nicfp->rx2_ctxt[chan].cache_free_prod,
			 is_bit_set( nicfp->rx2_bds_unseen, chan),
			 0,0);

#endif
	      NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3McRxDrp", 
			//chan,
			count,
			usd2_ctrl_p[chan].free_prod,
			nicfp->rx2_ctxt[chan].rx_bd_q,
			nicfp->rx2_ctxt[chan].rx_bd_rdy_eop,
			nicfp->rx2_ctxt[chan].rx_bd_done
			);


	      nicfp->nicMacRxDrops++;


#ifdef DROP_COUNT
	      nicfp->rx2_ctxt[chan].dropping++;
#endif		


	      (*rx2_poll_stub)(chan);

	      // this is unpleasant as it could penalise
	      // other connections. It does allow assist completions to happen

	      // XXXXX junk packet then cause us to exit loop in horrid way
	      
	      prod = get_next_mac_rx_descr(queued); // bletch !!!!
	      goto junk_it;

	    }
	}
      else
	{ // packet was CORRUPT

	  NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3McRxErr", 0x71601,
		    start, len, err, 0);

	  nicfp->nicMacRxErrs++;
	}

    junk_it:
      // if we get here, we have a packet we want to junk

      // We want to scrub this packet, but we can't free it
      // yet. It'll be skipped over when we consume the MacDescr
      // after we've DMA'ed other packets.

      queued->w1 |= 0x80000000; // mark as junk

      // if this is the FIRST and hence only packet in the RX
      // queue, we can safely Consumer advance over it.

      if( queued == trp->local_mem_conf.mac_rx_descr_consumer )
	{
	  U32 end;

	  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3McRxSkp", 0x71601,
		    //		    queued,
		    trp->local_mem_conf.mac_rx_descr_producer,
		    trp->local_mem_conf.mac_rx_descr_consumer,
		    trp->local_mem_conf.rx_buf_producer,
		    trp->local_mem_conf.rx_buf_consumer
		    );

#if 0
	  end = start + len - 64; XXXXX 
	  if( end > NIC_RX_BUF_END ) end -= NIC_RX_BUF_SIZE;
	  // the abve doesn't work. I don't understand why.
#endif	  

	  end = start; // this doesn't free up as much space as it
	               // could, but seems to work...


	  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3McRxSk2", 0x71601,
		    start, end, 0 ,0 );

	  
	  trp->local_mem_conf.mac_rx_descr_consumer = queued+1;
	  trp->local_mem_conf.rx_buf_consumer =  end;
	  
	  // queued is going to get incremented anyway!
	  
	}

      queued = get_next_mac_rx_descr(queued);      

    } // end of  :  while( queued != prod )

  nicfp->mac_rx_descr_queued = queued;

  trp->local_mem_conf.mac_rx_descr_ref = queued;

  NIC_TRACEV( TRACE_TYPE_RX2_DEBUG, "3MacComp", 0, count,0,0,0);

  // now we need to clean up any lazy bd downloads

  while( (chan = find_first_set_and_clear
	 ( nicfp->rx2_dbds_lazy, nicfp->max_ctxt_id_a )) )
    {
      chan--; // adjust to real chan number

      // we need to download BDs from bd_down_next to bd_next-1

      if( download_bds(chan,
		       trp->host_dma_assist.write_chan_hi_pri_producer,
		       trp->host_dma_assist.write_chan_hi_pri_ref,
		       nicfp->rx2_ctxt[chan].rx_bd_down_next,
		       nicfp->rx2_ctxt[chan].rx_bd_next) == OK )
	{
	  nicfp->rx2_ctxt[chan].rx_bd_down_next = 
	    nicfp->rx2_ctxt[chan].rx_bd_next;
	}
      else
	{
	  // Oh shit, must have run out of assist slots
	  set_bit( nicfp->rx2_dbds_lazy, chan );
	  break;
	}
    }

    
}
/* null routine to assist with scratchpad setup */
void h_mac_rx2_comp_end(void) {}
void_fn_t h_mac_rx2_comp_stub;


void
h_dma_rd_asst_hi_A(void)  
{
  /* runs on CPU A. Called after completion of a RX2 Read DMA
	e.g. after reading a BD or Frag from host
  */

  struct tg_dma_descr *ddp, *dd_cons;

  //NIC_UTRACE( "3RDmCpXX", 0x62609,0,0,0,0);

  ddp     = trp->host_dma_assist.read_chan_hi_pri_ref;
  dd_cons = trp->host_dma_assist.read_chan_hi_pri_consumer;

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3RDmCpXX", 0x62609,
            trp->host_dma.dma_rd_state,
            trp->host_dma_assist.assist_state,
            trp->host_dma.dma_rd_loc_addr,
            trp->host_dma.dma_rd_len);

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3RDmCp", 0x62600,
            trp->host_dma_assist.read_chan_hi_pri_producer,
            trp->host_dma_assist.read_chan_hi_pri_consumer,
            ddp,
            (ddp - tdp->rd_dma_hi_ring));

  NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3RDmCpD0", 0x62800,
            *(U32 *)ddp,		/* host addr */
            *((U32 *)ddp + 1),	/* host addr */
            *((U32 *)ddp + 2),	/* nic addr */
            *((U32 *)ddp + 3));	/* reserved & len */

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3RDmCpD1", 0x62900,
            *((U32 *)ddp + 4),	/* state */
            *((U32 *)ddp + 5),	/* reserved & cksum addr */
            *((U32 *)ddp + 6),	/* type */
            *((U32 *)ddp + 7));	/* index */

    // not a race since this is single threaded....
    // this should clear the event
  trp->host_dma_assist.read_chan_hi_pri_ref = ddp+1;

    if( ddp->type == TIGON_TYPE_FREE_BD )
      {
	int chan, didx, len, num, i, eop, old_rdy;
	rx2_descr_t * fd;

	nicfp->free_bd_dmas_in_q--; // one less in the queue

	chan = ddp->usd_id;
	didx = ddp->index;
	len  = ddp->len;

	num  = len / sizeof( rx2_descr_t );

	NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3RDCpRec", 0x62601,
                  chan, didx, len, num );

	NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3RDCpReX", 0x62601,
                  chan, didx, &(nicp->rx2_descr[chan][didx]),
                  ddp->nic_addr );

	fd = &(nicp->rx2_descr[chan][didx]);

	for(eop=0, i=1; i<=num; i++, fd++)
	  {
	    NIC_TRACE(TRACE_TYPE_RX2_TRACE, "3RDCpRes", 0x62602,
                      fd, fd->host_buf, fd->length, fd->flags );


	    if( fd->flags & RX2_DESCR_FLAGS_EOP )
	      eop = i;

	    
	    if( fd->host_buf < nicfp->rx2_ctxt[chan].host_range_base ||
	      (fd->host_buf + fd->length) > 
		(nicfp->rx2_ctxt[chan].host_range_base + 
		 nicfp->rx2_ctxt[chan].host_range_length) ||
		fd->length < 4) /* no taking the Michael... */
	      {
		// the swine!

		NIC_UTRACE("3RDCpIl!", chan,
                      fd, fd->host_buf, fd->length, fd->flags );

		// XXXX implement me properly !

		PANIC();
	      }

	  }

	old_rdy = nicfp->rx2_ctxt[chan].rx_bd_rdy;  

	nicfp->rx2_ctxt[chan].rx_bd_rdy += num;

	nicfp->rx2_ctxt[chan].rx_bd_rdy_eop = old_rdy + eop;

	NIC_TRACEV(TRACE_TYPE_RX2_TRACE, "3RDcpQQ", 0x007,
                  chan, 
                  nicfp->rx2_ctxt[chan].rx_bd_q, 
                  nicfp->rx2_ctxt[chan].rx_bd_rdy,
                  nicfp->rx2_ctxt[chan].rx_bd_rdy_eop);       
	
	return;
      }
    else if( ddp->type == TIGON_TYPE_USD_INSTALL_FILTER )
      {
	/* NB - can't receive any packets until all frags are installed ! */
	install_new_filter(ddp->usd_id, ddp->index, ddp->len);

      }
    else if ( ddp->type != TIGON_TYPE_NULL )
      {
	NIC_UTRACE("3RDDma?", 0x62600,
                  trp->host_dma_assist.read_chan_hi_pri_producer,
                  trp->host_dma_assist.read_chan_hi_pri_consumer,
                  ddp,
                  (ddp - tdp->rd_dma_hi_ring));	

	NIC_UTRACE("3RDDmaX1", 0x62600,
		   ddp->type, 0, 0, 0);


	PANIC();
      }

}

void h_dma_rd_asst_hi_A_end(void) {}

void_fn_t h_dma_rd_asst_hi_A_stub;  



static inline U32 
q_bd_to_nic_high(tg_hostaddr_t host_addr, U32 nic_addr, U32 len, 
             U16 type, U16 id, U32 index, U32 state) 
{
  // runs on CPU A

  tgDmaDescr_t *dd_prod, *ndd_prod, *dd_ref;

  dd_prod = trp->host_dma_assist.read_chan_hi_pri_producer; 
  // no `next available' producer on lo pri channel 
    
  dd_ref  = trp->host_dma_assist.read_chan_hi_pri_ref;
  // ref is what we've ACK'ed up to
 
  ndd_prod = get_next_rd_dma_high_descr( dd_prod );
  // due to stupid design we're only going to use 31 of the 32 slots

  if( ndd_prod != dd_ref)
    {
      // Must be space. Do DMA
      
      fill_in_dma_record( dd_prod,
			  host_addr, nic_addr, len, 
			  type, id, index, state );

      trp->host_dma_assist.read_chan_hi_pri_producer = ndd_prod; // fire!

      nicfp->free_bd_dmas_in_q++;

      return OK;
    }
  else
    {
        /*
         * KAF: This does happen if we reduce MTU to 1500 bytes!
         * I've therefore had a go at implementing DMA retry. (11/02/00)
         */
      nicfp->nicDmaReadRingFull++; 

      NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3QrDbdFu", 0x21500, 
		trp->host_dma_assist.read_chan_hi_pri_producer,
		trp->host_dma_assist.read_chan_hi_pri_consumer,
		trp->host_dma_assist.read_chan_hi_pri_ref,
		nicfp->nicDmaReadRingFull);      

      return ERROR;     
    }
}



static inline int
rx2_upload_bds_all_contig( int chan, int didx, U32 sidx, int num )
{
  // returns OK or ERROR

  tg_hostaddr_t src;

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE,"3upallc", 0x007, 
	     chan, didx, sidx, num);

  src = nicfp->rx2_ctxt[chan].rx2_ring_ptr;
  src += sidx * sizeof(rx2_descr_t);

  if( q_bd_to_nic_high( src, 
		    (U32)&(nicp->rx2_descr[chan][didx]),
		    sizeof(rx2_descr_t) * num,
		    TIGON_TYPE_FREE_BD,
		    chan,
		    didx,
		    RX2_DMA_TO_NIC_BD_STATE
		    ) )
    {
      return OK;
    }
  else
    {
      NIC_TRACE(TRACE_TYPE_RX2_DEBUG,"3upalFa!", 0x907, 
	     chan, didx, sidx, nicfp->free_bd_dmas_in_q);
     
      return ERROR;
    }

}


static inline int 
rx2_upload_bds_dst_contig( int chan, int didx, U32 rx_bd_q, int num )
{
  // We know the destination for these descriptors is contiguous,
  // though we should be wary of the source wrapping.
  // We don't update any pointers here

  U32 rx_h_mask, queued, batch;
  U32 sidx, rc;

  NIC_TRACEV(TRACE_TYPE_RX2_TRACE,"3updstc", 0x007, 
	     chan, didx, rx_bd_q, num);

  rx_h_mask = nicfp->rx2_ctxt[chan].rx_h_mask;

  queued = 0;

  sidx = rx_bd_q & rx_h_mask;  

  MIN_first_likely( batch, num, rx_h_mask + 1 - sidx );
  // batch = MIN( num, rx_h_mask + 1 - sidx );

top:
  rc = rx2_upload_bds_all_contig( chan, didx, sidx, batch );

  if( rc == OK && queued + batch == num )
    return queued + batch;

  if( rc == ERROR )
    return queued;

  sidx = 0;
  didx += batch;
  queued += batch;
  batch = num - batch;

  goto top;

}


int
rx2_upload_bds(int chan, U32 rx_f_prod)
{
  // where the client has kicked up to
  // U32 rx_f_prod = usd2_ctrl_p[chan].free_prod;  now cached!

  // where we've already queued up to
  U32 rx_bd_q = nicfp->rx2_ctxt[chan].rx_bd_q; 

  NIC_TRACE(TRACE_TYPE_RX2_TRACE,"3upbds", 0x007, 
	     chan, rx_f_prod, rx_bd_q, (rx_f_prod - rx_bd_q) & 0xffff );       

#if 0 // stats
  NIC_TRACE(TRACE_TYPE_RX2_STATS,"3Cstats", 0x007, 
   (rx_f_prod - nicfp->rx2_ctxt[chan].rx_bd_done) &0xffff ,
   (rx_bd_q - nicfp->rx2_ctxt[chan].rx_bd_done) &0xfff,
   (nicfp->rx2_ctxt[chan].rx_bd_rdy - nicfp->rx2_ctxt[chan].rx_bd_done)&0xffff,
   nicfp->rx2_free_bufs);

#endif


  if (rx_f_prod != rx_bd_q)
    {
      // There are BDs outstanding

      U32 rx_bd_done = nicfp->rx2_ctxt[chan].rx_bd_done;
      
      U32 in_q = (rx_bd_q - rx_bd_done) & 0xffff;

      U32 space = RX2_NUM_BDs - in_q;

      U32 unseen = (rx_f_prod - rx_bd_q) & 0xffff;
	  
      if( unseen > space )
      	{
	  // Make a note that we still have unseen BDs on this channel. 
	  // A retry can be triggered by a successful TX resulting in
	  // an incrememnt to rx_bd_done

	  set_bit(nicfp->rx2_bds_unseen, chan);

	  NIC_TRACE(TRACE_TYPE_RX2_TRACE,"3unseen", 0x007, 
		     in_q, space, unseen, nicfp->rx2_bds_unseen);

	}

      if( space >0 )
	{
	  // We have space to move some in
	  U32 tomove, max1, batch, rx_bd_q_idx, queued, rc;
	  
	  MIN_first_likely(tomove, unseen, space); //tomove = MIN(unseen,space)

	  rx_bd_q_idx = rx_bd_q % RX2_NUM_BDs;

	  queued = 0;
	  max1 = RX2_NUM_BDs - rx_bd_q_idx;
	  MIN_first_likely(batch,tomove, max1); // batch = min(tomove, max1)

	  // We go around this loop once, or twice if a dest wrap occurs.
	  // The loop is here to enable rx2_upload_bds_dst_contig to be inlined

	top:
	  rc = rx2_upload_bds_dst_contig( chan, rx_bd_q_idx, 
					  rx_bd_q + queued, batch );

	  queued += rc;

	  if( queued == tomove )
	    {
	      // success - all BDs moved OK

	      nicfp->rx2_ctxt[chan].rx_bd_q = (U16) (rx_bd_q + queued);

  NIC_TRACE(TRACE_TYPE_RX2_TRACE,"3upbdsQQ", 0x007, 
	     chan, rx_f_prod, nicfp->rx2_ctxt[chan].rx_bd_q, 
	     queued );       

	      return OK;
	    }
	  
	  if( rc < batch )
	    {
                /*
                 * Must have run out of DMA assist slots Make a note so that 
	         * we can trigger a thread to retry later.
                 * XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
                 * KAF: PANIC() removed (11/02/00) -- rx2_bds_pend
                 * code needs to be added somewhere!!! XXXXXXXXXXXXXXXXXXX
                 */
                set_bit(nicfp->rx2_bds_pend, chan);
                nicfp->rx2_ctxt[chan].rx_bd_q = (U16) (rx_bd_q + queued);
                
                rx2_print_stats();
                NIC_UTRACE("3bdDMA!", 0xdead,0,0,0,0);
                PANIC();

                return ERROR;
	    }

	  rx_bd_q_idx = 0;
	  batch = tomove - batch;  // the second batch
	  
	  goto top;
	}
      else
	{
	  // This channel is full already
	  NIC_TRACE(TRACE_TYPE_RX2_TRACE,"3upbdFu?", 0x009, 
		     rx_f_prod, rx_bd_q, space, 0);
	  return OK;
	}
    }
  else
    {
      // False Alarm
       
      /* We seem to get quite a lot of False Alarms, always when
         entering via the mailbox event poll routine. I don't
         understand quite why it happens so often, though I believe
         that an unlikley but  non-dangerous race is possible. 

	 This probably requires further investigation, but for now,
	 I've downgraded the trace from DEBUG to TRACE 
       */

      NIC_TRACE(TRACE_TYPE_RX2_TRACE,"3upbdFA?", 0x008, 
		usd2_ctrl_p[chan].free_prod, rx_bd_q, 
		usd2_ctrl_p[chan].tx_prod, 
		trp->gen_control.mailbox_event );
   

      return OK;
    }
}

void rx2_upload_bds_end(void) {}
int (*rx2_upload_bds_stub)(int chan, U32 rx_f_prod);

void 
h_rx2_mbox_poll(void)
{
    U32 e;
    U32 mbox_event;
    int chan, max;

    /* Find out which mailboxes have been frobbed */
    mbox_event = trp->gen_control.mailbox_event;

    e = pri(mbox_event, RX2_MBOX_MASK );  // XXX 4 New mailboxes only ! USD2

    max = nicfp->max_ctxt_id_a;  // `cache' volatile

    while(e)
      {
	int usd2mbox = e - ((16-USD2_NUM_MBOXS)+1); 
	int hint;

	NIC_TRACEV(TRACE_TYPE_RX2_TRACE,"rx2event", 0x2, 
		   mbox_event, e, tsp->mailbox[e-1].mbox_low, usd2mbox);

#define HINT_MASK ( (~(USD2_NUM_MBOXS-1)) & (USD2_NUM_CHANS-1) )

	hint = ( tsp->mailbox[e-1].mbox_low & HINT_MASK ) | usd2mbox;
	  
	chan = hint;

	NIC_TRACEV(TRACE_TYPE_RX2_TRACE,"rx2evenX", 0x2, 
		   chan, max, 0, 0);

        // It would be nice to batch together the Mbox bits that need
	// to be cleared and then do it at the end. However, we need
	// to do it here to avoid a classic race...

	trp->gen_control.mailbox_event = ( 1<<(e-1) );

	if ( chan > max )   // avoid a bogus hint
	  goto skip;

	do  // loop over all channels MUX'ed to this MBox
	  {
	    int rc;

	    // Any work to do here?

	    NIC_TRACE(TRACE_TYPE_RX2_TRACE,"rx2kick", 0x2, 
	       mbox_event, e, hint, chan);	    

	    (*rx2_poll_stub)(chan);
	    
	    // find next candidate

	    chan += USD2_NUM_MBOXS;
	    if( chan > max )
	      {
		chan = usd2mbox; // wrap to start
	      }

	  }
	while(chan != hint);  // do{}while  back to where we started ?

      skip:

#if 0
	if( nicfp->free_bd_dmas_in_q > BD_DMAs_IN_Q_X_OFF )
	  {
	    // we have overstepped our rough limit
	    
	  }
#endif
	// reading the mbox event register should be pretty fast, so
	// we reread it rather than using a `cached copy'

	mbox_event = trp->gen_control.mailbox_event;

	e = pri(mbox_event, RX2_MBOX_MASK );  // XXX 4 New mailboxes only ! USD2
      } /* end of while(e) */

    // Until we kill the old USD TX path, call through to TJG
    if (mbox_event & 0x00000003) 
    {
        NIC_TRACEV(TRACE_TYPE_RX2_TRACE,"RX2MbL2", 0x3, 0,0,0,0);
        (*(void_fn_t)mh_command_stub)(); // XXXX HACK
    }

    // check for any lazy bd downloads that failed
    
    while( (chan = find_first_set_and_clear
	 ( nicfp->rx2_dbds_lazy, nicfp->max_ctxt_id_a )) )
      {
	chan--; // adjust to real chan number

	// we need to download BDs from bd_down_next to bd_next-1

	NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3LazyFix", 0,
		  chan, nicfp->rx2_ctxt[chan].rx_bd_down_next,
		  nicfp->rx2_ctxt[chan].rx_bd_next, 0);
	
	
	if( download_bds(chan,
			 trp->host_dma_assist.write_chan_hi_pri_producer,
			 trp->host_dma_assist.write_chan_hi_pri_ref,	 
			 nicfp->rx2_ctxt[chan].rx_bd_down_next,
			 nicfp->rx2_ctxt[chan].rx_bd_next) == OK )
	  {
	    nicfp->rx2_ctxt[chan].rx_bd_down_next = 
	      nicfp->rx2_ctxt[chan].rx_bd_next;
	  }
	else
	  {
	    // Oh shit, must have run out of assist slots
	    set_bit( nicfp->rx2_dbds_lazy, chan );
	    break;
	  }
      }


}
void 
h_rx2_mbox_poll_end(void) {}

/* Pointers for the scratchpad relocation */
void_fn_t h_rx2_mbox_poll_stub;

static void 
rx2_print_stats(void)
{
  int chan;

  NIC_TRACE(TRACE_TYPE_RX2_STATS,"*RXstatP", trp->mac_control.mac_rx_state,
	    nicfp->stats.nicMacRxTotalAttns,
	    nicfp->nicMacRxOK,
	    nicfp->nicMacRxErrs,
	    nicfp->nicMacRxDrops );

  NIC_TRACE(TRACE_TYPE_RX2_STATS,"RXstatF", 0,
	    nicfp->nicDmaWriteRingFull,
	    nicfp->nicDmaReadRingFull,
	    0,0);


  NIC_TRACE(TRACE_TYPE_RX2_STATS,"RXstatI", 0,
	    tsp->gen_com.rx2_interrupts_active[0],
	    0,
	    0,0);


  NIC_TRACE(TRACE_TYPE_RX2_STATS,"RXstatD", 0,
	    (trp->host_dma_assist.write_chan_hi_pri_producer -
	      trp->host_dma_assist.write_chan_hi_pri_consumer) &31,

	    (trp->host_dma_assist.read_chan_hi_pri_producer -
	      trp->host_dma_assist.read_chan_hi_pri_consumer) &31,
	    
	    (trp->local_mem_conf.mac_rx_descr_producer -
	     trp->local_mem_conf.mac_rx_descr_consumer)&255,
	    
	    (nicfp->rx2_ctxt[1].rx_bd_rdy - 
	     nicfp->rx2_ctxt[1].rx_bd_done)&0xffff
	    );

#if 0
  NIC_TRACE(TRACE_TYPE_RX2_STATS,"*RXstatD", 0, 
	    trp->host_dma_assist.read_chan_hi_pri_producer
	      - tdp->rd_dma_hi_ring,
            trp->host_dma_assist.read_chan_hi_pri_consumer
	      - tdp->rd_dma_hi_ring,
            trp->host_dma_assist.read_chan_hi_pri_ref
	      - tdp->rd_dma_hi_ring,
	    (trp->host_dma_assist.read_chan_hi_pri_producer-
	    trp->host_dma_assist.read_chan_hi_pri_ref)&
	    (TG_DMA_ASSIST_DESCRS-1));



  NIC_TRACE(TRACE_TYPE_RX2_STATS,"RXstatS", 0, 
	    nicfp->free_bd_dmas_in_q,
	    RX2_PKT_BUFS - pop_count(nicfp->rx2_free_bufs),
	    0,0);

  NIC_TRACE(TRACE_TYPE_RX2_STATS,"RXstatM", 0, 
	    trp->local_mem_conf.mac_tx_descr_producer,
	    trp->local_mem_conf.mac_tx_descr_consumer,
	    trp->local_mem_conf.mac_tx_descr_ref,
	    trp->local_mem_conf.mac_tx_descr_producer -
	    trp->local_mem_conf.mac_tx_descr_ref);
#endif

  for(chan=0;chan<=nicfp->max_ctxt_id_a;chan++)
    { 
      U32 rx_f_prod, rx_bd_q;

      if( nicfp->rx2_ctxt[chan].rx2_ring_ptr == 0 ) continue;

      rx_f_prod = usd2_ctrl_p[chan].free_prod;
      rx_bd_q = nicfp->rx2_ctxt[chan].rx_bd_q; 

      NIC_TRACE(TRACE_TYPE_RX2_STATS,"RXstat1", chan, 
		rx_f_prod,
		rx_bd_q,
		nicfp->rx2_ctxt[chan].rx_bd_rdy_eop,
		nicfp->rx2_ctxt[chan].rx_bd_done
		);

      NIC_TRACE(TRACE_TYPE_RX2_STATS,"RXstat2", chan, 
       (rx_f_prod - nicfp->rx2_ctxt[chan].rx_bd_done) &0xffff ,
       (rx_bd_q - nicfp->rx2_ctxt[chan].rx_bd_done) &0xffff,
       (nicfp->rx2_ctxt[chan].rx_bd_rdy - 
	nicfp->rx2_ctxt[chan].rx_bd_done)&0xffff,
		usd2_ctrl_p[chan].rx_prod );

      NIC_TRACE(TRACE_TYPE_RX2_STATS,"RXstat3", chan, 
		rx_f_prod,
		usd2_ctrl_p[chan].rx_ref,
		usd2_ctrl_p[chan].rx_prod,
		0                            );
		
    
    }


}


void
h_timer(void)
{
    U32 time;

    NIC_TRACEV(TRACE_TYPE_TIMER, "#timer", 0x50300, 0, 0, 0, 0);
	
    /* first restart the timer so we make damn sure it gets done! */
    time = trp->gen_control.timer;
    trp->gen_control.timer_ref = time + TG_TICK_SLOW; //1ms
    //    trp->gen_control.timer_ref = trp->gen_control.timer + 100000;

    //if( time > nicfp->next_stats_time )
    if( (S32) (time - nicfp->next_stats_time) >= 0 )
      {
	rx2_print_stats();
	nicfp->next_stats_time = time + (TG_TICK_1US * 1000000);	
      }      

#ifdef RX_INT_HOLDOFF
    if( (S32) (time - nicfp->next_int ) >= 0 )      
      {
	nicfp->nicRxHoldOffInts++;

        NIC_TRACE(TRACE_TYPE_RX2_IRQ, "RXHldXXX", 0xaaaa,
                  time, nicfp->next_int, nicfp->nicRxHoldOffInts, 0);

	trp->gen_control.misc_local_control |= TG_MLC_SET_INTERRUPT;
        clear_fired_rx2_ints();
	nicfp->next_int += (1U<<30); // push into way into future
	
      }
#endif

    if (link_ready)
      {
        /* poll this bit to restart auto negotiation for auto neg attn fix */
        if (((attached_phy & ATTACHED_PHY_IF_MII) != ATTACHED_PHY_IF_MII) &&
	    (gig_negotiate) && !(link_sense_mode) &&
            (trp->mac_control.mac_rx_config != zs.saved_rx_config))
	  {
            link_down_notify();
	  }

	if (nicfp->rx2_mac_rx_state > 0)
	  {
	    // must be stalled

	    tgMacDescr_t *mdProd, *mdCons;
	    U32 bProd, bCons;
	    U32 bFree, mdFree;

	    /* This little bugger could still be moving... */
	    bProd = trp->local_mem_conf.rx_buf_producer;
	    bCons = trp->local_mem_conf.rx_buf_consumer;

	    /* bump the producer back to the start of the frame */
	    (U32)mdProd =
	      ROUNDDN((U32)trp->local_mem_conf.mac_rx_descr_producer, 8);
  
	    mdCons = trp->local_mem_conf.mac_rx_descr_consumer;
	    
	    bFree  = free_mac_space(bProd, bCons);
	    mdFree = free_mac_descrs(mdProd, mdCons);  

	    if( mdFree > 8 &&
		bFree  > NIC_RX_BUF_HI )
	      {
		NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3TiMacON", 0x50301,
			  mdFree,
			  bFree,
			  bProd,
			  bCons);

		nicfp->rx2_mac_rx_state = 0;

		// re-start RX MAC and clear latched condtions
		trp->mac_control.mac_rx_state = 
		  ( trp->mac_control.mac_rx_state & 
		   ~(TG_MAC_RX_ATTN_MASK | TG_MAC_RX_STATE_STOP_NEXT)) |
		  TG_MAC_RX_STATE_BUF_ATTN | TG_MAC_RX_STATE_IND_ATTN;

		// re-enable RX_ATTN events
		event_mask |= TG_FW_EVENT_MAC_RX_ATTN;

		NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3TiMacO2", 0x50301,
			  trp->mac_control.mac_rx_state,
			  0,mdProd,mdCons);

	      }
	    else
	      {
		NIC_TRACE(TRACE_TYPE_RX2_DEBUG, "3TiMac--",
			  nicfp->rx2_mac_rx_state ,
			  mdFree,
			  bFree,
			  bProd,
			  bCons);
		//PANIC();
	      }
	    
	  }


      } 
    else // else link is currently down
      {
        bringup_link();
      }


    return;
}

/* null routine to assist with scratchpad setup */
void h_timer_end(void) {}
U32 h_timer_stub;




/*******/
#if 0
static inline int
ip_demux( U32 ip_src_addr, U32 ip_dest_addr, U16 src_port, U16 dest_port )
{
  int chan;

  /*
   * KAF XXX: src/dest are opposite way round on rx side, so our local 
   * port binding is the dest port in the packet, but the _src_ port in
   * the context structure!
   * 
   * In fact there are more problems -- we have to be able to distinguish
   * between listening and non-listening sockets, giving priority to the
   * latter. This will require a clever data structure unless we keep 
   * _two_ hash tables...
   * 
   * How about an open-addressed HT but with a chain of connections on that
   * port (maybe a binary tree or something)...
   */
  if( dest_port == nicfp->rx2_ctxt[2].sourcePort ) return 2;
  if( dest_port == nicfp->rx2_ctxt[1].sourcePort ) return 1;
  if( dest_port == nicfp->rx2_ctxt[4].sourcePort ) return 4;
  if( dest_port == nicfp->rx2_ctxt[3].sourcePort ) return 3;
  return 0;

  return chan;
}

int
XXXdefault_rx_filter( U32 start, int pktlen, int * hdrlen, int * protolen )
{
  eth_t        *ethp;
  ip_t         *ipp;
  int           type, ver, hlen, proto;
  int           src_port, dest_port;
  U32           ip_src_addr, ip_dest_addr;
  int           chan;

  /* Return which channel this packet belongs to (default =0) 

     This is trickier than it sounds becasue of the following issues:
       1. The IP part of the packet will only be U16 aligned
       2. When trying to access above NIC_RX_BUF_END you must
           subtract NIC_RX_BUF_SIZE first !!!!

   */

  ethp = (eth_t *)start;
  ipp  = (ip_t *)(((U32)ethp) + ETH_HLEN);

  type = ethp->ethFrameType;
  ver  = IP_VERSION(ipp);
  hlen = IP_HLEN(ipp);
  proto= ipp->ipProtocol;

  ip_src_addr   = UNALIGNED_LOAD_32(&ipp->ipSourceAddr);
  ip_dest_addr  = UNALIGNED_LOAD_32(&ipp->ipDestAddr);

  // The purpose of this exercise is not to be particularly rigourous.
  // We just need to do enough to make sure that we're not giving a VALID
  // packet to the WRONG guy.  It's perfectly acceptable to give INVALID
  // packets to ANYONE.

  // i.e. looking past the end of a packet is OK! 

  if( type == ETH_IP && ver == IP_VER4 )
    {
      *protolen = ETH_HLEN + ipp->ipLen ;

      if( proto == IP_PROTO_TCP )
	{
	  int thdrlen;
	  U16 * app = ((U16*)ipp) + (hlen/2);

	  thdrlen = (app[6] >> 12)<<2;

	  src_port = app[0];
	  dest_port = app[1];

	  *hdrlen = ETH_HLEN + hlen + thdrlen;

	  chan = ip_demux( ip_src_addr, ip_dest_addr, src_port, dest_port );
	  return chan;
	}
      else if( proto == IP_PROTO_UDP )
	{
	  U16 * app = ((U16*)ipp) + (hlen/2);

	  src_port = app[0];
	  dest_port = app[1];

	  *hdrlen = ETH_HLEN + hlen + UDP_HLEN;

	  chan = ip_demux( ip_src_addr, ip_dest_addr, src_port, dest_port );
	  return chan;
	}
      else
	goto unknown;
     
    }

unknown:
  // implement other protocols here....

  *hdrlen = ETH_HLEN;
  *protolen = pktlen; // complete with CRC
  
  chan = 0; // pass to kernel
      
  return chan;
}

#endif
