/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * FILE proto.h
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/proto.h,v $
 * $Revision: 1.16 $ $Locker: iap10 $
 * $Date: 2000/03/31 12:18:50 $ $Author: iap10 $ $State: Exp $
 */

#ifndef _PROTO_H_
#define _PROTO_H_

/*
 * prototypes for all the routines
 */

extern U32 ev_handler[66];
extern U32 ev_handler_b[66];
extern U32 scratch_pad_enable_code;
extern U32 scratch_pad_enable_stack;
extern U32 scratch_pad_enable_vars;
extern U32 stack_start;
extern U32 stack_start_b;

extern U32 scratch_pad_size;
extern U32 scratch_pad_loc;
extern U32 scratch_pad_b_size; 
extern U32 scratch_pad_b_loc;

extern U32 h_dma_rd_assist_stub;
extern U32 h_recv_bd_ready_stub;
extern U32 h_send_bd_ready_stub;
extern U32 h_recv_jumbo_bd_ready_stub;
extern U32 h_recv_mini_bd_ready_stub;
extern U32 h_send_data_ready_stub;
extern U32 h_timer_stub;
extern U32 h_update_led_stub;
extern U32 mh_command_stub;


/* Horid transfer area for moving packet filters host->SRAM->SCRATCH */
#define FILTER_BUF_SIZE 4096
extern char filter_buf[FILTER_BUF_SIZE];



extern void _disp(void);
extern void add_mcast(tg_macaddr_t *);
extern void bcopy(U32 *, U32 *, U32);
extern void bzero(U32 *, U32);
extern U16  cksum16(U16 *, U32, U32, U32);
extern void cksum16_end(void);
extern U16  crc_cksum(U8 *);
extern void del_mcast(tg_macaddr_t *);
extern void do_mailbox_slow(struct tg_command);
extern void fix_xchip_hang_on_sbus(void);
extern U32  gen_crc(U8 *addr, U32 len);
extern void h_dma_rd_assist(void);
extern void h_dma_rd_assist_cksum(void);
extern void h_dma_rd_assist_cksum_end(void);
extern void h_dma_rd_assist_end(void);
extern void h_dma_rd_attn(void);
extern void h_dma_wr_assist(void);
extern void h_dma_wr_assist_cksum(void);
extern void h_dma_wr_assist_cksum_end(void);
extern void h_dma_wr_assist_end(void);
extern void (*h_dma_wr_assist_stub)(void);
extern void h_dma_wr_attn(void);
extern void h_mailbox(void);
extern void h_recv_bd_ready(void);
extern void h_recv_bd_ready_end(void);
extern void h_recv_jumbo_bd_ready(void);
extern void h_recv_jumbo_bd_ready_end(void);
extern void h_recv_mini_bd_ready(void);
extern void h_recv_mini_bd_ready_end(void);
extern void h_send_bd_ready(void);
extern void h_send_bd_ready_end(void);
extern void h_send_data_ready(void);
extern void h_send_data_ready_cksum(void);
extern void h_send_data_ready_cksum_end(void);
extern void h_send_data_ready_end(void);
extern void h_timer(void);
extern void h_timer_end(void);
extern void init_dma_assist(void);
extern void init_mac2(void);
extern void init_mailbox(void);
extern void init_timer(void);
extern void init_timer_b(void);
extern void init_trace(void);
extern void ltrace(U32 *, U32, U32, U32, U32, U32, U32 *);
extern void mcast_init(void);
extern bool mcast_rx_filter(U8 *addr);
extern void mcast_rx_filter_end(void);
extern void memcpy(U32 *dst, U32 *src, U32 len);
extern void memset_w(U32 *, U32, U32);
extern void mh_command(void);
extern void mh_command_end(void);
extern void probe_adj_stack(void);
extern void propagate_u64_stats(void);
extern U32  q_dma_to_host_cksum(tg_hostaddr_t, U32, U32, U16, U16, U32, U32);
extern void q_dma_to_host_cksum_end(void);
extern U32  q_dma_to_host(tg_hostaddr_t, U32, U32, U16, U16, U32, U32);
extern void q_dma_to_host_end(void);
extern U32  q_dma_to_nic_cksum(tg_hostaddr_t, U32, U32, U16, U16, U32, U32);
extern void q_dma_to_nic_cksum_end(void);
extern U32  q_dma_to_nic(tg_hostaddr_t, U32, U32, U16, U16, U32, U32);
extern void q_dma_to_nic_end(void);
extern void rx_ip_sanity(U32, U32);
extern void scream_handler(void);
extern void strace(U32 *, U32, U32, U32, U32, U32, U32 *, U32, U32);
extern void trace(U32 *, U32, U32, U32, U32, U32);
extern void update_stats(void);
extern void wait_us(U32);
extern void h_mac_rx_comp_nohost(void);

extern void print_assist_ring(char *, 
			      tgDmaDescr_t *, tgDmaDescr_t *, tgDmaDescr_t *);
extern void perf_test(tg_hostaddr_t);
extern void perf_test_end(void);


/* USD protos */
extern void init_usd_contexts(void);
extern void h_usd_add_context_B(U16 id, conn_ctxt_host_part_t *hp);
extern void init_new_usd_context(U16 id, conn_ctxt_host_part_t *hp);
/* connection teardown */
extern void h_usd_delete_context_B(U16 id);
extern void delete_usd_context(U16 id);
extern void delete_usd_context_final(U16 id);


typedef void (*void_fn_t)(void); 

extern void _start_b(void);

extern void_fn_t h_max_tx_comp_B_stub;
extern void h_max_tx_comp_B(void);
extern void h_max_tx_comp_B_end(void);

extern void_fn_t h_dma_rd_asst_lo_B_stub;
extern void h_dma_rd_asst_lo_B(void);
extern void h_dma_rd_asst_lo_B_end(void);

extern void_fn_t h_tx2_mbox_poll_stub;
extern void h_tx2_mbox_poll(void);
extern void h_tx2_mbox_poll_end(void);

extern void h_mac_tx2_attn(void);

extern void_fn_t h_rx2_mbox_poll_stub;
extern void h_rx2_mbox_poll(void);
extern void h_rx2_mbox_poll_end(void);

extern void_fn_t tx2_select_pkt_for_upload_stub;
extern void tx2_select_pkt_for_upload(void);
extern void tx2_select_pkt_for_upload_end(void);

extern int tx2_upload_bds(int chan, U32 tx_h_prod);
extern void tx2_upload_bds_end(void);
extern int (*tx2_upload_bds_stub)(int chan, U32 tx_h_prod);

extern int rx2_upload_bds(int chan, U32 rx_f_prod);
extern void rx2_upload_bds_end(void);
extern int (*rx2_upload_bds_stub)(int chan, U32 rx_f_prod);

extern void rx2_poll(int);
extern void rx2_poll_end(void);
extern void (*rx2_poll_stub)(int);

extern void_fn_t h_dma_rd_asst_hi_A_stub;
extern void h_dma_rd_asst_hi_A(void);
extern void h_dma_rd_asst_hi_A_end(void);

extern void_fn_t h_dma_wr_asst_hi_A_stub;
extern void h_dma_wr_asst_hi_A(void);
extern void h_dma_wr_asst_hi_A_end(void);

extern void_fn_t h_mac_rx2_comp_stub;
extern void h_mac_rx2_comp(void);
extern void h_mac_rx2_comp_end(void);

extern void_fn_t h_mac_rx2_attn_stub;
extern void h_mac_rx2_attn(void);
extern void h_mac_rx2_attn_end(void);

extern void (*hf_timer_stub)(void);
extern void h_hf_timer(void);
extern void h_hf_timer_end(void);

extern int default_rx_filter(U32 start, int pktlen);
extern void default_rx_filter_end(void);



#endif /* _PROTO_H_ */
