/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * FILE nic.h
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/nic.h,v $
 * $Revision: 1.21 $ $Locker: iap10 $
 * $Date: 2000/07/04 13:01:36 $ $Author: kaf24 $ $State: Exp $
 */

#ifndef _NIC_H_
#define _NIC_H_

/* left only for some common modules for switch and nic */
#undef	TRP
#undef	TDP
#undef	NIC
#undef	TSP
#define TRP	trp
#define	TDP	tdp
#define NIC	nicp
#define tsp	((tg_shmem_t *)(0))
#define	TSP	tsp

/* error code */
#undef  OK
#undef  ERROR
#define OK	(1)
#define ERROR	(0)

/* TG_CPU_A and TG_CPU_B only defined for TIGON_REV5 in tg.h */
#if !defined(TG_CPU_A)
#define TG_CPU_A        0
#define TG_CPU_B        1
#endif /* !defined(TG_CPU_A) */

/*
 * Software events for the host->NIC comms mechanism.
 * NB. This is lowest priority as it is intended to be the background task.
 */
#define TG_FW_EVENT_POLL_MBOX_A         (TG_FW_EVENT_SW0)
#define TG_FW_EVENT_NUM_POLL_MBOX_A     (TG_FW_EVENT_NUM_SW0)
#define TG_FW_EVENT_POLL_MBOX_B         (TG_FW_EVENT_SW0)
#define TG_FW_EVENT_NUM_POLL_MBOX_B     (TG_FW_EVENT_NUM_SW0)

/*
 * Software events for the inter-CPU comms mechanism.
 * NB. Reasonable high priority as fairly rare, and we don't want the 
 *     host to be "locked out".
 */
#define TG_FW_EVENT_USD_EVENT_A         (TG_FW_EVENT_SW8)
#define TG_FW_EVENT_NUM_USD_EVENT_A     (TG_FW_EVENT_NUM_SW8)
#define TG_FW_EVENT_USD_EVENT_B         (TG_FW_EVENT_SW8)
#define TG_FW_EVENT_NUM_USD_EVENT_B     (TG_FW_EVENT_NUM_SW8)

/* nic memory size */
#define NIC_MEM_256K	0x040000
#define	NIC_MEM_512K	0x080000
#define	NIC_MEM_1M	0x100000
#define	NIC_MEM_2M	0x200000
#define	NIC_MEM_4M	0x400000
#define	NIC_MEM_8M	0x800000

/* constants that depend on the size of nic memory */
#define	MIN_MAC_BUF_SIZE (64 * 1024) /* must be multiple of 4KB */
#define RX_MD_XOFF       ((15 - 7) >> 3) /* 15 descriptors */
#define RX_MD_XON        ((31 - 7) >> 3) /* 31 descriptors */
#define RX_BUF_HI_1M         (1024 * 200)
#define RX_BUF_LO_1M         ((((1024 * 9)  / 128) - 7) >> 3) /*  9KB */
#define RX_BUF_XOFF_1M       ((((1024 * 23) / 128) - 7) >> 3) /* 23KB */
#define RX_BUF_XON_1M        ((((1024 * 32) / 128) - 7) >> 3) /* 32KB */

#define	NIC_RX_BUF_SIZE	TG_RX_BUF_SIZE
#define	NIC_RX_BUF_END	(TG_DATA_END)
#define	NIC_RX_BUF	(NIC_RX_BUF_END - NIC_RX_BUF_SIZE)
#define	NIC_RX_BUF_HI	RX_BUF_HI_1M
#define	NIC_RX_BUF_LO	RX_BUF_LO_1M
#define	NIC_RX_BUF_XON	RX_BUF_XON_1M
#define	NIC_RX_BUF_XOFF	RX_BUF_XOFF_1M
#define	NIC_TX_BUF_SIZE	TG_TX_BUF_SIZE
#define	NIC_TX_BUF_END	NIC_RX_BUF
#define	NIC_TX_BUF	(NIC_TX_BUF_END - NIC_TX_BUF_SIZE)

#define ROUNDUP(x, n)		(((x) + (n) - 1) & ~((n) - 1))
#define ROUNDDN(x, n)		((x) & ~((n) - 1))

#include "usd_conn.h"


/********** USD2 ********************************************************/
#define USD2_NUM_CHANS     32
#define USD2_NUM_MBOXS     8     



#define RX2_MBOX_MASK (((1<<USD2_NUM_MBOXS)-1)<<(16-USD2_NUM_MBOXS))
#define TX2_MBOX_MASK (((1<<USD2_NUM_MBOXS)-1)<<(32-USD2_NUM_MBOXS))

/********** end of USD2 defines *****************************************/


/******************************************************************************
 * RX2
 */

#define RX2_DESCR_FLAGS_EOP   0x1 // last frag
#define RX2_DESCR_FLAGS_CONT  0x2 // data frags except last
#define RX2_DESCR_FLAGS_HDR   0x4 // set for a hdr frag (allowed only one)

#define RX2_DESCR_FLAGS_TRUNC 0x10 // frag was truncated
#define RX2_DESCR_FLAGS_OK    0x40 // everything was OK
#define RX2_DESCR_FLAGS_DONE  0x80 // This frag has been used!!!!


typedef struct {
  U32 host_buf;
#if ALT_BIG_ENDIAN
  U16 flags;			/* see below */
  U16 length;
#else /* ALT_BIG_ENDIAN */
  U16 length;
  U16 flags;			/* see below */
#endif /* ALT_BIG_ENDIAN */
} rx2_descr_t;

// XXXX Need to deal with IP fragments here


/*** RX2 internal stuff */

#define RX2_NUM_BDs       64     /* Num of BDs per channel */

typedef struct {                 // per channel context

  /* Where the client's RX2 consumer lives */
  //  tg_hostaddr_t rx2_consumer_ptr;

  /* Where the client's RX2 ring lives */
  tg_hostaddr_t rx2_ring_ptr;
  
  /* Where this USD can DMA to and from  */
  tg_hostaddr_t host_range_base;
  U32 host_range_length;

  /* What it's frames look like XXXX should use a proper packet filter ! */    
  U32 ipSourceAddr;
  U32 ipDestAddr;
  U16 sourcePort;
  U16 destPort;
  
  /* magic ptrd...*/
  U16 rx_h_mask; // number of BDs in the HOST ring - 1

  U16 rx_bd_q;   // what we've queued upload requests for
  U16 rx_bd_rdy; // what BDs are currently in the FIFO XXX not strictly needed?
  U16 rx_bd_rdy_eop; // the last rdy BD that had the EOP bit set
  U16 rx_bd_next;  // what BD we will consume next (1st frag receive)
   
  U16 rx_bd_down_next; // what BD we've queued for download to host +1

  U16 rx_bd_done;     // DMA completion for above

  /* cached copies of shared memory control area */
  
  U16 cache_free_prod;
  U16 cache_rx_ref;

  /* Debugging stuff */
  U16  dropping;

#ifdef RX_INT_HOLDOFF
  U16  trigger_next_pkt;      // really a bool 
#endif


  // The cons value we write back to the client could be rx_bd_rdy,
  // rx_bd_next, or soemthing to indicate the packet has actually gone...

} rx2_con_ctxt_t;

/* Write DMA channel state register values */

#define RX2_DMA_TO_HOST_CONS_STATE 0x20086
#define RX2_DMA_TO_HOST_BD_STATE   0x20086
#define RX2_DMA_TO_HOST_FRAG_STATE 0x20084

/* Read DMA channel state register values */

#define RX2_DMA_TO_NIC_BD_STATE    0x86


/* MAC RX BUF control parameters */

#define RX2_MAX_FRAGS       3


#define RX2_MAX_FILTER_HDR  64  // can't look past the 64th byte of header


typedef int rx_filter_fn_t(U32 start, int pktlen);

typedef struct nic_fast {
    /* identify myself --- MUST BE FIRST entry */
    U32 cpu_id;

    /******* RX2 stuff *******/
    rx2_con_ctxt_t rx2_ctxt[USD2_NUM_CHANS];  // per channel stuff

    U32 rx2_bds_unseen[(USD2_NUM_CHANS+31)/32];// Waiting for space in BD fifo
    U32 rx2_bds_pend[(USD2_NUM_CHANS+31)/32];  // Waiting for DMA slots avail

    U32 rx2_dbds_lazy[(USD2_NUM_CHANS+31)/32]; // Lazy download bds pending

    U16 max_ctxt_id_a;
    
    rx_filter_fn_t *rx_filter;

    /* Other stats */
    U32 nicDmaReadRingFull;
    U32 nicMacRxOK;     // OK packets
    U32 nicMacRxErrs;   // Err packets
    U32 nicMacRxDrops;  // Dropped packets
    U32 nicDmaWriteRingFull;
    U32 next_stats_time;
  
#ifdef RX_INT_HOLDOFF
    U32 nicRxHoldOffInts;      // stats
#endif

    /* DMA stuff */
    int free_bd_dmas_in_q;  // stop us filling assist slots with BDs

    /* RX Mac stuff */
    tgMacDescr_t *mac_rx_descr_queued; // where we've queued DMAs up to
    int rx2_mac_rx_state;

#ifdef RX_INT_HOLDOFF
    /* Interrupt hold off stuff */
    U32 next_int;
#endif

    /* KAF: we need this for proper interrupt avoidance. */
    U32 rx2_interrupts_primed[(USD_CHANNELS+31)/32];

    /****** end of RX2 stuff *******/

    /* host state */
    U32 host_state;
#define TG_HOST_STATE_STACK_UP          0x0001
#define TG_HOST_STATE_LINK_RDY_ON       0x0002

    /* dma states */
    U32 dma_to_host_bd_state;
    U32 dma_to_nic_bd_state;

    /* event ring */
    U32 event_prod_index;

    /* rx packet filtering */
    U32 mc_free_list;
    S32 mc_table_depth;

    /* pointer to runtime functions */
    U32  (*q_dma_to_nic_stub)(tg_hostaddr_t, U32, U32, U16, U16, U32, U32);
    U32  (*q_dma_to_host_stub)(tg_hostaddr_t, U32, U32, U16, U16, U32, U32);

    /* host pointers */
    U64 align_0[0]; /* force double word alignment */
    tg_hostaddr_t event_producer_ptr;
    tg_hostaddr_t event_ring_ptr;
    tg_hostaddr_t stats2_ptr;

    /* stats */
    struct tg_stats stats;

} nic_fast_t;



/******************************************************************************
 * TX2 
 */

#define TX2_DESCR_FLAGS_EOP 1

typedef struct {
  U32 host_buf;
#if ALT_BIG_ENDIAN
  U16 flags;			/* see below */
  U16 length;
#else /* ALT_BIG_ENDIAN */
  U16 length;
  U16 flags;			/* see below */
#endif /* ALT_BIG_ENDIAN */
} tx2_descr_t;

// XXXX Need to deal with IP fragments here

#define TX2_MAX_FRAGS    3       // Max number of frags per pkt 

/*** TX2 internal stuff *****/

#define TX2_NUM_BDs       64     /* Num of BDs per channel */

typedef struct {                 // per channel context

  /* Where the client's TX2 ring lives 
   Also serves as a `Channel Exists' flag */
  tg_hostaddr_t tx2_ring_ptr;

  /* Where the client's TX2 consumer lives */
  tg_hostaddr_t tx2_consumer_ptr;

  /* Where this USD can DMA to and from  */
  tg_hostaddr_t host_range_base;
  U32 host_range_length;

#if 0
  /* What frames must look like */    
  U8  ethDestAddr[6];
  U8  ipProtocol;   
  U8  pad;
  U32 ipSourceAddr;
  U32 ipDestAddr;
  U16 sourcePort;
  U16 destPort;
#endif  


  /* magic ptrs...*/
  U16 tx_h_mask; // number of BDs in the host ring - 1
  U16 tx_bd_q;   // what we've queued upload requests for
  U16 tx_bd_rdy; // what BDs are currently in the FIFOXXX not strictly needed!
  U16 tx_bd_rdy_eop; // the last rdy BD that had the EOP bit set
  U16 tx_bd_next;// what BD we will process next (load packet) 1st frag

  U16 tx_bd_done;// update when send consumer

  U16 cache_tx_prod;
  U16 cache_tx_ref;

  U8  irq_primed;

#ifdef TX_SHAPER_SCHED
  U8  credit_inc;   // in KB
  U8  time_inc;     // in 256us increments
  S32 credit;       // our current credit in bytes
  U32 last_credit;  // when were last credited
#endif

} tx2_con_ctxt_t;

/* Write DMA channel state register values */
#define TX2_DMA_TO_HOST_CONS_STATE 0x20086

/* Read DMA channel state register values */
#define TX2_DMA_TO_NIC_BD_STATE    0x86
#define TX2_DMA_TO_NIC_FRAG_STATE  0x84

/* MAC TX BUF control parameters */
#define TX2_MAX_FRAGS       3
#define TX2_MAX_PKT_LEN  (16*1024) 
#define TX2_PKT_BUFS       4   /* MUST be less than
				   NIC_TX_BUF_SIZE / TX2_MAX_PKT_LEN */

typedef U8 pkt_t[TX2_MAX_PKT_LEN];

typedef struct nic_fast_b        // scratchpad for CPU B
{
  /* identify myself */
  U32 cpu_id;

  U32 next_stats_time;  // TX2 stats due time

  U32 sched_mask;       // used by the per-pkt RR scheduler

  /* Other stats */
  U32 nicDmaReadRingFull;
  U32 tx2_pkts_sent;

  /* DMA stuff */
  int bd_dmas_in_q;  // stop us filling assist slots with BDs

  /* MAC stuff */

  U32 tx2_free_bufs;   // allow only 32 TXbufs for starters

  U16 tx2_buf_len[TX2_PKT_BUFS];  // store size of complete packet 
  U16 tx2_buf_consumer[TX2_PKT_BUFS];  // consumer pointer after dma complt

  pkt_t *tx2_buf;      // pointer to the TX buf area
 
  int max_ctxt_id_b;   // copy of A's max connection Id in use

  tx2_con_ctxt_t tx2_ctxt[USD2_NUM_CHANS];  // per channel stuff

  U32 tx2_bds_unseen[(USD2_NUM_CHANS+31)/32];// Waiting for space in BD fifo
  U32 tx2_bds_pend[(USD2_NUM_CHANS+31)/32];  // Waiting for DMA slots available
  U32 tx2_bds_rdy[(USD2_NUM_CHANS+31)/32];   // EOP BDs rdy pending pkt fetch

#ifdef TX_SHAPER_SCHED
  // allowed bit set if channel is in credit
  U32 tx2_bds_allowed[(USD2_NUM_CHANS+32)/32];   // +1 for sentinel

  int heap_entries;
  U32 heap_keys[USD2_NUM_CHANS+2]; // +1 for stats timer, 1 for sentinel
  U8  heap_data[USD2_NUM_CHANS+2]; // +1 for stats timer, 1 for sentinel
#endif


  /* XXX Debug stuff */
  U32 tx2_ever_used;

} nic_fast_b_t;

/****** end of TX2 stuff *************************************************/



/******************************************************************************
 * TX/RX shared state
 */

#define CPU_EVENT_RING_SIZE 64
typedef struct cpu_event_ring_st {
    volatile U32 ring[CPU_EVENT_RING_SIZE];
    volatile U16 cons, prod;
} cpu_event_ring_t;

typedef struct nic {
    /* my mac address */
    struct macaddr mac_addr;

    /* bds for dma gen_info from host */
    struct recv_bd gen_info_bd;

    /* gen_info from host */
    struct tg_gen_info gen_info;

    /* USD - need BD for DMAing connection state */
    struct recv_bd usd_conn_bd;

    U32 bringup_link_state; /* USED BY ../../../common link.c !!! */

    /* event ring */
    U64 align_0[0]; /* force double word alignment */
    struct tg_event event_ring[EVENT_RING_ENTRIES];

    /* multicast */
    struct macaddr mc_table[MAX_MCAST_ENTRIES];
    struct macaddr mc_bucket[MAX_MCAST_ENTRIES + 1];
    U32 mc_filter_saved[4];  /* state of the hardware to restore later */
#define MCAST_HASH_ENTRY_MASK   0x1f
#define MCAST_HASH_GROUP_MASK   0x60
#define MCAST_HASH_GROUP_SHIFT  5
#define MCAST_MAX_HASH_GROUP    3       /* max hash group number */
#define MCAST_FILTER(hash) \
            (MCAST_MAX_HASH_GROUP - \
            ((hash & MCAST_HASH_GROUP_MASK) >> MCAST_HASH_GROUP_SHIFT))

    /*
     * A count of the number of connection teardowns in progress.
     * Only CPU A should modify this!
     */
    U16 ctxt_teardown_count;

    S16 new_filter_install_id; 

    /* The highest numbered context created so far */
    U16 max_ctxt_id;  // should really be volatile, but won't be a problem
  
    /********//* USD2 SRAM variables *//*************************************/
    U64 align_1[0];
    rx2_descr_t rx2_descr[USD2_NUM_CHANS][RX2_NUM_BDs]; 
    tx2_descr_t tx2_descr[USD2_NUM_CHANS][TX2_NUM_BDs]; 
    U16 tx2_consumer[USD2_NUM_CHANS];

    /* New communications mechanism between the two CPUs  */
    cpu_event_ring_t event_ring_a;
    cpu_event_ring_t event_ring_b;
} nic_t;

/* declare global registers */
register U32 event_mask    __asm__ ("$20");	/* Events allowed to trigger */
register U32 event_mask_b  __asm__ ("$20");	/* Events allowed to trig - B*/
register U32 global_flags  __asm__ ("$22");	/* configuration flags */
register nic_t *nicp       __asm__ ("$23");	/* rings and stuff */
register nic_fast_t *nicfp __asm__ ("$26");	/* will in int scratchpad */
register nic_fast_b_t *nicbfp __asm__ ("$26");	/* will in int scratchpad - B*/

register tg_data_t *tdp    __asm__ ("$27");	/* tigon data area */
register tg_regs_t *trp    __asm__ ("$28");	/* All hardware registers */

/* bit definitions of global_flags in cpu register */
#define GF_CMD_MCAST_MODE     		(1 << 17)
#define GF_CMD_PROMISC_MODE    		(1 << 18)
#define set_global_flags(flags)   ({ global_flags |= (flags); })
#define clear_global_flags(flags) ({ global_flags &+ ~(flags); })
#define is_global_flags(flags)    (global_flags & (flags))


/*
 * Copies Wlen words starting at Wsrc to Wdest.
 * Wsrc and Wdest must be word aligned
 * Wlen must be the number of WORDS in block (sizeof(foo)>>2).
 */
__inline__ static void wcopy(U32 *Wsrc, U32 *Wdest, U32 Wlen)
{
    register U32 *src = Wsrc;
    register U32 *dst = Wdest;
    U32 *dst_end = dst + Wlen;

    while ( dst < dst_end ) *dst++ = *src++;
}

/*
 * Zeroes Wlen words starting at Wptr.
 * Wptr must be word aligned
 * Wlen must be the number of WORDS in block (sizeof(foo)>>2).
 */
__inline__ static void wzero(U32 *Wptr, U32 Wlen)
{
    register U32 *ptr = Wptr;
    U32 *ptr_end = ptr + Wlen;

    while ( ptr < ptr_end ) *ptr++ = 0;
}

#define WZERO(d, nwords)        wzero((U32 *)d, (U32)nwords)
#define WCOPY(s, d, nwords)     wcopy((U32 *)s, (U32 *)d, (U32)nwords)

#endif /* _NIC_H_ */
