/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: mac.h,v $
 * Revision 1.7  1999/12/01 10:57:08  iap10
 * *** empty log message ***
 *
 * Revision 1.6  1999/08/10 15:05:33  tjd21
 * First version by kaf.
 *
 * Revision 1.5  1999/07/12 13:17:40  tjd21
 * Scheduling in place, ready for multiple USDs
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 * 
 * $EndLog$
 */
/*
 * FILE mac.h
 *
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/mac.h,v $
 * $Revision: 1.7 $ $Locker:  $
 * $Date: 1999/12/01 10:57:08 $ $Author: iap10 $ $State: Exp $
 */

#ifndef _MAC_H_
#define _MAC_H_

#include "trace.h"
#include "assert.h"


#define INV_DESCR               0x01000000
#define ENQD_DESCR 		0x02000000
#define DMAD_DESCR		0x04000000

__inline__ static tgMacDescr_t *
get_next_mac_tx_descr(tgMacDescr_t *mdp)
{
    return ((mdp == &tdp->tx_mac_ring[TG_NUM_MAC_TX_DESCRS - 1])?
	    tdp->tx_mac_ring:
	    (mdp + 1));
}

__inline__ static tgMacDescr_t *
get_next_mac_rx_descr(tgMacDescr_t *mdp)
{
    return ((mdp == &tdp->rx_mac_ring[TG_NUM_MAC_RX_DESCRS - 1])?
	    tdp->rx_mac_ring:
	    (mdp + 1));
}

#endif /* _MAC_H_ */
