/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: mac.c,v $
 * Revision 1.7  1999/12/01 10:55:01  iap10
 * *** empty log message ***
 *
 * Revision 1.6  1999/08/10 15:05:33  tjd21
 * First version by kaf.
 *
 * Revision 1.5  1999/07/12 13:17:40  tjd21
 * Scheduling in place, ready for multiple USDs
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 * 
 * $EndLog$
 */
/*
 * FILE mac.c
 *
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/mac.c,v $
 * $Revision: 1.7 $ $Locker:  $
 * $Date: 1999/12/01 10:55:01 $ $Author: iap10 $ $State: Exp $
 */

#ifndef __lint
static const char rcsid[] = "$Header: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/mac.c,v 1.7 1999/12/01 10:55:01 iap10 Exp $";
#endif /* __lint */


#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "trace.h"
#include "assert.h"
#include "proto.h"
#include "timer.h"
#include "dma.h"
#include "ring.h"
#include "mac.h"
#include "link.h"
#include "link_op.h"
#include "link_if.h"
#include "zconf.h"
#include "mii.h"

/* globals */
U32 link_attn_count = 0;
U32 gig_negotiate_options;
U32 gig_negotiate;
U32 link_errs = 0;


void init_mac2(void)
{
    NIC_TRACE(TRACE_TYPE_MAC, "initMac2", 0x80100,
              0,0,0,0);
    
    /* set up out recognized unicast address */
    trp->mac_control.mac_src_addr = tsp->gen_com.mac_addr; /* struct copy */

    /* initialize MAC randomizer to low 32 bits of MAC addr */
    trp->mac_control.mac_random = *((U32 *)&(tsp->gen_com.mac_addr) + 1);

    /* determine if we have a 10/100 PHY and/or a Gbit PHY */
    probe_phy();

    active_phy = ATTACHED_PHY_IF_SERDES_EXT;
    set_mac_link(TIGON_MAC_INDEX, ATTACHED_PHY_IF_SERDES_EXT,
		 tsp->gen_com.tuneParms.link_negotiation);

    if (attached_phy & ATTACHED_PHY_IF_MII) {
        active_phy = ATTACHED_PHY_IF_MII;
        set_mac_link(TIGON_MAC_INDEX, ATTACHED_PHY_IF_MII,
		     LNK_10MB | LNK_100MB | LNK_FULL_DUPLEX | LNK_HALF_DUPLEX |
		     LNK_NEGOTIATE | LNK_ENABLE);
    }

#define USD_RX_DESC_LO  2  /* == 0010 => 0010111 == 23 */
    /* Setup threshold values for Descriptors */
    trp->mac_control.mac_thresholds =
        (NIC_RX_BUF_LO   << TG_MAC_RX_THRESH_BUF_SHIFT) |
        (RX_MD_XON       << TG_MAC_RX_THRESH_DESC_XON_SHIFT) |
        (RX_MD_XOFF      << TG_MAC_RX_THRESH_DESC_XOFF_SHIFT) |
        (NIC_RX_BUF_XON  << TG_MAC_RX_THRESH_BUFF_XON_SHIFT) |
        (NIC_RX_BUF_XOFF << TG_MAC_RX_THRESH_BUFF_XOFF_SHIFT) |
	(USD_RX_DESC_LO  << TG_MAC_RX_THRESH_DESC_SHIFT);

    NIC_UTRACE("macThres", 0x80200,
               trp->mac_control.mac_thresholds,
               trp->mac_control.mac_rx_state,
               trp->mac_control.mac_tx_state,
               0);

    additional_rx_bits_wanted = 0;
    link_ready = FALSE;
}


void link_down_notify(void)
{
    struct tg_event event;

    /* link_ready manipulation required by get_mac_link() */
    if (link_ready) {
        link_ready = FALSE;

        /* inform the link state machine that the current active phy 
         * has failed
         */
        active_phy_fail = 1;
        NIC_UTRACE("linkDOWN", 0x80600, 
            trp->mac_control.mac_rx_state,
	    0,
	    0,
	    0);
    }

    tsp->gen_com.linkState &= ~LNK_UP;
    event_mask &= ~TG_FW_EVENT_MAC_RX_ATTN;

    if (nicfp->host_state & TG_HOST_STATE_LINK_RDY_ON) {
        nicfp->host_state &= ~TG_HOST_STATE_LINK_RDY_ON;
        event.TG_EVENT_w0 =
            (TG_EVENT_LINK_STATE_CHANGED << TG_EVENT_EVENT_SHIFT) |
            (TG_EVENT_CODE_LINK_DOWN << TG_EVENT_CODE_SHIFT);
        must_enq_interrupt_event(&event);
        nicfp->stats.nicEventsLinkStateChanged++;
    }
    return;
}
 
void link_up_notify(void)
{
    /* link_ready manipulation required by get_mac_link() */
    if (!link_ready) {
        link_ready = TRUE;
        NIC_UTRACE("linkUP", 0x80700, 
            trp->mac_control.mac_rx_state,
	    0,
	    0,
	    0);
    }

    /* host notification done in h_timer() */

    if (is_global_flags(GF_CMD_PROMISC_MODE)) {
        trp->mac_control.mac_rx_state = 
            (trp->mac_control.mac_rx_state & ~TG_MAC_RX_ATTN_MASK) |
            TG_MAC_RX_STATE_ENA_PROMISC;
    }

    tsp->gen_com.linkState =
	get_mac_link(TIGON_MAC_INDEX, ATTACHED_PHY_IF_SERDES_EXT);
    return;
}
