/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: ip.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1.2.2  1998/09/30  18:49:58  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:39:54  shuang]
 *
 * Revision 1.1.2.1  1998/01/14  23:25:50  ted
 * 	rearrange directories
 * 	[1998/01/14  23:17:45  ted]
 * 
 * Revision 1.1.2.1  1997/11/19  19:23:10  ted
 * 	Support Tigon and Tigon2 in the same driver
 * 	[1997/11/19  19:19:19  ted]
 * 
 * Revision 1.1.2.1  1997/01/16  17:50:47  skapur
 * 	Adding new file to NIC FW Base
 * 	[1996/12/02  17:59:22  skapur]
 * 
 * $EndLog$
 */
#ifndef _IP_H_
#define _IP_H_


/* IP Datagram Structure */
typedef struct ip {
    U8	ipVerHdrLen;
    U8	ipServiceType;
    U16	ipLen;
    U16 ipId;
    U16 ipFragOffset;
    U8	ipTimeToLive;
    U8	ipProtocol;	/* See IP_PROTO_***  below */
    U16 ipCheckSum;
    U32 ipSourceAddr;
    U32 ipDestAddr;
    U8  ipData[0];
} ip_t;

/* IP Prototypes  for  ipProtocol */
#define	IP_PROTO_ICMP	1   /* ICMP Packets */
#define	IP_PROTO_IGMP	2   /* IGMP Packets */
#define	IP_PROTO_TCP	6   /* TCP  Packets */
#define	IP_PROTO_EGP	8   /* EGP  Packets */
#define	IP_PROTO_UDP	17  /* UDP  Packets */
#define	IP_PROTO_OSPF	89  /* OSPF Packets */

/* Misc. defines for IP  Protocol */
#define	IP_VER4		4    /* IP Version4; the current version  */
#define	IP_MIN_HLEN	20   /* IP minimum Header Length in bytes */

/* Macro to compute the Header Length for IP Header in bytes */
#define	IP_HLEN(pip)    ((((ip_t *)pip)->ipVerHdrLen & 0xf) << 2)	   

/* Macro to get version for IP */
#define	IP_VERSION(pip) ((((ip_t *)pip)->ipVerHdrLen & 0xf0) >> 4)	   

#endif /* _IP_H_ */
