/*
 * All modifications to this file are:
 * Copyright (c) 1999-2000, Ian Pratt & K A Fraser
 * 
 * Please read the FIRMWARE-LICENSE fiel for more details.
 */

/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * FILE fwmain.c
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/fwmain.c,v $
 * $Revision: 1.20 $ $Locker: iap10 $
 * $Date: 2000/03/31 12:18:50 $ $Author: iap10 $ $State: Exp $
 */

#ifndef __lint
static const char rcsid[] = "$Header: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/fwmain.c,v 1.20 2000/03/31 12:18:50 iap10 Exp iap10 $";
#endif /* __lint */

#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "trace.h"
#include "proto.h"
#include "timer.h"
#include "ring.h"
#include "link_op.h"
#include "dma.h"
#include "assert.h"

#include "usd2_util.h"
#include "event.h"

/* reserve how much stack on scratch pad */
#define SCRATCH_PAD_STACK_SIZE  (512)

/* relocate to scratchpad */
#define	TO_SCRATCHPAD(src, len, dstp, sizep) \
	copy2scratchpad("+"#src, (U32)src, (U32)len, (U32*)dstp, (U32*)sizep)

U32 stack_start   = (U32)(TG_DATA_END - 4);
U32 stack_start_b = (U32)(TG_DATA_END - 4 - 128);

/* how we want to utilize the scratch pad */
U32 scratch_pad_enable_stack = 1;
U32 scratch_pad_enable_vars  = 1;
U32 scratch_pad_enable_code  = 1;

U32 adj_stack_start    = TG_BEG_SCRATCH + SCRATCH_PAD_STACK_SIZE - sizeof(U32);
U32 scratch_pad_size   = TG_END_SCRATCH - TG_BEG_SCRATCH - sizeof(U32);
U32 scratch_pad_loc    = TG_BEG_SCRATCH;

U32 scratch_pad_b_size; // initialised later
U32 scratch_pad_b_loc;

/* externals */
extern void _disp_loop(void);
extern void _disp_loop_b(void);
extern U32 _end; /*implicit; needed for stack bounds checking... */

/* forward declarations */
static void fw_init(void);
static void fw_init_b(void);
static U32 copy2scratchpad(char *, U32, U32, U32*, U32*);
void main_a(void);
void main_b(void);


/* Horid transfer area for moving packet filters host->SRAM->SCRATCH */
#define FILTER_BUF_SIZE 4096
char filter_buf[FILTER_BUF_SIZE];


/*
 * The per-context data we have DMAed from the host for the connection
 * currently being set up.
 * 
 * This is used at startup to hack in the required state for connection zero.
 * 
 * XXXX DO NOT USE FOR ANYTHING ELSE!!!! XXXX
 */
static conn_ctxt_host_part_t conn_hps;

#define	set_event_disp(event_num, func) { \
	    ev_handlerp[((event_num) + 1) << 1] = \
		(0x08 << 24) | ((0x0fffffff & (U32)(func)) >> 2); \
	}

#define	set_event_disp_b(event_num, func) { \
	    ev_handlerp_b[((event_num) + 1) << 1] = \
		(0x08 << 24) | ((0x0fffffff & (U32)(func)) >> 2); \
	}
	

/*
 * initialization and main loop for firmware
 */
void main_a(void)
{
    /* Don't have any local variable here! */

    /* init trp */
    trp = (tg_regs_t *)(TG_BEG_REGS);

    /* cpu stuffs */
    trp->cpu_control.cpu_state |= 
	TG_CPU_PAGE_0_HALT_ENA ;
         /* | TG_CPU_DATA_CACHE_ENA; XXX IAP Cache ON  - FAILS!! */

    trp->local_mem_conf.cpu_priority = 3;
    trp->cpu_control_b.cpu_state |= TG_CPU_HALT;
    /* init trace buffer */
    init_trace();

    /* write 0 to last word in scratchpad to fix static IDD problem */
    *(U32 *)((U32)TG_END_SCRATCH - sizeof(U32)) = 0;

    /* init tdp, nicp */
    tdp = (tg_data_t *)(TG_DATA_END - sizeof(tg_data_t));
    nicp = (struct nic *)((U32)tdp - sizeof(nic_t));

    /* setup real stack values */
    stack_start   = (U32)&tdp->stack  [TG_STACK_WORDS - 1];
    stack_start_b = (U32)&tdp->stack_b[TG_STACK_WORDS - 1];

    /* in case the stack ever moves to scratch */
    trp->cpu_control.adjust_stack = TG_BEG_SCRATCH - (U32)tdp->stack_b;
    trp->cpu_control_b.adjust_stack = 
        TG_BEG_SCRATCH - (U32)tdp->stack_page_align_padding;

    if (scratch_pad_enable_stack) {

        /* make sure our external stack is on page boundary */
	ASSERT(!((U32)tdp->stack & 0xfff));

        /* relocate stack to scratch pad */
        __asm__ volatile
        ("
            .set noreorder
            lw   $sp, adj_stack_start
            move $fp, $sp
            .set reorder
        ");

        scratch_pad_size  -= SCRATCH_PAD_STACK_SIZE;
        scratch_pad_loc += SCRATCH_PAD_STACK_SIZE;

    } else {
        /* relocate to real stack */
        __asm__ volatile
        ("
            .set noreorder
            lw   $sp, stack_start
            move $fp, $sp
            .set reorder
        ");
    }

    /* setup nicfp */
    if (scratch_pad_enable_vars) {
        nicfp = (nic_fast_t *)scratch_pad_loc;
        scratch_pad_size  -= sizeof(nic_fast_t);
        scratch_pad_loc += sizeof(nic_fast_t);
    } else {
        nicfp = (nic_fast_t *)((U32)nicp - sizeof(nic_fast_t));
    }

    if (!scratch_pad_enable_code) {
        scratch_pad_size = 0; /* disable later code relocation */
    }

    NIC_UTRACE("NicMem", 0x00201,
	       tdp, nicp, nicfp, stack_start);



    /* firmware initialization */
    fw_init();
}

static void
fw_init(void)
{ 
    register U32 dispp __asm__ ("$16");
    register U32 *ev_handlerp __asm__("$18");

    struct tg_event event, error_event;
    static U8 alteonStr[] = "Alteon AceNIC V";
    U32 events, high_event;
    U32 align;
    U32 i;
    bool send_error_event;

    send_error_event = FALSE;
    ev_handlerp = ev_handler;

    NIC_UTRACE("hwFwVer", 0x00200,
               trp->gen_control.misc_host_control,0,0,0);

    /* check hw revision */
    if ( (trp->gen_control.misc_host_control & TG_MHC_TIGON_VERSION_MASK) !=
         TG_MHC_LSI_STANDARD_CELL_VERS_B )
    {
	NIC_UTRACE("badHwVer", 0x00300,
                   trp->gen_control.misc_host_control,0,0,0);
        PANIC();
    }

    /* clear semaphore */
    trp->cpu_control_b.cpu_state |= TG_CPU_HALT;
    if ( trp->gen_control.semaphore_a ) trp->gen_control.semaphore_a = 0;
    if ( trp->gen_control.semaphore_b ) trp->gen_control.semaphore_b = 0;

    /* zero out nic and nic fast structure */
    bzero((U32 *)nicp, sizeof(struct nic));
    bzero((U32 *)nicfp, sizeof(struct nic_fast));

    /* register myself */
    nicfp->cpu_id = TG_CPU_A;

    /* make sure external stack do not overlap bss region */
    {
	U32 mem_end = NIC_MEM_1M - 1;
	U32 stk_end = (U32)tdp->stack;

	if (((U32)&_end & mem_end) > (stk_end & mem_end)) {
	    NIC_UTRACE("redZone1", 0x00900,
		&_end,
		stk_end,
		mem_end,
		0);
            PANIC();
	}
    }

    /* pci configuration */
    NIC_UTRACE("pciConf", 0x01000,
	*(U32 *)trp, 		/* deviceId & vendorId */
	*((U32 *)trp + 1),	/* status & command */
	*((U32 *)trp + 3),	/* bist & hdrType & latencyTimer & cacheLnSz */
	*((U32 *)trp + 15));	/* maxLat & MinGrant & IntrPin & IntrLine */

    /* general configuration */
    NIC_UTRACE("genConf", 0x01100,
	tsp->gen_com.mode_status,
	tsp->gen_com.dma_read_config,
	tsp->gen_com.dma_write_config,
	tsp->gen_com.tx_buf_ratio);

    /*
     * Initialization works like this- We are completely controlled by the 
     * host. The host downloads the NIC code (this code!) into the nic and 
     * starts it running. It is assumed that the host has initialized the 
     * shared memory region and mapped all of the structures that the NIC 
     * DMA's to and from the host. Once we complete initialization, we give 
     * the host a FIRMWARE_OPERATIONAL event.
     */
 
    /* initialize timer for simulator */
    trp->gen_control.timer = 0;

    /* disable DMA assist and reset to known state */
    trp->host_dma_assist.assist_state = 0;

    /* set up dma state variables */
    if (tsp->gen_com.mode_status & TG_CFG_MODE_BYTE_SWAP_BD) {
        nicfp->dma_to_host_bd_state = 
            tsp->gen_com.dma_write_config |
            TG_DMA_STATE_ACTIVE |
            TG_DMA_STATE_DISABLE_PROD_COMP |
	    0;

        nicfp->dma_to_nic_bd_state = 
            tsp->gen_com.dma_read_config |
            TG_DMA_STATE_ACTIVE;

    } else {
        nicfp->dma_to_host_bd_state = 
            tsp->gen_com.dma_write_config |
            TG_DMA_STATE_ACTIVE |
            TG_DMA_STATE_NO_SWAP | 
            TG_DMA_STATE_DISABLE_PROD_COMP |
	    0;

        nicfp->dma_to_nic_bd_state = 
            tsp->gen_com.dma_read_config |
            TG_DMA_STATE_NO_SWAP |
            TG_DMA_STATE_ACTIVE |
	    0;
    }
    NIC_UTRACE("DMAState", 0x112, 
	       nicfp->dma_to_nic_bd_state,
	       nicfp->dma_to_host_bd_state,0,0);

    /* reset dma */
    trp->host_dma.dma_wr_state = TG_DMA_STATE_RESET;
    trp->host_dma.dma_rd_state = TG_DMA_STATE_RESET;
    WAIT_US(100);

    /* setup gen_info buffer descr */
    nicp->gen_info_bd.BD_host_addr = tsp->gen_com.gen_info_ptr;
    nicp->gen_info_bd.BD_nic_addr  = (U32)&nicp->gen_info;
    nicp->gen_info_bd.BD_w2        = sizeof(struct tg_gen_info); /* len */

    /* dma gen_info area into NIC */
    dma_to_nic(&nicp->gen_info_bd);
    while (trp->host_dma.dma_rd_state & TG_DMA_STATE_ACTIVE)
        ; /* wait for DMA to complete */

    /* Set up context space, and DMA in the host info for context 0 
     * Context 0 is always present, it is the kernel's interface.  
     * We will add user-level interfaces later. */

    init_usd_contexts();

    /* setup connection zero's BD */
    nicp->usd_conn_bd.BD_host_addr = nicp->gen_info.usd_conn_zero_ptr;
    nicp->usd_conn_bd.BD_nic_addr  = (U32)&conn_hps;
    nicp->usd_conn_bd.BD_w2        = sizeof (conn_ctxt_host_part_t);

    /* dma it into local (nic) memory */
    dma_to_nic(&nicp->usd_conn_bd);
    while (trp->host_dma.dma_rd_state & TG_DMA_STATE_ACTIVE)
        ; /* wait for DMA to complete */

    NIC_UTRACE("ConnZero", 0x01180,
	nicp->gen_info.usd_conn_zero_ptr,
	(U32)&conn_hps,0,0);

    /* setup global flags */
    global_flags = 0;

    /* setup nicfp host pointers */
    nicfp->event_producer_ptr = nicp->gen_info.event_producer_ptr;
    nicfp->event_ring_ptr     = nicp->gen_info.event_rcb.ring_addr;
    nicfp->stats2_ptr         = nicp->gen_info.stats2_ptr;

    /* zero HW macstats area in shmem */
    bzero((U32 *)&tsp->macstats, sizeof(struct mac_stats));

    /* Set up the basic default values for Stats
     * Following exists in command.c as well, so if it changes here
     * make sure to chage it there as well 
     */ 
    nicfp->stats.ifIndex	= tsp->gen_com.ifIndex; 
    nicfp->stats.ifMtu		= MTU; /* was: tsp->gen_com.ifMTU; */ 
    nicfp->stats.ifPhysAddress	= tsp->gen_com.mac_addr; 
    nicfp->stats.ifType		= 6;  /* Type = Ethernet(6) for now */
    nicfp->stats.ifOperStatus	= IF_OPER_STATUS_DOWN; 
    nicfp->stats.ifAdminStatus	= IF_ADMIN_STATUS_DOWN; 
    nicfp->stats.ifSpeed	= 1000000000;  /* 1 Gig bits/sec */
    nicfp->stats.ifHighSpeed	= 1000;  /* 1000 Mbits/sec */
    nicfp->stats.ifLinkUpDownTrapEnable = 2; /* Always Disabled(2) */
    nicfp->stats.ifConnectorPresent = 1; /* Always True (1) */


    for ( i = 0; i < 15; i++ ) nicfp->stats.ifDescr[i] = alteonStr[i];

    nicfp->stats.ifDescr[i++] = (U8) 0x30 + 
      ((trp->gen_control.misc_host_control & TG_MHC_TIGON_VERSION_MASK) >> 28);
    nicfp->stats.ifDescr[i++] = '\0'; /* Null terminate the string */

    NIC_UTRACE("globFlgs", 0x01400,
	global_flags,
	tsp->gen_com.mode_status,
	sizeof(nic_fast_t),
	sizeof(nic_t));
 
    /* Move most common routines into scratchpad. */
    dispp =
	TO_SCRATCHPAD
	(_disp_loop,
	16,
	&scratch_pad_loc,
	&scratch_pad_size);

    if (scratch_pad_enable_code) {
        /* jump table must appear on 256B boundary */
        align = ROUNDUP(scratch_pad_loc, 256);

        scratch_pad_size -= (align - scratch_pad_loc);
        scratch_pad_loc = align;
    }

    ev_handlerp = (U32 *)
	TO_SCRATCHPAD
	(ev_handler,
	sizeof(ev_handler),
	&scratch_pad_loc,
	&scratch_pad_size);

    nicfp->q_dma_to_nic_stub = q_dma_to_nic;
#if 0
        (U32 (*)(tg_hostaddr_t, U32, U32, U16, U16, U32, U32))
        TO_SCRATCHPAD
        (q_dma_to_nic,
         (U32)q_dma_to_nic_end - (U32)q_dma_to_nic,
         &scratch_pad_loc,
         &scratch_pad_size);
#endif

    h_dma_rd_asst_hi_A_stub = (void (*)(void))
        TO_SCRATCHPAD
        (h_dma_rd_asst_hi_A,
         (U32)h_dma_rd_asst_hi_A_end - (U32)h_dma_rd_asst_hi_A,
         &scratch_pad_loc,
         &scratch_pad_size);
    set_event_disp(TG_FW_EVENT_NUM_DMA_RD_ASST_HI, h_dma_rd_asst_hi_A_stub);

    nicfp->q_dma_to_host_stub = q_dma_to_host;
#if 0
        (U32 (*)(tg_hostaddr_t, U32, U32, U16, U16, U32, U32))
        TO_SCRATCHPAD
        (q_dma_to_host,
         (U32)q_dma_to_host_end - (U32)q_dma_to_host,
         &scratch_pad_loc,
         &scratch_pad_size);
#endif

    h_mac_rx2_comp_stub = (void (*)(void))
        TO_SCRATCHPAD
        (h_mac_rx2_comp,
         (U32)h_mac_rx2_comp_end - (U32)h_mac_rx2_comp,
         &scratch_pad_loc,
         &scratch_pad_size);
    set_event_disp(TG_FW_EVENT_NUM_MAC_RX_COMP, h_mac_rx2_comp_stub);

    h_dma_wr_asst_hi_A_stub = (void (*)(void))
        TO_SCRATCHPAD
        (h_dma_wr_asst_hi_A,
         (U32)h_dma_wr_asst_hi_A_end - (U32)h_dma_wr_asst_hi_A,
         &scratch_pad_loc,
         &scratch_pad_size);
    set_event_disp(TG_FW_EVENT_NUM_DMA_WR_ASST_HI, 
                   (U32)h_dma_wr_asst_hi_A_stub);

    mh_command_stub = 
        TO_SCRATCHPAD
	(mh_command,
	(U32)mh_command_end - (U32)mh_command,
	&scratch_pad_loc,
	&scratch_pad_size);

    /**************************************************************/

    // move some useful functions into sratch pad
    rx2_upload_bds_stub = (int (*)(int, U32))
      TO_SCRATCHPAD
      (rx2_upload_bds,
       (U32)rx2_upload_bds_end - (U32)rx2_upload_bds,
       &scratch_pad_loc,
       &scratch_pad_size);

    h_rx2_mbox_poll_stub = (void (*)(void))
        TO_SCRATCHPAD
	(h_rx2_mbox_poll,
	(U32)h_rx2_mbox_poll_end - (U32)h_rx2_mbox_poll,
	&scratch_pad_loc,
	&scratch_pad_size);

    rx2_poll_stub = (void (*)(int))
      TO_SCRATCHPAD
      (rx2_poll,
       (U32)rx2_poll_end - (U32)rx2_poll,
       &scratch_pad_loc,
       &scratch_pad_size);
    
    set_event_disp(TG_FW_EVENT_NUM_POLL_MBOX_A, h_rx2_mbox_poll_stub);
    set_event_reg(TG_FW_EVENT_POLL_MBOX_A); // stamped on later!!!

    /**************************************************************/

    h_timer_stub = 
        TO_SCRATCHPAD
	(h_timer,
	(U32)h_timer_end - (U32)h_timer,
	&scratch_pad_loc,
	&scratch_pad_size);

    set_event_disp(TG_FW_EVENT_NUM_TIMER, h_timer_stub);


    // Is the following function really worth putting in scratchpad???
    // I suppose it needs to turn the RX Mac off pretty sharpish...
    h_mac_rx2_attn_stub = (void_fn_t)
        TO_SCRATCHPAD
	(h_mac_rx2_attn,
	(U32)h_mac_rx2_attn_end - (U32)h_mac_rx2_attn,
	&scratch_pad_loc,
	&scratch_pad_size);

    set_event_disp(TG_FW_EVENT_NUM_MAC_RX_ATTN, h_mac_rx2_attn_stub);

    /* set all the HW rings key off the TX buf base and RX buf base */
    init_mac1();

    /* Set up the DMA assist rings and enable the DMA assist.
     * From now on, all DMA must go through the assist logic.
     * Using the other DMA method will confuse the DMA assist logic.
     */
    init_dma_assist();

#if 0
    if( tsp->gen_com.perf_test_ptr )
    {
        U32 tmp_loc = scratch_pad_loc, tmp_size = scratch_pad_size;
        void (*stub)(tg_hostaddr_t);

        init_timer();

        /* KAF: ensure that CPU B really is halted! */
        trp->cpu_control_b.cpu_state |= TG_CPU_HALT;

        /* First round of tests execute from SRAM: this hurts performance */
        NIC_UTRACE("PerfStrt", 0x97800,
                   tsp->gen_com.perf_test_ptr, 0, 0, 0);        
        perf_test(tsp->gen_com.perf_test_ptr);

        /* 2nd round: we temporarily copy the perf code into the scratchpad */
        NIC_UTRACE("PerfScra", 0x97900,
                   tsp->gen_com.perf_test_ptr, 0, 0, 0);
        stub = (void(*)(tg_hostaddr_t))
            TO_SCRATCHPAD(perf_test, (U32)perf_test_end - (U32)perf_test, 
                          &tmp_loc, &tmp_size);
        (*stub)(tsp->gen_com.perf_test_ptr);
    }   
#endif




    /* init shared memory stuffs */
#if CHECKFORERROR 
    tsp->mbox_command_prod_index = 0;
#endif
    tsp->gen_com.event_cons_index = 0;
    tsp->gen_com.command_cons_index = 0;
 
    /* init multicast stuffs */
    mcast_init();

    /************************************************ RX2 */

    // stagger next stats time from TX2
    nicfp->next_stats_time = TG_TICK_1US * 333333;

    /* Hack Context information for chan0 */
    {
        rx2_con_ctxt_t        *c  = nicfp->rx2_ctxt;
        conn_ctxt_host_part_t *hp = &conn_hps; 
    
        bzero( (void *)c, sizeof( rx2_con_ctxt_t ) );
      
        c->host_range_base   = hp->host_range_base;
        c->host_range_length = hp->host_range_length;
        c->rx_h_mask         = hp->rx2_ring_size - 1;
        c->rx2_ring_ptr      = hp->rx2_ring_ptr;      
    }

    /* By this point, everything thats going into the scratchpad
    appart from the RX filters MUST ALREADY BE THERE! */
    
    // scratch_pad_size/loc are already word aligned
    {
      U32 tmp_loc  = scratch_pad_loc;
      U32 tmp_size = scratch_pad_size;

      U32 len = (U32)default_rx_filter_end - (U32)default_rx_filter;

      nicp->new_filter_install_id = -1;  // nothing in progress

      nicfp->rx_filter = (rx_filter_fn_t*)
        TO_SCRATCHPAD
	(default_rx_filter,
	 len,
	 &tmp_loc,
	 &tmp_size);

      if( tmp_size == scratch_pad_size )
	{
	  // didn't fit !!!
	  NIC_UTRACE("3RxNoFit", 0x99001,
		     scratch_pad_loc, scratch_pad_size, len, 0);

	  PANIC();
	}

    }
    

    /************************************************ RX2 */

    /* Events from other CPU */
    set_event_disp(TG_FW_EVENT_NUM_USD_EVENT_A, event_handler_A);

    /* turn both LEDs off */
    trp->gen_control.misc_local_control &= 
      ~(TG_MLC_LED_DATA|TG_MLC_LED_LINK);	

    /* initialize event mask */
    event_mask =
        TG_FW_EVENT_TIMER |
        TG_FW_EVENT_MAC_RX_ATTN |
        TG_FW_EVENT_DMA_RD_ATTN |
        TG_FW_EVENT_DMA_WR_ATTN |
        TG_FW_EVENT_DMA_RD_ASST_HI |
        TG_FW_EVENT_DMA_WR_ASST_HI |
        TG_FW_EVENT_MAC_RX_COMP |
        TG_FW_EVENT_POLL_MBOX_A |
        TG_FW_EVENT_USD_EVENT_A;

    /* init the event reg */
    trp->gen_control.event =
        TG_FW_EVENT_REMOTE_CPU_ATTN | 
      TG_FW_EVENT_POLL_MBOX_A ;  // XXX RX2

#if defined(MAILBOX)
    init_mailbox(); XXX
#else /* !defined(MAILBOX) */
    trp->gen_control.mailbox_event = 0xffffffff;
#endif /* defined(MAILBOX) */

    /* init timers */
    init_timer();

    /* Initialize CPU B */
    trp->cpu_control_b.cpu_state |= TG_CPU_HALT;
    trp->cpu_control_b.pc         = (U32)_start_b;
    trp->cpu_control_b.cpu_state  = 0;
        
    /* Wait for CPU B to tell us to enter dispatch loop */
    while (! (trp->gen_control.event & TG_FW_EVENT_REMOTE_CPU_ATTN));

    /* Initialize the MAC interface.
     * This probes out the PHY(s) and takes a while
     * so we need to do it before we send the firmware operational event.
     */
    init_mac2();

    /* generate firmware up event */
    event.TG_EVENT_w0 = TG_EVENT_FIRMWARE_OPERATIONAL << TG_EVENT_EVENT_SHIFT;
    enq_event(&event);
    nicfp->stats.nicEventsNICFirmwareOperational++;
    if (send_error_event) {
	error_event.TG_EVENT_w0 =
	    (TG_EVENT_ERROR << TG_EVENT_EVENT_SHIFT) |
	    (TG_EVENT_CODE_ERR_BAD_CONFIG << TG_EVENT_CODE_SHIFT);
        enq_event(&error_event);
        nicfp->stats.nicEventsError++;

        NIC_UTRACE("fwOpFail", 0x02300,
	    error_event.TG_EVENT_w0,
	    0,
	    0,
	    0);
	PANIC();
    }

    /* wait for the operational event to complete to send interrupt */
    while ((trp->host_dma.dma_wr_state & TG_DMA_STATE_ACTIVE) &&
           (tsp->gen_com.maskRupts))
        ; /* wait for (DMA to complete, Host ready) */

    /* Interrupt host right away. */
    trp->gen_control.misc_local_control |= TG_MLC_SET_INTERRUPT;

    /* XXXX RX22 specific stuff */
    nicfp->mac_rx_descr_queued = TDP->rx_mac_ring;

    tsp->gen_com.rx2_interrupts_active[0] = 0; // HACK!

    /* XXXX end of RX22 specific stuff */

    NIC_UTRACE("intState", 0x02400,
	trp->gen_control.pci_state,
	trp->host_dma_assist.assist_state,
	trp->host_dma.dma_wr_state,
	trp->host_dma.dma_rd_state);

    NIC_UTRACE("**initCp", 0x02500,
	trp->gen_control.misc_local_control,
	trp->gen_control.misc_config,
	trp->mac_control.mac_tx_state,
	trp->mac_control.mac_rx_state);

    /* main dispatcher loop */
    __asm__ volatile
    ("
        .set noreorder
        .globl _disp_loop
    _disp_loop:
        lw      %0,0x60($28)     # load event register
        pri     %1,%0,%2         # determine next event
        joff    %1,%3            # jump to next event
        move    $31,%4
        .set reorder
        nop
        halt
        " : "=r" (events), "=r" (high_event)
        : "r" (event_mask), "r" (ev_handlerp), "r" (dispp)
    );
    /* not reached */
}

void scream_handler(void)
{
    NIC_UTRACE("#scream", 0x02600,0,0,0,0);
    PANIC();
}


U32 copy2scratchpad(char *name, U32 start_addr, U32 len,
                    U32 *spad_loc, U32 *spad_size)
{
    U32 actual_loc;
 
    len = ROUNDUP(len, 4);
    if (len <= *spad_size) {
        actual_loc = *spad_loc;
	#if 0
	*name = '+'; 
	#endif

        NIC_UTRACE(name, 0x03000,
	    start_addr,
	    *spad_loc,
	    len,
	    *spad_size);

        wcopy((U32 *)start_addr, (U32 *)*spad_loc, (len >> 2));
        *spad_size -= len; /* Word Boundary */
        *spad_loc  += len; /* Word Boundary */
    } else {
        actual_loc = start_addr;
	*name = '-';

        NIC_UTRACE(name, 0x03100,
	    start_addr,
	    *spad_loc,
	    len,
	    *spad_size);
	/*PANIC(); */                 /* XXX IAP */
    }
    return (actual_loc);
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 * Entry point for TigonSC CPU B (Tx CPU)
 */
void main_b(void)
{
    trp = ((tg_regs_t *)(TG_BEG_REGS));
    tdp = (tg_data_t *)(TG_DATA_END - sizeof(tg_data_t));
    nicp = (struct nic *)((U32)tdp - sizeof(nic_t));

    /* write 0 to last word in scratchpad to fix static IDD problem */
    *(U32 *)((U32)TG_END_SCRATCH_B - sizeof(U32)) = 0;

    scratch_pad_b_size  = TG_END_SCRATCH_B - TG_BEG_SCRATCH - sizeof(U32);
    scratch_pad_b_loc = TG_BEG_SCRATCH;

    /* relocate stack to scratch pad */
    __asm__ volatile
    ("
	.set noreorder
	lw	$sp, adj_stack_start
	move	$fp, $sp
	.set reorder
    ");
    scratch_pad_b_size  -= SCRATCH_PAD_STACK_SIZE;   // 512 bytes
    scratch_pad_b_loc += SCRATCH_PAD_STACK_SIZE;

    trp->cpu_control_b.cpu_state |=
#if 0  // CPU BUG work around !!!
        TG_CPU_DATA_CACHE_ENA |
#endif /* XXX */
        TG_CPU_PAGE_0_HALT_ENA;


    fw_init_b();
}


void fw_init_b(void)
{
    register U32 dispp_b __asm__ ("$16");
    register U32 *ev_handlerp_b __asm__("$18");
    U32 events_b, high_event_b;
    U32 align;

    //U32 scratch_pad_size = scratch_pad_sz;
    //U32 scratch_pad_loc  = scratch_pad_mem;


    nicbfp = (nic_fast_b_t *) TG_BEG_SCRATCH; // XXX temp value

    /* These copy2scratch pads are in this order to save a few bytes
due to alignment. It's a little horrid as we ll end up doing tracing
before nicbfp is properlly initialised, but if we're careful, it won't
kill us... */

    if (scratch_pad_enable_code) {
        /* jump table must appear on 256B boundary */
        align = ROUNDUP(scratch_pad_b_loc, 256);

        scratch_pad_b_size -= (align - scratch_pad_b_loc);
        scratch_pad_b_loc = align;
    }

    ev_handlerp_b = (U32 *)
	TO_SCRATCHPAD
	(ev_handler_b,
	sizeof(ev_handler_b),
	&scratch_pad_b_loc,
	&scratch_pad_b_size);

    dispp_b =
	TO_SCRATCHPAD
	(_disp_loop_b,
	 16, 
	&scratch_pad_b_loc,
	&scratch_pad_b_size);


    /* nic fast structure resides in scratch pad */
    nicbfp = (nic_fast_b_t *)scratch_pad_b_loc;
    scratch_pad_b_size  -= sizeof(nic_fast_b_t);
    scratch_pad_b_loc += sizeof(nic_fast_b_t);

    /* zero out nic and nic fast structure */
    bzero((U32 *)nicbfp, sizeof(struct nic_fast_b));

    /* register myself */
    nicbfp->cpu_id = TG_CPU_B;


    NIC_UTRACE("**DAWN_B", 0x03200,
	sizeof(nic_fast_b_t),
	sizeof(nic_fast_t),
	       //	tdp,
	nicp,
	nicbfp);

    ev_handlerp_b = ev_handler_b;


    /* initialize event mask */ 
    event_mask_b = 0;

    //init_timer_b();

    /* move most common routines into scratch pad */
    NIC_UTRACE("MboxevB", 0x03201,
	       trp->gen_control.mailbox_event_b,0,0,0);

    /* clear any mbox event bits that may be spuriously set */
    trp->gen_control.mailbox_event_b = trp->gen_control.mailbox_event_b;

    NIC_UTRACE("MboxevB", 0x03202,
	       trp->gen_control.mailbox_event_b,0,0,0);

    
    /* zero the tx2 control window */
    bzero( (U32 *) usd2_ctrl_p, sizeof(usd2_ctrl_t) * USD2_NUM_CHANS);


    // move some useful functions into sratch pad
    tx2_upload_bds_stub = (int (*)(int, U32))
      TO_SCRATCHPAD
      (tx2_upload_bds,
       (U32)tx2_upload_bds_end - (U32)tx2_upload_bds,
       &scratch_pad_b_loc,
       &scratch_pad_b_size);
    
    // move some useful functions into sratch pad
    tx2_select_pkt_for_upload_stub = (void (*)(void))
      TO_SCRATCHPAD
      (tx2_select_pkt_for_upload,
       (U32)tx2_select_pkt_for_upload_end - (U32)tx2_select_pkt_for_upload,
       &scratch_pad_b_loc,
       &scratch_pad_b_size);        

    // XXX need to re-evaluate this hf_timer code in TX2 world ?
    hf_timer_stub = (void (*)(void))
      TO_SCRATCHPAD
      (h_hf_timer,
       (U32)h_hf_timer_end - (U32)h_hf_timer,
       &scratch_pad_b_loc,
       &scratch_pad_b_size);

    set_event_disp_b(TG_FW_EVENT_NUM_TIMER, hf_timer_stub);

    /**** set up mbox handler -- now polling on `event' priority 0 ***/

    h_tx2_mbox_poll_stub = (void (*)(void))
	TO_SCRATCHPAD
	(h_tx2_mbox_poll,
	(U32)h_tx2_mbox_poll_end - (U32)h_tx2_mbox_poll,
	&scratch_pad_b_loc,
	&scratch_pad_b_size);

    set_event_disp_b(TG_FW_EVENT_NUM_POLL_MBOX_B, h_tx2_mbox_poll_stub);

    /**** set up MAC TX COMPLETE event handler ***/

    h_max_tx_comp_B_stub = (void (*)(void))
	TO_SCRATCHPAD
	( h_max_tx_comp_B,
	(U32) h_max_tx_comp_B_end - (U32) h_max_tx_comp_B,
	&scratch_pad_b_loc,
	&scratch_pad_b_size);

    set_event_disp_b(TG_FW_EVENT_NUM_MAC_TX_COMP, h_max_tx_comp_B_stub);

    /**** set up RD DMA ASSIST LO event handler ***/

    h_dma_rd_asst_lo_B_stub = (void (*)(void))
	TO_SCRATCHPAD
	( h_dma_rd_asst_lo_B,
	(U32) h_dma_rd_asst_lo_B_end - (U32) h_dma_rd_asst_lo_B,
	&scratch_pad_b_loc,
	&scratch_pad_b_size);

    set_event_disp_b(TG_FW_EVENT_NUM_DMA_RD_ASST_LO, h_dma_rd_asst_lo_B_stub);
    
    set_event_disp_b(TG_FW_EVENT_NUM_MAC_TX_ATTN, &h_mac_tx2_attn);

    /* Events from other CPU */
    set_event_disp_b(TG_FW_EVENT_NUM_USD_EVENT_B, event_handler_B);

    event_mask_b =       
        TG_FW_EVENT_MAC_TX_ATTN |
        TG_FW_EVENT_TIMER |
        TG_FW_EVENT_DMA_RD_ASST_LO |
        TG_FW_EVENT_POLL_MBOX_B  |
        TG_FW_EVENT_MAC_TX_COMP |
        TG_FW_EVENT_USD_EVENT_B;

    /* signal CPU A to enter dispatch loop */
    trp->gen_control.event_b = TG_FW_EVENT_SET_REMOTE_CPU_ATTN;

    /* Set event zero so that we enter the mbox_poll loop when idle */
    set_event_reg_b(TG_FW_EVENT_POLL_MBOX_B);


    /* Configure TX Buf area */

    nicbfp->tx2_buf = (pkt_t *) (NIC_TX_BUF+16); // XXXX HACK IAP

    nicbfp->tx2_free_bufs = (1<<TX2_PKT_BUFS)-1;


    /* Hack Context information for chan0 */
    {
        tx2_con_ctxt_t        *c  = nicbfp->tx2_ctxt;
        conn_ctxt_host_part_t *hp = &conn_hps; 

        bzero( (void *)c, sizeof( tx2_con_ctxt_t ) );
      
        c->host_range_base   = hp->host_range_base;
        c->host_range_length = hp->host_range_length;
        c->tx_h_mask         = hp->tx2_ring_size - 1;
        c->tx2_consumer_ptr  = hp->tx2_csm_ptr;
        c->tx2_ring_ptr      = hp->tx2_ring_ptr;

#ifdef TX_SHAPER_SCHED
	c->credit_inc = 255; 
	c->time_inc   = 0;   // unlimited credit

	c->credit      = c->credit_inc<<10;
	c->last_credit = trp->gen_control.timer;
	
	set_bit( nicbfp->tx2_bds_allowed, 0 );
#endif
       
    }

    /* start stats timer */
#ifdef TX_SHAPER_SCHED
    nicbfp->next_stats_time = 
      trp->gen_control.timer + (TG_TICK_1US * 1000000U);

    if( spq_insert( nicbfp->next_stats_time, USD2_NUM_CHANS ) == 1 )     
      trp->gen_control.timer_ref_b = nicbfp->next_stats_time;
    else
      PANIC();

    NIC_UTRACE("TXSinit",0,
	       nicbfp->next_stats_time, trp->gen_control.timer,0,0);

#else
    trp->gen_control.timer_ref_b = trp->gen_control.timer + TG_TICK_FAST;
#endif


#if 0
    {
    tgDmaDescr_t *dd_prod;

    dd_prod  = trp->host_dma_assist.read_chan_lo_pri_producer; 

    fill_in_dma_record(dd_prod,
		       tsp->gen_com.perf_test_ptr, // XXXX
		       NIC_TX_BUF,
		       8192,
		       TIGON_TYPE_NULL,
		       0x59,          // chan 
		       0x1,     // Mac RX Descr
		       TX2_DMA_TO_NIC_FRAG_STATE );
    
    trp->host_dma_assist.read_chan_lo_pri_producer = dd_prod+1;

    dd_prod  = trp->host_dma_assist.read_chan_lo_pri_producer; 

    fill_in_dma_record(dd_prod,
		       tsp->gen_com.perf_test_ptr, // XXXX
		       NIC_TX_BUF,
		       8192,
		       TIGON_TYPE_NULL,
		       0x59,          // chan 
		       0x2,     // Mac RX Descr
		       TX2_DMA_TO_NIC_FRAG_STATE );
    
    trp->host_dma_assist.read_chan_lo_pri_producer = dd_prod+1;


    }
#endif

    /* main dispatcher loop */
    __asm__ volatile
    ("
        .set noreorder
        .globl _disp_loop_b
    _disp_loop_b:
        lw      %0,0x70($28)     # load event register for CPU B !  $3
        pri     %1,%0,%2         # determine next event  $2, $3, $20
        joff    %1,%3            # jump to next event  $2, $18
        move    $31,%4
        .set reorder
        nop
        halt
        " : "=r" (events_b), "=r" (high_event_b)
          : "r" (event_mask_b), "r" (ev_handlerp_b), "r" (dispp_b)
    );
    /* not reached */

}
