/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: eth.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1.2.2  1998/09/30  18:49:54  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:39:46  shuang]
 *
 * Revision 1.1.2.1  1998/01/14  23:25:46  ted
 * 	rearrange directories
 * 	[1998/01/14  23:17:42  ted]
 * 
 * Revision 1.1.2.1  1997/11/19  19:23:07  ted
 * 	Support Tigon and Tigon2 in the same driver
 * 	[1997/11/19  19:19:08  ted]
 * 
 * Revision 1.1.2.1  1997/01/16  18:02:24  skapur
 * 	Adding new file to the NIC FW Base
 * 	[1996/12/02  17:59:49  skapur]
 * 
 * $EndLog$
 */
#ifndef _ETH_H
#define _ETH_H


#define ETH_ADDR_LEN	6	/* EtherNet Address Lenth in Bytes */

/* ETH Frame Format Structure */
typedef struct eth {
    U8  ethDestAddr[ETH_ADDR_LEN];
    U8  ethSrcAddr [ETH_ADDR_LEN];
    U16	ethFrameType;
    U8  eth_llc_dsap;
    U8  eth_llc_ssap;
    U8  eth_llc_cntl;
    U8  eth_snap_org[3];
    U16 eth_snap_type;
    U8  ethData[0];
} eth_t;

/* Misc. defines for ETH  Protocol */
#define	ETH_HLEN	14    /* ETH Header Length in bytes */
#define	ETH_LLC_HLEN	22    /* ETH + LLC + SNAP Header Length in bytes */
#define	ETH_MIN_LEN	64    /* ETH minimum Frame Length in bytes */
#define	ETH_MAX_LEN	1514  /* ETH maximum Frame Length in bytes */
#define	ETH_CRC_LEN	4     /* ETH CRC field Length in bytes */
#define ETH_IP		0x800 /* IP frame type */
#define ETH_ARP		0x806 /* ARP frame type */
#define ETH_RARP	0x8035/* RARP frame type */


/* return TRUE if following 6 bytes contain the 802.2 llc snap signature */
__inline__ static bool
is_llc_snap(U16 *bufp)
{
    return ((*bufp == 0xaaaa) && (*(bufp + 1) == 0x0300) && (*(bufp + 2) == 0));
}

#endif /* _ETH_H */
