/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * FILE command.c
 *
 * COPYRIGHT (c) Essential Communication Corp. 1995
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/command.c,v $
 * $Revision: 1.11 $ $Locker: iap10 $
 * $Date: 2000/01/27 18:07:40 $ $Author: kaf24 $ $State: Exp $
 */

#include "alt_def.h"
#include "nic_conf.h"
#include "nic_api.h"
#include "tg.h"

#include "nic.h"
#include "proto.h"
#include "trace.h"
#include "timer.h"
#include "dma.h"
#include "ring.h"
#include "link_if.h"    /* for tg_link_set */
#include "link_op.h"    /* for tg_link_set */
#include "assert.h"
#include "event.h"


/* mbox event */
#define MBOX_EVENT_PCI_INTR	 (1 << 0)
#define MBOX_EVENT_COMMAND	 (1 << 1)

/* globals */
U32 mh_command_stub;


/******************************************************************************
 * mh_command:
 *   Handler for mailboxes 0 and 1.
 */
void mh_command(void)
{
    U32 mbox_event, cmd_cons;
    struct tg_command cmd;

    mbox_event = trp->gen_control.mailbox_event;

    /*
     * Mailbox 0 is strobed by the host to clear the interrupt line. We
     * simply clear the event - clearing of IRQ is done in hardware.
     */
    trp->gen_control.mailbox_event = MBOX_EVENT_PCI_INTR;

    /*
     * Mailbox 1 is used to indicate new commands from the host.
     */
    if ( mbox_event & MBOX_EVENT_COMMAND ) 
    {
        /* dequeue a command from the host */
        trp->gen_control.mailbox_event = MBOX_EVENT_COMMAND;
        while ( (cmd_cons = tsp->gen_com.command_cons_index) !=
                tsp->mbox_command_prod_index )
        {
            /* There's an outstanding command. Process it... */
            cmd = tsp->gen_com.command_ring[cmd_cons];
            tsp->gen_com.command_cons_index = 
                (cmd_cons + 1) & (COMMAND_RING_ENTRIES - 1);
            do_mailbox_slow(cmd);

            /* Clear the mailbox event. */
            trp->gen_control.mailbox_event = MBOX_EVENT_COMMAND;
        } 
    }
}

/* null routine to assist with scratchpad setup */
void mh_command_end(void) {}


/******************************************************************************
 * get_cmd_args:
 */
static void get_cmd_args(U32 *args, int numargs)
{
    int i;
    U32 cmd_cons;

    for ( i = 0; i < numargs; i++ )
    {
	cmd_cons = tsp->gen_com.command_cons_index;
	args[i] = tsp->gen_com.command_ring[cmd_cons].TG_COMMAND_w0;
	tsp->gen_com.command_cons_index =
	    (cmd_cons + 1) & (COMMAND_RING_ENTRIES - 1);
    }
}


/******************************************************************************
 * do_mailbox_slow:
 *   The slow handler (not in scratchpad!). Called by mh_command when there
 *   are outstanding commands from the host.
 * 
 *   KAF: I've removed quite a few of the commands for things like m/c and
 *   promiscuous mode. We don't support these things at the moment...
 *   The removed code can be found at the bottom of this file.
 */
void do_mailbox_slow(struct tg_command cmd)
{
    struct tg_event event;
    U32 tm;

    /* NOTE: a jump table is generated from the following switch statement */
    switch (cmd.TG_COMMAND_cmd) {
    case TG_CMD_HOST_STATE:
        switch (cmd.TG_COMMAND_code) {
        case TG_CMD_CODE_STACK_UP:
            nicfp->host_state |= TG_HOST_STATE_STACK_UP;
            nicfp->stats.ifAdminStatus = IF_ADMIN_STATUS_UP;
            nicfp->stats.ifOperStatus = IF_OPER_STATUS_UP;
            set_event_handler(TG_FW_EVENT_NUM_MAC_RX_COMP, 
			      (U32)h_mac_rx2_comp_stub);

            /* Following is a approximation to get the number without div */
            tm = trp->gen_control.timer;
            nicfp->stats.ifLastChange = 
                (tm >> 17) + (tm >> 18) - (tm >> 19) + (tm >> 20) - (tm >>21);
            break;

        case TG_CMD_CODE_STACK_DOWN:
            nicfp->host_state &= ~TG_HOST_STATE_STACK_UP;
            nicfp->stats.ifAdminStatus = IF_ADMIN_STATUS_DOWN;
            nicfp->stats.ifOperStatus = IF_OPER_STATUS_DOWN;
            set_event_handler
		(TG_FW_EVENT_NUM_MAC_RX_COMP, (U32)h_mac_rx_comp_nohost);

            /* Following is a approximation to get the number without div */
            tm = trp->gen_control.timer;
            nicfp->stats.ifLastChange = 
                (tm >> 17) + (tm >> 18) - (tm >> 19) + (tm >> 20) - (tm >>21);
            break;

        default:
            NIC_UTRACE("?cmdHstS", 0x31000, cmd.TG_COMMAND_w0, 0, 0, 0);
	    break;
        }
        nicfp->stats.nicCmdsHostState++;
        break;

    case TG_CMD_SET_MAC_ADDR:
        trp->mac_control.mac_src_addr = tsp->gen_com.mac_addr; 
        nicfp->stats.ifPhysAddress = tsp->gen_com.mac_addr; 
        nicfp->stats.nicCmdsSetMACAddr++;
        break;

    /*
     *  USD code.  Commands to add and delete contexts from the card.
     *  These commands use ((code << 12) | index) as their arguments. 
     */
    case TG_CMD_USD_OPEN_CONNECTION:
    {
	U16 id;
        conn_ctxt_host_part_t hp;
	
        get_cmd_args((U32*)&hp, sizeof(hp)>>2);

	/* We are big endian, so this is the same as ((code << 12) | index) */
	id = (cmd.TG_COMMAND_w0) & 
            (TG_COMMAND_CODE_MASK | TG_COMMAND_INDEX_MASK);

        init_new_usd_context(id, &hp);
	break;
    }
    
    case TG_CMD_USD_CLOSE_CONNECTION:
    {
	U16 id;
	/* We are big endian, so this is the same as ((code << 12) | index) */
	id = (cmd.TG_COMMAND_w0) &
	    (TG_COMMAND_CODE_MASK | TG_COMMAND_INDEX_MASK);

	/* The delete routine does our error checking for us */
	delete_usd_context(id); 
	
	break;
    }

    case TG_CMD_USD_INSTALL_FILTER:
      {
	U16 id;
	
	/* We are big endian, so this is the same as ((code << 12) | index) */
	id = (cmd.TG_COMMAND_w0) & 
            (TG_COMMAND_CODE_MASK | TG_COMMAND_INDEX_MASK);
       	
	// XXX need to copy this into SRAM then to SCRATCH

	NIC_UTRACE("nRXFltr", 0x2900,
		   TSP->gen_com.new_rx_filter & 0xffffffffL,
		   TSP->gen_com.new_rx_filter_len,
		   id,nicp->new_filter_install_id);

	if( nicp->new_filter_install_id >= 0 )
        {
	    /* The driver has clearly gone utterly mad on us. */
	    event.TG_EVENT_w0 = 
		(TG_EVENT_ERROR << TG_EVENT_EVENT_SHIFT) |
		(TG_EVENT_CODE_ERR_INVALID_FILTER << TG_EVENT_CODE_SHIFT);
	    must_enq_event(&event);
	    break;
        }

	nicp->new_filter_install_id = id;

	if( TSP->gen_com.new_rx_filter_len > scratch_pad_size )
	  {
	    // won't fit in scratch pad. Die for now.

	    NIC_UTRACE("FltrNoFt", 0x2900,
		       TSP->gen_com.new_rx_filter & 0xffffffffL,
		       TSP->gen_com.new_rx_filter_len,
		       scratch_pad_size,
		       scratch_pad_loc );

	    PANIC();
	  }

	if( TSP->gen_com.new_rx_filter_len > FILTER_BUF_SIZE )
	  {
	    // should deal with this by having multiple DMAs....

	    PANIC();
	  }

	NIC_UTRACE("nRXFltr2", 0x2901,
		   TSP->gen_com.new_rx_filter,
		   (U32)filter_buf,
		   TSP->gen_com.new_rx_filter_len, 0 );


	if ( ! (*nicfp->q_dma_to_nic_stub)
	     (TSP->gen_com.new_rx_filter,
	      (U32)filter_buf,
	      TSP->gen_com.new_rx_filter_len,
	      TIGON_TYPE_USD_INSTALL_FILTER,
	      id,
	      0, /* zero for first frsg of filter */
	      nicfp->dma_to_nic_bd_state) )
	  {
	    /* Bugger. DMA engine must be full or something.
	       We should tell the host or retry.
	       For now, we die. */

	    PANIC();
	  }


	/* 
	 * Success! The DMA completion handler will invoke
	 * the next stage.  Our work here is done.
	 */

	break;
      }
#if 0
    case TG_CMD_USD_SET_TX_BW:
      {
	U16 id;

	/* We are big endian, so this is the same as ((code << 12) | index) */
	id = (cmd.TG_COMMAND_w0) & 
            (TG_COMMAND_CODE_MASK | TG_COMMAND_INDEX_MASK);

	send_event_to_B_with_args(EVB_SET_TX_BW | id);

	// CPU B will send a FINAL event to CPU A which will ACK host
      }
#endif
    default:
        NIC_UTRACE("?cmdErr", 0x31500, cmd.TG_COMMAND_w0, 0, 0, 0);

        event.TG_EVENT_w0 =
	    (TG_EVENT_ERROR << TG_EVENT_EVENT_SHIFT) |
            (TG_EVENT_CODE_ERR_INVALID_CMD << TG_EVENT_CODE_SHIFT) |
            (cmd.TG_COMMAND_cmd);
        enq_event(&event);
        nicfp->stats.nicCmdsUnknown++;
        nicfp->stats.nicEventsError++;
	break;
    }
}

/**********************************************************************/

#define CRC32_POLYNOMIAL        0xEDB88320
 
/* datalen is number of bytes */
U32
gen_crc (U8 *databuf, U32 datalen)
{
    register U32 idx, bit, data, crc = 0xFFFFFFFF;

    for (idx = 0; idx < datalen; idx++) {
        data = *databuf++;
        for (bit = 0; bit < 8; bit++, data >>= 1) {
            crc = (crc >> 1) ^ (((crc ^ data) & 1)? CRC32_POLYNOMIAL: 0);
        }
    }
    return (crc);
}



/******************************************************************************
 * XXXXXX KAF: the removed commands...
 */

#if 0
    case TG_CMD_ADD_MULTICAST_ADDR:
	mc_addr = tsp->gen_com.mcast_xfer_buf; /* struct copy */
        add_mcast(&mc_addr);
        break;

    case TG_CMD_EXT_ADD_MULTICAST_ADDR:
	/* get mcast address from command slots */
	cmd_cons = tsp->gen_com.command_cons_index;
	*(U32 *)&mc_addr = tsp->gen_com.command_ring[cmd_cons].TG_COMMAND_w0;
	cmd_cons = (cmd_cons + 1) & (COMMAND_RING_ENTRIES - 1);
	*(U32 *)&mc_addr.octet[2] =
	    tsp->gen_com.command_ring[cmd_cons].TG_COMMAND_w0;
	tsp->gen_com.command_cons_index =
	    (cmd_cons + 1) & (COMMAND_RING_ENTRIES - 1);
        add_mcast(&mc_addr);
        break;

    case TG_CMD_DEL_MULTICAST_ADDR:
	mc_addr = tsp->gen_com.mcast_xfer_buf; /* struct copy */
        del_mcast(&mc_addr);
	break;
 
    case TG_CMD_EXT_DEL_MULTICAST_ADDR:
	/* get mcast address from command slots */
	cmd_cons = tsp->gen_com.command_cons_index;
	*(U32 *)&mc_addr = tsp->gen_com.command_ring[cmd_cons].TG_COMMAND_w0;
	cmd_cons = (cmd_cons + 1) & (COMMAND_RING_ENTRIES - 1);
	*(U32 *)&mc_addr.octet[2] =
	    tsp->gen_com.command_ring[cmd_cons].TG_COMMAND_w0;
	tsp->gen_com.command_cons_index =
	    (cmd_cons + 1) & (COMMAND_RING_ENTRIES - 1);
        del_mcast(&mc_addr);
        break;

    case TG_CMD_SET_MULTICAST_MODE:
        switch (cmd.TG_COMMAND_code) {
        case TG_CMD_CODE_MULTICAST_ENABLE:
            /* save away the bit state of the hardware multicast mask */
            if (!is_global_flags(GF_CMD_MCAST_MODE)) {
                nicp->mc_filter_saved[0] = trp->mac_control.mac_rx_mcast_filt1;
                nicp->mc_filter_saved[1] = trp->mac_control.mac_rx_mcast_filt2;
                nicp->mc_filter_saved[2] = trp->mac_control.mac_rx_mcast_filt3;
                nicp->mc_filter_saved[3] = trp->mac_control.mac_rx_mcast_filt4;
                trp->mac_control.mac_rx_mcast_filt1 = 0xffffffff;
                trp->mac_control.mac_rx_mcast_filt2 = 0xffffffff;
                trp->mac_control.mac_rx_mcast_filt3 = 0xffffffff;
                trp->mac_control.mac_rx_mcast_filt4 = 0xffffffff;
            }
	    set_global_flags(GF_CMD_MCAST_MODE);
            break;
 
        case TG_CMD_CODE_MULTICAST_DISABLE:
            /* restore the bit state of the hardware multicast mask */
            if (is_global_flags(GF_CMD_MCAST_MODE)) {
                trp->mac_control.mac_rx_mcast_filt1 = nicp->mc_filter_saved[0];
                trp->mac_control.mac_rx_mcast_filt2 = nicp->mc_filter_saved[1];
                trp->mac_control.mac_rx_mcast_filt3 = nicp->mc_filter_saved[2];
                trp->mac_control.mac_rx_mcast_filt4 = nicp->mc_filter_saved[3];
            }
	    clear_global_flags(GF_CMD_MCAST_MODE);
            break;

        default:
            NIC_UTRACE("?cmdMcMd", 0x31100,
		cmd.TG_COMMAND_w0,
		0,
		0,
		0);
	    break;
        }
        nicfp->stats.nicCmdsSetMulticastMode++;
        break;

    case TG_CMD_SET_PROMISC_MODE:
        switch (cmd.TG_COMMAND_code) {
        case TG_CMD_CODE_PROMISC_ENABLE:
            trp->mac_control.mac_rx_state =
                (trp->mac_control.mac_rx_state & ~TG_MAC_RX_ATTN_MASK) |
                TG_MAC_RX_STATE_ENA_PROMISC;
            nicfp->stats.ifPromiscuousMode = 1; /* True(1) */
	    set_global_flags(GF_CMD_PROMISC_MODE);
            break;

        case TG_CMD_CODE_PROMISC_DISABLE:
            trp->mac_control.mac_rx_state &=
		~(TG_MAC_RX_ATTN_MASK | TG_MAC_RX_STATE_ENA_PROMISC);
            nicfp->stats.ifPromiscuousMode = 2; /* False(2) */
	    clear_global_flags(GF_CMD_PROMISC_MODE);
            break;

        default:
            NIC_UTRACE("?cmdProm", 0x31200,
		cmd.TG_COMMAND_w0,
		0,
		0,
		0);
	    break;
        }
        nicfp->stats.nicCmdsSetPromiscMode++;
        break;


    case TG_CMD_LINK_NEGOTIATION:
        switch (cmd.TG_COMMAND_code) {
        case TG_CMD_CODE_NEGOTIATE_BOTH:
	    set_mac_link(TIGON_MAC_INDEX, ATTACHED_PHY_IF_SERDES_EXT,
			 tsp->gen_com.tuneParms.link_negotiation);
	    set_mac_link(TIGON_MAC_INDEX, ATTACHED_PHY_IF_MII,
			 tsp->gen_com.tuneParms.fast_link_negotiation);
            break;

        case TG_CMD_CODE_NEGOTIATE_GIGABIT:
	    set_mac_link(TIGON_MAC_INDEX, ATTACHED_PHY_IF_SERDES_EXT,
			 tsp->gen_com.tuneParms.link_negotiation);
            break;

	case TG_CMD_CODE_NEGOTIATE_10_100:
	    set_mac_link(TIGON_MAC_INDEX, ATTACHED_PHY_IF_MII,
			 tsp->gen_com.tuneParms.fast_link_negotiation);
	    break;

        default:
            NIC_UTRACE("?cmdLink", 0x31300,
		cmd.TG_COMMAND_w0,
		0,
		0,
		0);
	    break;
        }
        nicfp->stats.nicCmdsLinkNegotiate++;
        break;

    case TG_CMD_CLEAR_STATS:
        PANIC(); // IAP
        break;

    case TG_CMD_REFRESH_STATS:
        PANIC(); // KAF
        break;

    case TG_CMD_UPDATE_GENCOM_STATS:
        /* Reset the basic default values for Stats */
        nicfp->stats.ifIndex = tsp->gen_com.ifIndex;
        nicfp->stats.ifMtu = MTU; /* was: tsp->gen_com.ifMTU; */
        nicfp->stats.ifPhysAddress = tsp->gen_com.mac_addr;

        /* Reset the value of Promiscuous mode */
        if (trp->mac_control.mac_rx_state & TG_MAC_RX_STATE_ENA_PROMISC)
            nicfp->stats.ifPromiscuousMode = 1; /* True(1) */
        else
            nicfp->stats.ifPromiscuousMode = 2; /* False(2) */
        nicfp->stats.nicCmdsUpdateGencommStats++;
        break;

    case TG_CMD_SET_PARTIAL_RECV_COUNT:
        PANIC(); // KAF
        break;
#endif
