/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996, 1997 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: cksum.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1  1999/06/07 10:48:14  tjd21
 * Start of archive
 *
 * Revision 1.1.2.5  1998/09/30  18:49:44  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:39:24  shuang]
 *
 * Revision 1.1.2.4  1998/06/23  01:29:29  shuang
 * 	added dynamic nic mem support.
 * 	[1998/06/23  01:21:22  shuang]
 * 
 * Revision 1.1.2.3  1998/04/25  03:07:43  shuang
 * 	add IP_FRAG_SUPPORT debug flag, add crc_cksum function
 * 	[1998/04/25  03:06:29  shuang]
 * 
 * Revision 1.1.2.2  1998/04/16  03:31:28  shuang
 * 	fix ip header cksum offload on buffer wrap.
 * 	[1998/04/16  03:30:26  shuang]
 * 
 * Revision 1.1.2.1  1998/03/26  01:34:20  shuang
 * 	cleanup
 * 	[1998/03/26  01:24:46  shuang]
 * 
 * $EndLog$
 */
/*
 * FILE cksum.h
 *
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/cksum.h,v $
 * $Revision: 1.4 $ $Locker:  $
 * $Date: 1999/06/22 12:43:01 $ $Author: tjd21 $ $State: Exp $
 */

#ifndef _CKSUM_H_
#define _CKSUM_H_

#include "eth.h"
#include "ip.h"
#include "tcp.h"
#include "udp.h"

/* for cksum debug */
#define IP_SANITY	0	/* check len == ip packet len */

/* for cksum calculation */
#define IP_HLEN_MASK		(0xf)
#define IP_FRAG_OFS_MASK	(0x1fff)

/*
 * sum up 16-bit of contiguous memory
 */
__inline__ static U32
sum16(U16 *buf, U32 nwords)
{
    U32 sum = 0;
    U16 *eob = buf + nwords;

    while (buf < eob)
	sum += *buf++;
    return (sum);
}

#endif /* _CKSUM_H_ */
