/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: assert.h,v $
 * Revision 1.6  1999/12/01 10:55:01  iap10
 * *** empty log message ***
 *
 * Revision 1.5  1999/10/13 14:30:34  iap10
 * *** empty log message ***
 *
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:52:05  tjd21
 * Start of archive
 *
 * Revision 1.1  1999/06/07 10:48:14  tjd21
 * Start of archive
 *
 * Revision 1.1.2.3  1998/09/30  18:49:42  shuang
 * 	change for new 12.3 API
 * 	[1998/09/30  18:39:16  shuang]
 *
 * Revision 1.1.2.2  1998/04/11  05:14:59  shuang
 * 	move fast timer to cpu B, add receive coalesed ticks
 * 	[1998/04/11  04:57:36  shuang]
 * 
 * Revision 1.1.2.1  1998/01/14  23:25:28  ted
 * 	rearrange directories
 * 	[1998/01/14  23:17:24  ted]
 * 
 * Revision 1.1.2.1  1997/11/19  19:22:56  ted
 * 	Support Tigon and Tigon2 in the same driver
 * 	[1997/11/19  19:18:10  ted]
 * 
 * Revision 1.8.4.5  1997/10/28  01:51:15  hayes
 * 	turn on MAC RX STOP NEXT on ASSERT()
 * 	[1997/10/27  23:18:58  hayes]
 * 
 * Revision 1.8.4.4  1997/05/21  03:35:35  ted
 * 	Remote assert support
 * 	[1997/05/21  03:01:28  ted]
 * 
 * Revision 1.8.4.3  1997/03/28  02:46:53  skapur
 * 	Turned off REMOTE_ASSERT
 * 	[1997/03/28  01:52:23  skapur]
 * 
 * Revision 1.8.4.2  1997/03/24  08:34:15  ted
 * 	New event ring handling, producer lives in host memory, misc. other more modest changes
 * 	[1997/03/24  08:27:34  ted]
 * 
 * Revision 1.8.4.1  1997/03/17  08:47:37  skapur
 * 	added remote assert()
 * 	[1997/03/17  08:27:29  skapur]
 * 
 * Revision 1.8.2.3  1996/11/15  04:23:59  hayes
 * 	convert to new header file structure.
 * 	[1996/11/15  04:12:11  hayes]
 * 
 * Revision 1.8.2.2  1996/11/05  21:54:12  hayes
 * 	Final pre-ODE merge
 * 	[1996/11/05  21:51:10  hayes]
 * 
 * Revision 1.8.2.1  1996/11/01  18:24:44  ted
 * 	change rr_ to tg_, fix compiler warnings, add copyright notices
 * 	[1996/10/29  22:05:37  ted]
 * 
 * $EndLog$
 */
/*
 * FILE assert.h
 *
 * $Source: /Nfs/stives/grp56/gige/src-current/acenic-fw-12.3.10/nic/fw2/common/RCS/assert.h,v $
 * $Revision: 1.6 $ $Locker:  $
 * $Date: 1999/12/01 10:55:01 $ $Author: iap10 $ $State: Exp $
 */

#ifndef _ASSERT_H_
#define _ASSERT_H_

/*
 * assert processing for the nic cards...
 */
#define REMOTE_ASSERT 0

#if (REMOTE_ASSERT)

#if !defined(CONFIG_BASE_REMOTE_ASSERT)
#define CONFIG_BASE_REMOTE_ASSERT (0x1402)
#endif /* CONFIG_BASE_REMOTE_ASSERT */

#define PANIC() { \
	    /* generate trace entry */ \
	    NIC_UUTRACE("**" __FILE__, 0xdead, \
		trp->cpu_control.pc , __FILE__, __LINE__, 0); \
	    /* disable MACs */ \
	    trp->mac_control.mac_tx_config = CONFIG_BASE_REMOTE_ASSERT; \
	    /* turn on config mode */ \
	    trp->mac_control.mac_tx_state &= ~TG_MAC_TX_STATE_ENABLE; \
	    /* stop dma assist */ \
	    trp->host_dma_assist.assist_state |= TG_DMA_ASSIST_PAUSE; \
	    /* and halt processor */ \
	    if (nicfp->cpu_id) \
	      { \
		trp->cpu_control.cpu_state |= TG_CPU_HALT; \
		trp->cpu_control_b.cpu_state |= TG_CPU_HALT; \
	      } \
	    else \
	      { \
		trp->cpu_control_b.cpu_state |= TG_CPU_HALT; \
		trp->cpu_control.cpu_state |= TG_CPU_HALT; \
	      } \
	}
#else /* REMOTE_ASSERT */
#define PANIC() { \
	    /* generate trace entry */ \
	    NIC_UUTRACE("**" __FILE__, 0xdead, \
		trp->cpu_control.pc , __FILE__, __LINE__, 0); \
	    /* stop dma assist */ \
	    trp->host_dma_assist.assist_state |= TG_DMA_ASSIST_PAUSE; \
	    /* stop rx */ \
	    trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_STOP_NEXT; \
	    /* and halt processor */ \
	    if (nicfp->cpu_id) \
	      { \
		trp->cpu_control.cpu_state |= TG_CPU_HALT; \
		trp->cpu_control_b.cpu_state |= TG_CPU_HALT; \
	      } \
	    else \
	      { \
		trp->cpu_control_b.cpu_state |= TG_CPU_HALT; \
		trp->cpu_control.cpu_state |= TG_CPU_HALT; \
	      } \
	}
#endif /* REMOTE_ASSERT */

#define VERIFY(x)	{if (!(x)) PANIC();}

#if !defined(NDEBUG)
#define ASSERT(x)	VERIFY(x)
#else  /* !defined(NDEBUG) */
#define ASSERT(x)	/**/
#endif /* !defined(NDEBUG) */

#endif /* _ASSERT_H_ */
