/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996 
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: zconf.c,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.36  1999/01/27  19:09:43  hayes
 * 	incorporate autosense code
 * 	[1999/01/27  19:07:58  hayes]
 *
 * Revision 1.1.30.3  1999/01/06  02:07:14  hayes
 * 	checkin for merge
 * 
 * Revision 1.1.30.2  1998/11/07  21:00:00  hayes
 * 	link autosense mode now works
 * 
 * Revision 1.1.2.35  1998/09/16  23:21:50  hayes
 * 	intermedioate checkin
 * 	[1998/09/14  17:08:55  hayes]
 * 
 * Revision 1.1.2.34  1998/09/11  20:12:43  fhwang
 * 	fall through to case STATE_LINK_CONF_COMPLETE_ACK_INI from step 7.
 * 	[1998/09/11  20:11:43  fhwang]
 * 
 * Revision 1.1.2.33  1998/06/17  03:50:05  fhwang
 * 	Saved the configuration page data.
 * 	[1998/06/17  03:48:43  fhwang]
 * 
 * Revision 1.1.2.32  1998/03/18  03:44:01  hayes
 * 	restructure mac mgt interface
 * 	[1998/03/18  03:38:02  hayes]
 * 
 * Revision 1.1.2.31  1998/02/23  01:22:40  hayes
 * 	relax timings for negotiation failure detection
 * 	[1998/02/23  01:20:41  hayes]
 * 
 * Revision 1.1.2.30  1998/02/06  22:19:46  hayes
 * 	remove link check for 180 workaround
 * 	[1998/02/06  22:19:23  hayes]
 * 
 * Revision 1.1.2.29  1998/01/30  06:45:20  hayes
 * 	cleanup
 * 	[1998/01/30  06:39:17  hayes]
 * 
 * Revision 1.1.2.28  1998/01/23  22:37:09  hayes
 * 	fix link bringup wirh Extreme power cyling
 * 	[1998/01/23  22:34:56  hayes]
 * 
 * Revision 1.1.2.27  1998/01/23  01:53:19  hayes
 * 	fix sloppy programming
 * 	[1998/01/23  01:29:50  hayes]
 * 
 * Revision 1.1.2.26  1998/01/22  22:51:14  hayes
 * 	fix different phy fctl bug
 * 	[1998/01/22  22:47:25  hayes]
 * 
 * Revision 1.1.2.25  1998/01/21  23:25:55  hayes
 * 	cleanup last checkin...
 * 	[1998/01/21  23:25:42  hayes]
 * 
 * Revision 1.1.2.24  1998/01/21  23:11:37  hayes
 * 	#ifdeff out unused next page code and data structures
 * 	[1998/01/21  23:09:50  hayes]
 * 
 * Revision 1.1.2.23  1998/01/14  00:25:18  hayes
 * 	always do a link_down_notify() on an unsolicited config
 * 	[1998/01/14  00:25:04  hayes]
 * 
 * Revision 1.1.2.22  1998/01/13  23:04:54  hayes
 * 	improve base config word error checking
 * 	[1998/01/13  23:04:37  hayes]
 * 
 * Revision 1.1.2.21  1998/01/09  18:26:07  hayes
 * 	don't initiate sending next page
 * 	[1998/01/09  18:24:19  hayes]
 * 
 * Revision 1.1.2.20  1998/01/04  23:48:11  hayes
 * 	clean, speed improvments and state machine error protection
 * 	[1998/01/04  23:42:37  hayes]
 * 
 * 	fix subtle link negotiation issues, code cleanup
 * 	[1998/01/04  02:29:31  hayes]
 * 
 * Revision 1.1.2.19  1997/12/28  01:09:14  hayes
 * 	improve gig link bringup speed
 * 	[1997/12/28  01:08:57  hayes]
 * 
 * Revision 1.1.2.18  1997/12/15  19:59:36  hayes
 * 	cleanup extended link negotiation
 * 	[1997/12/15  19:59:24  hayes]
 * 
 * Revision 1.1.2.17  1997/12/12  05:34:32  hayes
 * 	fix REV5 false garbage indicator
 * 	[1997/12/12  05:18:40  hayes]
 * 
 * 	remove unecessry attached phy gig bits once the proper phy has been determined
 * 	[1997/12/12  04:05:11  hayes]
 * 
 * Revision 1.1.2.16  1997/12/09  23:56:43  hayes
 * 	cleanup link negotiation
 * 	[1997/12/09  23:55:43  hayes]
 * 
 * Revision 1.1.2.15  1997/12/01  00:03:58  hayes
 * 	link negotiation works on rev4, int serdes, ext serdes
 * 	[1997/11/30  23:59:45  hayes]
 * 
 * Revision 1.1.2.14  1997/11/24  01:00:21  taylor
 * 	Rev5: move data structures into scratchpad
 * 	[1997/11/23  21:42:59  taylor]
 * 
 * Revision 1.1.2.13  1997/11/21  23:54:18  hayes
 * 	MII link down works
 * 	[1997/11/21  23:53:57  hayes]
 * 
 * 	MII interface works
 * 	[1997/11/21  22:45:31  hayes]
 * 
 * Revision 1.1.2.12  1997/11/21  04:48:12  hayes
 * 	release for NIC 2.1 pre-Beta
 * 	[1997/11/21  03:19:15  hayes]
 * 
 * Revision 1.1.2.11  1997/11/10  23:54:39  hayes
 * 	checkin before perf inprovment effort
 * 	[1997/11/10  23:53:36  hayes]
 * 
 * Revision 1.1.2.10  1997/11/03  22:38:29  hayes
 * 	 fix link bringup
 * 	[1997/11/03  22:37:31  hayes]
 * 
 * Revision 1.1.2.9  1997/10/30  02:21:15  hayes
 * 	get link negotiation working for Tigon2
 * 	[1997/10/30  02:18:12  hayes]
 * 
 * Revision 1.1.4.2  1997/10/19  19:55:44  hayes
 * 	fix next page negotiation and recognition
 * 	[1997/10/19  19:54:38  hayes]
 * 
 * 	intermediate checkin
 * 	[1997/10/18  22:29:24  hayes]
 * 
 * Revision 1.1.2.8  1997/10/17  00:05:20  hayes
 * 	update for rev5
 * 	[1997/10/17  00:02:48  hayes]
 * 
 * Revision 1.1.2.7  1997/10/16  23:42:39  hayes
 * 	detect new config chars for REV5 Tigon
 * 	[1997/10/16  23:41:02  hayes]
 * 
 * Revision 1.1.2.6  1997/10/11  19:02:51  hayes
 * 	updated rerorting of ALTEON, NIC and JUMBO LNK_XXX bits
 * 	[1997/10/11  19:02:28  hayes]
 * 
 * Revision 1.1.2.5  1997/10/10  20:38:21  hayes
 * 	new next page code
 * 	[1997/10/10  20:35:57  hayes]
 * 
 * 	cleaned up tracing
 * 	updated link negotiation to 3.2 compliant state machine
 * 	[1997/10/09  21:58:42  hayes]
 * 
 * Revision 1.1.2.4  1997/09/30  21:03:30  hayes
 * 	Change next page initiation so that we only initiate next page
 * 	exchanges and advertise next pages when the LNK_NEG_ADVANCED bit
 * 	is set in the tg_link_set register.
 * 	[1997/09/30  20:45:03  hayes]
 * 
 * Revision 1.1.2.3  1997/09/17  03:26:33  hayes
 * 	Fixed bug in do_next_page() where random garbage can cause us to
 * 	follow a null pointer.
 * 	Change failure criteria to active_phy_fail = TRUE.
 * 	Check for IDLE_MATCH when in ABILITY_DETECT
 * 	[1997/09/15  22:26:47  hayes]
 * 
 * 	completed link code restructuring
 * 	[1997/08/29  22:11:07  hayes]
 * 
 * Revision 1.1.2.2  1997/08/29  22:11:59  hayes
 * 	completed link code restructuring
 * 
 * Revision 1.1.2.1  1997/08/26  21:09:02  hayes
 * 	initial checkin
 * 	[1997/08/26  21:01:35  hayes]
 * 
 * Revision 1.1.2.22  1997/08/18  21:15:11  hayes
 * 	re-enable RX attns after LINK_OK
 * 	[1997/08/18  21:12:41  hayes]
 * 
 * Revision 1.1.2.21  1997/08/17  00:09:35  hayes
 * 	Fix incompatibility with previously released link code by adding
 * 	new idle_match variable.  We can now detect when our link partner
 * 	goes to IDLE_DETECT when we go into NEXT_PAGE_MATCH, and force a
 * 	renegotiation.  Also cleaned up some tracing and reset the GOT_ACK2
 * 	flags during initialization of data structures when restarting
 * 	negotiation.
 * 	[1997/08/17  00:09:24  hayes]
 * 
 * Revision 1.1.2.20  1997/08/12  03:31:18  hayes
 * 	detect ACK2 perperly for next pages
 * 	[1997/08/12  03:29:33  hayes]
 * 
 * Revision 1.1.2.19  1997/08/12  02:53:45  hayes
 * 	move next page data defns to np.c, add frame size NP
 * 	[1997/08/12  02:50:58  hayes]
 * 
 * Revision 1.1.2.18  1997/08/08  21:20:04  hayes
 * 	update comments on priority resolution of pause bits
 * 	[1997/08/08  21:17:31  hayes]
 * 
 * Revision 1.1.2.17  1997/08/07  18:31:59  hayes
 * 	Rewrite flow control priority resolution.
 * 	[1997/08/07  18:28:59  hayes]
 * 
 * Revision 1.1.2.16  1997/08/02  19:58:29  hayes
 * 	Adjust runt length in FIX_DISPARITY to 18 bytes.
 * 	Use additional_rx_bits_wanted to set differences between various uses of
 * 	link.c
 * 	[1997/08/02  19:57:52  hayes]
 * 
 * Revision 1.1.2.15  1997/07/22  23:35:55  hayes
 * 	Merged with changes from 1.1.2.14
 * 	[1997/07/22  23:35:34  hayes]
 * 
 * 	bring ge_latest up to same revision level as r1 branch
 * 	[1997/07/22  23:28:10  hayes]
 * 
 * 	update ge_latest to r1 levels...
 * 	[1997/07/16  22:33:35  hayes]
 * 
 * Revision 1.1.5.5  1997/07/22  22:40:58  hayes
 * 	Checkin after initial testing with Extreme switch for link negotiation.
 * 	We now also handle REMOTE fault properly.
 * 	[1997/07/22  22:35:08  hayes]
 * 
 * 	fixed missed rx_config (I guess this is a hardware bug).
 * 	Added tracing for unformatted next pages.
 * 	Added interpretation of remote fault bits in base page
 * 	[1997/07/21  02:08:43  hayes]
 * 
 * 	another intermediate checkin for testing
 * 	[1997/07/20  00:26:21  hayes]
 * 
 * 	intermediate checkin
 * 	[1997/07/19  19:51:53  hayes]
 * 
 * Revision 1.1.5.4  1997/07/16  19:33:50  hayes
 * 	fix config bit positions
 * 	[1997/07/16  19:33:35  hayes]
 * 
 * Revision 1.1.5.3  1997/07/11  00:43:29  hayes
 * 	Fixed sending ACK2 for UP when we did not send ACK2 for related MP.
 * 	Turned off sending all NP, unless the remote end send them.  In that
 * 	case we only rerspond with NULL_NP.
 * 	[1997/07/11  00:43:12  hayes]
 * 
 * Revision 1.1.5.2  1997/07/09  23:52:35  hayes
 * 	Fixed timing problem when running with different timers on each
 * 	end.  Also general cleanup and robustness.  I think this now
 * 	accurately reflects the D3.0 draft state machine.  It still needs
 * 	to be tested against other vendor's implementations.
 * 	[1997/07/09  23:51:37  hayes]
 * 
 * Revision 1.1.5.1  1997/07/09  17:53:58  hayes
 * 	bring r1 link code up to latest rev
 * 	[1997/07/09  17:53:47  hayes]
 * 
 * Revision 1.1.2.10  1997/07/08  23:02:32  hayes
 * 	more cleanup
 * 	[1997/07/08  23:02:14  hayes]
 * 
 * Revision 1.1.2.9  1997/07/08  00:07:20  hayes
 * 	Added set_base_page() to properly set the NP bit in the base page and
 * 	to initialize tx_npp.
 * 	[1997/07/08  00:07:06  hayes]
 * 
 * Revision 1.1.2.8  1997/07/07  22:50:41  hayes
 * 	minor tweaks
 * 	[1997/07/07  22:50:05  hayes]
 * 
 * Revision 1.1.2.7  1997/07/07  20:54:06  hayes
 * 	fixed minor link sequencing issue
 * 	[1997/07/07  20:53:56  hayes]
 * 
 * Revision 1.1.2.6  1997/07/06  19:03:48  hayes
 * 	Remove old, ifdeff'd out code.
 * 	Generify a few external variables so that this code can be used by
 * 	both the NIC and switch code.
 * 	[1997/07/06  19:03:35  hayes]
 * 
 * Revision 1.1.2.5  1997/07/05  00:12:32  hayes
 * 	next page functionality works
 * 	[1997/07/05  00:03:38  hayes]
 * 
 * 	Moved base page arbitration and priority resolution to do_base_page()
 * 	and added do_next_page().  Cleaned up consistency_match code.
 * 	Need to still do better testing to NP functionality.
 * 	[1997/07/03  00:11:14  hayes]
 * 
 * Revision 1.1.2.4  1997/07/01  01:02:12  davis
 * 	removed SP specific stuff.
 * 	[1997/07/01  01:01:59  davis]
 * 
 * Revision 1.1.2.3  1997/06/30  17:22:23  hayes
 * 	insure that we don't reuse old configs
 * 	[1997/06/30  17:22:06  hayes]
 * 
 * Revision 1.1.2.2  1997/06/30  00:34:53  hayes
 * 	Change to use acknowledge_match and ability_match functions as described
 * 	in 37.3.1.2.
 * 	[1997/06/30  00:34:00  hayes]
 * 
 * 	Priority resolution for 37.2.5.2 now works.
 * 	[1997/06/29  23:56:11  hayes]
 * 
 * Revision 1.1.2.1  1997/06/29  21:11:21  hayes
 * 	More restructuring, more common code.  LC still needs to finish
 * 	testing NEXT PAGE support, and test against non-Alteon implementations.
 * 	[1997/06/29  21:11:04  hayes]
 * 
 * 	initial checkin
 * 	[1997/06/26  21:49:05  hayes]
 * 
 * Revision 1.1.2.14  1997/07/18  04:08:48  tibor
 * 	standard cell changes
 * 	[1997/07/18  04:08:30  tibor]
 * 
 * Revision 1.1.2.13  1997/07/11  00:51:32  ted
 * 	more cleanup
 * 	[1997/07/08  23:02:14  hayes]
 * 
 * 	Added set_base_page() to properly set the NP bit in the base page and
 * 	to initialize tx_npp.
 * 	[1997/07/08  00:07:06  hayes]
 * 
 * 	minor tweaks
 * 	[1997/07/07  22:50:05  hayes]
 * 
 * 	fixed minor link sequencing issue
 * 	[1997/07/07  20:53:56  hayes]
 * 
 * 	Remove old, ifdeff'd out code.
 * 	Generify a few external variables so that this code can be used by
 * 	both the NIC and switch code.
 * 	[1997/07/06  19:03:35  hayes]
 * 
 * 	next page functionality works
 * 	[1997/07/05  00:03:38  hayes]
 * 
 * 	Moved base page arbitration and priority resolution to do_base_page()
 * 	and added do_next_page().  Cleaned up consistency_match code.
 * 	Need to still do better testing to NP functionality.
 * 	[1997/07/03  00:11:14  hayes]
 * 
 * 	removed SP specific stuff.
 * 	[1997/07/01  01:01:59  davis]
 * 
 * 	insure that we don't reuse old configs
 * 	[1997/06/30  17:22:06  hayes]
 * 
 * 	Change to use acknowledge_match and ability_match functions as described
 * 	in 37.3.1.2.
 * 	[1997/06/30  00:34:00  hayes]
 * 
 * 	Priority resolution for 37.2.5.2 now works.
 * 	[1997/06/29  23:56:11  hayes]
 * 
 * 	More restructuring, more common code.  LC still needs to finish
 * 	testing NEXT PAGE support, and test against non-Alteon implementations.
 * 	[1997/06/29  21:11:04  hayes]
 * 
 * 	initial checkin
 * 	[1997/06/26  21:49:05  hayes]
 * 
 * $EndLog$
 */

#include "alt_const.h"
#include "link.h"
#include "link_op.h"
#include "zconf.h"
#include "np.h"

#include "link_if.h"

#include "assert.h"
#include "trace.h"
#include "timer.h"
#include "mac.h"

#if defined(_SP_CONF_H_)
#include "sp_regs.h"
#endif /* defined(_SP_CONF_H_) */

/*****************************************************************************/


void set_base_page(U32 gig_options);
void do_base_page(U32 rx_Config_reg);

#ifdef DO_NEXT_PAGE
void do_next_page(U32 rx_Config_reg);
void next_page_results(void);
#endif /* DO_NEXT_PAGE */

U32 gig_negotiate;
U32 gig_negotiate_options; /* set in set_mac_link() */
U32 gig_negotiate_fctl;

zconf_state_t zs;

#define ABILITY_COUNT_LIMIT	20000

/* information about our link partner */
U32 link_partner_alteon = 0;
U32 link_partner_jumbo = 0;
U32 link_partner_nic = 0;
U32 link_sense_count = 0;
U32 link_sense_countdown = 2;
U32 link_sense_mode = 0;

#if (TIGON_REV & TIGON_REV4)
#define CHECK_SYNC(__trace_id) \
    if (rx_state & TG_MAC_RX_STATE_NOT_SYNCED_ATTN) { \
	LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_fail", (__trace_id), \
	    rx_state, trp->mac_control.mac_rx_state, 0, 0); \
	active_phy_fail = 1; \
	/* clear attns */ \
	trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK; \
	return; /* early return */ \
    }
#else /* (TIGON_REV & TIGON_REV4) */
/*
 * XXX this is broken, pending the outcome of Claude's HW DVT.
 */
#define CHECK_SYNC(__trace_id)
#endif /* (TIGON_REV & TIGON_REV4) */

#define CHECK_RESET(__trace_id) \
    if (zs.ability_match) { \
	/* are we receiving a reset? */ \
	if (!zs.rx_config_last) { \
	    LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_reset", (__trace_id), \
		zs.rx_match_ability_count, 0, 0, 0); \
	    zs.link_conf_state = STATE_LINK_CONF_RESTART_INIT; \
	    break;	/* early break */ \
	}  \
    }


void
autoneg_8023z(U32 rx_state)
{
    U32 rx_config;

    if (BRINGUP_LINK_STATE != BRINGUP_LINK_STATE_READY)
	return;

    if (!gig_negotiate) {
	rx_config = TRP->mac_control.mac_rx_config;

#if (TIGON_REV & TIGON_REV4)
	if ((rx_config == CONFIG_BASE_REM_FAULT_OFFLINE) ||
	    (rx_config == CONFIG_BASE_REM_FAULT_LINK_FAIL) ||
	    (rx_config == CONFIG_BASE_REM_FAULT_CONFIG_ERR) ||
	    (rx_config == 0x400) || /* old configs from pre D1 code */
	    (rx_config == 0x402) || /* old configs from pre D1 code */
	    (rx_config == 0x404)) { /* old configs from pre D1 code */
	    /* remote end is down */

	    link_down_notify();

	} else {
	    /* ignore configs for now... */
	    link_up_notify();
	    get_mac_link(TIGON_MAC_INDEX, active_phy);
	    /*
	     * since we know that we can have only 1 gig phy
	     * attached, mask off the others from the attached_phy
	     * field
	     */
	    if (active_phy == ATTACHED_PHY_IF_SERDES_EXT)
		attached_phy &= ~ATTACHED_PHY_IF_SERDES_INT;
	    else
		attached_phy &= ~ATTACHED_PHY_IF_SERDES_EXT;

	}
	zs.link_conf_state = STATE_LINK_CONF_LINK_OK;
#else /* (TIGON_REV & TIGON_REV4) */
#endif /* (TIGON_REV & TIGON_REV4) */
	link_down_notify();
	return;
    }

    /*
     * Have we received a new config symbol?
     *
     * Attns in the mac_rx_state register are cleared at the end of
     * this routine.
     */
#if (TIGON_REV & TIGON_REV4)
    if (trp->mac_control.mac_rx_state & TG_MAC_RX_STATE_NOT_AVAIL_ERR) {
	/*
	 * run ability_match and acknowledge_match
	 * functions as per 37.3.1.2
	 */
	rx_config = trp->mac_control.mac_rx_config;
	if ((rx_config & ~CONFIG_BASE_ACK) == 
	    (zs.rx_config_last & ~CONFIG_BASE_ACK)) {
	    zs.rx_match_ability_count++;
	    if (zs.rx_match_ability_count > 1)
		zs.ability_match = 1;
	} else {
	    zs.rx_match_ability_count = 0;
	    zs.ability_match = 0;
	}

	if ((zs.ability_match && (rx_config & CONFIG_BASE_ACK))) {
	    zs.acknowledge_match = 1;
	} else {
	    zs.acknowledge_match = 0;
	}

	zs.rx_config_last = rx_config;

	zs.idle_match = 0;
    } else {
	zs.idle_match = 1;

	/*
	 * once we start receiving IDLEs, all of our other functions get
	 * reset.
	 */
	zs.ability_match = 0;
	zs.rx_match_ability_count = 0;
	zs.acknowledge_match = 0;
	zs.rx_config_last = 0;
    }
#else /* (TIGON_REV & TIGON_REV4) */
#if (TIGON_REV & TIGON_REV5)
    if (trp->mac_control.mac_rx_state & TG_MAC_RX_STATE_CONFIG_SYNC) {
	/*
	 * run ability_match and acknowledge_match
	 * functions as per 37.3.1.2
	 */
	rx_config = trp->mac_control.mac_rx_config;
	if (trp->mac_control.mac_rx_state & TG_MAC_RX_STATE_AUTO_NEG_CHNGD) {
	    /*
	     * we got a new (different) config word
	     */
	    zs.rx_match_ability_count = 0;
	    zs.ability_match = 0;
	} else {
	    zs.rx_match_ability_count++;
	    if (zs.rx_match_ability_count > 1)
		zs.ability_match = 1;
	}

	if ((zs.ability_match && (rx_config & CONFIG_BASE_ACK))) {
	    zs.acknowledge_match = 1;
	} else {
	    zs.acknowledge_match = 0;
	}

	zs.rx_config_last = rx_config;

	zs.idle_match = 0;
    } else {
	zs.idle_match = 1;

	/*
	 * once we start receiving IDLEs, all of our other functions get
	 * reset.
	 */
	zs.ability_match = 0;
	zs.rx_match_ability_count = 0;
	zs.acknowledge_match = 0;
	zs.rx_config_last = 0;
    }
#else /* (TIGON_REV & TIGON_REV5) */
#error *** TIGON_REV4 or TIGON_REV5 not defined ***
#endif /* (TIGON_REV & TIGON_REV5) */
#endif /* (TIGON_REV & TIGON_REV4) */

    if (zs.link_conf_state != zs.link_conf_last_state) {
	zs.link_conf_last_state = zs.link_conf_state;
	LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_8023z", 0xc0001, 
	    zs.link_conf_state,
	    zs.rx_config_last << 16 | trp->mac_control.mac_tx_config,
	    trp->mac_control.mac_rx_state,
	    trp->mac_control.mac_tx_state);
    }

    /* have we lost sync? */
    CHECK_SYNC(0xf0031);

    switch(zs.link_conf_state) {
        case STATE_LINK_CONF_AUTONEG_ENABLE:

            /* initialize everything */
	    zs.ability_match = 0;
	    zs.rx_match_ability_count = 0;
	    zs.rx_config_last = 0;
	    zs.acknowledge_match = 0;

            zs.restart_count = 0;
	    zs.tx_toggle = 0;

	    trp->mac_control.mac_rx_config = 0;

#if (TIGON_REV & TIGON_REV4)
	    /*
	     * disable mac_rx_state reg so we can config it...
	     */
	    DISABLE_MAC_RX();
#endif /* (TIGON_REV & TIGON_REV4) */

            zs.link_conf_state = STATE_LINK_CONF_RESTART_INIT;
	    /* fall through */
 
        case STATE_LINK_CONF_RESTART_INIT:

	    /*
	     * detect if the remote side is sending IDLEs, if so,
	     * is is probably NOT performing autonegotiation.
	     */
	    if (zs.idle_match) {
		link_sense_count++;
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_IDLE", 0xf0037, 
		    link_sense_count, 0, 0, 0);

		if (link_sense_count >= 2) {
		    link_sense_mode = 1;
		    link_sense_count = 0;

		    active_phy_fail = 1;
		}
		break;	/* early break */
	    }

	    /* disable rx_attns */
	    EVENT_MASK &= ~TG_FW_EVENT_MAC_RX_ATTN;
	    link_down_notify();

	    /* send null configs as per 37.6 */
            trp->mac_control.mac_tx_config = 0;
            trp->mac_control.mac_tx_state &= ~TG_MAC_TX_STATE_ENABLE;
	    zs.last_tx_config = 0;

	    /* restart link timer */
	    zs.link_conf_timer = trp->gen_control.timer;

	    zs.mr_base_page = 1;

	    /* XXX Following lines not part of clause 37 */
            /* if we come here too often, try resetting the MAC */
	    zs.restart_count++;
            if (zs.restart_count > RESTART_THRESHHOLD) {
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_fail", 0xf0030, 
		    zs.restart_count, 0, 0, 0);
		active_phy_fail = 1;
                zs.restart_count = 0;
		break;
            }
	    /* XXX End of non-clause 37 section */

	    zs.link_conf_state = STATE_LINK_CONF_RESTART;
	    break;
 
        case STATE_LINK_CONF_RESTART:
	    /*
	     * Following computation is done the way it is to handle the timer
	     * wrapping around...
	     */
	    if (((zs.link_conf_timer + LINK_TIMER) -
		trp->gen_control.timer) >= LINK_TIMER) {
		zs.link_conf_state = STATE_LINK_CONF_ABILITY_DETECT_INIT;
	    }	

	    /*
	     * detect if the remote side is sending IDLEs, if so,
	     * is is probably NOT performing autonegotiation.
	     */
	    if (zs.idle_match) {
		link_sense_count++;
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_IDLE", 0xf0037, 
		    link_sense_count, 0, 0, 0);

		if (link_sense_count >= 2) {
		    link_sense_mode = 1;
		    link_sense_count = 0;

		    active_phy_fail = 1;
		}
		break;	/* early break */
	    }

	    /* disable rx_attns */
	    EVENT_MASK &= ~TG_FW_EVENT_MAC_RX_ATTN;
            break;
 
        case STATE_LINK_CONF_ABILITY_DETECT_INIT:
	    zs.rx_config_count = 0;

	    /*
	     * initialize base page from gig_negotiate options
	     * this may turn on the NP bit
	     */
	    set_base_page(gig_negotiate_options);

            trp->mac_control.mac_tx_config = zs.alt_base_page; 

	    /*
	     * detect if the remote side is sending IDLEs, if so,
	     * is is probably NOT performing autonegotiation.
	     */
	    if (zs.idle_match) {
		link_sense_count++;
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_IDLE", 0xf0037, 
		    link_sense_count, 0, 0, 0);

		if (link_sense_count >= 2) {
		    link_sense_mode = 1;
		    link_sense_count = 0;

		    active_phy_fail = 1;
		}
		break;	/* early break */
	    }

	    /* disable rx_attns */
	    EVENT_MASK &= ~TG_FW_EVENT_MAC_RX_ATTN;
            /*
             * if we are sending a remote fault, then we should immediately
             * reset the link too...
             */
            if (trp->mac_control.mac_tx_config & CONFIG_BASE_REM_FAULT_MASK) {
		zs.link_conf_state = STATE_LINK_CONF_RESTART_INIT;
                break;  /* early break */
            }
 
	    zs.last_tx_config = zs.alt_base_page;
	    zs.link_conf_state = STATE_LINK_CONF_ABILITY_DETECT;
	    
	    break;
            /* fall through */
 
        case STATE_LINK_CONF_ABILITY_DETECT:

	    /*
	     * detect if the remote side is sending IDLEs, if so,
	     * is is probably NOT performing autonegotiation.
	     */
	    if (zs.idle_match) {
		link_sense_count++;
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_IDLE", 0xf0037, 
		    link_sense_count, 0, 0, 0);

		if (link_sense_count >= 2) {
		    link_sense_mode = 1;
		    link_sense_count = 0;

		    active_phy_fail = 1;
		}
		break;	/* early break */
	    }

	    /* disable rx_attns */
	    EVENT_MASK &= ~TG_FW_EVENT_MAC_RX_ATTN;
	    if (zs.ability_match) {
		/* are we (still) receiving a reset? */
		if (!zs.rx_config_last) {
		    /*
		     * As of D3, DO NOT go back to ENABLE, just stay in 
		     * this state until something show up and
		     * we match.  Only possible transition is ACK_DETECT
		     */
		    break;	/* early break */
		} 

		/*
		 * save rx_Config_reg for later use in determining
		 * consistency_match
		 */
		zs.consistency_match_value = zs.rx_config_last;
		    
		/*
		 * reset rx_match_ability to minimum...
		 */
		zs.rx_match_ability_count = 3;		

		zs.link_conf_state = STATE_LINK_CONF_ACK_DETECT_INIT;

            }

            break;
 
        case STATE_LINK_CONF_ACK_DETECT_INIT:
	    zs.rx_config_count = 0;

	    /* ACK */
	    trp->mac_control.mac_tx_config |= CONFIG_BASE_ACK;
	    zs.last_tx_config |= CONFIG_BASE_ACK;

	    zs.link_conf_state = STATE_LINK_CONF_ACK_DETECT;
            /* fall through */
 
        case STATE_LINK_CONF_ACK_DETECT:

	    CHECK_RESET(0xf0042);

	    /*
	     * XXX violates 802.3z state machine
	     * detect if we are stuck because of not receiving
	     * the proper configs...
	     */
	    if (zs.rx_match_ability_count > ABILITY_COUNT_LIMIT) {
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_reset", 0xf0043, 
		    zs.rx_match_ability_count, 0, 0, 0);
		zs.link_conf_state = STATE_LINK_CONF_RESTART_INIT;
		break;
	    }

            /*
             * if we're stable, and have been ACK'd see if we
             * can agree on something
             */
            if (zs.acknowledge_match) {
		/*
		 * check for consistency_match
		 */
		if ((zs.rx_config_last & ~CONFIG_BASE_ACK) == 
		    (zs.consistency_match_value & ~CONFIG_BASE_ACK)) {

		    /*
		     * reset rx_match_ability to minimum...
		     */
		    zs.rx_match_ability_count = 3;		

		    /* and go on to the next state */	
		    zs.link_conf_state = STATE_LINK_CONF_COMPLETE_ACK_INIT;
		} else {
		    /*
		     * consistency_match failed 
		     */
		    zs.link_conf_state = STATE_LINK_CONF_AUTONEG_ENABLE;
		    break;	/* early break */
		}
	    } else {
		/*
		 * we don't have acknowledge_match yet...
		 */
		break;
	    }

	    /* break; fall through */

        case STATE_LINK_CONF_COMPLETE_ACK_INIT:
	    /*
	     * check for base page or next page
	     * and do whatever we're supposed to do...
	     */
	    if (zs.mr_base_page) {
		do_base_page(zs.rx_config_last);
		/*
		 * Did we fail base page negotiation?
		 */
		if (zs.tx_rem_error || zs.rx_rem_error) {
		    LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_fail", 0xf0044, 
			zs.tx_rem_error, zs.rx_rem_error, 0, 0);
		    active_phy_fail = 1;
		    zs.restart_count = 0;
		    break;
		}
	    } else {
#ifdef DO_NEXT_PAGE 
		do_next_page(zs.rx_config_last);
#else /* DO_NEXT_PAGE */
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_fail", 0xf0048, 
		    zs.mr_base_page, 0, 0, 0);
		active_phy_fail = 1;
		zs.restart_count = 0;
		break;
#endif /* DO_NEXT_PAGE */
	    }

	    /* toggle, toggle */
	    zs.tx_toggle = zs.tx_toggle ? 0 : CONFIG_NP_T;
	    zs.rx_toggle = zs.rx_config_last & CONFIG_NP_T;

	    /* restart link timer */
	    zs.link_conf_timer = trp->gen_control.timer;
	    zs.link_conf_state = STATE_LINK_CONF_COMPLETE_ACK;
            break;
 
        case STATE_LINK_CONF_COMPLETE_ACK:
	    /*
	     * Following computation is done the way it is to handle the timer
	     * wrapping around...
	     */
	    if (((zs.link_conf_timer + LINK_TIMER) -
		trp->gen_control.timer) >= LINK_TIMER) {

		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_8023z", 0xc0011, 
		    zs.link_conf_state,
		    zs.rx_config_last << 16 | trp->mac_control.mac_tx_config,
		    trp->mac_control.mac_rx_state,
		    0);

		CHECK_RESET(0xf0045);

		/*
		 * XXX violates 802.3z state machine
		 * detect if we are stuck because of not receiving
		 * the proper configs...
		 */
		if (zs.rx_match_ability_count > ABILITY_COUNT_LIMIT) {
		    LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_reset", 0xf0046, 
			zs.rx_match_ability_count, 0, 0, 0);
		    zs.link_conf_state = STATE_LINK_CONF_RESTART_INIT;
		    break;
		}

		/*
		 * The next page bit has different meanings for base page
		 * and next page.  For the base page it indicates the ability
		 * to support the next page.  BOTH local and link partner must
		 * support next page to start the exchange
		 *
		 * For the next page, the next page bit means there are 
		 * additional pages to be exchanged.  BOTH local or
		 * link partner must reset this bit to exit the next
		 * page portion of the state machine
		 */
		if (zs.mr_base_page) {
		    /*
		     * handle base page NP logic here...
		     */
		    zs.mr_base_page = 0;
		    if ((zs.rx_config_last & CONFIG_BASE_NP) &&
			(trp->mac_control.mac_tx_config & CONFIG_BASE_NP)) {
			/*
			 * reset rx_match_ability to minimum...
			 */
			zs.rx_match_ability_count = 3;		

			zs.link_conf_state = 
			    STATE_LINK_CONF_NEXT_PAGE_WAIT_INIT;
			/* fall through */
		    } else {
			zs.link_conf_state = STATE_LINK_CONF_IDLE_DETECT_INIT;
			break;
		    }
		} else {
		    /*
		     * handle next page NP logic here...
		     */
		    if ((zs.rx_config_last & CONFIG_NP_NP) ||
			(trp->mac_control.mac_tx_config & CONFIG_NP_NP)) {

			/*
			 * reset rx_match_ability to minimum...
			 */
			zs.rx_match_ability_count = 3;		

			zs.link_conf_state = 
			    STATE_LINK_CONF_NEXT_PAGE_WAIT_INIT;
			/* fall through */
		    } else {
			zs.link_conf_state = STATE_LINK_CONF_IDLE_DETECT_INIT;
			break;
		    }
		}	
	    } else {
		CHECK_RESET(0xf0047);
		break;
	    }
 
        case STATE_LINK_CONF_NEXT_PAGE_WAIT_INIT:

	    /* 
	     * send new next page and toggle
	     */
	    trp->mac_control.mac_tx_config = zs.alt_next_page | zs.tx_toggle;
	    zs.last_tx_config = zs.alt_next_page | zs.tx_toggle;

	    zs.link_conf_state = STATE_LINK_CONF_NEXT_PAGE_WAIT;
            /* fall through */
 
        case STATE_LINK_CONF_NEXT_PAGE_WAIT:

	    /*
	     * XXX violates 802.3z state machine
	     * detect if we are stuck because of not receiving
	     * the proper configs...
	     */
	    if (zs.rx_match_ability_count > ABILITY_COUNT_LIMIT) {
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_reset", 0xf0048, 
		    zs.rx_match_ability_count, zs.rx_config_last, 0, 0);
		zs.link_conf_state = STATE_LINK_CONF_RESTART_INIT;
		break;
	    }

	    /*
	     * XXX violates 802.3z state machine
	     * detect if link partner entered IDLE_DETECT before us,
	     * restart...
	     */
	    if (zs.idle_match) {
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_error", 0xf0049, 
		    zs.rx_match_ability_count, 0, 0, 0);
		zs.link_conf_state = STATE_LINK_CONF_IDLE_DETECT_INIT;
		break;
	    }

	    CHECK_RESET(0xf004a);

	    if (zs.ability_match) {
		if (zs.rx_toggle ^ (zs.rx_config_last & CONFIG_NP_T)) {
		    /*
		     * save rx_Config_reg for later use in determining
		     * consistency_match
		     */
		    zs.consistency_match_value = zs.rx_config_last;

		    /*
		     * reset rx_match_ability to minimum...
		     */
		    zs.rx_match_ability_count = 3;		

		    zs.link_conf_state = STATE_LINK_CONF_ACK_DETECT_INIT;
		    break;
		}
            }

            break;

        case STATE_LINK_CONF_IDLE_DETECT_INIT:

#ifdef DO_NEXT_PAGE 
	    /*
	     * we're done with all next page options, now put them
	     * together and see what we got...
	     */
	    next_page_results();
#endif /* DO_NEXT_PAGE */

            /* start transmitting idles... */
            trp->mac_control.mac_tx_state |= TG_MAC_TX_STATE_ENABLE;

	    /* restart link timer */
	    zs.link_conf_timer = trp->gen_control.timer;
	    zs.link_conf_state = STATE_LINK_CONF_IDLE_DETECT;
            /* fall through */
 
        case STATE_LINK_CONF_IDLE_DETECT:

	    /*
	     * Following computation is done the way it is to handle the timer
	     * wrapping around...
	     */
	    if (((zs.link_conf_timer + LINK_TIMER) -
		trp->gen_control.timer) >= LINK_TIMER) {

		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_8023z", 0xc0021, 
		    zs.link_conf_state,
		    zs.rx_config_last << 16 | trp->mac_control.mac_tx_config,
		    trp->mac_control.mac_rx_state,
		    trp->mac_control.mac_tx_state);

		if (zs.idle_match) {
		    /* good to go... */
		    zs.link_conf_state = STATE_LINK_CONF_LINK_OK;

		    if (!zs.rx_rem_error) {
			/*
			 * notify the host/MP that the link is up, but
			 * only if the remote side has not indicated an
			 * error during negotiation 
			 */

			link_up_notify();
			get_mac_link(TIGON_MAC_INDEX, active_phy);
			/*
			 * since we know that we can have only 1 gig phy
			 * attached, mask off the others from the attached_phy
			 * field
			 */
			if (active_phy == ATTACHED_PHY_IF_SERDES_EXT)
			    attached_phy &= ~ATTACHED_PHY_IF_SERDES_INT;
			else
			    attached_phy &= ~ATTACHED_PHY_IF_SERDES_EXT;

		    }

		    /* return to normal operation */
		    EVENT_MASK |= TG_FW_EVENT_MAC_RX_ATTN;

		    /*
		     * save for workaround of no indication of rx configs...
		     */
		    zs.saved_rx_config = trp->mac_control.mac_rx_config;
		      
#if (TIGON_REV & TIGON_REV4)
		    ENABLE_MAC_RX();
#endif /* (TIGON_REV & TIGON_REV4) */

		    break;
		}

		CHECK_RESET(0xf004b);

		/*
		 * are we continuing to receive garbage from the remote
		 * end?
		 */
		if (zs.rx_match_ability_count > ABILITY_COUNT_LIMIT) {
		    LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_fail", 0xf0030, 
			0, 0, 0, 0);
		    zs.link_conf_state = STATE_LINK_CONF_RESTART_INIT;
		    break;	/* early break */
		}
            }

	    CHECK_RESET(0xf004c);

            break;
 
        case STATE_LINK_CONF_LINK_OK:

	    /* XXX Following lines not part of clause 37 */
	    if (zs.ability_match) {
		/*
		 * we're receiving configs from the remote side,
		 * restart the link negotiation state machine
		 */
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "lc_fail", 0xf0011, 
		    0, 0, 0, 0);
		link_down_notify();
	    }

            break;
 
        default:
            /* XXX */
    }

    /* clear attns */
    trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;

}

np_oui_info_t *prev_tx_npp;

void
set_base_page(U32 gig_options)
{
    /*
     * do we need to send an error indication?  This is
     * self clearing
     */
    if (zs.tx_rem_error) {
	zs.alt_base_page = zs.tx_rem_error | CONFIG_BASE_FD;
	zs.tx_rem_error = 0;
	return;
    }

    zs.alt_base_page = gig_options;

#ifdef DO_NEXT_PAGE 
    /*
     * reset the received rx bit for all NP entries
     * and set conditional next pages
     */
    tx_npp = oui_msgs;
    while (!(tx_npp->flags & NP_INFO_DONE)) {
	tx_npp->flags &= ~(NP_INFO_GOT_RX | 
	    NP_INFO_GOT_ACK2 |
	    NP_INFO_GOT_EARLY_ACK2);
	/*
	 * now enable/disable conditional next pages according to
	 * tg_link_set
	 */
	switch(tx_npp->type) {
#if defined(NIC)
	    /*
	     * switches can always support jumbo frames,
	     * NIC need jumbo frame support explicielt
	     * enabled...
	     */
	    case OUI_LINK_FEATURE_JUMBO:
		if (tg_link_set_gig & LNK_JUMBO)
		    tx_npp->flags |= (NP_INFO_TX | NP_INFO_ACK2);
		else
		    tx_npp->flags &= ~NP_INFO_ACK2;
		break;
#endif /* defined(NIC) */

	    default:
		/* ignore everything else */
	}
	tx_npp++;
    }

    /*
     * now set up for 1st next page (if any)
     */

    tx_npp = oui_msgs;
    while (!(tx_npp->flags & (NP_INFO_TX | NP_INFO_DONE)))
	tx_npp++;
    /*
     * do we want to send any next pages? 
     */
    if (!(tx_npp->flags & NP_INFO_DONE)) {
	zs.alt_base_page |= CONFIG_NP_NP;
    }
    /*
     * reset tx_npp to point at start, we always point at what
     * we did last.
     */
    tx_npp = oui_msgs;
    prev_tx_npp = 0;
    
    /*
     * point rx at first valid entry...
     */
    rx_npp = oui_msgs;
    rx_npp++;
#endif /* DO_NEXT_PAGE */
}

/*
 * The Alteon user interface describes flow control in terms of RX
 * and TX.  This is mapped into symmetric and assymetric pause bits
 * in the following way:
 *
 *   TX   RX    PS1    PS2    Action
 *   --   --    ---    ---    ------
 *   N    N      N      N     no pause capability
 *   Y    N      N	Y     asymmetric pause capable 
 *				towards remote partner
 *   N    Y      Y      Y     assymetric pause capable 
 *				towards local interface
 *   Y    Y      Y      N     symmetric pause capable
 *
 * Priority resolution is done in accordance with 37.2.5.2 as 
 * shown in the table below:
 *
 *                    Link Partner Pause Capability
 *             None	Sym	Asym Remote	Asym Local
 * Local Pause
 * Capability           Local resolution
 *        +-----------------------------------------------
 * None	  |    None     None    None            None
 *        |
 * Sym	  |    None     TX, RX  None            RX#
 *        |
 * Asym   |    None     None    None            RX
 * Remote |
 *        |
 * Asym   |    None     TX, RX  TX              RX#
 * Local  |
 *        |
 *
 * '#' indicates that 37.2.5.2 would enable both TX and RX flow
 * control, but since our local setting requests RX only (in the
 * asym local case) we will not locally enable the sending of 
 * FC frames.  This is still compliant with 37.2.5.2.
 */
 
/* local resolution result */
#define LOC_FC_NONE     0x00
#define LOC_FC_RX       0x01
#define LOC_FC_TX       0x02
#define LOC_FC_BOTH     0x03
 
/*
 * use PS2, PS1 as index
 */
U8 fc_pri_local_resolution[4][4] = {    /* remote, local */
/*                  none         sym          asym rem     asym local  */
/*                 -----------  -----------  -----------  -----------  */
/* none       */ { LOC_FC_NONE, LOC_FC_NONE, LOC_FC_NONE, LOC_FC_NONE },
/* sym        */ { LOC_FC_NONE, LOC_FC_BOTH, LOC_FC_NONE, LOC_FC_RX   },
/* asym rem   */ { LOC_FC_NONE, LOC_FC_NONE, LOC_FC_NONE, LOC_FC_RX   },
/* asym local */ { LOC_FC_NONE, LOC_FC_BOTH, LOC_FC_TX,   LOC_FC_RX   }};

void
do_base_page(U32 rx_Config_reg)
{

    /*
     * save remote fault
     */
    zs.rx_rem_error = rx_Config_reg & CONFIG_BASE_REM_FAULT_MASK;
    /*
     * if we got a remote fault, we're done, the link negotiation
     * will be restarted
     */
    if (zs.rx_rem_error)
	return;

    /*
     * if any extra bits are on in the base page, it is garbage...
     */
    if (rx_Config_reg & 
	~(CONFIG_BASE_FD |
	  CONFIG_BASE_HD |
	  CONFIG_BASE_PS1 |
	  CONFIG_BASE_PS2 |
	  CONFIG_BASE_RF1 |
	  CONFIG_BASE_RF2 |
	  CONFIG_BASE_ACK |
	  CONFIG_BASE_NP)) {
	zs.tx_rem_error = CONFIG_BASE_REM_FAULT_CONFIG_ERR;
	return;
    }	

    if (rx_Config_reg & CONFIG_BASE_FD) {
        U32 resolv;
        U32 loc_i, rem_i;       /* PS2, PS1 as indices */
 
        rem_i = NORMAL_DATA(rx_Config_reg & CONFIG_BASE_PAUSE_MASK) >> 7;
        loc_i = NORMAL_DATA(gig_negotiate_options &
            CONFIG_BASE_PAUSE_MASK) >> 7;
        resolv = fc_pri_local_resolution[rem_i][loc_i];
 
        /*
         * we've resolved what to do, now set up our MAC appropriately...
         */
        switch(resolv) {
            case LOC_FC_NONE:
                trp->mac_control.mac_tx_state &= ~TG_MAC_TX_STATE_ENA_FC;
                trp->mac_control.mac_rx_state &= ~TG_MAC_RX_STATE_ENA_FC;
		mac_mgt_state[TIGON_MAC_INDEX].tx_fctl_gig = 0;
		mac_mgt_state[TIGON_MAC_INDEX].rx_fctl_gig = 0;
                break;
 
            case LOC_FC_TX:
                trp->mac_control.mac_tx_state |= TG_MAC_TX_STATE_ENA_FC;
                trp->mac_control.mac_rx_state &= ~TG_MAC_RX_STATE_ENA_FC;
		mac_mgt_state[TIGON_MAC_INDEX].tx_fctl_gig = TG_MAC_TX_STATE_ENA_FC;
		mac_mgt_state[TIGON_MAC_INDEX].rx_fctl_gig = 0;
                break;
 
            case LOC_FC_RX:
                trp->mac_control.mac_tx_state &= ~TG_MAC_TX_STATE_ENA_FC;
                trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_ENA_FC;
		mac_mgt_state[TIGON_MAC_INDEX].tx_fctl_gig = 0;
		mac_mgt_state[TIGON_MAC_INDEX].rx_fctl_gig = TG_MAC_RX_STATE_ENA_FC;
                break;
 
            case LOC_FC_BOTH:
                trp->mac_control.mac_tx_state |= TG_MAC_TX_STATE_ENA_FC;
                trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_ENA_FC;
		mac_mgt_state[TIGON_MAC_INDEX].tx_fctl_gig = TG_MAC_TX_STATE_ENA_FC;
		mac_mgt_state[TIGON_MAC_INDEX].rx_fctl_gig = TG_MAC_RX_STATE_ENA_FC;
                break;
 
            default:
                LINK_UTRACE("doBasePg", 0xfffff,
                    rem_i, loc_i,
                    resolv, 0);
        }
    } else { 
	/*
	 * we can't ever succeed here...
	 * we don't support HD, so we're dead until the remote 
	 * end does something different.
	 */
	zs.tx_rem_error = CONFIG_BASE_REM_FAULT_CONFIG_ERR;
	/*
	 * forget any next page exchange
	 */
	return;
    }	

#ifdef DO_NEXT_PAGE 
    /*
     * tx_npp should be set up from earlier call to set_base_page()
     * do we want to send any next pages?  Does our link partner support
     * next pages?
     */
    if (rx_Config_reg & CONFIG_BASE_NP) {
	tx_npp = oui_msgs;
	while (!(tx_npp->flags & (NP_INFO_TX | NP_INFO_DONE)))
	    tx_npp++;

	if (!(tx_npp->flags & NP_INFO_DONE)) {
	    zs.alt_next_page |= 
		CONFIG_NP_OUI_UP4 | 
		CONFIG_NP_MP |
		CONFIG_NP_NP;
	    tx_unformatted_remaining = 4;
	    transmitting_oui = 1;
	    tx_npp->tx_index = 0;
	} else {
	    transmitting_oui = 0;
	}
    }
#endif /* DO_NEXT_PAGE */
}

#ifdef DO_NEXT_PAGE 

void
do_next_page(U32 rx_Config_reg)
{
    zs.alt_next_page = 0;	/* reset */


    /*
     * first, see if we got our previous page ack'd
     */
    if (rx_Config_reg & CONFIG_NP_ACK2) {
	if (transmitting_oui) {
	    switch (tx_unformatted_remaining) {
		case 4:
		    /* ACK2 from previous last UP */
		    if (prev_tx_npp) {
			prev_tx_npp->flags |= NP_INFO_GOT_ACK2;
		    }
		    break;

		case 3:
		    /* MP ACK2 */
		    break;

		case 2:
		case 1:
		case 0:
		    /* early ACK2 */
		    tx_npp->flags |= NP_INFO_GOT_EARLY_ACK2;
		    break;

		default:
		    /* XXX */
	    }
	} else {
	    /*
	     * the first NULL page may contain an ACK2 from the
	     * last transmitted UP
	     */
	    if (prev_tx_npp) {
		prev_tx_npp->flags |= NP_INFO_GOT_ACK2;
		prev_tx_npp = 0;
	    }
	}
    }

    /*
     * now see what they are sending us
     */
    if (rx_Config_reg & CONFIG_NP_MP) {
	switch(rx_Config_reg & CONFIG_NP_DATA_MASK) {
	    case CONFIG_NP_NULL:
		rx_unformatted_remaining = 0;
		receiving_oui = 0;
		zs.alt_next_page |= CONFIG_NP_ACK2;
		break;

	    case CONFIG_NP_OUI_UP4:
		rx_unformatted_remaining = 4;
		receiving_oui = 1;
		rx_npp->rx_index = 0;
		zs.alt_next_page |= CONFIG_NP_ACK2;
		break;

	    case CONFIG_NP_UP1:
		rx_unformatted_remaining = 1;
		receiving_oui = 0;
		break;

	    case CONFIG_NP_UP2:
		rx_unformatted_remaining = 2;
		receiving_oui = 0;
		break;

	    case CONFIG_NP_REM_FAULT_UP1:
		rx_unformatted_remaining = 1;
		receiving_oui = 0;
		break;

	    case CONFIG_NP_PHY_TAG_UP4:
		rx_unformatted_remaining = 4;
		receiving_oui = 0;
		break;

	    default:
		rx_unformatted_remaining = 0;
		receiving_oui = 0;
	}
    } else {
	/*
	 * only save data if we are expecting it...  Unsolicited unformatted
	 * data is just tossed...
	 */
	if (rx_unformatted_remaining && receiving_oui) {
	    /*
	     * save unformatted data
	     */
	    oui_sequence[4 - rx_unformatted_remaining] = 
		rx_Config_reg & CONFIG_NP_DATA_MASK;

	    /*
	     * if this is the last one in the sequence, see if we
	     * should ACK2 it...
	     */
	    rx_unformatted_remaining--;
	    if (!rx_unformatted_remaining) {
		U32 i;
		U32 match_fail = 1;
		U32 cooked[2];

		rx_npp = oui_msgs;
		while (!(rx_npp->flags & NP_INFO_DONE) && match_fail) {
		    for (i = 0; i < 4; i++) {
			if (oui_sequence[i] != NP_DATA(rx_npp->data[i]))
			    break;	/* for() */

			/* we have a match... */
			if (i == 3)
			    match_fail = 0;
		    }
		    if (match_fail) {
			rx_npp++;
		    } else {
			/*
			 * so I want to ACK2 this?
			 */
			rx_npp->flags |= NP_INFO_GOT_RX;
			if (rx_npp->flags & NP_INFO_ACK2)
			    zs.alt_next_page |= CONFIG_NP_ACK2;

			break; /* while() */
		    }
		}

		/*
		 * display what we got...  in raw mode
		 */
		LINK_TRACE(TRACE_TYPE_LNK_NEG, "doNextPg", 0xc0401,
		    NORMAL_DATA(oui_sequence[0]), 
		    NORMAL_DATA(oui_sequence[1]),
		    NORMAL_DATA(oui_sequence[2]),
		    NORMAL_DATA(oui_sequence[3]));
		/*
		 * and put back together...
		 */
		cooked[0] = NORMAL_DATA(oui_sequence[0]) << 21;
		cooked[0] |= NORMAL_DATA(oui_sequence[1]) << 10;
		cooked[0] |= NORMAL_DATA(oui_sequence[2]) >> 1;
		cooked[1] = NORMAL_DATA(oui_sequence[2]) << 31;
		cooked[1] |= NORMAL_DATA(oui_sequence[3]) << 20;
		
		LINK_UTRACE("doNextPg", 0xc0402,
		    cooked[0], cooked[1], rx_npp->flags, 0);
	    }
	} else {
	    /*
	     * otherwise just toss it...
	     */
	}
    }
    /*
     * now handle tx size of things
     *
     * tx_npp always points at the entry we just finished
     * first go the a new page, if there is another one...
     */
    if (transmitting_oui) {
	/*
	 * Do we need to send more UPs for this page?
	 */
	if (!tx_unformatted_remaining) {
	    /*
	     * go to next valid entry...
	     */
	    prev_tx_npp = tx_npp;
	    tx_npp++;
	    while (!(tx_npp->flags & (NP_INFO_TX | NP_INFO_DONE)))
		tx_npp++;
	    
	    /* are we done? */
	    if (tx_npp->flags & NP_INFO_DONE) {
		transmitting_oui = 0;
		/* send NULLs */
		zs.alt_next_page |= 
		    CONFIG_NP_NULL | 
		    CONFIG_NP_MP;
		tx_unformatted_remaining = 0;
	    } else {
		tx_unformatted_remaining = 4;
		tx_npp->tx_index = 0;
		zs.alt_next_page |= 
		    CONFIG_NP_OUI_UP4 | 
		    CONFIG_NP_MP |
		    CONFIG_NP_NP;
	    }
	} else {
	    zs.alt_next_page |= 
		NP_DATA(tx_npp->data[tx_npp->tx_index]) |
		CONFIG_NP_NP;
	    tx_npp->tx_index++;
	    tx_unformatted_remaining--;
	}
    } else {
	/* just send NULLs */
	zs.alt_next_page |= 
	    CONFIG_NP_NULL | 
	    CONFIG_NP_MP;
	tx_unformatted_remaining = 0;
    }
}

void
next_page_results(void)
{
    /* clear previous settings... */
    link_partner_alteon = 0;
    link_partner_jumbo = 0;
    link_partner_nic = 0;

    /*
     * walk through the list, looking for things we received
     */
    rx_npp = oui_msgs;
    while (!(rx_npp->flags & NP_INFO_DONE)) {
	if (rx_npp->flags & NP_INFO_TX) {
	    switch (rx_npp->type) {
		case OUI_LINK_FEATURE_ALTEON:
		    if ((rx_npp->flags & NP_INFO_GOT_ACK2) &&
			!(rx_npp->flags & NP_INFO_GOT_EARLY_ACK2)) {
			link_partner_alteon = 1;
			LINK_UTRACE("lnk_ALTN ", 0xc0770, 
			    rx_npp->flags, 0, 0, 0);
		    }
		    break;

		case OUI_LINK_FEATURE_NIC:
		    if ((rx_npp->flags & NP_INFO_GOT_ACK2) &&
			!(rx_npp->flags & NP_INFO_GOT_EARLY_ACK2)) {
			link_partner_nic = 1;
			LINK_UTRACE("lnk_NIC ", 0xc0770, 
			    rx_npp->flags, 0, 0, 0);
		    }
		    break;

		case OUI_LINK_FEATURE_JUMBO:
		    if ((rx_npp->flags & NP_INFO_GOT_ACK2) &&
			!(rx_npp->flags & NP_INFO_GOT_EARLY_ACK2)) {
			link_partner_jumbo = 1;
			LINK_UTRACE("lnk_JMBO", 0xc0771, 
			    rx_npp->flags, 0, 0, 0);
		    }
		    break;

		case OUI_LINK_FEATURE_NULL:
		default:
		    break;
	    }
	}
	rx_npp++;
    }
}

#endif /* DO_NEXT_PAGE */

