/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996 
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: np.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.3  1998/01/04  23:48:10  hayes
 * 	seperate Alteon device detection from other capability detection
 * 	[1998/01/04  02:27:58  hayes]
 *
 * Revision 1.1.2.2  1997/10/10  20:38:15  hayes
 * 	new next page code
 * 	[1997/10/10  20:35:54  hayes]
 * 
 * Revision 1.1.2.1  1997/08/12  02:53:59  hayes
 * 	initial checkin
 * 	[1997/08/12  02:50:07  hayes]
 * 
 * $EndLog$
 */

#ifndef _NP_H_
#define _NP_H_

/*
 * defined so we can tell our switches from others
 */
#ifdef OEM_ALTEON
#define OUI_LINK	0x0060cf
#define OUI_LINK_PARTNER	0
#endif /* defined OEM_ALTEON */

#ifdef OEM_OP1
#define OUI_LINK	0x0060cf
#define OUI_LINK_PARTNER	1
#endif /* defined OEM_OP1 */

#ifndef OUI_LINK_PARTNER
#error "You MUST define proper link partner- see Hayes for details"
#endif /* ifndef OP_LINK_PARTNER */

/*
 * things we can communicate
 */
#define OUI_LINK_FEATURE_NULL	0	
#define OUI_LINK_FEATURE_JUMBO	1	
#define OUI_LINK_FEATURE_NIC	2	
#define OUI_LINK_FEATURE_ALTEON	3	

/*
 * macros for generating the UP messages
 */
#define OUI_UP1(link_oui, op, feature) \
    (link_oui >> 13)
#define OUI_UP2(link_oui, op, feature) \
    ((link_oui >> 2) & 0x7ff)
#define OUI_UP3(link_oui, op, feature) \
    ((link_oui & 3) << 9) | (op << 1) | (feature >> 11)
#define OUI_UP4(link_oui, op, feature) \
    (feature & 0x7ff)

/*
 * how many do we have space for?
 */
#define MAX_NP_OUI	16

extern np_oui_info_t *rx_npp;	/* pointer for receiving pages */
extern np_oui_info_t *tx_npp;	/* pointer for sending pages */

extern U32 rx_unformatted_remaining;
extern U32 tx_unformatted_remaining;

extern U32 oui_sequence[];

extern U32 receiving_oui;
extern U32 transmitting_oui;

extern np_oui_info_t oui_msgs[];

#endif /* _NP_H_ */
