/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996, 1997 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: mii.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.8  1998/05/27  01:19:34  fhwang
 * 	add  MII_AUTONEG_ADV_802_3 definition
 * 	[1998/05/27  00:56:26  fhwang]
 *
 * Revision 1.1.2.7  1997/12/09  02:38:05  hayes
 * 	fix timer incompatibility between nic and switch
 * 	[1997/12/09  02:37:49  hayes]
 * 
 * Revision 1.1.2.6  1997/10/21  21:59:39  tibor
 * 	converted macros to subr
 * 	[1997/10/21  21:57:24  tibor]
 * 
 * Revision 1.1.2.5  1997/10/06  23:53:35  hayes
 * 	more adjustments to ICS 1890 initialization
 * 	[1997/10/06  23:53:19  hayes]
 * 
 * Revision 1.1.2.4  1997/09/17  03:26:32  hayes
 * 	Added defines for 2 additional ICS states; RESET_PHY_MII_ICS_REG24_2 and
 * 	RESET_PHY_MII_ICS_REG24_2_WAIT.
 * 	[1997/09/15  22:24:26  hayes]
 * 
 * Revision 1.1.2.3  1997/09/09  02:57:35  hayes
 * 	Add support for various MII devices
 * 	Add device support for Level One LXT970 in addition
 * 	to the ICS 1890
 * 	[1997/09/09  02:56:26  hayes]
 * 
 * 	completed link code restructuring
 * 	[1997/08/29  22:11:01  hayes]
 * 
 * Revision 1.1.2.2  1997/08/29  22:11:57  hayes
 * 	completed link code restructuring
 * 
 * Revision 1.1.2.1  1997/08/26  21:09:01  hayes
 * 	initial checkin
 * 	[1997/08/26  21:01:32  hayes]
 * 
 * $EndLog$
 */
#ifndef _MII_H_
#define _MII_H_

 
/*
 * MII interface definitions
 * from 802.3u
 */
 
#define MII_REG_CONTROL         0
#define MII_REG_STATUS          1
#define MII_REG_PHY_ID0         2
#define MII_REG_PHY_ID1         3
#define MII_REG_AUTONEG_AD      4
#define MII_REG_AUTONEG_LINK_PA 5
#define MII_REG_AUTONEG_EXPN    6
#define MII_REG_AUTONEG_NEXT    7
#define MII_REG_ICS_QUICK_STATUS        17
#define MII_REG_LEVL1_CHIPSTAT	20
 
#define MII_CONTROL_RESET       0x8000
#define MII_CONTROL_LOOPBACK    0x4000
#define MII_CONTROL_SPEED_10    0x0000  /* for code readability */
#define MII_CONTROL_SPEED_100   0x2000
#define MII_CONTROL_AUTONEG_ENA 0x1000
#define MII_CONTROL_POWER_DOWN  0x0800
#define MII_CONTROL_ISOLATE     0x0400
#define MII_CONTROL_RESTART_AUTONEG     0x0200
#define MII_CONTROL_FULL_DUPLEX 0x0100
#define MII_CONTROL_HALF_DUPLEX 0x0000  /* for code readability */
#define MII_CONTROL_COLL_TEST   0x0080
 
#define MII_STATUS_100T4        0x8000
#define MII_STATUS_100XFD       0x4000
#define MII_STATUS_100XHD       0x2000
#define MII_STATUS_10FD         0x1000
#define MII_STATUS_10HD         0x0800
#define MII_STATUS_PRE_SUPPRESS 0x0040
#define MII_STATUS_AUTONEG_DONE 0x0020
#define MII_STATUS_REM_FAULT    0x0010
#define MII_STATUS_AUTONEG      0x0008
#define MII_STATUS_LINK_UP      0x0004
#define MII_STATUS_JABBER       0x0002
#define MII_STATUS_EXTEND       0x0001
 
#define MII_AUTONEG_ADV_NEXT_PAGE       0x8000
#define MII_AUTONEG_ADV_FAULT           0x2000
#define MII_AUTONEG_ADV_100_FD          0x0100
#define MII_AUTONEG_ADV_100_HD          0x0080
#define MII_AUTONEG_ADV_10_FD           0x0040
#define MII_AUTONEG_ADV_10_HD           0x0020
#define MII_AUTONEG_ADV_802_3		0x0001

/* special defines for ICS QUICKPOLL register (reg 17) */
#define MII_ICS_QUICKPOLL_100           0x8000
#define MII_ICS_QUICKPOLL_FD            0x4000
#define MII_ICS_QUICKPOLL_LINK          0x0001

/* special defines for Level One status register (reg 20) */
#define MII_LEVL1_CHIPSTAT_LINK		0x2000
#define MII_LEVL1_CHIPSTAT_FD		0x1000
#define MII_LEVL1_CHIPSTAT_100		0x0800

/*
 * MII control routines
 */
extern U32 read_mii_bit(void);
extern void write_mii_bit(U32 bit);
extern void write_mii_z(void);

/*
 * low level routines for accessing the MII registers
 */
void read_mii_mgt(U32 device, U32 reg, U16 *data);
void write_mii_mgt(U32 device, U32 reg, U16 *data);

/*
 * structure for interpreting MII control and AUTONEGOTIATION settings
 */
typedef struct mii_pair {
    U16 reg_control;
    U16 reg_autoneg_adv;
} mii_pair_t;
	 
extern mii_pair_t mii_set[4][4];

/*
 * mii reset state variables
 */
extern U32 mii_reset_state;
extern U32 mii_reset_timer;

/* following timer for reset_mii_phy() */
#define MII_TIMER                      (100)

void reset_mii_phy(void);

/*
 * defines for using after determining what MII device is attached
 * to us.
 */

extern U32 mii_device_attached;

#define MII_DEVICE_NONE		1
#define MII_DEVICE_UNKNOWN	2
#define MII_DEVICE_ICS_1890_2	3
#define MII_DEVICE_LXT_970	4

/* the following is for the MII reset state machine */
 
#define RESET_PHY_MII_RESET             1
#define RESET_PHY_MII_RESET_WAIT        2
#define RESET_PHY_MII_REG_CONTROL       3
#define RESET_PHY_MII_REG_CONTROL_WAIT  4
#define RESET_PHY_MII_ICS_REG18         5
#define RESET_PHY_MII_ICS_REG18_WAIT    6
#define RESET_PHY_MII_ICS_REG19         7
#define RESET_PHY_MII_ICS_REG19_WAIT    8
#define RESET_PHY_MII_ICS_REG24         9
#define RESET_PHY_MII_ICS_REG24_WAIT    10
#define RESET_PHY_MII_ICS_REG23         11
#define RESET_PHY_MII_ICS_REG23_WAIT    12
#define RESET_PHY_MII_ICS_REG20         	18
#define RESET_PHY_MII_ICS_REG20_WAIT    	19
#define RESET_PHY_MII_ICS_REG24_2       13
#define RESET_PHY_MII_ICS_REG24_2_WAIT  14
#define RESET_PHY_MII_LEVL1_REG19       15
#define RESET_PHY_MII_LEVL1_REG19_WAIT  16
#define RESET_PHY_MII_READY             17
  
#endif /* _MII_H_ */
