/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996 
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: link.c,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision cur_hayes/2 1999/03/01 21:15:48 hayes
 * 	fix promiscuous bug for T1 disparity workaround
 * 
 * Revision 1.1.2.107  1999/01/27  19:09:34  hayes
 * 	incorporate autosense code
 * 	[1999/01/27  19:07:48  hayes]
 *
 * Revision 1.1.64.3  1999/01/06  02:06:13  hayes
 * 	link autosense mode now works
 * 	[1998/11/07  20:59:54  hayes]
 * 
 * Revision 1.1.2.106  1998/12/16  18:20:34  fhwang
 * 	add revision id 0xf430 for new phy ICS 1892
 * 	[1998/12/16  18:19:39  fhwang]
 * 
 * Revision 1.1.2.105  1998/10/14  00:10:53  ted
 * 	Fix Gigablaze startup problem
 * 	[1998/10/14  00:10:30  ted]
 * 
 * Revision 1.1.2.104  1998/09/22  23:42:28  taylor
 * 	Finalize software keys
 * 	[1998/09/22  22:54:55  taylor]
 * 
 * Revision 1.1.2.103  1998/09/16  23:21:46  hayes
 * 	new gig reset state machine works
 * 	[1998/09/14  20:56:30  hayes]
 * 
 * 	intermediate checkin of blocking reset code that fixes T1
 * 	[1998/09/12  22:53:59  hayes]
 * 
 * Revision 1.1.2.101  1998/06/18  23:05:09  fhwang
 * 	wait 500 us after mac_reset in probe_phy.
 * 	[1998/06/18  22:44:04  fhwang]
 * 
 * Revision 1.1.2.100  1998/06/17  03:50:01  fhwang
 * 	Add code to power down serdes once every 4 times before reset and
 * 	remove extra reset on serdes.
 * 	[1998/06/17  03:47:49  fhwang]
 * 
 * Revision 1.1.2.99  1998/05/30  01:11:05  shuang
 * 	Moved break statement to right place.
 * 	[1998/05/30  01:03:59  shuang]
 * 
 * Revision 1.1.2.98  1998/05/29  22:37:25  ted
 * 	Fix loopback when there's a loopback plug present
 * 	[1998/05/29  22:37:09  ted]
 * 
 * Revision 1.1.2.97  1998/05/28  18:18:13  fhwang
 * 	add code to adjust polarity according to different phy attached.
 * 	[1998/05/28  18:16:48  fhwang]
 * 
 * Revision 1.1.2.96  1998/05/27  20:14:56  taylor
 * 	Fixed link code: added back TG_MAC_RC_STATE_LINK_PPOL_HIGH
 * 	[1998/05/27  20:14:44  taylor]
 * 
 * Revision 1.1.2.95  1998/05/27  01:19:29  fhwang
 * 	change ticks to 1 second for MII phy, LXT970 revision id to 1, and link up active low.
 * 	[1998/05/27  01:01:29  fhwang]
 * 
 * Revision 1.1.2.94  1998/05/21  18:02:28  kyung
 * 	Merged with changes from 1.1.2.93
 * 	[1998/05/21  18:02:19  kyung]
 * 
 * 	clear active_phy before exiting probe_phy
 * 	[1998/05/21  18:01:27  kyung]
 * 
 * 	take out unnecessary debug code
 * 	[1998/05/20  21:47:47  kyung]
 * 
 * 	clear misc bits 0-2 if no ext. serdes present - ACEdir support
 * 	[1998/05/20  21:39:15  kyung]
 * 
 * Revision 1.1.2.93  1998/05/20  21:25:22  hayes
 * 	fix PHY LOOPBACK for internal SERDES
 * 	[1998/05/20  21:25:09  hayes]
 * 
 * Revision 1.1.2.92  1998/04/24  00:00:26  hayes
 * 	insure that link state is failed after probe_phy()
 * 	[1998/04/24  00:00:10  hayes]
 * 
 * Revision 1.1.2.91  1998/03/18  03:43:57  hayes
 * 	restructure mac mgt interface
 * 	[1998/03/18  03:37:53  hayes]
 * 
 * Revision 1.1.2.90  1998/03/09  18:56:45  hayes
 * 	LOOPBACK works for Rev4, lots of mac_len cleanup
 * 	[1998/03/09  18:55:27  hayes]
 * 
 * Revision 1.1.2.89  1998/03/09  17:32:07  hayes
 * 	complete gig PHY detection code, add internal LOOPBACK
 * 	[1998/03/09  17:31:49  hayes]
 * 
 * 	intermediate checkin, initial LOOPBACK support for gig
 * 	[1998/03/09  00:42:20  hayes]
 * 
 * Revision 1.1.2.88  1998/03/08  02:03:52  ted
 * 	Fix compile warning on Tigon 4
 * 	[1998/03/08  02:02:52  ted]
 * 
 * Revision 1.1.2.87  1998/03/04  04:34:50  hayes
 * 	detect if the internal SERDES is powered (and available)
 * 	[1998/03/04  04:34:39  hayes]
 * 
 * Revision 1.1.2.86  1998/02/28  02:55:27  hayes
 * 	cleanup last fix...
 * 	[1998/02/28  02:55:00  hayes]
 * 
 * Revision 1.1.2.85  1998/02/27  02:42:15  hayes
 * 	fix link preferences and restructure link mgt interface
 * 	[1998/02/27  02:41:33  hayes]
 * 
 * Revision 1.1.2.84  1998/02/23  02:08:09  hayes
 * 	cleanup for Tigno1
 * 	[1998/02/23  02:07:59  hayes]
 * 
 * Revision 1.1.2.83  1998/02/23  01:22:38  hayes
 * 	don't complete link bringup in non-negotiate case until we are
 * 	receiving IDLEs.
 * 	[1998/02/23  01:19:36  hayes]
 * 
 * Revision 1.1.2.82  1998/02/21  21:07:41  hayes
 * 	disable DESCR attns for Tigon2 NICs
 * 	[1998/02/21  20:43:18  hayes]
 * 
 * Revision 1.1.2.81  1998/02/08  01:37:34  hayes
 * 	reset mac before touching producer/comsumers
 * 	[1998/02/08  01:37:21  hayes]
 * 
 * Revision 1.1.2.80  1998/02/06  22:19:41  hayes
 * 	add support for link preferences
 * 	[1998/02/06  21:33:07  hayes]
 * 
 * Revision 1.1.2.79  1998/02/02  19:42:03  hayes
 * 	change debugging information
 * 	[1998/02/02  19:41:45  hayes]
 * 
 * Revision 1.1.2.78  1998/01/26  23:22:32  hayes
 * 	fix 3COM FDR bringup problem for Tigon2
 * 	[1998/01/26  23:22:14  hayes]
 * 
 * Revision 1.1.2.77  1998/01/26  06:24:33  hayes
 * 	code cleanup
 * 	[1998/01/26  06:23:08  hayes]
 * 
 * Revision 1.1.2.76  1998/01/23  22:37:07  hayes
 * 	fix link bringup wirh Extreme power cyling
 * 	[1998/01/23  22:34:54  hayes]
 * 
 * Revision 1.1.2.75  1998/01/22  22:51:11  hayes
 * 	fix different phy fctl bug
 * 	[1998/01/22  22:47:18  hayes]
 * 
 * Revision 1.1.2.74  1998/01/20  04:39:15  hayes
 * 	add tigon Rev6 support
 * 	[1998/01/20  04:37:05  hayes]
 * 
 * Revision 1.1.2.73  1998/01/14  23:58:56  hayes
 * 	improve low level link robustness
 * 	[1998/01/14  23:58:42  hayes]
 * 
 * Revision 1.1.2.72  1998/01/14  00:25:20  hayes
 * 	re-enable the FLAP_CHECK_WAIT state
 * 	[1998/01/14  00:22:17  hayes]
 * 
 * Revision 1.1.2.71  1998/01/06  17:05:25  hayes
 * 	fix disable to shut down remote gig port
 * 	[1998/01/06  03:31:29  hayes]
 * 
 * Revision 1.1.2.70  1998/01/04  23:48:08  hayes
 * 	Merged with changes from 1.1.2.69
 * 	[1998/01/04  23:48:00  hayes]
 * 
 * 	general cleanup and speed improvments
 * 	[1998/01/04  23:41:37  hayes]
 * 
 * Revision 1.1.2.69  1998/01/03  02:16:43  kyung
 * 	fast enet board support - added by J.H.
 * 	[1998/01/03  02:16:26  kyung]
 * 
 * Revision 1.1.2.68  1998/01/01  00:12:13  hayes
 * 	fix MII settings for 180 board
 * 	[1998/01/01  00:12:02  hayes]
 * 
 * Revision 1.1.2.67  1997/12/28  01:09:12  hayes
 * 	improve gig link bringup speed
 * 	[1997/12/28  01:08:54  hayes]
 * 
 * Revision 1.1.2.66  1997/12/17  21:42:35  hayes
 * 	 fix for 3.0 110 build
 * 	[1997/12/17  21:42:22  hayes]
 * 
 * Revision 1.1.2.65  1997/12/12  05:34:29  hayes
 * 	use timer based phy selection mechanism
 * 	[1997/12/12  04:04:27  hayes]
 * 
 * 	internediate checkin
 * 	[1997/12/11  23:37:11  hayes]
 * 
 * Revision 1.1.2.64  1997/12/09  23:56:39  hayes
 * 	cleanup link negotiation
 * 	[1997/12/09  23:55:39  hayes]
 * 
 * Revision 1.1.2.63  1997/12/01  00:03:55  hayes
 * 	cleanup
 * 	[1997/12/01  00:03:38  hayes]
 * 
 * 	enhance link bringup under load
 * 	[1997/11/30  22:54:53  hayes]
 * 
 * Revision 1.1.2.62  1997/11/30  20:33:31  hayes
 * 	don't touch MAC threshholds for Sp code
 * 	[1997/11/30  20:33:10  hayes]
 * 
 * Revision 1.1.2.61  1997/11/30  00:57:38  hayes
 * 	fixup NIC threshholds
 * 	[1997/11/30  00:54:53  hayes]
 * 
 * Revision 1.1.2.60  1997/11/29  22:52:50  hayes
 * 	link bringup works reliably for external SERDES too...
 * 	[1997/11/29  22:52:39  hayes]
 * 
 * Revision 1.1.2.59  1997/11/29  22:09:24  hayes
 * 	internal SERDES link code now works for everything
 * 	[1997/11/29  22:09:10  hayes]
 * 
 * Revision 1.1.2.58  1997/11/29  20:57:43  hayes
 * 	fix 110 link bringup
 * 	[1997/11/29  20:57:33  hayes]
 * 
 * Revision 1.1.2.57  1997/11/29  20:36:32  hayes
 * 	more link bringup...
 * 	[1997/11/29  20:36:22  hayes]
 * 
 * Revision 1.1.2.56  1997/11/26  01:08:43  hayes
 * 	improve external serdes bringup
 * 	[1997/11/26  01:07:19  hayes]
 * 
 * Revision 1.1.2.55  1997/11/24  16:30:08  taylor
 * 	Fixed build: place POL_HIGH inside #if's
 * 	[1997/11/24  16:29:45  taylor]
 * 
 * Revision 1.1.2.54  1997/11/22  21:39:41  hayes
 * 	changes to support new phy mgt interface for both 110 and 180
 * 	[1997/11/22  21:39:27  hayes]
 * 
 * Revision 1.1.2.53  1997/11/22  20:01:24  hayes
 * 	more MII fixes...
 * 	[1997/11/22  19:59:52  hayes]
 * 
 * Revision 1.1.2.52  1997/11/21  23:54:13  hayes
 * 	MII link down works
 * 	[1997/11/21  23:53:49  hayes]
 * 
 * 	MII interface works
 * 	[1997/11/21  22:45:23  hayes]
 * 
 * Revision 1.1.2.51  1997/11/21  04:48:08  hayes
 * 	release for NIC 2.1 pre-Beta
 * 	[1997/11/21  03:19:08  hayes]
 * 
 * 	internal and external SERDES co-exist peacefully
 * 	[1997/11/20  01:27:55  hayes]
 * 
 * Revision 1.1.2.50  1997/11/18  21:22:30  hayes
 * 	fix REV4 build problem
 * 	[1997/11/18  21:22:17  hayes]
 * 
 * Revision 1.1.2.49  1997/11/18  19:33:45  hayes
 * 	fix up use use proper SERDES...
 * 	[1997/11/18  19:33:35  hayes]
 * 
 * Revision 1.1.2.48  1997/11/18  01:33:55  hayes
 * 	initial cut with working external serdes for Tigon2 boards
 * 	[1997/11/18  01:30:39  hayes]
 * 
 * Revision 1.1.2.47  1997/11/13  16:45:33  kyung
 * 	Merged with changes from 1.1.2.46
 * 	[1997/11/13  16:45:19  kyung]
 * 
 * 	Rev5: more hardware software integration
 * 	[1997/11/13  16:41:07  kyung]
 * 
 * Revision 1.1.2.46  1997/11/13  00:51:36  hayes
 * 	Merged with changes from 1.1.2.45
 * 	[1997/11/13  00:51:29  hayes]
 * 
 * 	fix build
 * 	[1997/11/13  00:49:39  hayes]
 * 
 * Revision 1.1.2.45  1997/11/12  15:50:04  wayne
 * 	Fix nightly build.
 * 	[1997/11/12  15:49:31  wayne]
 * 
 * Revision 1.1.2.44  1997/11/10  02:55:08  hayes
 * 	adjuct for better link bringup
 * 	[1997/11/10  02:54:54  hayes]
 * 
 * Revision 1.1.2.43  1997/11/10  02:09:37  kyung
 * 	Rev: hardware software optimiziations
 * 	[1997/11/10  02:08:28  kyung]
 * 
 * Revision 1.1.2.42  1997/11/09  23:27:26  hayes
 * 	link bringup is more reliable for non-LC, int-SERDES mode
 * 	[1997/11/09  23:27:05  hayes]
 * 
 * Revision 1.1.2.41  1997/10/30  02:21:13  hayes
 * 	Merged with changes from 1.1.2.40
 * 	[1997/10/30  02:21:03  hayes]
 * 
 * 	get link negotiation working for Tigon2
 * 	[1997/10/30  02:18:06  hayes]
 * 
 * Revision 1.1.2.40  1997/10/29  23:48:55  taylor
 * 	Rev5: disable USE_ASM and SCRATCH_PAD, fix link compile
 * 	[1997/10/29  23:48:35  taylor]
 * 
 * Revision 1.1.2.39  1997/10/29  03:44:46  hayes
 * 	Merged with changes from 1.1.2.38
 * 	[1997/10/29  03:44:26  hayes]
 * 
 * 	cleanup int SERDES link initialization
 * 	[1997/10/29  03:42:57  hayes]
 * 
 * Revision 1.1.2.38  1997/10/28  21:51:03  taylor
 * 	Rev5: Add MAC RX workaround
 * 	[1997/10/28  21:50:35  taylor]
 * 
 * Revision 1.1.2.37  1997/10/27  22:59:49  hayes
 * 	make Tigon 2 support work for internal SERDES
 * 	[1997/10/27  22:56:03  hayes]
 * 
 * Revision 1.1.2.36  1997/10/21  21:59:35  tibor
 * 	converted macros to subr
 * 	[1997/10/21  21:54:09  tibor]
 * 
 * Revision 1.1.2.35  1997/10/17  00:05:17  hayes
 * 	update for rev5
 * 	[1997/10/17  00:02:44  hayes]
 * 
 * Revision 1.1.2.34  1997/10/10  20:37:58  hayes
 * 	cleaned up tracing
 * 	[1997/10/09  21:39:14  hayes]
 * 
 * Revision 1.1.2.33  1997/10/02  21:36:25  hayes
 * 	fixed initializtion for REV5
 * 	[1997/10/02  21:36:07  hayes]
 * 
 * Revision 1.1.2.32  1997/09/30  22:54:58  hayes
 * 	fixed compile error for REV5
 * 	[1997/09/30  22:54:46  hayes]
 * 
 * Revision 1.1.2.31  1997/09/30  21:03:27  hayes
 * 	Change activate_link() tracing strategy.
 * 	#ifdeff'd REV4 and REV5 differences.
 * 	Added activation state machines for internal serdes
 * 	Added place holder for GMII bringup state machine
 * 	Added #ifdeff'd placeholders for REV5 external serdes bringup
 * 	state machine.
 * 	[1997/09/30  20:47:27  hayes]
 * 
 * Revision 1.1.2.30  1997/09/25  20:42:14  hayes
 * 	fix len notify from 32 to 64 bytes
 * 	[1997/09/25  20:41:42  hayes]
 * 
 * Revision 1.1.2.29  1997/09/19  21:26:15  hayes
 * 	added rev5 support for mac_reset()
 * 	[1997/09/19  21:26:03  hayes]
 * 
 * Revision 1.1.2.28  1997/09/17  03:26:23  hayes
 * 	Change bringup_link() from the activation routine, to the routine that
 * 	oversees the bringup of the various phys.
 * 	Added activate_phy() to do the actual bringup of each phy.
 * 	Fixed mac_reset() so that it handles all phys now.
 * 	[1997/09/15  22:19:11  hayes]
 * 
 * Revision 1.1.2.27  1997/09/10  03:55:05  hayes
 * 	start code preparation to handle multiple phys per mac
 * 	[1997/09/10  03:50:35  hayes]
 * 
 * Revision 1.1.2.26  1997/09/09  02:57:29  hayes
 * 	Add support for autodetecting different MII devices
 * 	Add device support for Level One LXT970
 * 	[1997/09/09  02:54:59  hayes]
 * 
 * Revision 1.1.2.25  1997/09/05  21:01:12  hayes
 * 	zero mac stats on initialization - again
 * 	[1997/09/05  20:59:05  hayes]
 * 
 * 	completed link code restructuring
 * 	[1997/08/29  22:10:52  hayes]
 * 
 * Revision 1.1.2.24  1997/08/29  22:11:50  hayes
 * 	completed link code restructuring
 * 
 * Revision 1.1.2.23  1997/08/26  21:08:52  hayes
 * 	split up link files in preparation for SC changes
 * 	[1997/08/26  21:02:10  hayes]
 * 
 * $EndLog$
 */

#include "link_op.h"
#include "mii.h"
#include "zconf.h"
#include "np.h"
#include "link.h"
#include "link_if.h"

#include "mac.h"
#include "assert.h"
#include "trace.h"
#include "timer.h"

#if defined(_SP_CONF_H_)
#include "sp_regs.h"
#endif /* defined(_SP_CONF_H_) */

/*****************************************************************************/

U32 runt_frame[16] = { 0x0060cf00, 0x00000060, 0xcf000000, 0x00000000 };

U32 save_tx_fctl_gig = 0;
U32 save_rx_fctl_gig = 0;
U32 save_tx_fctl_fast = 0;
U32 save_rx_fctl_fast = 0;

/*
 * The following value is set during init processing in the various mac.c
 * to allow the interface to tell the link code what additional mac RX
 * state bits are wanted.  The possible bits are:
 * 
 * for REV4 tigons:
 *
 *      TG_MAC_RX_STATE_ENA_BUFIND_ATTN
 *      TG_MAC_RX_STATE_ENA_PROMISC
 *
 * for REV5 tigons:
 *
 *      TG_MAC_RX_STATE_ENA_PROMISC
 *
 * For NIC and SP2 this value should be 0.
 */
U32 additional_rx_bits_wanted = 0;

/*
 * this routine gets driven from h_timer()
 */

U32 bringup_link_timer;

U32 attached_phy = 0;
U32 active_phy = 0;
U32 active_phy_fail = 3;
#define ACTIVE_PHY_FAIL_THRESH	3
#define ACTIVE_PHY_FAIL_TIMEOUT_USECS	1000000	/* 1 second */
U32 active_phy_fail_timeout;
U32 phy_lock = 0;
U32 reset_phy = 1;
U32 link_ready = 0;
U32 mac_notify_len = 0;

#define SENSE_MODE_TRIES	2

/*
 * phy reset state variables
 */
U32 gig_reset_state = RESET_PHY_GIG_RESET;
U32 gig_reset_timer;

/* need to save across invocations... */
U32 gig_reset_state_last = 0;

void reset_gig_phy(void);

static U32 validate_link(void);

static U32
validate_link(void)
{
#if (TIGON_REV & TIGON_REV5)
    ENABLE_MAC_RX();
    if (mac_mgt_state[TIGON_MAC_INDEX].link_set_gig & LNK_LOOPBACK) {
	U32 tx_enable = trp->mac_control.mac_tx_state & TG_MAC_TX_STATE_ENABLE;
	U32 i;
       
	trp->mac_control.mac_tx_state &= ~TG_MAC_TX_STATE_ENABLE;
       
	for (i=1; i<0x8000; i<<=1) {
	    trp->mac_control.mac_tx_config = i;
	    WAIT_US(1);
	    if (trp->mac_control.mac_rx_config != i)
		return(0);
	}
	trp->mac_control.mac_tx_state |= tx_enable;

	/* now set LINK ready as necessary, because this signal is
	 * solely dependent upon the received (from the wire) data
	 * signal.  Therefore we must sample it here and set it so
	 * that the bit in the RX state reg is correct.  It will be
	 * set differently if we are connected to an outside live
	 * fiber vs and unplugged fiber, even though we are in
	 * loopback mode.  */

	trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_LINK_POL_HIGH;
	WAIT_US(1);

	if (!(trp->mac_control.mac_rx_state & TG_MAC_RX_STATE_LINK_SYNC)) {
	    trp->mac_control.mac_rx_state &= ~TG_MAC_RX_STATE_LINK_POL_HIGH;
	    WAIT_US(1);
	}

	if (!(trp->mac_control.mac_rx_state & TG_MAC_RX_STATE_LINK_SYNC)) {
	    trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_LINK_POL_HIGH;
	    WAIT_US(1);
	}

	if (!(trp->mac_control.mac_rx_state & TG_MAC_RX_STATE_LINK_SYNC)) {
	    return(0);
	}

	/* clear attns */
	trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;

	return(1);
    } else {
	/* clear attns */
	trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;
	/* disable RX, this should cause an ATTN */
	trp->mac_control.mac_rx_state &= ~TG_MAC_RX_STATE_ENABLE;
	if (trp->mac_control.mac_rx_state &
	    (TG_MAC_RX_STATE_LINK_STATE_ATTN | TG_MAC_RX_STATE_NOT_SYNCED_ATTN)) {
	    /*
	     * link is valid, re-enable it...
	     */
	    trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_ENABLE;
	    /* clear attns */
	    trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;
	    return(1);
	} else {
	    return(0);
	}
    }
#else /* (TIGON_REV & TIGON_REV5) */
    /* clear attns */
    trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;
    if (trp->mac_control.mac_rx_state &
	(TG_MAC_RX_STATE_LINK_STATE_ATTN | TG_MAC_RX_STATE_NOT_SYNCED_ATTN)) {
	/*
	 * link is bad
	 */
	return(0);
    } else {
	/* clear attns */
	trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;
	return(1);
    }
#endif /* (TIGON_REV & TIGON_REV5) */
}

#define INT_SERDES_TUNE 0x00c80000 /* RZ = 01 */

void
init_mac1(void)
{
#if (TIGON_REV & TIGON_REV5)
    int i;
#endif /* if (TIGON_REV & TIGON_REV5) */

    /*
     * initialize threshholds and turn off MAC to prevent 
     * overrun before we start...
     */
    trp->mac_control.mac_thresholds = 0;

    trp->mac_control.mac_tx_state = TG_MAC_TX_STATE_RESET;
    trp->mac_control.mac_rx_state = TG_MAC_RX_STATE_RESET;

    /* initialize rx and tx buffer areas */
    trp->local_mem_conf.rx_buf_base = (U32)TDP->rx_buf;
    trp->local_mem_conf.rx_buf_producer = (U32)TDP->rx_buf;
    trp->local_mem_conf.rx_buf_consumer = (U32)TDP->rx_buf;
 
    trp->local_mem_conf.tx_buf_base = (U32)TDP->tx_buf;
    trp->local_mem_conf.tx_buf_producer = (U32)TDP->tx_buf;
    trp->local_mem_conf.tx_buf_consumer = (U32)TDP->tx_buf;
 
    /* initialize descriptor rings */
    trp->local_mem_conf.mac_rx_descr_producer = TDP->rx_mac_ring;
    trp->local_mem_conf.mac_rx_descr_consumer = TDP->rx_mac_ring;
    trp->local_mem_conf.mac_rx_descr_ref      = TDP->rx_mac_ring;
 
    trp->local_mem_conf.mac_tx_descr_producer = TDP->tx_mac_ring;
    trp->local_mem_conf.mac_tx_descr_consumer = TDP->tx_mac_ring;
    trp->local_mem_conf.mac_tx_descr_ref      = TDP->tx_mac_ring;

#if (TIGON_REV & TIGON_REV5)
    /*
     * initialize MAC descriptors so we can determine that they
     * are invalid
     */
    for (i=0; i<TG_NUM_MAC_RX_DESCRS; i++) {
	TDP->rx_mac_ring[i].w1 = 0x01000000;
	TDP->rx_mac_ring[i].w0 = 0;
    }
    for (i=0; i<TG_NUM_MAC_TX_DESCRS; i++) {
	TDP->tx_mac_ring[i].w1 = 0;
	TDP->tx_mac_ring[i].w0 = 0;
    }
    trp->mac_control.mac_phy_config = 0;
#endif /* if (TIGON_REV & TIGON_REV5) */
#if (TIGON_REV & TIGON_REV6)
    trp->mac_control.mac_phy_config = 0;
#endif /* if (TIGON_REV & TIGON_REV6) */

    WZERO((U32 *)0x80, 32 /* Words */ );           /* Zero MAC stats. */
 
    switch (TRP->gen_control.misc_host_control & TG_MHC_TIGON_VERSION_MASK) {

	case TG_MHC_LSI_STANDARD_CELL_VERS:
	    mac_notify_len = 0x700;	/* 56 bytes minimum - bug in Rev 5 */
	    break;

	case TG_MHC_LSI_GATE_VERS:
	case TG_MHC_LSI_STANDARD_CELL_VERS_B:
	    mac_notify_len = 0x800;	/* 64 bytes minimum */
	    break;

	default:
	    ASSERT(0);	/* XXX error! */
    }
 
    return;
}

/*
 * determine what type of PHY and how it is attached
 */
void
probe_phy(void)
{
    U16 mii_data;
    U16 mii_phy_id[2];
#if (TIGON_REV & TIGON_REV5)
    U32 i, j;
#endif  /* (TIGON_REV & TIGON_REV5) */

    attached_phy = 0;	/* initialize */

    /*
     * read the OUI of from the MII port.
     * We can determine what PHY part we are using from the
     * OUI and the part number.  If there is no response, we
     * can assume there is nothing connected to the MII/GMII
     * interface
     */
    write_mii_z();
    mii_data = MII_CONTROL_RESET;
    write_mii_mgt(1, MII_REG_CONTROL, &mii_data);
 
    WAIT_US(100);
    read_mii_mgt(1, MII_REG_STATUS, &mii_data);
    WAIT_US(100);
    read_mii_mgt(1, MII_REG_STATUS, &mii_data);

    WAIT_US(100);
    read_mii_mgt(1, MII_REG_PHY_ID0, &mii_phy_id[0]);
    WAIT_US(100);
    read_mii_mgt(1, MII_REG_PHY_ID1, &mii_phy_id[1]);

    if (mii_data) {
	attached_phy |= ATTACHED_PHY_IF_MII;
	/*
	 * something IS attached to the MII/GMII managment port
	 * determine what it is:
	 */
	if ((mii_phy_id[0] == 0x0015) && 
	    ((mii_phy_id[1] == 0xf423) || (mii_phy_id[1] == 0xf430))) {
		/*
		 * device is ICS 1890, revision 3
		 */
		mii_device_attached = MII_DEVICE_ICS_1890_2;
	    } else {
	if ((mii_phy_id[0] == 0x7810) && 
	    (mii_phy_id[1] == 0x0001)) {
		/*
		 * device is Level One LXT970, revision 1
		 */
		mii_device_attached = MII_DEVICE_LXT_970;
	} else {
		/*
		 * device is unknown 
		 */
		mii_device_attached = MII_DEVICE_UNKNOWN;
	    }
	}
    } else {
	mii_device_attached = MII_DEVICE_NONE;
#if (TIGON_REV & TIGON_REV4)
	/*
	 * we only have an external serdes on rev4 tigons
	 */
	attached_phy |= ATTACHED_PHY_IF_SERDES_EXT;
#endif  /* (TIGON_REV & TIGON_REV4) */
    }

#if (TIGON_REV & TIGON_REV5)
    /*
     * check for internal SERDES.  For boards using external SERDES, this
     * section of the chip is not powered, so it should fail.
     *
     * probe works like this:  
     *  set TX and RX clocks to internal SERDES
     *  reset MAC and disable TX to enable configs
     *  set internal SERDES to loopback
     *  sync SERDES
     *  write pattern to TX config register
     *  read RX config register and compare
     */

    active_phy = ATTACHED_PHY_IF_SERDES_INT;

    /*
     * Fix Gigablaze cold start errata
     * power cycle the internal SERDES before probing it...
     */
    trp->mac_control.mac_serdes_config =
	TG_MAC_SERDES_PDOWNT |
	TG_MAC_SERDES_PDOWNR |
	TG_MAC_SERDES_PDOWNB;

    WAIT_US(500);

    trp->mac_control.mac_serdes_config =
      TG_MAC_SERDES_RDWS |
      TG_MAC_SERDES_TDWS |
      TG_MAC_SERDES_ENSYNCDET |
      TG_MAC_SERDES_SYNCPOL |
      TG_MAC_SERDES_LOOPBACK |
      TG_MAC_SERDES_WRAPBACK |
      TG_MAC_SERDES_ENABLE |
      INT_SERDES_TUNE |
      TG_MAC_SERDES_RESET;

    WAIT_US(500);

    for (i = 0; i < 20; i++) {
	mac_reset();

	gig_reset_state = RESET_PHY_GIG_RESET;	
	while (gig_reset_state != RESET_PHY_GIG_READY)
	    reset_gig_phy();

	/*
	 * de-assert RESET and LOCKREF
	 */
	trp->mac_control.mac_serdes_config =
	    TG_MAC_SERDES_RDWS |
	    TG_MAC_SERDES_TDWS |
	    TG_MAC_SERDES_ENSYNCDET |
	    TG_MAC_SERDES_SYNCPOL |
	    TG_MAC_SERDES_LOCKREF |
	    TG_MAC_SERDES_WRAPBACK |
	    INT_SERDES_TUNE |
	    TG_MAC_SERDES_ENABLE;

	WAIT_US(10);

	ENABLE_MAC_RX();

	trp->mac_control.mac_tx_state &= ~TG_MAC_TX_STATE_ENABLE;

	for (j=1; j<0x8000; j<<=1) {
	    trp->mac_control.mac_tx_config = j;
	    WAIT_US(1);
	    if (trp->mac_control.mac_rx_config != j)
		break;
	}

	if (j == 0x8000) {
	    attached_phy |= ATTACHED_PHY_IF_SERDES_INT;
	    break;
	} 
    }

    /*
     * check for external SERDES.
     *
     * probe works like this:  
     *  set TX and RX clocks to external SERDES
     *  reset MAC and disable TX to enable configs
     *  set external SERDES to loopback
     *  sync SERDES
     *  write pattern to TX config register
     *  read RX config register and compare
     */

    active_phy = ATTACHED_PHY_IF_SERDES_EXT;

    for (i = 0; i < 100; i++) {

	mac_reset();

	gig_reset_state = RESET_PHY_GIG_RESET;	
	while (gig_reset_state != RESET_PHY_GIG_READY)
	    reset_gig_phy();

	/* allow SERDES to SYNC to reference clock */
	trp->gen_control.misc_local_control = 
	    (trp->gen_control.misc_local_control & 
		~(TG_MLC_MISC_OUT_0 | 
		  TG_MLC_MISC_OUT_1 |
		  TG_MLC_MISC_OUT_2)) |
	    TG_MLC_MISC_OUT_2 |		/* select 1000 */
	    TG_MLC_MISC_OUT_0 |		/* loopback */
	    TG_MLC_MISC_OUT_0_ENA |	/* loopback */
	    0;

	WAIT_US(10);

	/*
	 * re-enable phy to communicate with transciever
	 */
	trp->gen_control.misc_local_control = 
	    (trp->gen_control.misc_local_control & 
		~(TG_MLC_MISC_OUT_0 | 
		  TG_MLC_MISC_OUT_1 |
		  TG_MLC_MISC_OUT_2)) |
	    TG_MLC_MISC_OUT_2 |		/* select 1000 */
	    TG_MLC_MISC_OUT_1 |		/* lockref */
	    TG_MLC_MISC_OUT_1_ENA |	/* lockref */
	    TG_MLC_MISC_OUT_0 |		/* loopback */
	    TG_MLC_MISC_OUT_0_ENA |	/* loopback */
	    0;

	WAIT_US(10);

	trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;

	WAIT_US(100);

	ENABLE_MAC_RX();

	trp->mac_control.mac_tx_state &= ~TG_MAC_TX_STATE_ENABLE;

	for (j=1; j<0x8000; j<<=1) {
	    trp->mac_control.mac_tx_config = j;
	    WAIT_US(1);
	    if (trp->mac_control.mac_rx_config != j)
		break;
	}

	if (j == 0x8000) {
	    attached_phy |= ATTACHED_PHY_IF_SERDES_EXT;
	    break;
	} 
    }
    if (!(attached_phy & ATTACHED_PHY_IF_SERDES_EXT)) {
        trp->gen_control.misc_local_control = 
            (trp->gen_control.misc_local_control & 
             ~(TG_MLC_MISC_OUT_0 | 
               TG_MLC_MISC_OUT_1 |
               TG_MLC_MISC_OUT_2));
    }
#endif  /* (TIGON_REV & TIGON_REV5) */

    /*
     * now reset the state machines to the link will come up...
     */
    active_phy = 0;

    active_phy_fail = 1;
 
    active_phy_fail_timeout = 
	trp->gen_control.timer - ACTIVE_PHY_FAIL_TIMEOUT_USECS;

    LINK_UTRACE("ProbePhy", 0xd0100, attached_phy, mii_device_attached, 
	mii_phy_id[0], mii_phy_id[1]);
}

/*
 * master state machine from which all other link state machines are
 * run...
 *
 * This routine expects that attached_phy to contain the bits for
 * all the phys that are present.  Try each of them (if present) in
 * the order of internal serdes, external serdes, GMII, MII to obtain
 * link.  
 */

void
bringup_link(void)
{
    U32 no_phy = 4;	/* try all phys */
    U32 good_phy = 0;
    U32 next_phy = active_phy;
    U32 ticks;

    if (active_phy == ATTACHED_PHY_IF_MII) {
	if (mac_mgt_state[TIGON_MAC_INDEX].link_set_fast & LNK_PREF) {
	    ticks = 1000000;	/* 1 seconds */
	} else {
	    ticks = 300000;	/* 0.3 seconds */
	}
    } else {
	if (mac_mgt_state[TIGON_MAC_INDEX].link_set_fast & LNK_PREF) {
	    ticks = 2000000;	/* 2 seconds */
	} else {
	    ticks = 1000000;	/* 1 seconds */
	}
    }

    /*
     * set phy_lock to prevent a phy from EVER timing out
     */
    if ((((active_phy_fail_timeout + ticks) - 
	trp->gen_control.timer) >= ticks) && !phy_lock) {
	/*
	 * failed to successfully bring up the designated active phy
	 * select the next phy that is attached- but only if
	 * it is enabled...
	 */
	while (!good_phy && no_phy) {
	    no_phy--;

	    next_phy = next_phy >> 1;
	    if (!next_phy)
		next_phy = ATTACHED_PHY_IF_SERDES_INT;

	    if (next_phy & attached_phy) {
		if (next_phy == ATTACHED_PHY_IF_MII) {
		    if (mac_mgt_state[TIGON_MAC_INDEX].link_set_fast & LNK_ENABLE)
			good_phy = 1;
		} else {
		    if (mac_mgt_state[TIGON_MAC_INDEX].link_set_gig & LNK_ENABLE)
			good_phy = 1;
		}
	    }
	}
	active_phy = next_phy;
	LINK_TRACE(TRACE_TYPE_LNK_PHY, "ActivPhy", 0xd0e00,
	    attached_phy, active_phy, good_phy, 0);

	/*
	 * did we find a good attached phy?
	 */
	if (!good_phy)
	    return; /* early return */

	active_phy_fail_timeout = trp->gen_control.timer;

	active_phy_fail = 1;
    }

    if (active_phy_fail) {
	/* clear fail indication */
	active_phy_fail = 0;
     
	BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_RESET_START;
    }

    if (BRINGUP_LINK_STATE != BRINGUP_LINK_STATE_READY) {
        /* run link bringup state machine */
       activate_phy();
    } else {
        if ((active_phy != ATTACHED_PHY_IF_MII) &&
            (zs.link_conf_state != STATE_LINK_CONF_LINK_OK))
            /* now run the config state machine */
            autoneg_8023z(trp->mac_control.mac_rx_state);
    }
}

/*
 * try to make a given phy the active phy
 */
U32 activate_phy_last_phy = 0;
U32 activate_phy_last_state = 0;

void
activate_phy(void)
{
    /* mask off rx attn event...  */
    EVENT_MASK &= ~TG_FW_EVENT_MAC_RX_ATTN;

    if ((active_phy != activate_phy_last_phy) ||
	(BRINGUP_LINK_STATE != activate_phy_last_state)) {

	LINK_TRACE(TRACE_TYPE_LNK_PHY, "brguplnk", 0xc0101, 
	    BRINGUP_LINK_STATE, trp->mac_control.mac_rx_state, 
	    trp->mac_control.mac_tx_state, 
	    (active_phy == ATTACHED_PHY_IF_MII) ?
		mac_mgt_state[TIGON_MAC_INDEX].link_set_fast :
		mac_mgt_state[TIGON_MAC_INDEX].link_set_gig);

	activate_phy_last_phy = active_phy;
	activate_phy_last_state = BRINGUP_LINK_STATE;
    }

    switch (active_phy) {
	case ATTACHED_PHY_IF_MII:
	    switch (BRINGUP_LINK_STATE) {
		case BRINGUP_LINK_STATE_RESET_START:
		    /*
		     * now reset everything...
		     */
		    mac_reset();

		    link_attn_count = 0;

		    /*
		     * the MII chip can sometimes take as long as
		     * several seconds to re-negotiate, so unless we are
		     * changing the MII configuration, just see if we
		     * have link.
		     */
		    if (reset_phy) {
		        BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_RESET_WAIT;
			reset_phy = 0;
		    } else {
		        BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_READY_START;
		    }
		    break;

		case BRINGUP_LINK_STATE_RESET_WAIT:
		    /*
		     * reset and configure the MII attached phy
		     */
     		    reset_mii_phy();

		    if (mii_reset_state == RESET_PHY_MII_READY) {
			BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_STABILIZE_START;
		    }
		    break;

		case BRINGUP_LINK_STATE_STABILIZE_START:
		    /*
                     * re-setup the MII interface - this will reset the link
                     * state to reset_start, we must override it.
		     */
                    set_mac_link(TIGON_MAC_INDEX, active_phy, 
			mac_mgt_state[TIGON_MAC_INDEX].link_set_fast);
		    reset_phy = 0;

		    /* 10/100 interface doesn't need the STABILIZE_WAIT_STATE */
		    BRINGUP_LINK_STATE = 
			BRINGUP_LINK_STATE_FLAP_CHECK_START;
		    break;

		case BRINGUP_LINK_STATE_STABILIZE_WAIT:
		    /* this state not used for 10/100 */
		    LINK_UTRACE("lnkASSRT", 0xf0100, 0, 0, 0, 0);
		    ASSERT(0);
		    break;

		case BRINGUP_LINK_STATE_FLAP_CHECK_START:
		    /* clear the attn bits */
		    trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;

		    /* start the flaps timer */
		    bringup_link_timer = trp->gen_control.timer;

		    BRINGUP_LINK_STATE = 
			BRINGUP_LINK_STATE_FLAP_CHECK_WAIT;

		    break;

		case BRINGUP_LINK_STATE_FLAP_CHECK_WAIT:
		    /*
		     * see if we have link, or that we have exceeded our
		     * time to wait...
		     */
		    if (trp->mac_control.mac_rx_state & 
			TG_MAC_RX_STATE_LINK_SYNC) {
			BRINGUP_LINK_STATE = 
			    BRINGUP_LINK_STATE_READY_START;
			break;
		    }

		    /*
		     * Following computation is done the way it is to handle 
		     * the timer wrapping around...
		     */
		    if (((bringup_link_timer + 
			BRINGUP_10_100_FLAP_CHECK_TIMER) -
			trp->gen_control.timer) >= 
			    BRINGUP_10_100_FLAP_CHECK_TIMER) {
			active_phy_fail = 1;
			LINK_TRACE(TRACE_TYPE_LNK_PHY, "ActPhyFL", 0xc0136, 
			    active_phy,
			    mac_mgt_state[TIGON_MAC_INDEX].link_set_fast,
			    trp->mac_control.mac_rx_state,
			    0);
		    }
		    break;

		case BRINGUP_LINK_STATE_READY_START:
		    /* get current link state */
		    get_mac_link(TIGON_MAC_INDEX, active_phy);

		    /*
		     * now update the MAC to match the current PHY settings.
		     */
		    set_mac_active(TIGON_MAC_INDEX);

		    /* 
		     * no attns, but MII interface says link is down...
		     * This is done in a seperate step because get_mac_link()
		     * is an expensive operation
		     */
		    if (!(mac_mgt_state[TIGON_MAC_INDEX].link_state_fast & 
			LNK_UP)) {
			LINK_TRACE(TRACE_TYPE_LNK_PHY, "ActPhyFL", 0xc0131, 
			    active_phy,
		    	    mac_mgt_state[TIGON_MAC_INDEX].link_state_fast,
			    link_attn_count,
			    trp->mac_control.mac_rx_state);
			active_phy_fail = 1;
			break;	/* early break */
		    }

		    /*
		     * set up MAC TX length field...
		     */
		    if (mac_mgt_state[TIGON_MAC_INDEX].link_state_fast &
			LNK_FULL_DUPLEX) {
			trp->mac_control.mac_len = 
			    (trp->mac_control.mac_len & 
				TG_MAC_TX_LEN_TAG_TYPE_MASK) |
			    0x251f;
		    } else {
			/* half duplex */
			trp->mac_control.mac_len = 
			    (trp->mac_control.mac_len & 
				TG_MAC_TX_LEN_TAG_TYPE_MASK) |
			    0x241f;
		    }

		    /* return to normal operation */
		    EVENT_MASK |= TG_FW_EVENT_MAC_RX_ATTN;

		    ENABLE_MAC_RX();

		    BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_READY;
		    LINK_TRACE(TRACE_TYPE_LNK_PHY, "ActPhyOK", 0xc0135, 
			active_phy,
			mac_mgt_state[TIGON_MAC_INDEX].link_state_fast,
			mac_mgt_state[TIGON_MAC_INDEX].link_set_fast,
			trp->mac_control.mac_tx_state);

		    link_up_notify();

		    break;

		case BRINGUP_LINK_STATE_READY:
		    /* should never come here... */
		    break;
	    }
	    break;

	case ATTACHED_PHY_IF_SERDES_EXT:
	    switch (BRINGUP_LINK_STATE) {
		case BRINGUP_LINK_STATE_RESET_START:
		    /* inform the MP if link down immediately */
		    link_down_notify();

		    /*
		     * override phy failure indication from link_down_notify()
		     */
		    active_phy_fail = 0;

		    /* send config 0 to reset the other side... */
		    trp->mac_control.mac_tx_config = 0;
		    zs.last_tx_config = 0;

		    mac_reset();	

		    gig_reset_state = RESET_PHY_GIG_RESET;	

		    BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_RESET_WAIT;
		    break;

		case BRINGUP_LINK_STATE_RESET_WAIT:
		    /*
		     * reset and configure the MII attached phy
		     */
     		    reset_gig_phy();

		    if (gig_reset_state == RESET_PHY_GIG_READY) {
			BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_STABILIZE_START;
		    }
		    break;

		case BRINGUP_LINK_STATE_STABILIZE_START:
#if (TIGON_REV & TIGON_REV4)
		    /*
		     * re-enable phy to communicate with transciever
		     */
		    if (mac_mgt_state[TIGON_MAC_INDEX].link_set_gig & 
			LNK_LOOPBACK) {
			trp->gen_control.misc_local_control &= 
			    ~TG_MLC_SRAM_LADDR_22;
		    } else {
			trp->gen_control.misc_local_control &= 
			    ~TG_MLC_LOOPBACK;
		    }
#else  /* (TIGON_REV & TIGON_REV4) */
		    if (mac_mgt_state[TIGON_MAC_INDEX].link_set_gig & 
			LNK_LOOPBACK) {
			trp->gen_control.misc_local_control = 
			    (trp->gen_control.misc_local_control & 
				~(TG_MLC_MISC_OUT_0 | 
				  TG_MLC_MISC_OUT_1 |
				  TG_MLC_MISC_OUT_2)) |
			    TG_MLC_MISC_OUT_2 |		/* select 1000 */
			    TG_MLC_MISC_OUT_1 |		/* lockref */
			    TG_MLC_MISC_OUT_1_ENA |	/* lockref */
			    TG_MLC_MISC_OUT_0 |		/* loopback */
			    TG_MLC_MISC_OUT_0_ENA |	/* loopback */
			    0;
		    } else {
			trp->gen_control.misc_local_control = 
			    (trp->gen_control.misc_local_control & 
				~(TG_MLC_MISC_OUT_0 | 
				  TG_MLC_MISC_OUT_1 |
				  TG_MLC_MISC_OUT_2)) |
			    TG_MLC_MISC_OUT_2 |		/* select 1000 */
			    TG_MLC_MISC_OUT_1 |		/* lockref */
			    TG_MLC_MISC_OUT_1_ENA |	/* lockref */
			    0;
		    }

#endif  /* (TIGON_REV & TIGON_REV4) */

		    /* start the reset timer */
		    bringup_link_timer = trp->gen_control.timer;

		    BRINGUP_LINK_STATE = 
			BRINGUP_LINK_STATE_STABILIZE_WAIT;
		    break;

		case BRINGUP_LINK_STATE_STABILIZE_WAIT:
		    /*
		     * Following computation is done the way it is to handle 
		     * the timer wrapping around...
		     */
		    if (((bringup_link_timer + BRINGUP_1000_STABILIZE_TIMER) -
			trp->gen_control.timer) >= 
			    BRINGUP_1000_STABILIZE_TIMER) {
			BRINGUP_LINK_STATE = 
			    BRINGUP_LINK_STATE_FLAP_CHECK_START;
		    }
		    break;

		case BRINGUP_LINK_STATE_FLAP_CHECK_START:

		    /* clear attns */
		    trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;

		    /* send config 0 to reset the other side... */
		    trp->mac_control.mac_tx_config = 0;
		    zs.last_tx_config = 0;

		    /* start the flaps timer */
		    bringup_link_timer = trp->gen_control.timer;

		    BRINGUP_LINK_STATE = 
			BRINGUP_LINK_STATE_FLAP_CHECK_WAIT;
		    break;

		case BRINGUP_LINK_STATE_FLAP_CHECK_WAIT:

		    /*
		     * Following computation is done the way it is to handle 
		     * the timer wrapping around...
		     */
		    if (((bringup_link_timer + 
			BRINGUP_1000_FLAP_CHECK_TIMER) -
			trp->gen_control.timer) >=
			    BRINGUP_1000_FLAP_CHECK_TIMER) {
			BRINGUP_LINK_STATE =
			    BRINGUP_LINK_STATE_READY_START;
		    }

		    break;

		case BRINGUP_LINK_STATE_READY_START:
		    if (!validate_link()) {
			active_phy_fail = 1;
			LINK_TRACE(TRACE_TYPE_LNK_PHY, "ActPhyFL", 0xc0192,
			    active_phy,
			    trp->mac_control.mac_rx_state,
			    trp->mac_control.mac_tx_config,
			    trp->mac_control.mac_rx_config);
			break;  /* early break */
		    }
		    
		    /*
		     * set MAC TX control lengths...
		     */
		    trp->mac_control.mac_len = 
			(trp->mac_control.mac_len & 
			    TG_MAC_TX_LEN_TAG_TYPE_MASK) |
			0x251f;

		    BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_READY;

		    if (gig_negotiate && !link_sense_mode) {
			/* now run the config state machine */
			zs.link_conf_state = STATE_LINK_CONF_AUTONEG_ENABLE;
			autoneg_8023z(trp->mac_control.mac_rx_state);
		    } else {
			/*
			 * wait for idles...
			 */
			if (!(trp->mac_control.mac_rx_state & 
			    TG_MAC_RX_STATE_CONFIG_SYNC)) {

			    /*
			     * we're not negotiating, just go to the 
			     * proper state
			     */
			    zs.link_conf_state = STATE_LINK_CONF_LINK_OK;

			    /* return to normal operation */
			    EVENT_MASK |= TG_FW_EVENT_MAC_RX_ATTN;

			    /*
			     * turn on the appropriate MAC bits...
			     */
			    set_mac_active(TIGON_MAC_INDEX);

			    ENABLE_MAC_RX();

			    link_up_notify();

			    /* get current link state */
			    get_mac_link(TIGON_MAC_INDEX, active_phy);

			    break;	/* early break */
			}
		    }

		    /*
		     * try 2 times before we exit sense mode
		     */
		    if (link_sense_mode) {
			link_sense_countdown--;
			if (!link_sense_countdown) {
			    link_sense_mode = 0;
			    link_sense_countdown = SENSE_MODE_TRIES;
			}
		    }
		    break;

		case BRINGUP_LINK_STATE_READY:
		    /* shouldn't come here... */
		    break;
	    }
	    break;

	case ATTACHED_PHY_IF_SERDES_INT:
#if (TIGON_REV & TIGON_REV5)
	    switch (BRINGUP_LINK_STATE) {
		case BRINGUP_LINK_STATE_RESET_START:
		    /* inform the MP if link down immediately */
		    link_down_notify();

		    /*
		     * override phy failure indication from link_down_notify()
		     */
		    active_phy_fail = 0;

		    /* send config 0 to reset the other side... */
		    trp->mac_control.mac_tx_config = 0;
		    zs.last_tx_config = 0;

		    mac_reset();	

		    gig_reset_state = RESET_PHY_GIG_RESET;	

		    BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_RESET_WAIT;
		    break;

		case BRINGUP_LINK_STATE_RESET_WAIT:
		    /*
		     * reset and configure the MII attached phy
		     */
     		    reset_gig_phy();

		    if (gig_reset_state == RESET_PHY_GIG_READY) {
			BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_STABILIZE_START;
		    }
		    break;

		case BRINGUP_LINK_STATE_STABILIZE_START:
		    /*
		     * de-assert RESET and LOCKREF
		     */
		    if (mac_mgt_state[TIGON_MAC_INDEX].link_set_gig & 
			LNK_LOOPBACK) {
			trp->mac_control.mac_serdes_config =
			    TG_MAC_SERDES_RDWS |
			    TG_MAC_SERDES_TDWS |
			    TG_MAC_SERDES_ENSYNCDET |
			    TG_MAC_SERDES_SYNCPOL |
			    TG_MAC_SERDES_LOCKREF |
			    TG_MAC_SERDES_WRAPBACK |
			    INT_SERDES_TUNE |
			    TG_MAC_SERDES_ENABLE;
		    } else {
			trp->mac_control.mac_serdes_config =
			    TG_MAC_SERDES_RDWS |
			    TG_MAC_SERDES_TDWS |
			    TG_MAC_SERDES_ENSYNCDET |
			    TG_MAC_SERDES_SYNCPOL |
			    TG_MAC_SERDES_LOCKREF |
			    TG_MAC_SERDES_WRAPBACK |
			    TG_MAC_SERDES_LOOPBACK |
			    INT_SERDES_TUNE |
			    TG_MAC_SERDES_ENABLE;
		    }

		    /* start the reset timer */
		    bringup_link_timer = trp->gen_control.timer;

		    BRINGUP_LINK_STATE = 
			BRINGUP_LINK_STATE_STABILIZE_WAIT;
		    break;

		case BRINGUP_LINK_STATE_STABILIZE_WAIT:
		    /*
		     * Following computation is done the way it is to handle 
		     * the timer wrapping around...
		     */
		    if (((bringup_link_timer + BRINGUP_1000_STABILIZE_TIMER) -
			trp->gen_control.timer) >= 
			    BRINGUP_1000_STABILIZE_TIMER) {
			BRINGUP_LINK_STATE = 
			    BRINGUP_LINK_STATE_FLAP_CHECK_START;
		    }
		    break;

		case BRINGUP_LINK_STATE_FLAP_CHECK_START:

		    /* clear attns */
		    trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;

		    /* send config 0 to reset the other side... */
		    trp->mac_control.mac_tx_config = 0;
		    zs.last_tx_config = 0;

		    /* start the flaps timer */
		    bringup_link_timer = trp->gen_control.timer;

		    BRINGUP_LINK_STATE = 
			BRINGUP_LINK_STATE_FLAP_CHECK_WAIT;
		    break;

		case BRINGUP_LINK_STATE_FLAP_CHECK_WAIT:

		    /*
		     * Following computation is done the way it is to handle 
		     * the timer wrapping around...
		     */
		    if (((bringup_link_timer + 
			BRINGUP_1000_FLAP_CHECK_TIMER) -
			trp->gen_control.timer) >= 
			    BRINGUP_1000_FLAP_CHECK_TIMER) {
			BRINGUP_LINK_STATE = 
			    BRINGUP_LINK_STATE_READY_START;
		    }
		    break;

		case BRINGUP_LINK_STATE_READY_START:

		    if (!validate_link()) {
			active_phy_fail = 1;
			LINK_TRACE(TRACE_TYPE_LNK_PHY, "ActPhyFL", 0xc0194,
			    active_phy,
			    trp->mac_control.mac_rx_state,
			    trp->mac_control.mac_tx_config,
			    trp->mac_control.mac_rx_config);
			break;  /* early break */
		    }

		    /*
		     * set MAC transmit control lengths...
		     */
		    trp->mac_control.mac_len = 
			(trp->mac_control.mac_len & 
			    TG_MAC_TX_LEN_TAG_TYPE_MASK) |
			0x251f;

		    BRINGUP_LINK_STATE = BRINGUP_LINK_STATE_READY;

		    if (gig_negotiate && !link_sense_mode) {
			ENABLE_MAC_RX();

			/* now run the config state machine */
			zs.link_conf_state = STATE_LINK_CONF_AUTONEG_ENABLE;
			autoneg_8023z(trp->mac_control.mac_rx_state);
		    } else {
			/*
			 * wait for idles...
			 */
			if (!(trp->mac_control.mac_rx_state & 
			    TG_MAC_RX_STATE_CONFIG_SYNC)) {

			    /*
			     * we're not negotiating, just go to the 
			     * proper state
			     */
			    zs.link_conf_state = STATE_LINK_CONF_LINK_OK;

			    /* return to normal operation */
			    EVENT_MASK |= TG_FW_EVENT_MAC_RX_ATTN;

			    /*
			     * turn on the appropriate MAC bits...
			     */
			    set_mac_active(TIGON_MAC_INDEX);

			    ENABLE_MAC_RX();

			    link_up_notify();

			    /* get current link state */
			    get_mac_link(TIGON_MAC_INDEX, active_phy);

			    break;	/* early break */
			}
		    }

		    /*
		     * try 2 times before we exit sense mode
		     */
		    if (link_sense_mode) {
			link_sense_countdown--;
			if (!link_sense_countdown) {
			    link_sense_mode = 0;
			    link_sense_countdown = SENSE_MODE_TRIES;
			}
		    }
		    break;
		}
		break;
    #endif  /* (TIGON_REV & TIGON_REV5) */

	case ATTACHED_PHY_IF_GMII:
#if (TIGON_REV & TIGON_REV5)
	    /*
	     * XXX need to add GMII bringup state machine
	     */
	    break;
#endif  /* (TIGON_REV & TIGON_REV5) */

	default:
	    active_phy_fail = 1;
	    LINK_TRACE(TRACE_TYPE_LNK_PHY, "ActPhyFL", 0xc0135, 
		active_phy, 0, 0, 0);

    }
}

void
mac_reset()
{
    U32 tx_enable = 0;
    U32 rx_enable = 0;

    /* save state */
    tx_enable = trp->mac_control.mac_tx_state & TG_MAC_TX_STATE_ENABLE;
    rx_enable = trp->mac_control.mac_rx_state & TG_MAC_RX_STATE_ENABLE;

    /*
     * pause MAC state machines
     */
    trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_STOP_NEXT;
    trp->mac_control.mac_tx_state |= TG_MAC_TX_STATE_STOP_NEXT;

    switch (active_phy) {
        case ATTACHED_PHY_IF_MII:
#if (TIGON_REV & TIGON_REV5)
	    trp->gen_control.misc_config =
		(trp->gen_control.misc_config & 
		    ~(TG_MSC_TX_CLK_SEL_MASK | TG_MSC_RX_CLK_SEL_MASK)) |
		(TG_MSC_TX_CLK_SEL_MII | TG_MSC_RX_CLK_SEL_MII);
#endif  /* (TIGON_REV & TIGON_REV5) */

	    /*
	     * now reset mac state 
	     */
	    trp->mac_control.mac_tx_state = TG_MAC_TX_STATE_RESET;
	    trp->mac_control.mac_rx_state = TG_MAC_RX_STATE_RESET;

#if (TIGON_REV & TIGON_REV5)
	    /*
	     * turn off SERDES to save power
	     */
	    trp->mac_control.mac_serdes_config =
		TG_MAC_SERDES_PDOWNT |
		TG_MAC_SERDES_PDOWNR |
		TG_MAC_SERDES_PDOWNB;

	    trp->gen_control.misc_local_control = 
		(trp->gen_control.misc_local_control & 
		    ~(TG_MLC_MISC_OUT_0 | 
		      TG_MLC_MISC_OUT_1 |
		      TG_MLC_MISC_OUT_2)) |
		0;	/* select 100 */
#endif  /* (TIGON_REV & TIGON_REV5) */

	    /*
	     * Now re-enable things as appropriate
	     */
	    trp->mac_control.mac_tx_state =     /* enable */
		TG_MAC_TX_STATE_ENA_FULL_DUPLEX |
		save_tx_fctl_fast |
		TG_MAC_TX_STATE_ENABLE |
		0;

	    trp->mac_control.mac_rx_state =     /* enable */
		additional_rx_bits_wanted |
#if (TIGON_REV & TIGON_REV5)
	      /* LXT970 is polarity low, ICS is high */
	        ((mii_device_attached == MII_DEVICE_LXT_970)?0:
                TG_MAC_RX_STATE_LINK_POL_HIGH) | /* Claude's circuit */
#endif  /* (TIGON_REV & TIGON_REV5) */
		mac_notify_len |
		save_rx_fctl_fast |
		TG_MAC_RX_STATE_ENABLE |
		0;

            break;
 
        case ATTACHED_PHY_IF_GMII:
#if (TIGON_REV & TIGON_REV5)
	    trp->gen_control.misc_config =
		(trp->gen_control.misc_config & 
		    ~(TG_MSC_TX_CLK_SEL_MASK | TG_MSC_RX_CLK_SEL_MASK)) |
		(TG_MSC_TX_CLK_SEL_GMII | TG_MSC_RX_CLK_SEL_GMII);

	    /*
	     * now reset mac state 
	     */
	    trp->mac_control.mac_tx_state = TG_MAC_TX_STATE_RESET;
	    trp->mac_control.mac_rx_state = TG_MAC_RX_STATE_RESET;

	    /*
	     * turn off SERDES to save power
	     */
	    trp->mac_control.mac_serdes_config =
		TG_MAC_SERDES_PDOWNT |
		TG_MAC_SERDES_PDOWNR |
		TG_MAC_SERDES_PDOWNB;

	    if (gig_negotiate && !link_sense_mode) {
		trp->mac_control.mac_tx_state =   /* TX + clear attns */
		    TG_MAC_TX_STATE_ENA_GMII |
		    TG_MAC_TX_STATE_ENA_1000BASE_F |
		    TG_MAC_TX_ATTN_MASK |
		    TG_MAC_TX_STATE_ENA_FULL_DUPLEX |
		    save_tx_fctl_gig;
	    } else {
		trp->mac_control.mac_tx_state =   /* TX + clear attns */
		    TG_MAC_TX_STATE_ENABLE |      /* + ENABLE */
		    TG_MAC_TX_STATE_ENA_GMII |
		    TG_MAC_TX_STATE_ENA_1000BASE_F |
		    TG_MAC_TX_ATTN_MASK |
		    TG_MAC_TX_STATE_ENA_FULL_DUPLEX |
		    save_tx_fctl_gig;
	    }

	    trp->mac_control.mac_rx_state =   /* RX disable */
		additional_rx_bits_wanted |
		TG_MAC_RX_ATTN_MASK |
		save_rx_fctl_gig |
		mac_notify_len;

#endif  /* (TIGON_REV & TIGON_REV5) */
            break;
 
        case ATTACHED_PHY_IF_SERDES_EXT:
#if (TIGON_REV & TIGON_REV5)
	    trp->gen_control.misc_config =
		(trp->gen_control.misc_config & 
		    ~(TG_MSC_TX_CLK_SEL_MASK | TG_MSC_RX_CLK_SEL_MASK)) |
		(TG_MSC_TX_CLK_SEL_EXT_SERDES | TG_MSC_RX_CLK_SEL_EXT_SERDES);
#endif  /* (TIGON_REV & TIGON_REV5) */

	    /*
	     * now reset mac state 
	     */
	    trp->mac_control.mac_tx_state = TG_MAC_TX_STATE_RESET;
	    trp->mac_control.mac_rx_state = TG_MAC_RX_STATE_RESET;

	    if (gig_negotiate && !link_sense_mode) {
		trp->mac_control.mac_tx_state =   /* TX + clear attns */
		    TG_MAC_TX_STATE_ENA_ENCODING |
		    TG_MAC_TX_STATE_ENA_1000BASE_F |
		    TG_MAC_TX_ATTN_MASK |
		    TG_MAC_TX_STATE_ENA_FULL_DUPLEX |
		    save_tx_fctl_gig;
	    } else {
		trp->mac_control.mac_tx_state =   /* TX + clear attns */
		    TG_MAC_TX_STATE_ENABLE |      /* + ENABLE */
		    TG_MAC_TX_STATE_ENA_ENCODING |
		    TG_MAC_TX_STATE_ENA_1000BASE_F |
		    TG_MAC_TX_ATTN_MASK |
		    TG_MAC_TX_STATE_ENA_FULL_DUPLEX |
		    save_tx_fctl_gig;
	    }

	    trp->mac_control.mac_rx_state =   /* RX disable */
		additional_rx_bits_wanted |
#if (TIGON_REV & TIGON_REV5)
		TG_MAC_RX_STATE_LINK_POL_HIGH | /* Claude's circuit */
#endif  /* (TIGON_REV & TIGON_REV5) */
		TG_MAC_RX_ATTN_MASK |
		save_rx_fctl_gig |
		mac_notify_len;
            break;

        case ATTACHED_PHY_IF_SERDES_INT:
#if (TIGON_REV & TIGON_REV5)
	    trp->gen_control.misc_config =
		(trp->gen_control.misc_config & 
		    ~(TG_MSC_TX_CLK_SEL_MASK | TG_MSC_RX_CLK_SEL_MASK)) |
		(TG_MSC_TX_CLK_SEL_INT_SERDES | TG_MSC_RX_CLK_SEL_INT_SERDES);

	    /*
	     * now reset mac state 
	     */

	    if (gig_negotiate && !link_sense_mode) {
	        trp->mac_control.mac_tx_state = TG_MAC_TX_STATE_RESET;
	        trp->mac_control.mac_rx_state = TG_MAC_RX_STATE_RESET;

		trp->mac_control.mac_tx_state =   /* TX + clear attns */
		    TG_MAC_TX_STATE_ENA_ENCODING |
		    TG_MAC_TX_STATE_ENA_1000BASE_F |
		    TG_MAC_TX_ATTN_MASK |
		    TG_MAC_TX_STATE_ENA_FULL_DUPLEX |
		    save_tx_fctl_gig;
	    } else {
	        trp->mac_control.mac_tx_state =   /* TX + clear attns */
		    TG_MAC_TX_STATE_ENABLE |      /* + ENABLE */
		    TG_MAC_TX_STATE_ENA_ENCODING |
		    TG_MAC_TX_STATE_ENA_1000BASE_F |
		    TG_MAC_TX_ATTN_MASK |
		    TG_MAC_TX_STATE_ENA_FULL_DUPLEX |
		    save_tx_fctl_gig;
	    }

	    trp->mac_control.mac_rx_state =   /* RX disable */
		additional_rx_bits_wanted |
		TG_MAC_RX_STATE_LINK_POL_HIGH | /* Claude's circuit */
		TG_MAC_RX_ATTN_MASK |
		save_rx_fctl_gig |
		mac_notify_len;

#endif  /* (TIGON_REV & TIGON_REV5) */
            break;

	default:
	    /* XXX */
    }
}

#if (TIGON_REV & TIGON_REV4)
void
disable_mac_rx(void)
{
    U32 __mprod;
    U32 __timeout;
    trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_STOP_NEXT;
    if (active_phy != ATTACHED_PHY_IF_MII) {
        WAIT_US(2);
    } else {
        WAIT_US(7);
    }
    __mprod =  (U32)trp->local_mem_conf.mac_rx_descr_producer;
    if (__mprod & 7) {
        /*
         * wait for current packet to end
         */
        __timeout = trp->gen_control.timer + 50;
        while ( (__mprod ==
            (U32)trp->local_mem_conf.mac_rx_descr_producer) &&
                (__timeout - trp->gen_control.timer <= 50) )
            ;
    }
    trp->mac_control.mac_rx_state &= ~TG_MAC_RX_STATE_ENABLE;
}
#endif /* (TIGON_REV & TIGON_REV4) */

/*
 * insure compiler does not combine or reorder operations...
 */
#define __CB() __asm__( ".set noreorder ; .set reorder");

#if (TIGON_REV & TIGON_REV4)
void
reset_gig_phy(void)
{
    U32 j;
    struct tg_mac_descr *__Next, *__Curr, *__Cons;

    if (gig_reset_state != gig_reset_state_last) {
	LINK_TRACE(TRACE_TYPE_LNK_PHY, "rst_gig", 0xd0101, 
	    gig_reset_state, 0, 0, 0);
	gig_reset_state_last = gig_reset_state;
    }

    switch (gig_reset_state) {
	case RESET_PHY_GIG_RESET:
	    /* force quiet on the PHY */
	    trp->gen_control.misc_local_control |= 
		TG_MLC_LOOPBACK |
		TG_MLC_SRAM_LADDR_22;

	    gig_reset_timer = trp->gen_control.timer;

	    gig_reset_state = RESET_PHY_GIG_RESET_WAIT;
	    break;

	case RESET_PHY_GIG_RESET_WAIT:
	    /*
	     * Following computation is done the way it is to handle 
	     * the timer wrapping around...
	     */
	    if (((gig_reset_timer + 10000) -
		trp->gen_control.timer) >= 10000) {
		gig_reset_state = RESET_PHY_GIG_LOOPBACK_SYNC;
	    }
	    break;

	case RESET_PHY_GIG_LOOPBACK_SYNC:
	    /* now let it sync up... */
	    trp->gen_control.misc_local_control &= 
		~TG_MLC_SRAM_LADDR_22;

	    gig_reset_timer = trp->gen_control.timer;

	    gig_reset_state = RESET_PHY_GIG_LOOPBACK_SYNC_WAIT;
	    break;

	case RESET_PHY_GIG_LOOPBACK_SYNC_WAIT:
	    /*
	     * Following computation is done the way it is to handle 
	     * the timer wrapping around...
	     */
	    if (((gig_reset_timer + 10) -
		trp->gen_control.timer) >= 10) {
		gig_reset_state = RESET_PHY_GIG_DISPARITY_FIX;
	    }
	    break;

	case RESET_PHY_GIG_DISPARITY_FIX:

	    /* clear attns and check for flaps... */
	    trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;

	    /* validate link */
	    ENABLE_MAC_RX();
	    __CB();

	    trp->mac_control.mac_tx_state =   /* TX + clear attns */
		TG_MAC_TX_STATE_ENA_ENCODING |
		TG_MAC_TX_STATE_ENA_1000BASE_F |
		TG_MAC_TX_ATTN_MASK |
		TG_MAC_TX_STATE_ENA_FULL_DUPLEX;
	    __CB();

	    trp->mac_control.mac_tx_state &= ~TG_MAC_TX_STATE_ENABLE;
	    __CB();

	    /*
	     * this insures that we have sync in loopback...
	     */
	    for (j=1; j<0x10000; j<<=1) {
		trp->mac_control.mac_tx_config = j;

		WAIT_US(1);	/* XXX */

		if (trp->mac_control.mac_rx_config != j)
		    LINK_TRACE(TRACE_TYPE_LNK_PHY, "DispFixX", 0xd0ff1,
			trp->mac_control.mac_rx_state,
			trp->mac_control.mac_tx_config,
			trp->mac_control.mac_rx_config,
			j);
	    }

	    /*
	     * display state before we send something...
	     */
	    LINK_TRACE(TRACE_TYPE_LNK_PHY, "DispFix1", 0xd0cc1,
		trp->mac_control.mac_rx_state,
		trp->local_mem_conf.mac_rx_descr_producer,
		trp->local_mem_conf.mac_rx_descr_consumer,
		trp->local_mem_conf.mac_rx_descr_ref);
	    LINK_TRACE(TRACE_TYPE_LNK_PHY, "DispFix2", 0xd0cc2,
		trp->mac_control.mac_tx_state,
		trp->local_mem_conf.mac_tx_descr_producer,
		trp->local_mem_conf.mac_tx_descr_consumer,
		trp->local_mem_conf.mac_tx_descr_ref);

	    /* clear attns */
	    trp->mac_control.mac_rx_state |= TG_MAC_RX_ATTN_MASK;

	    /* set MAC TX control lengths... */
	    trp->mac_control.mac_len =
		(trp->mac_control.mac_len &
		    TG_MAC_TX_LEN_TAG_TYPE_MASK) |
		0x251f;

	    /* enable normal operation */
	    ENABLE_MAC_RX();

	    /* clear attns */
	    trp->mac_control.mac_rx_state |= 
		TG_MAC_RX_ATTN_MASK |
		TG_MAC_RX_STATE_ENA_PROMISC;

	    /* enable transmitter */
	    trp->mac_control.mac_tx_state =   /* TX + clear attns */
		TG_MAC_TX_STATE_ENABLE |      /* + ENABLE */
		TG_MAC_TX_STATE_ENA_ENCODING |
		TG_MAC_TX_STATE_ENA_1000BASE_F |
		TG_MAC_TX_ATTN_MASK |
		TG_MAC_TX_STATE_ENA_FULL_DUPLEX;

	    /* enqueue bogus frame */
	    __Curr = trp->local_mem_conf.mac_tx_descr_producer;
	    if (__Curr == &TDP->tx_mac_ring[TG_NUM_MAC_TX_DESCRS-1])
		__Next = TDP->tx_mac_ring;
	    else 
	        __Next = __Curr + 1;
	    (volatile)__Cons = trp->local_mem_conf.mac_tx_descr_consumer;
	    if (__Next != __Cons) {
		__Curr->w0 = (U32)&runt_frame;
		__Curr->w1 = RUNT_LEN | TG_MAC_TX_W1_NO_CRC;
		trp->local_mem_conf.mac_tx_descr_producer = __Next;
	    }
	    /*
	     * ignore if we can't put runt on queue, another frame will TX for
	     * us.
	     */

	    /* 
	     * we won't receive the frame because it is not addresses to 
	     * us AND because the CRC will fail.  Just check the MAC TX
	     * to insure that it was transmitted...
	     */
	    gig_reset_timer = trp->gen_control.timer;

	    gig_reset_state = RESET_PHY_GIG_DISPARITY_FIX_WAIT;
	    break;

	case RESET_PHY_GIG_DISPARITY_FIX_WAIT:
	    /*
	     * Following computation is done the way it is to handle 
	     * the timer wrapping around...
	     */
	    if (((gig_reset_timer + 10) -
		trp->gen_control.timer) >= 10) {
		gig_reset_state = RESET_PHY_GIG_CORRECT_DISPARITY;
	    }
	    break;

	case RESET_PHY_GIG_CORRECT_DISPARITY:
	    /*
	     * display state after we sent something...
	     */
	    LINK_TRACE(TRACE_TYPE_LNK_PHY, "DispFix3", 0xd0cc3,
		trp->mac_control.mac_rx_state,
		trp->local_mem_conf.mac_rx_descr_producer,
		trp->local_mem_conf.mac_rx_descr_consumer,
		trp->local_mem_conf.mac_rx_descr_ref);
	    LINK_TRACE(TRACE_TYPE_LNK_PHY, "DispFix4", 0xd0cc4,
		trp->mac_control.mac_tx_state,
		trp->local_mem_conf.mac_tx_descr_producer,
		trp->local_mem_conf.mac_tx_descr_consumer,
		trp->local_mem_conf.mac_tx_descr_ref);

	    /* 
	     * ok, now go back to the state we left, before the
	     * workaround...
	     */
	    trp->local_mem_conf.mac_rx_descr_consumer = 
		trp->local_mem_conf.mac_rx_descr_producer;
	    trp->local_mem_conf.mac_rx_descr_ref = 
		trp->local_mem_conf.mac_rx_descr_producer;

	    trp->mac_control.mac_rx_state |= TG_MAC_RX_STATE_STOP_NEXT;
	    trp->mac_control.mac_rx_state &= ~TG_MAC_RX_STATE_ENA_PROMISC;

	    /* force quiet on the PHY */
	    trp->gen_control.misc_local_control |= 
		TG_MLC_LOOPBACK |
		TG_MLC_SRAM_LADDR_22;

	    gig_reset_timer = trp->gen_control.timer;

	    gig_reset_state = RESET_PHY_GIG_RESET_WAIT_2;
	    break;

	case RESET_PHY_GIG_RESET_WAIT_2:
	    /*
	     * Following computation is done the way it is to handle 
	     * the timer wrapping around...
	     */
	    if (((gig_reset_timer + 
		BRINGUP_1000_RESET_TIMER) -
		trp->gen_control.timer) >= 
		    BRINGUP_1000_RESET_TIMER) {
		gig_reset_state = RESET_PHY_GIG_READY;
	    }
	    break;

	case RESET_PHY_GIG_READY:
	    /*
	     * this should never be reached...
	     */
	    ASSERT(0); /* XXX */

        default:
	    /*
	     * this should never be reached...
	     */
	    ASSERT(0); /* XXX */
    }
}
#endif /* TIGON_REV & TIGON_REV4 */

#if (TIGON_REV & TIGON_REV5)
void
reset_gig_phy(void)
{

    if (gig_reset_state != gig_reset_state_last) {
	LINK_TRACE(TRACE_TYPE_LNK_PHY, "rst_gig", 0xd0101, 
	    gig_reset_state, 0, 0, 0);
	gig_reset_state_last = gig_reset_state;
    }

    switch (gig_reset_state) {
	case RESET_PHY_GIG_RESET:
	    switch (active_phy) {
		case ATTACHED_PHY_IF_SERDES_INT:
		    trp->mac_control.mac_serdes_config =
		      TG_MAC_SERDES_RDWS |
		      TG_MAC_SERDES_TDWS |
		      TG_MAC_SERDES_ENSYNCDET |
		      TG_MAC_SERDES_SYNCPOL |
		      TG_MAC_SERDES_LOOPBACK |
		      TG_MAC_SERDES_WRAPBACK |
		      TG_MAC_SERDES_ENABLE |
		      INT_SERDES_TUNE |
		      TG_MAC_SERDES_RESET;
		    break;

		case ATTACHED_PHY_IF_SERDES_EXT:
		    trp->mac_control.mac_serdes_config =
			TG_MAC_SERDES_RESET |
			TG_MAC_SERDES_PDOWNT |
			TG_MAC_SERDES_PDOWNR |
			TG_MAC_SERDES_PDOWNB;

		    trp->gen_control.misc_local_control = 
			(trp->gen_control.misc_local_control & 
			    ~(TG_MLC_MISC_OUT_0 | 
			      TG_MLC_MISC_OUT_1 |
			      TG_MLC_MISC_OUT_2)) |
			TG_MLC_MISC_OUT_2 |	/* select 1000 */
			0;
		    break;

		default:
		    ASSERT(0);	/* XXX */
	    }

	    gig_reset_timer = trp->gen_control.timer;

	    gig_reset_state = RESET_PHY_GIG_RESET_WAIT;
	    break;

	case RESET_PHY_GIG_RESET_WAIT:
	    /*
	     * Following computation is done the way it is to handle 
	     * the timer wrapping around...
	     */
	    if (((gig_reset_timer + 
		BRINGUP_1000_RESET_TIMER) -
		trp->gen_control.timer) >= 
		    BRINGUP_1000_RESET_TIMER) {
		gig_reset_state = RESET_PHY_GIG_READY;
	    }
	    break;

	case RESET_PHY_GIG_READY:
	    /*
	     * this should never be reached...
	     */
	    ASSERT(0); /* XXX */

        default:
	    /*
	     * this should never be reached...
	     */
	    ASSERT(0); /* XXX */
    }
}
#endif /* TIGON_REV & TIGON_REV5 */



/*****************************************************************************/
