/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996 
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: led.c,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.2.1  1997/11/15  18:38:38  hayes
 * 	initial checkin
 * 	[1997/11/15  18:37:31  hayes]
 *
 * $EndLog$
 */

#if defined(_SP_CONF_H_)
#include "sp_regs.h"
#endif /* defined(_SP_CONF_H_) */

/*
 * Set the LEDs by toggling a serial line to a serial to parallel 
 * shift register.
 *
 * This is designed to use the National 74ACT164
 * LED_DATA is used for the data and LED_LINK is used for
 * clock.  The data must be presented before the rising edge of
 * each clock.
 *
 * See led.h for definition of the bits.
 *
 * This implementation ignores the UART bits, since they are not used
 * on the NIC or the SPs.  If the UART needs to be used in conjunction
 * with this code, we must mask off the UART bits whenever we write the
 * Misc Local Control register to avoid inadvertantly clearing our UART
 * state.
 */

#include "led.h"

void
set_led(U8 bits)
{
    int i;

    for (i = 0; i<8; i++) {
	if ((bits >> i) & 1) {
	    /* turn bit on */
	    TRP->gen_control.misc_local_control |= SER_LED_DATA;
	    /* clock up */
	    TRP->gen_control.misc_local_control |= SER_LED_CLK;
	    /* clock down */
	    TRP->gen_control.misc_local_control &= ~SER_LED_CLK;
	} else {
	    /* turn bit off */
	    TRP->gen_control.misc_local_control &= ~SER_LED_DATA;
	    /* clock up */
	    TRP->gen_control.misc_local_control |= SER_LED_CLK;
	    /* clock down */
	    TRP->gen_control.misc_local_control &= ~SER_LED_CLK;
	}
    }
}

