/*
 * COPYRIGHT NOTICE
 * Copyright (c) Alteon Networks, Inc. 1996 
 * All rights reserved
 * 
 */
/*
 * HISTORY
 * $Log: alt_def.h,v $
 * Revision 1.4  1999/06/22 12:43:01  tjd21
 * Before removing extra recv rings
 *
 * Revision 1.1  1999/06/07 10:53:09  tjd21
 * Start of archive
 *
 * Revision 1.1.4.6  1999/02/16  18:53:23  wayne
 * 	Define NBBY early in a manner that is compatible with
 * 	/usr/local/lib/gcc-lib/sparc-sun-solaris2.5.1/2.7.2/include/sys/param.h
 * 	so that /usr/include/sys/select.h won't try to redefine it in an
 * 	incompatible manner.
 * 	[1999/02/16  18:35:34  wayne]
 *
 * Revision 1.1.4.5  1999/02/13  23:55:59  wayne
 * 	This check-in hopefully provides the mechanism for solving the
 * 	Solaris /usr/include/sys/types.h problem once and for all.  The
 * 	problem is that Solaris's types.h and Epilogue's types.h both
 * 	define boolean_t, and Epilogue's is needed for lib/epi, while
 * 	Solaris's is needed for SUN_MP threads.  This solution says if
 * 	Epilogue's has already been included, then DON'T include
 * 	Solaris's; otherwise go ahead and include Solaris's and set a
 * 	flag that tells Epilogue to not try to define boolean_t itself
 * 	(the __TYPES_HAVE_booleatn_t_ flag that was already in Epilogue).
 * 
 * 	The previous solution was to create our own copy of Solaris's
 * 	types.h in libcommon/sys, but that's stupid since Solaris will be
 * 	growing and growing.  Hopefully that's no longer necessary in the
 * 	GNE world.  (I am NOT planning on backporting this fix into the
 * 	Tigon (ts) branch, which is why it is #ifdeffed HW_GS.)
 * 	[1999/02/13  23:41:42  wayne]
 * 
 * Revision 1.1.4.4  1998/07/16  21:39:32  tibor
 * 	added MAX macro
 * 	[1998/07/16  20:47:24  tibor]
 * 
 * Revision 1.1.4.3  1998/06/23  00:29:36  shuang
 * 	include tg_rev.h for tigon revision definitions
 * 	[1998/06/22  23:14:31  shuang]
 * 
 * Revision 1.1.4.2  1998/04/24  01:05:07  kyung
 * 	added first cut web support
 * 	[1998/04/24  01:03:22  kyung]
 * 
 * Revision 1.1.4.1  1997/04/16  22:40:37  mlin
 * 	Add #ifndef TRUE.
 * 	[1997/04/15  21:12:36  mlin]
 * 
 * Revision 1.1.2.6  1996/11/22  23:15:11  ted
 * 	Changed Uxx typedefs to #defines so that we can do #if defined(Uxx)
 * 	Added new #defines for Sxx (signed quantities).
 * 	Added typedef unsigned char bool
 * 	[1996/11/22  23:11:56  ted]
 * 
 * Revision 1.1.2.5  1996/11/20  20:04:02  ted
 * 	Add PTR_ARE_64 and ALT_BIG_ENDIAN so proper structures in nic_conf.h ...
 * 	are picked up.
 * 	[1996/11/20  19:43:44  ted]
 * 
 * Revision 1.1.2.4  1996/11/14  23:12:30  wayne
 * 	Add #define REG register
 * 	[1996/11/14  23:12:19  wayne]
 * 
 * Revision 1.1.2.3  1996/11/13  00:36:17  wayne
 * 	No changes
 * 	[1996/11/13  00:10:13  wayne]
 * 
 * Revision 1.1.2.2  1996/11/12  22:03:53  wayne
 * 	Semicolons after typedefs
 * 	[1996/11/12  22:03:42  wayne]
 * 
 * Revision 1.1.2.1  1996/11/12  01:13:42  wayne
 * 	General company-wide typedefs and #defines -- *FIRST* include file
 * 	[1996/11/12  01:13:26  wayne]
 * 
 * $EndLog$
 */

#ifndef _ALT_DEF_H_
#define _ALT_DEF_H_

#include "tg_rev.h"	/* tigon revisions */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 * Very basic Alteon definitions -- should be FIRST file included.
 */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *  First some basic typedefs and #defines...
 */

#define U64 unsigned long long
#define U32 unsigned long
#define U16 unsigned short
#define U8  unsigned char
#define S64 signed long long
#define S32 signed long
#define S16 signed short
#define S8  signed char

typedef void VOID;
typedef unsigned char bool;

#define VOLATILE volatile

#define REG register

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL  0
#endif

#define NULLP (void *)NULL

/* things to make NIC and host code play together well */
/* NOTE: this file is only used by non-host code */
#define ALT_BIG_ENDIAN 1
#define PTRS_ARE_64 1

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *  Now some general-purpose macros...
 */

#define MIN(a,b)  ((a)<(b)?(a):(b))
#define MAX(a,b)  ((a)>(b)?(a):(b))

#if (defined(HW_GS) && defined(SUN_MP))
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*
 *  The following is an EGREGIOUS hack -- trying to get Epilogue to
 *  tolerate coexistence with Solaris headers that define similar things!
 */
#define NBBY 8

#if !defined(EPILOGUE_TYPES_H)
#define __TYPES_HAVE_boolean_t_         /* stop Epi from redefining boolean_t */
#include </usr/include/sys/types.h>
#endif /* !defined(EPILOGUE_TYPES_H) */

#endif /* (defined(HW_GS) && defined(SUN_MP)) */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#endif /* _ALT_DEF_H_ */
