/*
 * $ID: $
 * (C) 2001 Mixerton Flash BIOS for H8S
 * www.mixerton.com
 * DJ Greaves
 *
 *  16-Dec-03 check block is clear after erase and added EA command.
 *  26-Nov-02 not to enable interrupts in the mfshim.S leaf call routines.
 *
 */ 

#include "prstdio.h"
#include "mixflash.h"

#define version_string "MIXERTON FLASH BIOS i 19-May-05"

extern void craft_wrch(char u);

void craft_putchar(char c)
{
  craft_wrch(c);
  if (c=='\n') craft_wrch(13);
}



void flashprog_install_code()
{
  extern char ramrtn_text_start[], ramrtn_text_end[];
  char *p = ramrtn_text_start;
  short int i;
  const int len = ramrtn_text_end - ramrtn_text_start;
  char *d = (char *) MEM_CODE_REGION;
  for (i=0;i<len;i++) 
    {
      /*       printf("%x ", d); */
      *d++ = *p++;
    }
}


int ihex_verify(char *dest, char *src, short int len)
{
  while (len-- > 0)
    {
      if (*dest++ != *src++) return 1;
    }
  return 0;
}

int  mf_verify(char *dest, char *src, short int len)
{
  while(len > 0)
    {
      if (*dest ++ != *src++) return 1;
      len --;
    }
  return 0;
}


void ihex_write(char *dest, char *src, short int len)
{
  if (dest >= (char *) 0x200000)
    {
      while (len-- > 0)
	{
	  *dest++ = *src++;
	}
    }
  else if (LOAD_POINT >= (char *) 0x20000 || dest >= (char *) CODE_BASE)
    {
      flashprog_install_code();
      mf_flash_write(dest, src, len);
      if (len > 1) mf_flash_write(dest+1, src+1, len-1);
    }
}


short int checkblank(long int s)
{
  long int r;
  for (r=0;r < 0x10000; r++)
    {
      if (((unsigned short int *)s)[r] != 0xFFFF) break;
    }
  if (r != 0x10000) 
    {
      printf("Erase failed blank test at %x\n", s+r*2);
      return 16;
    }
  return 0;
}


/*
 *
 */
short int flash_erase(long int s)
{
  short int attempts = 4;
  short int rc;
  while (1)
    {
      flashprog_install_code();
      rc = flash_sector_erase_lowlev((char *)s);
      if (flash_sector_erase_lowlev((char *)(s+1))) rc |= 2 ;
      rc |= checkblank(s);
      if (!rc) break;
      printf("Erase failed ya, code=%04X", rc);
      printf("     A=%x\n", s);
      attempts --;
      if (attempts == 0) break;
      printf("Retry erase %x\n", attempts);
    }
  return attempts;
}


/*
 *
 */
void bot_flash_erase(unsigned long int load_point)
{
  if (load_point < 0x20000) 
    {
      printf("BER: would be suicide\n");
    }
  else
    {
      short int a;
      printf("BER: S ");
      a = flash_erase(0);
      printf("BER Done. rc=%x\n", a);
    }
}


short int flash_erase_cmd(int verbosef, int allf)
{
  unsigned long int b;
  if (verbosef) printf("S ");
  flash_erase(0x020000);
  if (verbosef) printf("E2 ");
  mf_flash_write(0x020000, 0, 32767);
  if (verbosef) printf("C1 ");
  mf_flash_write(0x020001, 1, 32767);
  if (verbosef) printf("C2 ");
  if (mf_verify((char *)0x020000, 0, 32767)) return 1;
  if (verbosef) printf("VC ");
  mf_erase_self_and_retriev();
  if (verbosef) printf("T ");
 
  b = 0x020000;
  while (b < 0x100000)
    {
      flash_erase(b);
      if (verbosef) printf("D ");
      if (!allf) break;
      b += 0x20000;
    }
  return 0;
}

/*
 * Simple line input with no echo. Return NULL on escape.
 */
char *simplelinein()
{
  int i = 0;
  while(1)
    {
      char c = getchar();
      if (c == 'M') { fastloader(); continue; }
      while(c != (char) 13 && i < MAXLINE-1)
	{
	  if (c== (char)27) return NULL;
	  if (c >= ' ')
	    {
	      /* Skip leading spaces - useful as pads for ihex download before the colon */
	      if (c != ' ' || i != 0) linebuffer[i++] = c;
	    }
	  c = getchar();
	}
      linebuffer[i] = (char) 0;
      return linebuffer;
    }
}

void banner()
{
  printf("\n\nMixerton flash BIOS. Commands are m ER+ EA+ BER M v s :\n"); 
}

void enter_image()
{
  if (*((short int *)CODE_FLAG_PLACE)==CODE_FLAG)
    {
      loaded_image();
    }
  banner();
  printf("No flash image\n"); 
}



/*
 * Simple shell for Cambertronics flash programming mode.
 */
void progshell()
{
  errorf = 0;
  ihex_offset = 0;
  while (errorf==0)
    {
      printf("(ER)ase or send data:");
      while(1)
	{
	  char *cmd, **argv;
	  cmd = simplelinein();
	  if (cmd == NULL) break;

	  if (cmd[0] == 'e' && cmd[1] == 'e') loaded_image();

	  else if (cmd[0] == 'E' && cmd[1] == 'A') /* Erase all */
	    {
	      if (flash_erase_cmd(cmd[2]=='+', 1) == 0)
		printf("Flash memory all erased\n");
	      else printf("Memory erase FAILED\n");
	    }
	  if (cmd[0] == 'E' && cmd[1] == 'R')
	    {
	      if (flash_erase_cmd(cmd[2]=='+', 0) == 0)
		printf("Flash memory low 2 blocks erased\n");
	      else printf("Memory erase FAILED\n");
	    }
	  else if (cmd[0] == 'B' && cmd[1] == 'E' && cmd[2] == 'R')
	    {
	      bot_flash_erase((int)LOAD_POINT);
	    }
	  else if (cmd[0] == 'm') mymon_main();
	  else if (cmd[0] == 's') code_checksum(CODE_BASE, CODE_END);
	  else if (cmd[0] == 'v') 
	    {
	      printf(version_string);
	      printf(" 0x%x\n", LOAD_POINT);
	    }
	  else if (cmd[0] == ':')
	    {
	      char c = handle_ihex(cmd);
	      putchar(c); 
	    }
	  else if (cmd[0] == (char) 0) continue;
	  else 
	    {
	      printf("bad %x\n", cmd[0]);
	      banner();
	    }
	}
    }
  printf("Download error. Exit from program shell\n");
}


/* 
 * Quick and dirty loader for loading to RAM without checking.
 */
fastloader()
{
  char *a;
  int sa = digit(getchar());
  sa = (sa << 4) | digit(getchar());

  sa = (sa << 4) | digit(getchar());
  sa = (sa << 4) | digit(getchar());
  sa = (sa << 4) | digit(getchar());
  sa = (sa << 4) | digit(getchar());
  a = (char *) sa;
  putchar('*');
  while(1)
    {
      uchar d; char c = getchar();
      if (c == (char) 27) return;
      if (c == '.') break;
      d = digit(c) << 4;
      d |= digit(getchar());
      *a++ = d;
    }
  if (1)
    {
      int (*f)() = sa;
      printf("Load/go %x,%x\n", sa, a);
      f();
    }
}


#define PORT5_DATA 0xffff54
#define PORT5_DDR  0xfffEB4




int main()
{
  int c;
  if (craft_testch())
    {
      /* Enter progshell if an escape received during power up */
      if (craft_rdch() == 27) progshell();
    }
  /* Enter prog shell on grounding bit0 of port 5 */
  *((char *)PORT5_DDR) = 0;
  c = *((char *)PORT5_DATA);
  if ((c & 1)==0) progshell();

  enter_image();
  progshell();
  mymon_main();
  return 0;
}


/* eof */
