        ; odshim.S
	;
	;; A bootstrap loader for the mixflash loader itself.
	; 
 	; (C) 2004 Mixerton.ST  www.mixerton.com
	; This shim has a delay in it after flash write - seems better.
	; 
	.h8300h			; 
	.set	StackTop,0xFFFBF0

	.set dirty_loc,0x804444
	
	.set flash_base,0x000000
	;; System Control Register
	.set syscr,0xffff39
 	
	;; Port 1
	.set p1ddr,0xfffeb0
	.set p1dr,0xffff60

	;; Port 3
	.set p3ddr,0xfffeb2
	.set p3dr,0xffff62
	
	;; Port 5
	.set p5ddr,0xfffeb4
	.set p5dr,0xffff64
	.set p5data,0xffff54
	
 	;; Serial port 0 is PIC control
	.set scr0,0xffff7a		; serial control reg
	.set rdr0,0xffff7d
	.set ssr0,0xffff7c		;  rate
 	.set brr0,0xffff79		;  
	.set smr0,0xffff78		;
	.set tdr0,0xffff7b	;  transmit data reg

 	;; Serial port 1 is ops and maintenance port
	.set scr1,0xffff82		; serial control reg
	.set rdr1,0xffff85
	.set ssr1,0xffff84		;  rate
 	.set brr1,0xffff81		;  16 for 19200
	.set smr1,0xffff80		;
	.set tdr1,0xffff83	;  transmit data reg

	;; Port G
	.set pgddr,0xfffebf	;  Needed for the CSn outputs
	.set mstp,0xffff3c	;  module stop register
	;; Bus Controller Registers
	.set bcrl,0xfffed5
	.set bcrh,0xfffed4
	.set wcrl,0xfffed3
	.set wcrh,0xfffed2
	;;
	;; On chip RAM resources
	
	

;
; Cold Reset Vectors and low stuff
;
	.set	prod_isr,0xFFF00C

	
cold_start:			; This should be in on chip ram
	mov.l	#StackTop,er7
	mov.l	er7,er6		;  Establish a C frame pointer
		;; 	jsr	__crt0
	jsr	_main
_exit:	
	jmp 0  			; or whever the vector says if done correctly.

;-------------------
_craft_rdch:
	btst	#6,@ssr1
	beq	_craft_rdch
	
rdch1:	mov.b	@rdr1,r0l 
	bclr	#6,@ssr1
	bclr	#7,r0l
	rts
;-------------------
_craft_wrch:
sa_wrch_1:	
	btst	#7,@(ssr1)	; Bit 7 is a one if we can send
	beq	sa_wrch_1	; the next char.
	mov.b	r0l,@(tdr1)
	bclr	#7,@ssr1
	rts

; ----------------------------------------------------------------
;;  The lowlev routines are in RAM all the time of course!


_mf_flash_write:	 
mf_flash_write_core:	
	mov.l	er0, er3	;  dest to er3

	mov.b	#0xAA,r0l
	mov.b	r0l,@wcrl	;  Select two wait states for flash write.
fw32a:		
	mov.w 	#0xF0F0,r0	;  Reset
	mov.w	r0,@(flash_base)

; Open the chip and sector in er3.
	btst	#0,r3l
	bne	flash_lower


	mov.w 	#0xAAFF,r0	;  AA to 555
	mov.w	r0,@(flash_base+(0x555<<1))
	mov.w	#0x55FF,r0	; 55 to 2AA
	mov.w	r0,@(flash_base+(0x2AA<<1))
	mov.w 	#0xA0FF,r0	; A0 to 555
	mov.w	r0,@(flash_base+(0x555<<1))
	bra fw_core1

flash_lower:
	mov.w 	#0xFFaa,r0	;  AA to 555
	mov.w	r0,@(flash_base+(0x555<<1))
	mov.w	#0xFF55,r0	; 55 to 2AA
	mov.w	r0,@(flash_base+(0x2AA<<1))
	mov.w 	#0xFFa0,r0	; A0 to 555
	mov.w	r0,@(flash_base+(0x555<<1))
fw_core1:
	;; Chip now opened
	mov.b	@er1,r0l	;  Get src byte
	mov.b	r0l,@er3	;  Store it in flash

	mov.w	#50,r0		; Mini delay
xl1:	
	mov.w	r2,@(dirty_loc)
	add.w	#(65536-1),r0	; > 80 microseconds.
	bne	xl1
	
	;;
	;; Now must wait for flash write to complete in this poll loop.
	;;
fw32p:
	nop
	mov.b	@er1,r0l	; Read old - causes bus cycle
	mov.b	r0l,@(dirty_loc); Store old - causes bus cycle
	mov.b	@er3,r0h	; Read new from flash.
	cmp.b	r0h,r0l		; Compare
	bne	fw32p		; Poll until correct.

	add.l	#2,er3		; Advance dest to next byte within same chip
	add.l	#2,er1		; Advance src to corresponding next byte
	sub.w	#1,r2
	beq	fw32d		; done when r2 gets to zero
	sub.w	#1,r2
	bne	fw32a:16	; loop back for next byte
fw32d:	

	mov.w 	#0xF0F0,r0	;  Reset
	mov.w	r0,@(flash_base)

	rts


	
;--------------------------------------------------------------
	;; EOF



