/*
 *
 * (C) 2003 Odette - minimal flash writer
 * www.mixerton.com
 * DJ Greaves
 *
 *
 */ 

#include "prstdio.h"
#include "mixflash.h"

extern void craft_wrch(char u);

void craft_putchar(char c)
{
  craft_wrch(c);
  if (c=='\n') craft_wrch(13);
}


void writes(char *s)
{
  while (*s) craft_putchar(*s++);
}



int ihex_verify(char *dest, char *src, short int len)
{
  const int flash = 0x200000;
  if (dest < (char *) 0x8000) dest += flash;

  while (len-- > 0)
    {
      if (*dest++ != *src++) return 1;
    }
  return 0;
}

int  mf_verify(char *dest, char *src, short int len)
{
  const int flash = 0x200000;
  if (dest < (char *) 0x8000) dest += flash;
  while(len > 0)
    {
      if (*dest ++ != *src++) return 1;
      len --;
    }
  return 0;
}


void ihex_write(char *dest, char *src, short int len)
{
  const int flash = 0x200000;
  if (dest < (char *) 0x8000) dest += flash;

  if (len > 1) mf_flash_write(dest+1, src+1, len-1);
  mf_flash_write(dest, src, len);
}



#define toupper(X) X

int iread(len)
{
  int r = 0;
  int i;
  for (i=0; i < len; i++)
  {
    char c = toupper(*inpoi++);
    while (c == ' ') c = toupper(*inpoi++);
    c = (c <= '9') ? c-'0': c-('0'+7);
    r = (r<<4) + c;
  }
  return r;
}

/*
 * Return '*' for ok.
 */
char handle_ihex(char *src)
{
  int llen, laddr, baddr, ltype;
  uchar lsum;
  int wq;
  inpoi = src+1; /* Skip colon */
  llen = iread(2);
  laddr = iread(4);
  baddr = laddr;
  ltype = iread(2);
  if (ltype == 1 && llen == 0) return '@'; /* end of file indication */

  if (ltype == 4 && llen == 2 && laddr == 0) /* offset record */
    {
      uchar d0 = iread(2);
      uchar d1 = iread(2);
      long int o = (d0 << 8) | d1;
      lsum = llen + ltype + d0 + d1;
      lsum += iread(2);
      if (lsum != 0) 
	{ 
	  writes("Checksum error\n");
	  errorf = 1;
	  return '3';
	}
      ihex_offset = (uchar *) (o << 16);
      return '*';
    }

  if (ltype != 0 || llen > IHEX_MAX_LENGTH)
  {
    errorf = 1;
    return '2';
  }
  lsum = llen + laddr + ltype + (laddr >> 8);
  for (wq=0; wq<llen; wq++)
  {
    uchar data = iread(2);
    lsum = lsum + data;
    ihex_buffer[wq] = data;
  }
  lsum += iread(2);
  if (lsum != 0) 
    { 
      writes("Checksum error");
      errorf = 1;
      return '3';

    }
  ihex_write(ihex_offset+baddr, ihex_buffer, llen); 

  if (ihex_verify(ihex_offset+baddr, ihex_buffer, llen))
    {
      errorf = 1;
      return '0';
    }
  return '*';
}


/*
 * Simple line input with no echo. Return NULL on escape.
 */
char *simplelinein()
{
  int i = 0;
  while(1)
    {
      char c = craft_rdch();
      while(c != (char) 13 && i < MAXLINE-1)
	{
	  if (c== (char)27) return NULL;
	  if (c >= ' ')
	    {
	      /* Skip leading spaces - useful as pads for ihex download before the colon */
	      if (c != ' ' || i != 0) linebuffer[i++] = c;
	    }
	  c = craft_rdch();
	}
      linebuffer[i] = (char) 0;
      return linebuffer;
    }
}



/*
 * Simple shell for Cambertronics flash programming mode.
 */
void odette_shell()
{
  errorf = 0;
  ihex_offset = 0;
  while (errorf==0)
    {
      writes("send data:");
      while(1)
	{
	  char *cmd, **argv;
	  cmd = simplelinein();
	  if (cmd == NULL) break;

	  else if (cmd[0] == 'q') exit();
	  else if (cmd[0] == ':')
	    {
	      char c = handle_ihex(cmd);
	      putchar(c); 
	    }
	  else if (cmd[0] == (char) 0) continue;
	  else 
	    {
	      writes("bad cmd\n");
	    }
	}
    }
  writes("Download error. Exit from odette.\n");
}

int main()
{
  int c;
  writes("\n\nMixerton Odette Rescue\n");
  odette_shell();
}


/* eof */
