        ; mixflashass.S
	; contains reset vectors and so on for mixteron flash bios
	; 
 	; (C) 2001 Mixerton.ST  www.mixerton.com
	;
	; 
	.h8300h			; 
	.set	StackTop,0xFFFBF0

	.set dirty_loc,0x804444
	
	.set flash_base,0											
	;; System Control Register
	.set syscr,0xffff39
	
	;; Port 1
	.set p1ddr,0xfffeb0
	.set p1dr,0xffff60

	;; Port 3
	.set p3ddr,0xfffeb2
	.set p3dr,0xffff62
	
	;; Port 5
	.set p5ddr,0xfffeb4
	.set p5dr,0xffff64
	.set p5data,0xffff54
	
 	;; Serial port 0 is PIC control
	.set scr0,0xffff7a		; serial control reg
	.set rdr0,0xffff7d
	.set ssr0,0xffff7c		;  rate
 	.set brr0,0xffff79		;  
	.set smr0,0xffff78		;
	.set tdr0,0xffff7b	;  transmit data reg

 	;; Serial port 1 is ops and maintenance port
	.set scr1,0xffff82		; serial control reg
	.set rdr1,0xffff85
	.set ssr1,0xffff84		;  rate
 	.set brr1,0xffff81		;  16 for 19200
	.set smr1,0xffff80		;
	.set tdr1,0xffff83	;  transmit data reg

	;; Port G
	.set pgddr,0xfffebf	;  Needed for the CSn outputs
	.set mstp,0xffff3c	;  module stop register
	;; Bus Controller Registers
	.set bcrl,0xfffed5
	.set bcrh,0xfffed4
	.set wcrl,0xfffed3
	.set wcrh,0xfffed2
	;;
	;; On chip RAM resources
	
	

;
; Cold Reset Vectors and low stuff
;
	.set	prod_isr,0xFFF00C
	


	;;  The first eight bytes of this table are in another file
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	



	;; 
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	;; 
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	;; 
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	
	.long	prod_isr	; ISR
	.long	prod_isr	; ISR	

_LOAD_POINT:	
	
warm_start:			; This should be at address 0x200
	bra	warm_start1
cold_start:			; This should be at address 0x202
	mov.l	#StackTop,er7

	mov.w	#200,r0
del0:	sub.w	#1,r0
	bne	del0

	jsr	micro_init

	mov.w	#65000,r0
del1:	sub.w	#1,r0
	bne	del1


	mov.l	er7,er6		;  Establish a C frame pointer
	jsr	__crt0
	bra	cold_start

;; -----------------------------------------------------
warm_start1:	
	mov.l	#StackTop,er7
	jsr	micro_init

	mov.w	#65000,r0
del9:	sub.w	#1,r0
	bne	del9

	mov.l	er7,er6		;  Re-stablish a C frame pointer
	jsr	_mymon_main
	bra	cold_start

version_string:	
	.ascii	"Mixerton Flash Base, (C) 2001 www.mixerton.com. "
	.word	0
	.align 4			

	
	;;
	;; Initialise sufficient hardware resources to run the monitor
	;; 
micro_init:		
	mov.b	#0xAA,r0l
	mov.b	r0l,@wcrl	;  Select two wait states for flash execution.

	mov.b	#0x1e,r0l	;  Turn on all 4 CSn outputs
	mov.b	r0l,@pgddr


	mov.w	#0x7080,r0	;  Enable SCI 0-1 and ADC, turn off SCI1, DTC and timers
	mov.b	r0h,@mstp
	mov.b	r0l,@(mstp+1)

	mov.w	#0,r1				
msdel:				;  Delay loop while recover from mstp write.
	add.w	#1,r1
	bne	msdel
		
	mov.b	#(32*4),r0l	; Set BTT1 to 32*4 for 4800 baud	(page 411 of manual)
	mov.b	r0l,@brr0
	
	mov.b	#32,r0l		; Set BTT1 to 32 for 19200 baud	(page 411 of manual)
	mov.b	r0l,@brr1
	mov.b	#0,r0l		;  Set SMR1 to zero
	mov.b	r0l,@smr0
	mov.b	r0l,@smr1

	mov.w	#0,r1				
podel:				;  Power up delay loop and uart settling delay
	add.w	#1,r1
	bne	podel
	
	mov.b	#0x30,r0l	;  SCR1 to 0x30 to turn on the serial ports
	mov.b	r0l,@scr0
	mov.b	r0l,@scr1

	rts
;
;-------------------
_craft_rdch:
	btst	#6,@ssr1
	beq	_craft_rdch
	
rdch1:	mov.b	@rdr1,r0l 
	bclr	#6,@ssr1
	bclr	#7,r0l
	rts
;-------------------
; See if a char is there to read.  Return 1 if so.
_craft_testch:
	mov.w	#1,r0
	btst	#6,@ssr1
	bne	sa_testch00
	mov.w	#0,r0
sa_testch00:	
	rts
;-------------------
_craft_wrch:
sa_wrch_1:	
	btst	#7,@(ssr1)	; Bit 7 is a one if we can send
	beq	sa_wrch_1	; the next char.
	mov.b	r0l,@(tdr1)
	bclr	#7,@ssr1
	rts

; ----------------------------------------------------------------
_flash_sector_erase_lowlev:	
	.global  _flash_sector_erase
	jmp	0xFFF000	;  Go to ram copy

_mf_flash_write:	 
	.global  __flash_write_lowlev
	jmp	0xFFF004	;  Go to ram copy

_mf_erase_self_and_retriev:	
	jmp	0xFFF008	;  Go to ram copy
;-----------------------------------------------
;  The following code is copied to local ram for execution
_ramrtn_text_start: 
	bra flash_sector_erase_core:16
	bra mf_flash_write_core:16
; -------------------------------------
; This function erases sector 0 and copies sector 1 first 64K back into
; sector 0 
mf_erase_self_and_retriev_lowlev:	
	sub.l	er0,er0
	bsr	flash_sector_erase_core:16
	bset	#0,r0l
	bsr	flash_sector_erase_core:16

	sub.l	er0,er0		; Dest
	mov.l	#0x20000,er1	; Src
	mov.w	#65535,r2	; len
	bsr	mf_flash_write_core


	mov.l	#1,er0		; Dest
	mov.l	#0x20001,er1	; Src
	mov.w	#65535,r2	; len
;; now fall into mf_flash_write_core for odd bytes and return
	
; -------------------------------------
; 
; This routine must run from RAM since cannot execute out of flash while writing the flash.
; Args:   dest, src, count
;  If dest is odd, only odd bytes are written and ditto even
; 
; ---------------------------------
; er0 dest
; er1 src 
; r2 count
mf_flash_write_core:	
	mov.l	er0, er3	;  dest to er3

	mov.b	#0xAA,r0l
	mov.b	r0l,@wcrl	;  Select two wait states for flash write.
fw32a:		
; Open the chip and sector in er3.
	btst	#0,r3l
	bne	flash_lower

	mov.w 	#0xF0F0,r0	;  Reset
	mov.w	r0,@(flash_base)

	mov.w 	#0xAAFF,r0	;  AA to 555
	mov.w	r0,@(flash_base+(0x555<<1))
	mov.w	#0x55FF,r0	; 55 to 2AA
	mov.w	r0,@(flash_base+(0x2AA<<1))
	mov.w 	#0xA0FF,r0	; A0 to 555
	mov.w	r0,@(flash_base+(0x555<<1))
	bra fw_core1

flash_lower:
	mov.w 	#0xF0F0,r0	;  Reset
	mov.w	r0,@(flash_base)

	mov.w 	#0xFFaa,r0	;  AA to 555
	mov.w	r0,@(flash_base+(0x555<<1))
	mov.w	#0xFF55,r0	; 55 to 2AA
	mov.w	r0,@(flash_base+(0x2AA<<1))
	mov.w 	#0xFFa0,r0	; A0 to 555
	mov.w	r0,@(flash_base+(0x555<<1))
fw_core1:
	;; Chip now opened

	mov.b	@er1,r0l	;  Get src byte
	mov.b	r0l,@er3	;  Store it in flash

	;;
	;; Now must wait for flash write to complete in this poll loop.
	;;
fw32p:
	nop
	mov.b	@er1,r0l	; Read old - causes bus cycle
	mov.b	r0l,@(dirty_loc); Store old - causes bus cycle
	mov.b	@er3,r0h	; Read new from flash.
	cmp.b	r0h,r0l		; Compare
	bne	fw32p		; Poll until correct.

	add.l	#2,er3		; Advance dest to next byte within same chip
	add.l	#2,er1		; Advance src to corresponding next byte
	sub.w	#1,r2
	beq	fw32d		; done when r2 gets to zero
	sub.w	#1,r2
	bne	fw32a		; loop back for next byte
fw32d:	
	rts


;---------------------------------------------------------------
; Flash sector erase
;  er0 = base address of sector
;
flash_sector_erase_core:	
	mov.w 	#0xF0F0,r1	;  Reset
	mov.w	r1,@(flash_base)

	btst	#0,r0l
	bne	erase_odd_low:16
	
	mov.w 	#0xaaff,r1	;  AA to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	
	mov.w	#0x55ff,r1	; 55 to 2AA
	mov.w	r1,@(flash_base+(0x2AA<<1))

	mov.w 	#0x80ff,r1	; 80 to 555
 	mov.w	r1,@(flash_base+(0x555<<1))

	mov.w 	#0xaaff,r1	; AA to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	
	mov.w	#0x55ff,r1	; 55 to 2AA
	mov.w	r1,@(flash_base+(0x2AA<<1))

	bclr	#0,r0l		;  Make even address (is anyway)
	mov.w 	#0x30FF,r1
	mov.w	r1,@er0		; 0x30 is Sector erase (10 is chip erase)
	
	mov.w	#0,r1		; Mini delay
xl1:	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	add.w	#(65536-1),r1	; > 80 microseconds.
	bne	xl1

; Must poll in different locations from where we wrote the command  
; Sector erase takes up to 13 seconds so allow a good 20 for time out.
	mov.l	#19000111,er1		; Use R1 as timeout
erase_poll_even:			
	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	and.b	#128,r2h	; msb is a one when erased
	bne	ll_eok

	sub.l	#1,er1
	bne	erase_poll_even; Loop again if no timeout
ll_nok:	
	mov.w	#1,r1
	bra	ll_ret

ll_eok:
	sub.w	r0,r0
ll_ret:
ep_home:	
	mov.w 	#0xF0F0,r1	;  Reset
	mov.w	r1,@(flash_base)
hang_for_rom_ok:	
	mov.w	r0,@(dirty_loc)	; Dirty the bus
	mov.l	@(_flashtest_const+0),er1;  Poll for correct
	cmp.l	#0x12345678,er1
	beq	hang_done
	mov.l	#_flashtest_const,er1;  Other possible location
	add.l	#0x20000,er1
	mov.l	@er1,er1;  Other possible location
	cmp.l	#0x12345678,er1
	bne hang_for_rom_ok
hang_done:	

	mov.w	r1,@(flash_base+2); Dummy reads writes.
	mov.w	r1,@(flash_base+4); Dummy reads 
	rts			;  

erase_odd_low:
	mov.w 	#0xFFaa,r1	;  AA to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	mov.w	#0xFF55,r1	; 55 to 2AA
	mov.w	r1,@(flash_base+(0x2AA<<1))
	mov.w 	#0xFF80,r1	; 80 to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	mov.w 	#0xFFAA,r1	; AA to 555
	mov.w	r1,@(flash_base+(0x555<<1))
	mov.w	#0xFF55,r1	; 55 to 2AA
	mov.w	r1,@(flash_base+(0x2AA<<1))

	bclr	#0,r0l		;  Make even address 
	mov.w 	#0xFF30,r1
	mov.w	r1,@er0		; 0x30 is Sector erase (10 is chip erase)


	mov.w	#0,r1		; Mini delay
xl2:	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	add.w	#(65536-1),r1	; > 80 microseconds.
	bne	xl2
	

; Sector erase takes up to 20 seconds or so, poll for it.
	mov.l	#0x19000111,er1		; Use R1 as timeout
erase_poll_odd:			
	mov.w	@(0x202,er0),r2
	mov.w	r2,@(dirty_loc)
	and.b	#128,r2l	; msb is a one when erased
	bne	ll_eok:16

	sub.l	#1,er1
	bne	erase_poll_odd; Loop again if no timeout
	mov.b	#1,r0l
;;	xorc.b	#0x80,ccr	; flip interrupt enable bit - bit 7, ints on
	bra	ll_nok:16

_ramrtn_text_end:
;--------------------------------------------------------------
___mulsi3:
	push.l	er2
	sub.l	er2,er2
	cmp.l	#0,er0	
	beq	__ms1
__ms0:	
	btst	#0,r0l
	beq	__ms2
	add.l	er1,er2
__ms2:	shll.l	er1
	shlr.l  er0	
	bne	__ms0

__ms1:	mov.l	er2,er0		
	pop.l	er2
	rts
;--------------------------------------------------------------
_loaded_image:
	mov.l	#0x8000,er0
	jmp	@er0
;--------------------------------------------------------------
	;; Should be 1234567 when read back
_flashtest_const:
	.word 0x1234,0x5678

	
;--------------------------------------------------------------
	;; EOF



