//
// Kiwi Scientific Acceleration  
// University of Cambridge, Computer Laboratory
//
// vsys.v - A test wrapper for FPGA test 
//
`timescale 1ns/1ns

module SIMSYS();

   reg clk, reset;
   initial begin reset = 1; clk = 0; #33 reset = 0; end
   always #5 clk = !clk;

   initial begin # (1000 * 100 * 1000) $display("Finish HDL simulation on timeout %t.", $time); $finish(); end

   initial begin $dumpfile("vcd.vcd"); $dumpvars(); end

   wire start = 1;
   wire busy;
   wire [31:0] codesent;
   ATOP_LCD the_dut(.CLK_sys_clk_p(clk), 
	       .reset(reset),
	       .done(done)
//..	       .xpc10_start(start),
//	       .xpc10_busy(busy),
//	       .codesent(codesent)
	       );

   always @(posedge clk) begin
      if (done) begin
	 $display("Exit on done asserted.");
	 $finish;
	 end
      //$display("%1t,  pc=%1d, codesent=%h" , $time, the_dut.xpc10nz, codesent);
   end
   
endmodule
// eof


