// (C) 2010-16 DJ Greaves, University of Cambridge.
//
// Kiwi Scientific Acceleration  
// University of Cambridge, Computer Laboratory
//
// simsys.v - Virtual LCD panel test wrapper - dummy output device present.
// 
//  
//
`timescale 1ns/1ns

module ATOP_SIM_WHOLE();

   reg clk, por_reset;
   initial begin por_reset = 1; clk = 1; # 43 por_reset = 0; end
   always #5 clk = !clk;

   initial # (10 * 1000) begin
      $display("Finish HDL simulation on timeout %t.", $time); 
      $finish(); 
      end

   initial begin $dumpfile("vcd.vcd"); $dumpvars(); end

    wire i2c_sda_in = 0;
    wire i2c_scl_openable;
    wire i2c_sda_openable;
    wire i2c_sda_out;
    wire i2c_scl_out;
    wire done;

   wire  GPIO_SW_N = 0;
   wire  GPIO_SW_S = 0;
   wire  GPIO_SW_W = 0;
   wire  GPIO_SW_E = 0;
   wire  GPIO_SW_C = 0;

   tri 	 LCD_DB4_LS, LCD_DB5_LS, LCD_DB6_LS, LCD_DB7_LS;
   
   ATOP_LCD the_dut(.CLK_sys_clk_p(clk), 
   	 .GPIO_SW_S(GPIO_SW_S),
   	 .GPIO_SW_N(GPIO_SW_N),
   	 .GPIO_SW_W(GPIO_SW_W),
   	 .GPIO_SW_E(GPIO_SW_E),
   	 .GPIO_SW_C(GPIO_SW_C),
   	 .CPU_RESET(por_reset),
	 	    .LCD_RS_LS(LCD_RS_LS),
		    .LCD_E_LS(LCD_E_LS),
		    .LCD_RW_LS(LCD_RW_LS),
		    .LCD_DB4_LS(LCD_DB4_LS),
		    .LCD_DB5_LS(LCD_DB5_LS),
		    .LCD_DB6_LS(LCD_DB6_LS),
		    .LCD_DB7_LS(LCD_DB7_LS)

	 );
	 
   wire [31:0] count, vol;
   wire finished;  
   reg start; 

   VIRTUAL_LCD_PANEL_1602 lcd_panel(
				    .LCD_DB4_LS(LCD_DB4_LS),
				    .LCD_DB5_LS(LCD_DB5_LS),
				    .LCD_DB6_LS(LCD_DB6_LS),
				    .LCD_DB7_LS(LCD_DB7_LS),
				    .LCD_RS_LS(LCD_RS_LS),
				    .LCD_E_LS(LCD_E_LS),
				    .LCD_RW_LS(LCD_RW_LS));

     always @(posedge clk) begin
       if (done) begin
       $display("Exit vsys on done asserted");
       $finish;
       end
//	$display("%1t, pc, thread_pc10 = %1d", $time, the_dut.xpc10nz);
	end

endmodule
// eof
