// Kiwi Scientific Acceleration.
//
// Top level FPGA file for LCD display demo on Xilinx vc707 card. Part=xc7vx485tffg1761-2
//

module ATOP_LCD(
	      input 	   CLK_sys_clk_p,
	      input 	   CLK_sys_clk_n,
	 

	      output 	   USB_UART_RX,
	      input 	   USB_UART_TX,
	      input 	   USB_UART_RTS,
	      output 	   USB_UART_CTS,
     
	      input 	   GPIO_SW_S,
	      input 	   GPIO_SW_N,
	      input 	   GPIO_SW_W,
	      input 	   GPIO_SW_E,
	      input 	   GPIO_SW_C,
	      input 	   CPU_RESET,
	      output [7:0] leds,

	      output 	   USER_SMA_GPIO_P,
	      output 	   USER_SMA_GPIO_N,
	      output 	   USER_SMA_CLOCK_P,
	      output 	   USER_SMA_CLOCK_N,


	      
	      // LCD 1602 pins 
	      output 	   LCD_RS_LS, // register select
	      output 	   LCD_E_LS,  // enable/guard
	      output 	   LCD_RW_LS, // read=notwrite.
	      inout 	   LCD_DB7_LS, inout LCD_DB6_LS, inout LCD_DB5_LS, inout LCD_DB4_LS
			   
	      );

   
   //
   // SYSCLK
   // 
   IBUFDS IBUFDS_inst_sys_clock(
				.O(sys_clock_pre), // Buffer output
				.I(CLK_sys_clk_p), // Diff_p buffer input (connect directly to top-level port)
				.IB(CLK_sys_clk_n) // Diff_n buffer input (connect directly to top-level port)
				);

   

   wire 		   done;
   wire 		   clk1MHz;
   wire 		   clk50;
// `define RTLSIM 1
   
`ifdef RTLSIM
   initial $display("COMPILED FOR RTL SIMULATION NOT FOR FPGA");
   wire slow_reset = CPU_RESET;
   BUFG slow_clock_buffer(clk1MHz, sys_clock_pre);
   BUFG fast_clock_buffer(clk50, sys_clock_pre);
   wire pbit = 0;
`else
   reg 	slow_reset;
   reg 			   jonprescale0, jonprescale1;
   always @(posedge sys_clock_pre) begin // divide 200 to 50 MHz
      jonprescale0 <= jonprescale1;
      jonprescale1 <= !jonprescale0;
   end


   wire 		   hreset = 1'b0;
   

   BUFG fast_clock_buffer (
			     .O(clk50), // 1-bit output: Clock output 50MHz
			     .I(jonprescale0)
			     );
`ifndef VSLOW 
   // Clock prescaler - 50 MHZ divide by 256 or more
   reg [7:0] 		   clk_prescale;
   always @(posedge clk50)
     clk_prescale <= /*(clk_prescale == 49)  ? 0:*/ clk_prescale+1;

   assign pbit = clk_prescale[7];
`else

      // Very slow clock prescaler - 
   reg [9:0] 		   clk_prescale;
   reg [8:0] 		   clk_prescale1;
   reg [5:0] 		   clk_prescale2;
   wire 		   pbit = clk_prescale[5];
   reg 			   ovf1, ovf2;
   
   
   always @(posedge clk50)
      if (hreset) begin
	 slow_reset <= 1;
	 clk_prescale <= 0;
	 clk_prescale1 <= 0;
	 clk_prescale2 <= 0;
	 ovf1 <= 0;
	 ovf2 <= 0;
      end
      else begin
	 clk_prescale1 <= clk_prescale1 + 1;
	 ovf1 <= (clk_prescale1 == 0) && !GPIO_SW_C;
	 if (ovf1) clk_prescale2 <= clk_prescale2 + 1;
	 ovf2 <= clk_prescale2 == 0;
	 
	 if (ovf1 && ovf2) clk_prescale <=  clk_prescale + 1;


      end

`endif
   BUFG slow_clock_buffer(clk1MHz, pbit);

   always @(posedge clk1MHz) slow_reset <= CPU_RESET;
`endif   


  
   wire [31:0] 		   codesent, codeword;

   // Instance of the Kiwi-generated LCD driver
   wire lcd_data4_openable; 
   wire [3:0] lcd_data4_in, lcd_data4_out;
   bufif1(LCD_DB4_LS, lcd_data4_out[0], lcd_data4_openable);  
   bufif1(LCD_DB5_LS, lcd_data4_out[1], lcd_data4_openable);  
   bufif1(LCD_DB6_LS, lcd_data4_out[2], lcd_data4_openable);  
   bufif1(LCD_DB7_LS, lcd_data4_out[3], lcd_data4_openable);  
   IBUF lcd_in40(lcd_data4_in[0], LCD_DB4_LS);
   IBUF lcd_in41(lcd_data4_in[1], LCD_DB5_LS);
   IBUF lcd_in42(lcd_data4_in[2], LCD_DB6_LS);
   IBUF lcd_in43(lcd_data4_in[3], LCD_DB7_LS);
   
   kiwi_lcd1602_driver  the_lcd_driver(  
					 //.xpc10nz(lcd_driver_pc),
					 .select(1'b1),

					 .codeword(codeword),
					 .reset(slow_reset),   
					 .clk(clk1MHz),
					 .done(done),
					 .LCD_RS_LS(LCD_RS_LS),
					 .LCD_E_LS(LCD_E_LS),
					 .LCD_RW_LS(LCD_RW_LS),
					 .lcd_data4_in(lcd_data4_in),
					 .lcd_data4_out(lcd_data4_out),
					 .lcd_data4_openable(lcd_data4_openable)
					 );


   
   assign leds[0] = codesent[0]  ^ GPIO_SW_S;
   assign leds[1] = codesent[1];
   assign leds[2] = codesent[2];
   assign leds[3] = codesent[3];
   assign leds[4] = codesent[4];
   assign leds[5] = codesent[5];
   assign leds[6] = codesent[6];
   assign leds[7] = codesent[7];

   //assign codesent = { pbit, lcd_driver_pc /*codeword[4:0] */ };
   assign codesent = { pbit, slow_reset, done, codeword[4:0] };

   //-----------------------------------------------------------
   // UART
   //   assign USB_UART_RX = USB_UART_TX; // simple loopback

   wire       tx_av;
   wire [7:0] uart_rx_parout;

   //assign codesent = { uart_rx_parout[3:0], tx_av, /*pc*/ /*the_lcd_driver.xpc10nz*/ !USB_UART_RX, !USB_UART_TX, USB_UART_RTS };

   assign USER_SMA_GPIO_P = USB_UART_TX;
   assign USER_SMA_GPIO_N = USB_UART_RX;
   assign USER_SMA_CLOCK_P = USB_UART_RX;
   assign USER_SMA_CLOCK_N = USB_UART_TX;

   assign USB_UART_CTS = 0; // active low.  RTS goes low when USB uart is opened by the host.

   reg [8:0] baudctr;
   always @(posedge clk50) begin
      baudctr <= (baudctr == 324) ? 0: baudctr+1;
      end

   wire       baudck;
   BUFG baud_buf(baudck, baudctr[8]);

   reg [15:0] utest;
   reg 	      uart_write;
   wire [1:0] f = utest[15:14];
   reg [7:0]  uart_parin;
   always @(posedge clk50MHz) begin
      utest <= utest +1;
      uart_write <= utest[13:0]==0;
      uart_parin <= (f==0) ? 8'h31: 
		    (f==1) ? 8'h32:
		    (f==2) ? 8'h41:
		    uart_rx_parout;
   end

   CBGUART1 the_uart(
		     .clk(clk50MHz),
		     .reset(reset),
		     .baudck(baudck),
		     .rxdata(USB_UART_TX), // Cross them over here
		     .txdata(USB_UART_RX), // Cross them over here		    
		     .rx_parout(uart_rx_parout),
		     .tx_av(tx_av),
		     .tx_parin(uart_parin), // GPIO_SW_N ? 8'h43: 8'h2a),
		     .tx_write(uart_write)  // GPIO_SW_S)
		     );


endmodule

// eof
