/* PIC 12 Instruction Set from MicroChip, encoded for Mixerton ISS 
 *
 * This file $ID: $
 *
 * CBG Lambda Lambdem - PIC MicroChip version
 * Microcontroller emulator and model checker
 *
 * (C) 1998-2006 DJ Greaves, Mixerton ST.
 *
 */
#ifndef PIC12ISS_H
#define PIC12ISS_H


		    /* K8 Eight bit immediate field */
#define K8        L_AND(L_DIE(OCODE), L_INT(255))

		    /* K11 Eleven bit immediate field */
#define K11       L_AND(L_DIE(OCODE), L_INT(2047))
		    /* K9 nine bit immediate field */
#define K9       L_AND(L_DIE(OCODE), L_INT(511))

                    /* Bits 4:3 of PCLATH  */
#define PCHIGOTO   L_AND(L_RSHIFT(PCLATH, L_INT(3)), L_INT(3))

#define PCLATH    L_PATH(L_STR("MMREG"), L_STR("PCLATH"))
#define PCL       L_PATH(L_STR("MMREG"), L_STR("PCL"))
#define PCH       L_PATH(L_STR("CPUREG"), L_STR("PCH"))

#define W8        L_PATH(L_STR("CPUREG"), L_STR("W"))
#define WDT       L_PATH(L_STR("MMREG"), L_STR("WDT"))
#define OPTION    L_PATH(L_STR("MMREG"), L_STR("OPTION"))
#define PRESCALE  L_PATH(L_STR("CPUREG"), L_STR("PRESCALE"))



/* old L_GETBIT(L_GETV(L_VAR(W), L_STR(N)), L_ONE, L_ASSOC(L_GET(L_VAR(W), L_STR(N)), L_STR(BN), L_ANSWER, L_FAIL)) */


// These ones have hardwired bit offsets...
#define CC        L_BITSEL(L_PATH(L_STR("MMREG"), L_STR("STATUS")), L_INT(0))
#define ZZ        L_BITSEL(L_PATH(L_STR("MMREG"), L_STR("STATUS")), L_INT(2))
#define PD        L_BITSEL(L_PATH(L_STR("MMREG"), L_STR("STATUS")), L_INT(7))
#define GIE       L_BITSEL(L_PATH(L_STR("MMREG"), L_STR("INTCON")), L_INT(7))
									  
// need to reenable these forms....
#define           L_GETBITV(W, N, BN) \
             L_LAMBDA(L_V("JF"), \
		      L_BITSEL(L_V("JF"),  L_LOOKUP(L_V("JF"), L_STR(BN), L_FAIL)), \
		      L_LOOKUP(L_VAR(W), L_STR(N), L_FAIL))
#define GIE1       L_GETBITV(MMREGS, "INTCON", "GIE")
#define CC1        L_GETBITV(MMREGS, "STATUS", "C")
#define PD1        L_GETBITV(MMREGS, "STATUS", "nPD")
#define ZZ1        L_GETBITV(MMREGS, "STATUS", "Z")

#define L_ZERO    L_INT(0)
#define L_ONE     L_INT(1)

/* INDF register, at location zero, looks up via FSR register */
/* Need to OR-in the bank select here */
#define FSR       L_PATH(L_STR("MMREG"), L_STR("FSR"))

// indf invokes the xduce dynomux to make an address multiplexor
#define INDF      L_INT(0) //L_LOOKUP(L_TRENCH("MMREG"), FSR, L_FAIL)


#define MMREGS_L  L_LMODE(L_TRENCH("MMREG"))
#define FF14X     L_LAMBDA(L_V("ff14"), \
			   L_COND(L_EQ(L_V("ff14"), L_ZERO), INDF, L_GETV(MMREGS_L, L_V("ff14"))), \
			   L_AND(L_DIE(OCODE), L_INT(127)))


#define FF12X     L_LAMBDA(L_V("ff"), \
			   L_COND(L_EQ(L_V("ff"), L_ZERO), INDF, L_GETV(MMREGS_L, L_V("ff"))), \
			   L_AND(L_DIE(OCODE), L_INT(31)))


#define FF12R     L_PIN(5, FF12X)   
#define FF14R     L_PIN(1, FF14X)
#define FF12W     L_PIN(3, FF12X)   
#define FF14W     L_PIN(4, FF14X)

/*
 * Three bit bit select field within opcode.
 */
#define BSEL12  L_AND(L_RSHIFT(L_DIE(OCODE), L_INT(5)), L_INT(7)) 
#define BSEL14  L_AND(L_RSHIFT(L_DIE(OCODE), L_INT(7)), L_INT(7)) 


/*
 * Test one bit of field FF
 */
#define BB12  L_AND(L_ONE, L_RSHIFT(FF12R, BSEL12))
#define BB14  L_AND(L_ONE, L_RSHIFT(FF14R, BSEL14))
#define FB12  L_ORRED(BB12)
#define FB14  L_ORRED(BB14)


#define IFZ8(X, C)  L_COND(L_EQ(L_ZERO, L_AND(L_INT(255), X)), \
			   L_SKIP, \
			   C)


#define UPDATEz8(X) L_ASSIGN(ZZ, \
			     L_COND(L_EQ(L_ZERO, X), L_ONE, L_ZERO))

#define UPDATEc8(X) L_ASSIGN(CC, \
			     L_COND(L_EQ(L_ZERO, L_AND(X, L_INT(256))), \
                                    L_ZERO,  \
                                    L_ONE))

#define MOVz8(R, L) L_LAMBDA(L_V("res8"), \
                             L_SEQ(L_ASSIGN(L, L_V("res8")), UPDATEz8(L_V("res8"))), \
                             L_AND(L_INT(255), R))

#define MOV(R, L) L_ASSIGN(L, R)
#define SEL12  L_ORRED(L_AND(L_DIE(OCODE),  L_INT(32)))
#define SEL14  L_ORRED(L_AND(L_DIE(OCODE),  L_INT(128)))

#define W8W L_LMODE(W8)

#define MOV12(X) L_LAMBDA(L_V("res12z"), L_COND(SEL12, MOV(L_V("res12z"), FF12W), MOV(L_V("res12z"), W8W)), L_AND(X, L_INT(255)))

#define MOV12z8(X) L_LAMBDA(L_V("res12z8"), \
			    L_SEQ(L_COND(SEL12, MOV(L_V("res12z8"), FF12W), MOV(L_V("res12z8"), W8W)), \
				  UPDATEz8(L_V("res12z8"))), L_AND(X, L_INT(255)))

#define MOV12zc8(X) L_LAMBDA(L_V("c8"), \
			     L_SEQ(MOV12z8(L_V("c8")), UPDATEc8(L_V("c8"))), \
			     X)


#define MOV14(X) L_LAMBDA(L_V("res14"), \
			  L_COND(SEL14, MOV(L_V("res14"), FF14W), MOV(L_V("res14"), W8W)), \
			  L_AND(X, L_INT(255))) 

#define MOV14z8(X) L_LAMBDA(L_V("res14z8"), \
			    L_SEQ(L_COND(SEL14, MOV(L_V("res14z8"), FF14W), \
					 MOV(L_V("res14z8"), W8W)), \
				  UPDATEz8(L_V("res14z8"))),  \
			    L_AND(X, L_INT(255)))

#define MOV14zc8(X) L_LAMBDA(L_V("c8"), \
			     L_SEQ(MOV14z8(L_V("c8")), \
				   UPDATEc8(L_V("c8"))), \
			     X)

#define MOV14SKIPZ(X) L_LAMBDA(L_V("res14sz"), \
                               L_SEQ(L_COND(SEL14, MOV(L_V("res14sz"), FF14W), MOV(X, W8W)), \
				     IFZ8(L_V("res14sz"), INCINC_PC)), \
                               X)

#define MOV12SKIPZ(X) L_LAMBDA(L_V("res12sz"), \
			       L_SEQ(L_COND(SEL12, MOV(L_V("res12sz"), FF12W), MOV(X, W8W)), \
				     IFZ8(L_V("res12sz"), INCINC_PC)), \
			       X)

#define BIT(X) L_LSHIFT(L_ONE, X)
#define IFZ(X) L_COND(ZZ, X, L_ONE) 

#define TOS           L_PATH(L_STR("CPUREG"), L_STR("TOS"))
#define TOS1          L_PATH(L_STR("CPUREG"), L_STR("TOS1"))
#define TOS2          L_PATH(L_STR("CPUREG"), L_STR("TOS2"))

#define PC_SANSP      L_BITOR(PCL, L_LSHIFT(PCH, L_INT(8)))
#define PC            L_PIN(2, PC_SANSP)
#define PC222         L_BITOR(PCL, L_LSHIFT(PCH, L_INT(8)))
#define SETPC(X)      L_SEQ(MOV(L_RSHIFT(X, L_INT(8)), PCH), MOV(L_AND(X, L_INT(255)), PCL))
#define POPPC         L_SEQ(SETPC(TOS), L_SEQ(MOV(TOS1, TOS), MOV(TOS2, TOS1)))
#define PUSHPC        L_SEQ(MOV(L_INC(PC), TOS), L_SEQ(MOV(TOS, TOS1), MOV(TOS1, TOS2)))


//---------------------------------
// Test reg code
#define BOTH L_OR(TESTR0, L_LSHIFT(TESTR1, L_INT(4))) 
#define TESTREGCODE L_ASSIGN(TESTR0, L_PIN(10, L_OR(L_ADD(BOTH , L_ONE), TESTR0)))

#define TESTR0 L_PATH(L_STR("CPUREG"), L_STR("TESTR0"))
#define TESTR1 L_PATH(L_STR("CPUREG"), L_STR("TESTR1"))

//-------------------------------------------------

#define SETPCK11REAL      SETPC(L_BITOR(K11, L_LSHIFT(PCHIGOTO, L_INT(11))))
#define SETPCK11          L_SEQ(L_P(L_STR("DOGGOTO")), SETPCK11REAL)
#define PIC_ADVANCE_PC    SETPC(L_INC(PC))
#define INCINC_PC         SETPC(L_INC(L_INC(PC)))

/* PC is permanently connected to the program address bus */
#define P_ADDRESSBUS_12 PC
#define P_ADDRESSBUS_14 PC
#define P_ADDRESSBUS_16 PC


#define PHI L_SKIP

P12(0xC00, 0xF00, "MOVLW", 8,  "Load immediate",       MOV(K8, W8), 0, "", "")
P12(0xD00, 0xF00, "IORLW", 8,  "OR immediate",         MOVz8(L_OR(K8,W8), W8), 0, "", "z")
P12(0xE00, 0xF00, "ANDLW", 8,  "AND immediate",        MOVz8(L_AND(K8,W8), W8), 0, "", "z")
P12(0xF00, 0xF00, "XORLW", 8,  "XOR immediate",        MOVz8(L_XOR(K8,W8), W8), 0, "", "z")


P12(0x900, 0xF00, "CALL",  11,  "Call subroutine",     PUSHPC, SETPCK11, "", "") 
P12(0x800, 0xF00, "RETLW", 8,  "Return with literal",  MOV(K8, W8), POPPC, "", "")
P12(0x008, 0xFFF, "RETURN", 0,  "Return",              POPPC, 0, "", "")
P12(0x009, 0xFFF, "RETFIE", 0,  "Return from int",     POPPC, MOV(L_ZERO, GIE), "", "")

P12(0xA00, 0xE00, "GOTO",  11,  "Goto address k",      SETPCK11, 0, "", "")


/* P12(0x000, 0xFF8, "TRIS", 0xF3,  "Tristate port",   MOV(W,  F3), 0, "", "")  */

/* Sleep needs to clear PD bit */
P12(0x003, 0xFFF, "SLEEP", 0,  "Standby Mode",          MOV(L_ZERO, WDT), MOV(L_ZERO, PD), "", "")


P12(0x002, 0xFFF, "OPTION",0,  "Load OPTION Register",  MOV(W8, OPTION), PHI, "", "")
P12(0x004, 0xFFF, "CLRWDT",0,  "Clear watchdog timer",  MOV(L_ZERO,WDT), MOV(L_ZERO,PRESCALE), "", "")
P12(0x000, 0xFFF, "NOP",   0,  "No operation",          PHI, PHI, "", "")  
P12(0x040, 0xFFF, "CLRW",  0,  "Clear W",               MOV(L_ZERO, W8), PHI, "", "z")


P12(0x060, 0xFE0, "CLRF",  0xFF,  "Clear f",            MOV(L_ZERO, FF12W), PHI, "", "z")
P12(0x020, 0xFE0, "MOVWF", 0xFF,  "Move W to f",        MOV(W8, FF12W), PHI, "", "z")

P12(0x080, 0xFC0, "SUBWF",  0xFD, "Subtract W from f",  MOV12zc8(L_SUB(FF12R,W8)), PHI, "", "c,dc,z") 
P12(0x0C0, 0xFC0, "DECF",   0xFD, "Decrement f",        MOV12z8(L_DEC(FF12R)), PHI, "", "z")
P12(0x100, 0xFC0, "IORWF",  0xFD, "OR W and f",         MOV12z8(L_OR(W8,FF12R)), PHI, "", "z")
P12(0x180, 0xFC0, "XORWF",  0xFD, "Xor W and f",        MOV12z8(L_XOR(W8,FF12R)), PHI, "", "z")
P12(0x140, 0xFC0, "ANDWF",  0xFD, "AND W and f",        MOV12z8(L_AND(W8,FF12R)), PHI, "", "z")
P12(0x1C0, 0xFC0, "ADDWF",  0xFD, "Add W and f",        MOV12zc8(L_ADD(W8,FF12R)), PHI, "", "c,dc,z") 
P12(0x200, 0xFC0, "MOVF",   0xFD, "Move f",             MOV12(FF12R), PHI, "", "") 
/*  D=1 means store back to  file instead of updating W8 */
P12(0x200, 0xFE0, "MOVFW",  0xFF, "Load f to W",        MOV(FF12R, W8), PHI, "", "") 
P12(0x240, 0xFC0, "COMF",   0xFD, "Complement f",       MOV12z8(L_NEG(FF12R)), PHI, "", "z")
P12(0x2C0, 0xFC0, "DECFSZ", 0xFD, "Decrement f, skipz", MOV12SKIPZ(L_DEC(FF12R)), PHI, "", "")
P12(0x280, 0xFC0, "INCF",   0xFD, "Increment f",        MOV12z8(L_INC(FF12R)), PHI, "", "z")
P12(0x300, 0xFC0, "RRF",    0xFD, "Rotate right",       MOV12(L_OR(L_RSHIFT(FF12R,L_ONE),(L_LSHIFT(CC,L_INT(7))))), MOV(FF12R, CC), "", "")
P12(0x340, 0xFC0, "RLF",    0xFD, "Rotate left",        MOV12z8(L_OR(L_RSHIFT(FF12R,L_ONE),CC)), MOV(L_RSHIFT(FF12R,L_INT(7)), CC), "", "z")
P12(0x380, 0xFC0, "SWAPF",  0xFD, "Swap halves f",      MOV12(L_OR(L_RSHIFT(FF12R, L_INT(4)), L_LSHIFT(FF12R , L_INT(4)))), PHI, "", "")
P12(0x3C0, 0xFC0, "INCFSZ", 0xFD,  "Increment f, skipz", MOV12SKIPZ(L_INC(FF12R)), PHI, "", "")
    
P12(0x7b0, 0xF00, "BTFSS", 0xFB,  "Bit test, skips",    L_COND(FB12, L_SKIP, INCINC_PC), PHI, "", "")  

P12(0x4b0, 0xF00, "BCF",   0xFB,  "Bit clear f",        MOV(L_AND(FF12R,L_NEG(BIT(BB12))), FF12W), PHI, "", "")

P12(0x5b0, 0xF00, "BSF",   0xFB,  "Bit set f",          MOV(L_OR(FF12R,BIT(BB12)), FF12W), PHI, "", "")  

P12(0x6b0, 0xF00, "BTFSC", 0xFB,  "Bit test, skipc",    L_COND(FB12, INCINC_PC, L_SKIP), PHI, "", "")  
    

#endif
// eof cbg
