`timescale 1ns / 1ps

//  `define LOADSTORE_PORT_COUNT 1
// Kiwi Scientific Acceleration
// ksubs3 Start of the susbtrate for the Zynq platform.
// DRAFT !

module ksubs3_innercore(
      input 		clk,
      input 		reset_n,
      input [1:0] 	ksubs_runstop,
      output [31:0] 	elimit,

      output [23:0] 	mon0,
      output [23:0] 	mon1, 
      output reg [23:0] runtime0,
      output reg [31:0] count,

      output [31:0] 	result_hi,
      output [31:0] 	result_lo, 

 
      output [7:0] 	ksubsGpioLeds,
      output [7:0] 	ksubsAbendSyndrome,

      output [31:0] 	waypoint,
      output [23:0] 	designSerialNumber, 

			// Programmed I/O access to director shim
      input [11:0] 	pio_addr,
      output [31:0] 	pio_rdata,
      input [31:0] 	pio_wdata,
      input 		pio_hwen,
			
		// Ksubs Noc16 duplex interface: customer-side net directions.
      output [63:0] 	Ksubs3_Noc16_TxData_lo,
      //output [63:0] 	Ksubs3_Noc16_TxData_hi,
      output [7:0] 	Ksubs3_Noc16_TxData_cmd,
      output 		Ksubs3_Noc16_TxData_valid,
      input 		Ksubs3_Noc16_TxData_rdy,

      input [63:0] 	Ksubs3_Noc16_RxData_lo,
      //input [63:0] 	Ksubs3_Noc16_RxData_hi,
      input [7:0] 	Ksubs3_Noc16_RxData_cmd,
      input 		Ksubs3_Noc16_RxData_valid,
      output 		Ksubs3_Noc16_RxData_rdy
		
    );
    

`ifdef NOTDEF
// Not in use...
    reg [1:0] controller;
    reg [23:0] runtime0_live;  // Timer for design 

    always @(posedge clk) if (!reset_n) begin
        controller <= 0;
	runtime0 <= 0;
	runtime0_live <= 0;
	count <= 101; // for debug
        end
        else begin

             if (controller == 0) begin
	     	      controller <= 1;
		      runtime0_live <= 0;
		      runtime0 <= runtime0_live;
		      end
             if (controller == 1) controller <= 2;
             if (controller == 2 && runtime0_live != 24'hffffff) runtime0_live <= runtime0_live + 1; 

             if (controller == 3) controller <= 0;
             end
            
    assign kreset = (controller == 0);
`else // !`if AUTORESET
   assign kreset = (ksubs_runstop==0);      // Reset the design
   assign k_hold__ = (ksubs_runstop==2);    // Disable design stepping - single step in the future...
`endif


    parameter dram_dwidth = 256;          // 32 byte DRAM burst size or cache line.
    parameter laneSize = 8;
    parameter noLanes = dram_dwidth / laneSize; // Bytelanes.
    parameter memsize = 64;
 
    wire [noLanes-1:0] bs_r0bank_lanes;
    wire [21:0]         bs_r0bank_addr;
    wire bs_r0bank_oprdy, bs_r0bank_opreq, bs_r0bank_ack, bs_r0bank_rwbar;
    wire [dram_dwidth-1:0]  bs_r0bank_rdata, bs_r0bank_wdata;
 
    wire [noLanes-1:0] fs_r0bank_lanes;
    wire [21:0]         fs_r0bank_addr;
    wire fs_r0bank_oprdy, fs_r0bank_opreq, fs_r0bank_ack, fs_r0bank_rwbar;
   wire [dram_dwidth-1:0] fs_r0bank_rdata, fs_r0bank_wdata;
    

`ifndef DUT_WANTS_NOC8_SERVICE   
   assign Ksubs3_Noc16_RxData_rdy = 0;
   assign Ksubs3_Noc16_TxData_lo = 0;
   assign Ksubs3_Noc16_TxData_hi = 0;
   assign Ksubs3_Noc16_TxData_cmd = 0;
   assign Ksubs3_Noc16_TxData_valid = 0;
`endif

   
   // The design of interest - generated by KiwiC or otherwise. Must be called DUT for this wrapper.
   DUT the_dut(
	       // old director interface
	       .Knoc16Test10PC10nz_pc_export(pcmon),
	       .ksubsGpioLeds(ksubsGpioLeds),
	       .ksubsAbendSyndrome(ksubsAbendSyndrome),
	       .ksubsManualWaypoint(waypoint),



`ifdef DUT_WANTS_RESULT64_SERVICE   	       
	       .result_hi(result_hi),
	       .result_lo(result_lo),	       
`endif
	       .designSerialNumber(designSerialNumber),

	       
`ifdef DUT_WANTS_NOC8_SERVICE   	       
		// Ksubs Noc16 duplex interface
		.Ksubs3_Noc16_TxData_lo(Ksubs3_Noc16_TxData_lo),
	       //.Ksubs3_Noc16_TxData_hi(Ksubs3_Noc16_TxData_hi),
		.Ksubs3_Noc16_TxData_cmd(Ksubs3_Noc16_TxData_cmd),
		.Ksubs3_Noc16_TxData_valid(Ksubs3_Noc16_TxData_valid),
		.Ksubs3_Noc16_TxData_rdy(Ksubs3_Noc16_TxData_rdy),

		.Ksubs3_Noc16_RxData_lo(Ksubs3_Noc16_RxData_lo),
		//.Ksubs3_Noc16_RxData_hi(Ksubs3_Noc16_RxData_hi),
		.Ksubs3_Noc16_RxData_cmd(Ksubs3_Noc16_RxData_cmd),
		.Ksubs3_Noc16_RxData_valid(Ksubs3_Noc16_RxData_valid),
		.Ksubs3_Noc16_RxData_rdy(Ksubs3_Noc16_RxData_rdy),
`endif
			 
`ifdef DUT_WANTS_LOADSTORE_PORT0
	       // connect 'off-chip' memory to BRAM for now
	       .hf1_dram0bank_lanes(fs_r0bank_lanes),
	       .hf1_dram0bank_oprdy(fs_r0bank_oprdy),
	       .hf1_dram0bank_opreq(fs_r0bank_opreq),
	       .hf1_dram0bank_ack(fs_r0bank_ack),
	       .hf1_dram0bank_rwbar(fs_r0bank_rwbar), .hf1_dram0bank_rdata(fs_r0bank_rdata),
	       .hf1_dram0bank_addr(fs_r0bank_addr), .hf1_dram0bank_wdata(fs_r0bank_wdata),
`endif

`ifdef DUT_WANTS_PIO_32_8_SERVICE   
	       // Programmed I/O access from the director shim
	       .pio_hwen(pio_hwen), .pio_rdata(pio_rdata), .pio_wdata(pio_wdata), .pio_addr(pio_addr),
`endif	       
	       .clk(clk), 
	       .reset(kreset)
	   	       
    );


   assign mon0 = 0; // no longer used { controller, ksubsAbendSyndrome, ksubsGpioLeds };
   assign mon1 = pcmon;

   
`ifdef LOADSTORE_PORT_COUNT
   membank256_hf1    #(noLanes, laneSize, memsize) drambank0_hfast1
   		  (clk, kreset,
		      fs_r0bank_rwbar, fs_r0bank_rdata,
		      fs_r0bank_wdata, fs_r0bank_addr,
		      fs_r0bank_oprdy, fs_r0bank_opreq,
		      fs_r0bank_ack, fs_r0bank_lanes);
`endif
   
endmodule
// eof
