//
// Kiwi Scientific Acceleration 
// (C) 2014 DJ Greaves, University of Cambridge, Computer Laboratory.

//
// Example directorate shim for programmed IO 
//



using System;
using System.Text;
using KiwiSystem;
using System.Diagnostics;


class KSubs3_Director
{

// This design template can be adjusted as much as you like.

  [Kiwi.OutputWordPort("design_serial_number")]
  static int design_serial_number = 0x221102;

  [Kiwi.InputWordPort("pio_addr")]
  static int pio_addr;
  [Kiwi.InputWordPort("pio_wdata")]
  static int pio_wdata;
  [Kiwi.OutputWordPort("pio_rdata")]
  static int pio_rdata = 0;
  [Kiwi.InputBitPort("pio_hwen")]
  static bool pio_hwen;

  public const int pio_size = 10;

  // perhaps put some future Kiwi register file attribute here. [Kiwi.RegisterFile("pio_space")]
  [Kiwi.CombSRAM()] 
  public static int [] pio_space = new int [pio_size];

  [Kiwi.HardwareEntryPoint()]
  public static void host_pio_process()
  {
    while (true)
      {
	if (pio_hwen) pio_space[pio_addr] = pio_wdata;
	else pio_rdata = pio_space[pio_addr];
	Kiwi.Pause();
      }
  }


}


// eof