
#include <stdio.h>
#include <stdint.h>

// Coprocessor demo:


// EtherCRC example co-processor instructions
#define NOP_CUSTOM_ETHERCRC_READ     0x0008  
#define NOP_CUSTOM_ETHERCRC_WRITE    0x0009
#define NOP_CUSTOM_ETHERCRC_PROCESS  0x000A  


// We use in-line assembler to implement the NOPs.
void ethercrc_write(int value)
{
  asm("l.addi r3,%0,0": :"r" (value)                    : "r3");
  asm("l.nop %0"       : :"K" (NOP_CUSTOM_ETHERCRC_WRITE));
}

void ethercrc_process(int value)
{
  asm("l.addi r3,%0,0": :"r" (value)                      : "r3");
  asm("l.nop %0"       : :"K" (NOP_CUSTOM_ETHERCRC_PROCESS));
}

int ethercrc_read()
{
  volatile int value;
  asm("l.nop %0":        :"K" (NOP_CUSTOM_ETHERCRC_READ): "r3");
  asm("l.sw  %0(r1),r3": :"m" (value)                   :);
  return value;
}

 
// Test application: canned Ethernet test data.
uint8_t test_data[] = 
{
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
    0x00, 0x20, 0xaf, 0xb7, 0x80, 0xB8, 
    0x08, 0x06, 

    0x00, 0x01, 0x08, 0x00, 
    0x06, 0x04, 0x00, 0x01, 
    0x00, 0x20, 0xaf, 0xb7, 
    0x80,  0xB8, 0x80, 0xE8, 
    0x0f, 0x94, 0x00, 0x00, 
    0x00,  0x00, 0x00, 0x00, 
    0x80,  0xE8, 0x0f, 0xDe, 

    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde,

    0x9e, 0xd2,  0xc2, 0xaf 
};


const uint32_t ethernet_polynomial_le = 0xedb88320U;

// coprocessor implementation
unsigned ether_crc_le(int length0, uint8_t *data0, int foxes)
{
    int crc = (foxes) ? 0xffffffff: 0;	/* Initial value. */
    ethercrc_write(crc);
    int repeat;
    for (repeat=0;repeat<1000;repeat++)
      {
	int length = length0;
	int *idata = (int *) data0;
	for( ; length >= 0; length -=4)  
	  {
	    int d = *idata ++;
	    //printf("d=%08X, old=%08X\n", d, ethercrc_read());
	    ethercrc_process(d);
	  }
      }
    crc = ethercrc_read();
    printf("crc final %x\n", crc);
    /*  if (crc != 0xdebb20e3) printf("crc is wrong");*/
    return crc;
  }


int main()
{

  ether_crc_le(64, test_data, 1);
  return 0;
}

void _isr_routine()
{

}

// eof
