
// barelift-arm32
// barefliftshim.c - minimal C code for running 'bare metal' binaries on top of linux - a wierd thing to do.

// Including these may supress some warnings but might lead to further errors.
// #include <stdlib.h>
// #include <stdio.h>

//extern int bm_main(int argc, char *argv[]);
extern void bd_puts();

int _archglue_test_and_set(int *x, int v)
{
  // This is not atomic for now - this should use a strex instruction.
  int ov = *x;
  *x = v;
  return ov; // for now - not atomic. - see archglue code for real implementation.
}


void _core_pause()
{
   asm(" yield");
}


char craft_rdch() { return getchar(); }

void craft_wrch(char c)  // Every write is turned into a write system call.
{ 
  extern void craft_wrch_1char(char *);
  craft_wrch_1char(&c);
} 


void _kill_sim()
{
  printf("Sim killed\n");
  exit(0);
}


void bd_writes(const char *s)
{
  bd_puts(s, strlen(s));
}

int main(int argc, char *argv[])
{
  //bd_writes("barelifthshim says hello\n");
  int rc = bm_main(argc, argv);
  bd_writes("barelifthshim main finished\n");
  return 0;
}

void __aeabi_unwind_cpp_pr0()
{
  printf("unwind_cpp_pr0 %s %i\n", __FILE__, __LINE__);
}

void raise()
{
  printf("raised %s %i\n", __FILE__, __LINE__);
  exit(2);
}
// eof
