import numpy as np
import sys
import time
import serv_manager as svm
RC = [ 0x0000000000000001, 0x0000000000008082,\
       0x800000000000808A, 0x8000000080008000,\
       0x000000000000808B, 0x0000000080000001,\
       0x8000000080008081, 0x8000000000008009,\
       0x000000000000008A, 0x0000000000000088,\
       0x0000000080008009, 0x000000008000000A,\
       0x000000008000808B, 0x800000000000008B,\
       0x8000000000008089, 0x8000000000008003,\
       0x8000000000008002, 0x8000000000000080,\
       0x000000000000800A, 0x800000008000000A,\
       0x8000000080008081, 0x8000000000008080,\
       0x0000000080000001, 0x8000000080008008]

def read_table(name):
  T_array = svm.Load(name)
  table = []
  for n in range(0, 1600):
    table.append([])
  for n in range(0, 1600):
    for t in range(0, 2):
      temp = []
      temp.append(int(T_array[n][t][0]))
      temp.append(float(T_array[n][t][1]))
      table[n].append(temp)
    table[n].sort()
  return table

class Table:
  def __init__(self, prob=0.0):
    self.table = []
    for t in range(0, 2):
      temp = []
      temp.append(t)
      temp.append(prob)
      self.table.append(temp)
    return
  
  def norm(self):
    Prob = 0.0
    for t in range(0, 2):
      Prob += self.table[t][1]
    if Prob==0.0:
      return
    for t in range(0, 2):
      self.table[t][1] /= Prob
    return
  
  def INV(self):
    temp = self.table[0][1]
    self.table[0][1] = self.table[1][1]
    self.table[1][1] = temp
    return

Dummy = Table(1.0)

class Keys:
  Fore = svm.Load("rhopi_bit/foresupliment.npy")
  Back = svm.Load("rhopi_bit/backsupliment.npy")

class RP_variable:
  def __init__(self, table=Dummy.table):
    self.I0 = Table(1.0)
    for x in range(0, 2):
      self.I0.table[x][1] = table[x][1]
    self.RT = Table(1.0)
    self.RC = Table(1.0)
    return
  
  def Output_Q(self):
    qt = Table(1.0)
    qc = Table(1.0)
    for x in range(0, 2):
      qt.table[x][1] = self.RC.table[x][1]*self.I0.table[x][1]
      qc.table[x][1] = self.RT.table[x][1]*self.I0.table[x][1]
    return qt, qc
  
  def Renew_RT(self, rt):
    self.RT = rt
    self.RT.norm()
    return
  
  def Renew_RC(self, rc):
    self.RC = rc
    self.RC.norm()
    return
  
  def Zeta(self):
    output = Table(1.0)
    for x in range(0, 2):
      output.table[x][1] = self.RT.table[x][1]*self.RC.table[x][1]*self.I0.table[x][1]
    output.norm()
    return output

class CH_variable:
  def __init__(self, table=Dummy.table):
    self.I0 = Table(1.0)
    for x in range(0, 2):
      self.I0.table[x][1] = table[x][1]
    self.Rc = Table(1.0)
    self.Rt = Table(1.0)
    self.Rf = Table(1.0)
    return
  
  def Output_Q(self):
    qc = Table(1.0)
    qt = Table(1.0)
    qf = Table(1.0)
    for x in range(0, 2):
      qc.table[x][1] = self.Rt.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      qt.table[x][1] = self.Rc.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      qf.table[x][1] = self.Rc.table[x][1]*self.Rt.table[x][1]*self.I0.table[x][1]
    return qc, qt, qf
  
  def Renew_Rc(self, R):
    self.Rc = R
    self.Rc.norm()
    return
  
  def Renew_Rt(self, R):
    self.Rt = R
    self.Rt.norm()
    return
  
  def Renew_Rf(self, R):
    self.Rf = R
    self.Rf.norm()
    return
  
  def Zeta(self):
    output = Table(1.0)
    for x in range(0, 2):
      output.table[x][1] = self.Rc.table[x][1]*self.Rt.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
    output.norm()
    return output  

class CH_variable_INV:
  def __init__(self, table=Dummy.table):
    self.I0 = Table(1.0)
    for x in range(0, 2):
      self.I0.table[x][1] = table[x][1]
    self.Rc = Table(1.0) #To Chi factor.
    self.Rt = Table(1.0) #To third Theta factor.
    self.Rf = Table(1.0) #To first theta factor.
    return
  
  def Output_Q(self):
    qc = Table(1.0)
    qt = Table(1.0)
    qf = Table(1.0)
    for x in range(0, 2):
      qc.table[x][1] = self.Rt.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      qt.table[x][1] = self.Rc.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      qf.table[x][1] = self.Rc.table[x][1]*self.Rt.table[x][1]*self.I0.table[x][1]
    qt.INV()
    qf.INV()
    return qc, qt, qf
  
  def Renew_Rc(self, R):
    self.Rc = R
    self.Rc.norm()
    return
  
  def Renew_Rt(self, R):
    self.Rt = R
    self.Rt.norm()
    self.Rt.INV()
    return
  
  def Renew_Rf(self, R):
    self.Rf = R
    self.Rf.norm()
    self.Rf.INV()
    return
  
  def Zeta(self):
    output = Table(1.0)
    for x in range(0, 2):
      output.table[x][1] = self.Rc.table[x][1]*self.Rt.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
    output.norm()
    return output

class BC_variable:
  def __init__(self, table=Dummy.table):
    self.I0 = Table(1.0)                                                              
    for x in range(0, 2):                                             
      self.I0.table[x][1] = table[x][1]   
    self.Rf = Table(1.0) #To the first Theta factor.
    self.Rc = Table(1.0) #To the second Theta factor in the same slice.
    self.Rp = Table(1.0) #To the second Theta factor in the latter slice.
    return
  
  def Output_Q(self):
    qf = Table(1.0)
    qc = Table(1.0)
    qp = Table(1.0)
    for x in range(0, 2):
      qf.table[x][1] = self.Rc.table[x][1]*self.Rp.table[x][1]*self.I0.table[x][1]
      qc.table[x][1] = self.Rf.table[x][1]*self.Rp.table[x][1]*self.I0.table[x][1]
      qp.table[x][1] = self.Rf.table[x][1]*self.Rc.table[x][1]*self.I0.table[x][1]
    return qf, qc, qp
  
  def Renew_Rf(self, R):
    self.Rf = R
    self.Rf.norm()
    return
  
  def Renew_Rc(self, R):
    self.Rc = R
    self.Rc.norm()
    return
  
  def Renew_Rp(self, R):
    self.Rp = R
    self.Rp.norm()
    return
  
  def Zeta(self):
    output = Table(1.0)
    for x in range(0, 2):
      output.table[x][1] = self.Rf.table[x][1]*self.Rc.table[x][1]*self.Rp.table[x][1]*self.I0.table[x][1]
    output.norm()
    return output

class BD_variable:
  def __init__(self, table=Dummy.table):
    self.I0 = Table(1.0)
    for x in range(0, 2):
      self.I0.table[x][1] = table[x][1]
    self.R0 = Table(1.0)
    self.R1 = Table(1.0)
    self.R2 = Table(1.0)
    self.R3 = Table(1.0)
    self.R4 = Table(1.0)
    self.Rf = Table(1.0) #To the second Theta factor.
    return
  
  def Output_Q(self):
    q0 = Table(1.0)
    q1 = Table(1.0)
    q2 = Table(1.0)
    q3 = Table(1.0)
    q4 = Table(1.0)
    qf = Table(1.0)
    for x in range(0, 2):
      q0.table[x][1] = self.R1.table[x][1]*self.R2.table[x][1]*self.R3.table[x][1]*self.R4.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      q1.table[x][1] = self.R0.table[x][1]*self.R2.table[x][1]*self.R3.table[x][1]*self.R4.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      q2.table[x][1] = self.R0.table[x][1]*self.R1.table[x][1]*self.R3.table[x][1]*self.R4.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      q3.table[x][1] = self.R0.table[x][1]*self.R1.table[x][1]*self.R2.table[x][1]*self.R4.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      q4.table[x][1] = self.R0.table[x][1]*self.R1.table[x][1]*self.R2.table[x][1]*self.R3.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
      qf.table[x][1] = self.R0.table[x][1]*self.R1.table[x][1]*self.R2.table[x][1]*self.R3.table[x][1]*self.R4.table[x][1]*self.I0.table[x][1]
    return q0, q1, q2, q3, q4, qf
  
  def Renew_R0(self, R):
    self.R0 = R
    self.R0.norm()
    return
  
  def Renew_R1(self, R):
    self.R1 = R
    self.R1.norm()
    return
  
  def Renew_R2(self, R):
    self.R2 = R
    self.R2.norm()
    return
  
  def Renew_R3(self, R):
    self.R3 = R
    self.R3.norm()
    return
  
  def Renew_R4(self, R):
    self.R4 = R
    self.R4.norm()
    return
  
  def Renew_Rf(self, R):
    self.Rf = R
    self.Rf.norm()
    return
  
  def Zeta(self):
    output = Table(1.0)
    for x in range(0, 2):
      output.table[x][1] = self.R0.table[x][1]*self.R1.table[x][1]*self.R2.table[x][1]*self.R3.table[x][1]*self.R4.table[x][1]*self.Rf.table[x][1]*self.I0.table[x][1]
    output.norm()
    return output


class THETA_factor_first:
  def __init__(self):
    self.Q0 = Table(1.0)
    self.Q1 = Table(1.0)
    self.Q2 = Table(1.0)
    self.Q3 = Table(1.0)
    self.Q4 = Table(1.0)
    self.Qf = Table(1.0) #To the BC.
    return
  
  def Output_R(self):
    R0 = Table(0.0)
    R1 = Table(0.0)
    R2 = Table(0.0)
    R3 = Table(0.0)
    R4 = Table(0.0)
    Rf = Table(0.0)
    for t0 in range(0, 2):
      for t1 in range(0, 2):
        for t2 in range(0, 2):
          for t3 in range(0, 2):
            for t4 in range(0, 2):
              tf = (t0^t1^t2^t3^t4)&0x1
              R0.table[t0][1] += self.Q1.table[t1][1]*self.Q2.table[t2][1]*self.Q3.table[t3][1]*self.Q4.table[t4][1]*self.Qf.table[tf][1]
              R1.table[t1][1] += self.Q0.table[t0][1]*self.Q2.table[t2][1]*self.Q3.table[t3][1]*self.Q4.table[t4][1]*self.Qf.table[tf][1]
              R2.table[t2][1] += self.Q0.table[t0][1]*self.Q1.table[t1][1]*self.Q3.table[t3][1]*self.Q4.table[t4][1]*self.Qf.table[tf][1]
              R3.table[t3][1] += self.Q0.table[t0][1]*self.Q1.table[t1][1]*self.Q2.table[t2][1]*self.Q4.table[t4][1]*self.Qf.table[tf][1]
              R4.table[t4][1] += self.Q0.table[t0][1]*self.Q1.table[t1][1]*self.Q2.table[t2][1]*self.Q3.table[t3][1]*self.Qf.table[tf][1]
              Rf.table[tf][1] += self.Q0.table[t0][1]*self.Q1.table[t1][1]*self.Q2.table[t2][1]*self.Q3.table[t3][1]*self.Q4.table[t4][1]
    return R0, R1, R2, R3, R4, Rf
  
  def Renew_Q0(self, Q):
    self.Q0 = Q
    self.Q0.norm()
    return
  
  def Renew_Q1(self, Q):
    self.Q1 = Q
    self.Q1.norm()
    return
  
  def Renew_Q2(self, Q):
    self.Q2 = Q
    self.Q2.norm()
    return
  
  def Renew_Q3(self, Q):
    self.Q3 = Q
    self.Q3.norm()
    return
  
  def Renew_Q4(self, Q):
    self.Q4 = Q
    self.Q4.norm()
    return
  
  def Renew_Qf(self, Q):
    self.Qf = Q
    self.Qf.norm()
    return

class THETA_factor_second:
  def __init__(self):
    self.Qc = Table(1.0) #To the BC vector in the same slice.
    self.Qp = Table(1.0) #To the BC vector in the previous slice.
    self.Qb = Table(1.0) #To the BD vector.
    return
  
  def Output_R(self):
    Rc = Table(0.0)
    Rp = Table(0.0)
    Rb = Table(0.0)
    for tc in range(0, 2):
      for tp in range(0, 2):
        tb = (tc^tp)&0x1
        Rc.table[tc][1] += self.Qp.table[tp][1]*self.Qb.table[tb][1]
        Rp.table[tp][1] += self.Qc.table[tc][1]*self.Qb.table[tb][1]
        Rb.table[tb][1] += self.Qc.table[tc][1]*self.Qp.table[tp][1]
    return Rc, Rp, Rb
  
  def Renew_Qc(self, Q):
    self.Qc = Q
    self.Qc.norm()
    return
  
  def Renew_Qp(self, Q):
    self.Qp = Q
    self.Qp.norm()
    return
  
  def Renew_Qb(self, Q):
    self.Qb = Q
    self.Qb.norm()
    return

class THETA_factor_third:
  def __init__(self):
    self.Qbd = Table(1.0)
    self.Qch = Table(1.0)
    self.Qth = Table(1.0)
    return
  
  def Output_R(self):
    Rbd = Table(0.0)
    Rch = Table(0.0)
    Rth = Table(0.0)
    for t0 in range(0, 2):
      for t1 in range(0, 2):
        t2 = (t0^t1)&0x1
        Rbd.table[t0][1] += self.Qch.table[t1][1]*self.Qth.table[t2][1]
        Rch.table[t1][1] += self.Qbd.table[t0][1]*self.Qth.table[t2][1]
        Rth.table[t2][1] += self.Qbd.table[t0][1]*self.Qch.table[t1][1]
    return Rbd, Rch, Rth
  
  def Renew_Qbd(self, Q):
    self.Qbd = Q
    self.Qbd.norm()
    return
  
  def Renew_Qch(self, Q):
    self.Qch = Q
    self.Qch.norm()
    return
  
  def Renew_Qth(self, Q):
    self.Qth = Q
    self.Qth.norm()
    return

class CHI_factor:
  def __init__(self):
    self.Qut0 = Table(1.0)
    self.Qut1 = Table(1.0)
    self.Qut2 = Table(1.0)
    self.Qut3 = Table(1.0)
    self.Qut4 = Table(1.0)
    self.Qin0 = Table(1.0)
    self.Qin1 = Table(1.0)
    self.Qin2 = Table(1.0)
    self.Qin3 = Table(1.0)
    self.Qin4 = Table(1.0)
    return
  
  def constraint(self, x0, x1, x2, x3, x4):
    o0 = ((x0^((0x1^x1)&x2)))&0x1
    o1 = ((x1^((0x1^x2)&x3)))&0x1
    o2 = ((x2^((0x1^x3)&x4)))&0x1
    o3 = ((x3^((0x1^x4)&x0)))&0x1
    o4 = ((x4^((0x1^x0)&x1)))&0x1
    return o0, o1, o2, o3, o4
  
  def Output_R(self):
    O0 = Table(0.0)
    O1 = Table(0.0)
    O2 = Table(0.0)
    O3 = Table(0.0)
    O4 = Table(0.0)
    R0 = Table(0.0)
    R1 = Table(0.0)
    R2 = Table(0.0)
    R3 = Table(0.0)
    R4 = Table(0.0)
    for t0 in range(0, 2):
      for t1 in range(0, 2):
        for t2 in range(0, 2):
          for t3 in range(0, 2):
            for t4 in range(0, 2):
              z0, z1, z2, z3, z4 = self.constraint(t0, t1, t2, t3, t4)
              O0.table[z0][1] += self.Qin0.table[t0][1]*self.Qin1.table[t1][1]*self.Qin2.table[t2][1]*self.Qin3.table[t3][1]*self.Qin4.table[t4][1]*self.Qut1.table[z1][1]*self.Qut2.table[z2][1]*self.Qut3.table[z3][1]*self.Qut4.table[z4][1]
              O1.table[z1][1] += self.Qin0.table[t0][1]*self.Qin1.table[t1][1]*self.Qin2.table[t2][1]*self.Qin3.table[t3][1]*self.Qin4.table[t4][1]*self.Qut0.table[z0][1]*self.Qut2.table[z2][1]*self.Qut3.table[z3][1]*self.Qut4.table[z4][1]
              O2.table[z2][1] += self.Qin0.table[t0][1]*self.Qin1.table[t1][1]*self.Qin2.table[t2][1]*self.Qin3.table[t3][1]*self.Qin4.table[t4][1]*self.Qut0.table[z0][1]*self.Qut1.table[z1][1]*self.Qut3.table[z3][1]*self.Qut4.table[z4][1]
              O3.table[z3][1] += self.Qin0.table[t0][1]*self.Qin1.table[t1][1]*self.Qin2.table[t2][1]*self.Qin3.table[t3][1]*self.Qin4.table[t4][1]*self.Qut0.table[z0][1]*self.Qut1.table[z1][1]*self.Qut2.table[z2][1]*self.Qut4.table[z4][1]
              O4.table[z4][1] += self.Qin0.table[t0][1]*self.Qin1.table[t1][1]*self.Qin2.table[t2][1]*self.Qin3.table[t3][1]*self.Qin4.table[t4][1]*self.Qut0.table[z0][1]*self.Qut1.table[z1][1]*self.Qut2.table[z2][1]*self.Qut3.table[z3][1]
              R0.table[t0][1] += self.Qin1.table[t1][1]*self.Qin2.table[t2][1]*self.Qin3.table[t3][1]*self.Qin4.table[t4][1]*self.Qut0.table[z0][1]*self.Qut1.table[z1][1]*self.Qut2.table[z2][1]*self.Qut3.table[z3][1]*self.Qut4.table[z4][1]
              R1.table[t1][1] += self.Qin0.table[t0][1]*self.Qin2.table[t2][1]*self.Qin3.table[t3][1]*self.Qin4.table[t4][1]*self.Qut0.table[z0][1]*self.Qut1.table[z1][1]*self.Qut2.table[z2][1]*self.Qut3.table[z3][1]*self.Qut4.table[z4][1]
              R2.table[t2][1] += self.Qin0.table[t0][1]*self.Qin1.table[t1][1]*self.Qin3.table[t3][1]*self.Qin4.table[t4][1]*self.Qut0.table[z0][1]*self.Qut1.table[z1][1]*self.Qut2.table[z2][1]*self.Qut3.table[z3][1]*self.Qut4.table[z4][1]
              R3.table[t3][1] += self.Qin0.table[t0][1]*self.Qin1.table[t1][1]*self.Qin2.table[t2][1]*self.Qin4.table[t4][1]*self.Qut0.table[z0][1]*self.Qut1.table[z1][1]*self.Qut2.table[z2][1]*self.Qut3.table[z3][1]*self.Qut4.table[z4][1]
              R4.table[t4][1] += self.Qin0.table[t0][1]*self.Qin1.table[t1][1]*self.Qin2.table[t2][1]*self.Qin3.table[t3][1]*self.Qut0.table[z0][1]*self.Qut1.table[z1][1]*self.Qut2.table[z2][1]*self.Qut3.table[z3][1]*self.Qut4.table[z4][1]
    return O0, O1, O2, O3, O4, R0, R1, R2, R3, R4
  
  def Renew_Qut(self, Q, x):
    if x==0:
      self.Qut0 = Q
      self.Qut0.norm()
    elif x==1:
      self.Qut1 = Q
      self.Qut1.norm()
    elif x==2:
      self.Qut2 = Q
      self.Qut2.norm()
    elif x==3:
      self.Qut3 = Q
      self.Qut3.norm()
    elif x==4:
      self.Qut4 = Q
      self.Qut4.norm()
    return
  
  def Renew_Qin(self, Q, x):
    if x==0:
      self.Qin0 = Q
      self.Qin0.norm()
    elif x==1:
      self.Qin1 = Q
      self.Qin1.norm()
    elif x==2:
      self.Qin2 = Q
      self.Qin2.norm()
    elif x==3:
      self.Qin3 = Q
      self.Qin3.norm()
    elif x==4:
      self.Qin4 = Q
      self.Qin4.norm()
    return


class FourRounds_SASCA:
  def __init__(self, T_IN, T_C0, T_D0, T_A0, T_B0, T_C1, T_D1, T_A1, T_B1, T_C2, T_D2, T_A2, T_B2, T_C3, T_D3, T_A3, T_B3):
    self.IN_V = []
    # Round 0:
    self.BC0_V = []
    self.BD0_V = []
    self.THETA0_F1 = []
    self.THETA0_F2 = []
    self.THETA0_F3 = []
    self.RP0_V = []
    self.CHI0_F = []
    self.CH0_V = []
    # Round 1:
    self.BC1_V = []
    self.BD1_V = []
    self.THETA1_F1 = []
    self.THETA1_F2 = []
    self.THETA1_F3 = []
    self.RP1_V = []
    self.CHI1_F = []
    self.CH1_V = []
    # Round 2:
    self.BC2_V = []
    self.BD2_V = []
    self.THETA2_F1 = []
    self.THETA2_F2 = []
    self.THETA2_F3 = []
    self.RP2_V = []
    self.CHI2_F = []
    self.CH2_V = []
    # Round 3:
    self.BC3_V = []
    self.BD3_V = []
    self.THETA3_F1 = []
    self.THETA3_F2 = []
    self.THETA3_F3 = []
    self.RP3_V = []
    self.CHI3_F = []
    self.CH3_V = []
    #
    for vy in range(0, 320):
      #Round 0:
      self.BC0_V.append(BC_variable(T_C0[vy]))
      self.BD0_V.append(BD_variable(T_D0[vy]))
      self.THETA0_F1.append(THETA_factor_first())
      self.THETA0_F2.append(THETA_factor_second())
      self.CHI0_F.append(CHI_factor())
      #Round 1:
      self.BC1_V.append(BC_variable(T_C1[vy]))
      self.BD1_V.append(BD_variable(T_D1[vy]))
      self.THETA1_F1.append(THETA_factor_first())
      self.THETA1_F2.append(THETA_factor_second())
      self.CHI1_F.append(CHI_factor())
      #Round 2:
      self.BC2_V.append(BC_variable(T_C2[vy]))
      self.BD2_V.append(BD_variable(T_D2[vy]))
      self.THETA2_F1.append(THETA_factor_first())
      self.THETA2_F2.append(THETA_factor_second())
      self.CHI2_F.append(CHI_factor())
      #Round 3:
      self.BC3_V.append(BC_variable(T_C3[vy]))
      self.BD3_V.append(BD_variable(T_D3[vy]))
      self.THETA3_F1.append(THETA_factor_first())
      self.THETA3_F2.append(THETA_factor_second())
      self.CHI3_F.append(CHI_factor())
    #
    for y in range(0, 5):
      for x in range(0, 5):
        for z in range(0, 64):
          v = y*320+x*64+z
          self.IN_V.append(CH_variable((T_IN[v])))
          #Round 0:
          self.THETA0_F3.append(THETA_factor_third())
          self.RP0_V.append(RP_variable((T_A0[v])))
          if (x==0) and (y==0) and ((RC[0]&(2**z))!=0):
            self.CH0_V.append(CH_variable_INV((T_B0[v])))
          else:
            self.CH0_V.append(CH_variable((T_B0[v])))
          #Round 1:
          self.THETA1_F3.append(THETA_factor_third())
          self.RP1_V.append(RP_variable((T_A1[v])))
          if (x==0) and (y==0) and ((RC[1]&(2**z))!=0):
            self.CH1_V.append(CH_variable_INV((T_B1[v])))
          else:
            self.CH1_V.append(CH_variable((T_B1[v])))
          #Round 2:
          self.THETA2_F3.append(THETA_factor_third())
          self.RP2_V.append(RP_variable((T_A2[v])))
          if (x==0) and (y==0) and ((RC[2]&(2**z))!=0):
            self.CH2_V.append(CH_variable_INV((T_B2[v])))
          else:
            self.CH2_V.append(CH_variable((T_B2[v])))
          #Round 3:
          self.THETA3_F3.append(THETA_factor_third())
          self.RP3_V.append(RP_variable((T_A3[v])))
          if (x==0) and (y==0) and ((RC[3]&(2**z))!=0):
            self.CH3_V.append(CH_variable_INV((T_B3[v])))
          else:
            self.CH3_V.append(CH_variable((T_B3[v])))
    return
  
  def R_renew(self):
    #print "R_renew"
    #THETA0 outputs
    for z in range(0, 64):
      for x in range(0, 5):
        pl = x*64+z
        R0, R1, R2, R3, R4, Rf = self.THETA0_F1[pl].Output_R()
        self.IN_V[pl].Renew_Rf(R0)
        self.IN_V[(pl+320)].Renew_Rf(R1)
        self.IN_V[(pl+640)].Renew_Rf(R2)
        self.IN_V[(pl+960)].Renew_Rf(R3)
        self.IN_V[(pl+1280)].Renew_Rf(R4)
        self.BC0_V[pl].Renew_Rf(Rf)
        Rc, Rp, Rb = self.THETA0_F2[pl].Output_R()
        plc = ((x+4)%5)*64+z
        self.BC0_V[plc].Renew_Rc(Rc)
        plp = ((x+1)%5)*64+((z+63)%64)
        self.BC0_V[plp].Renew_Rp(Rp)
        self.BD0_V[pl].Renew_Rf(Rb)
        RBD = []
        for y in range(0, 5):
          v = y*320+x*64+z
          Rbd, Rch, Rth = self.THETA0_F3[v].Output_R()
          RBD.append(Rbd)
          self.IN_V[v].Renew_Rt(Rch)
          self.RP0_V[(Keys.Back[v])].Renew_RT(Rth)
        self.BD0_V[pl].Renew_R0(RBD[0])
        self.BD0_V[pl].Renew_R1(RBD[1])
        self.BD0_V[pl].Renew_R2(RBD[2])
        self.BD0_V[pl].Renew_R3(RBD[3])
        self.BD0_V[pl].Renew_R4(RBD[4])
    #CHI0 outputs
    for y in range(0, 5):
      for z in range(0, 64):
        v_ch = y*64+z
        v0 = y*64*5+z
        O0_0, O0_1, O0_2, O0_3, O0_4, R0_0, R0_1, R0_2, R0_3, R0_4 = self.CHI0_F[v_ch].Output_R()
        self.CH0_V[v0+64*0].Renew_Rc(O0_0)
        self.CH0_V[v0+64*1].Renew_Rc(O0_1)
        self.CH0_V[v0+64*2].Renew_Rc(O0_2)
        self.CH0_V[v0+64*3].Renew_Rc(O0_3)
        self.CH0_V[v0+64*4].Renew_Rc(O0_4)
        self.RP0_V[v0+64*0].Renew_RC(R0_0)
        self.RP0_V[v0+64*1].Renew_RC(R0_1)
        self.RP0_V[v0+64*2].Renew_RC(R0_2)
        self.RP0_V[v0+64*3].Renew_RC(R0_3)
        self.RP0_V[v0+64*4].Renew_RC(R0_4)
    #THETA1 outputs
    for z in range(0, 64):
      for x in range(0, 5):
        pl = x*64+z
        R0, R1, R2, R3, R4, Rf = self.THETA1_F1[pl].Output_R()
        self.CH0_V[pl].Renew_Rf(R0)
        self.CH0_V[(pl+320)].Renew_Rf(R1)
        self.CH0_V[(pl+640)].Renew_Rf(R2)
        self.CH0_V[(pl+960)].Renew_Rf(R3)
        self.CH0_V[(pl+1280)].Renew_Rf(R4)
        self.BC1_V[pl].Renew_Rf(Rf)
        Rc, Rp, Rb = self.THETA1_F2[pl].Output_R()
        plc = ((x+4)%5)*64+z
        self.BC1_V[plc].Renew_Rc(Rc)
        plp = ((x+1)%5)*64+((z+63)%64)
        self.BC1_V[plp].Renew_Rp(Rp)
        self.BD1_V[pl].Renew_Rf(Rb)
        RBD = []
        for y in range(0, 5):
          v = y*320+x*64+z
          Rbd, Rch, Rth = self.THETA1_F3[v].Output_R()
          RBD.append(Rbd)
          self.CH0_V[v].Renew_Rt(Rch)
          self.RP1_V[(Keys.Back[v])].Renew_RT(Rth)
        self.BD1_V[pl].Renew_R0(RBD[0])
        self.BD1_V[pl].Renew_R1(RBD[1])
        self.BD1_V[pl].Renew_R2(RBD[2])
        self.BD1_V[pl].Renew_R3(RBD[3])
        self.BD1_V[pl].Renew_R4(RBD[4])
    #CHI1 outputs
    for y in range(0, 5):
      for z in range(0, 64):
        v_ch = y*64+z
        v0 = y*64*5+z
        O1_0, O1_1, O1_2, O1_3, O1_4, R1_0, R1_1, R1_2, R1_3, R1_4 = self.CHI1_F[v_ch].Output_R()
        self.CH1_V[v0+64*0].Renew_Rc(O1_0)
        self.CH1_V[v0+64*1].Renew_Rc(O1_1)
        self.CH1_V[v0+64*2].Renew_Rc(O1_2)
        self.CH1_V[v0+64*3].Renew_Rc(O1_3)
        self.CH1_V[v0+64*4].Renew_Rc(O1_4)
        self.RP1_V[v0+64*0].Renew_RC(R1_0)
        self.RP1_V[v0+64*1].Renew_RC(R1_1)
        self.RP1_V[v0+64*2].Renew_RC(R1_2)
        self.RP1_V[v0+64*3].Renew_RC(R1_3)
        self.RP1_V[v0+64*4].Renew_RC(R1_4)
    #THETA2 outputs
    for z in range(0, 64):
      for x in range(0, 5):
        pl = x*64+z
        R0, R1, R2, R3, R4, Rf = self.THETA2_F1[pl].Output_R()
        self.CH1_V[pl].Renew_Rf(R0)
        self.CH1_V[(pl+320)].Renew_Rf(R1)
        self.CH1_V[(pl+640)].Renew_Rf(R2)
        self.CH1_V[(pl+960)].Renew_Rf(R3)
        self.CH1_V[(pl+1280)].Renew_Rf(R4)
        self.BC2_V[pl].Renew_Rf(Rf)
        Rc, Rp, Rb = self.THETA2_F2[pl].Output_R()
        plc = ((x+4)%5)*64+z
        self.BC2_V[plc].Renew_Rc(Rc)
        plp = ((x+1)%5)*64+((z+63)%64)
        self.BC2_V[plp].Renew_Rp(Rp)
        self.BD2_V[pl].Renew_Rf(Rb)
        RBD = []
        for y in range(0, 5):
          v = y*320+x*64+z
          Rbd, Rch, Rth = self.THETA2_F3[v].Output_R()
          RBD.append(Rbd)
          self.CH1_V[v].Renew_Rt(Rch)
          self.RP2_V[(Keys.Back[v])].Renew_RT(Rth)
        self.BD2_V[pl].Renew_R0(RBD[0])
        self.BD2_V[pl].Renew_R1(RBD[1])
        self.BD2_V[pl].Renew_R2(RBD[2])
        self.BD2_V[pl].Renew_R3(RBD[3])
        self.BD2_V[pl].Renew_R4(RBD[4])
    #CHI2 outputs
    for y in range(0, 5):
      for z in range(0, 64):
        v_ch = y*64+z
        v0 = y*64*5+z
        O2_0, O2_1, O2_2, O2_3, O2_4, R2_0, R2_1, R2_2, R2_3, R2_4 = self.CHI2_F[v_ch].Output_R()
        self.CH2_V[v0+64*0].Renew_Rc(O2_0)
        self.CH2_V[v0+64*1].Renew_Rc(O2_1)
        self.CH2_V[v0+64*2].Renew_Rc(O2_2)
        self.CH2_V[v0+64*3].Renew_Rc(O2_3)
        self.CH2_V[v0+64*4].Renew_Rc(O2_4)
        self.RP2_V[v0+64*0].Renew_RC(R2_0)
        self.RP2_V[v0+64*1].Renew_RC(R2_1)
        self.RP2_V[v0+64*2].Renew_RC(R2_2)
        self.RP2_V[v0+64*3].Renew_RC(R2_3)
        self.RP2_V[v0+64*4].Renew_RC(R2_4)
    #THETA3 outputs
    for z in range(0, 64):
      for x in range(0, 5):
        pl = x*64+z
        R0, R1, R2, R3, R4, Rf = self.THETA3_F1[pl].Output_R()
        self.CH2_V[pl].Renew_Rf(R0)
        self.CH2_V[(pl+320)].Renew_Rf(R1)
        self.CH2_V[(pl+640)].Renew_Rf(R2)
        self.CH2_V[(pl+960)].Renew_Rf(R3)
        self.CH2_V[(pl+1280)].Renew_Rf(R4)
        self.BC3_V[pl].Renew_Rf(Rf)
        Rc, Rp, Rb = self.THETA3_F2[pl].Output_R()
        plc = ((x+4)%5)*64+z
        self.BC3_V[plc].Renew_Rc(Rc)
        plp = ((x+1)%5)*64+((z+63)%64)
        self.BC3_V[plp].Renew_Rp(Rp)
        self.BD3_V[pl].Renew_Rf(Rb)
        RBD = []
        for y in range(0, 5):
          v = y*320+x*64+z
          Rbd, Rch, Rth = self.THETA3_F3[v].Output_R()
          RBD.append(Rbd)
          self.CH2_V[v].Renew_Rt(Rch)
          self.RP3_V[(Keys.Back[v])].Renew_RT(Rth)
        self.BD3_V[pl].Renew_R0(RBD[0])
        self.BD3_V[pl].Renew_R1(RBD[1])
        self.BD3_V[pl].Renew_R2(RBD[2])
        self.BD3_V[pl].Renew_R3(RBD[3])
        self.BD3_V[pl].Renew_R4(RBD[4])
    #CHI3 outputs
    for y in range(0, 5):
      for z in range(0, 64):
        v_ch = y*64+z
        v0 = y*64*5+z
        O3_0, O3_1, O3_2, O3_3, O3_4, R3_0, R3_1, R3_2, R3_3, R3_4 = self.CHI3_F[v_ch].Output_R()
        self.CH3_V[v0+64*0].Renew_Rc(O3_0)
        self.CH3_V[v0+64*1].Renew_Rc(O3_1)
        self.CH3_V[v0+64*2].Renew_Rc(O3_2)
        self.CH3_V[v0+64*3].Renew_Rc(O3_3)
        self.CH3_V[v0+64*4].Renew_Rc(O3_4)
        self.RP3_V[v0+64*0].Renew_RC(R3_0)
        self.RP3_V[v0+64*1].Renew_RC(R3_1)
        self.RP3_V[v0+64*2].Renew_RC(R3_2)
        self.RP3_V[v0+64*3].Renew_RC(R3_3)
        self.RP3_V[v0+64*4].Renew_RC(R3_4)
    return
  
  def Q_renew(self):
    #print "Q_renew"
    for z in range(0, 64):
      for x in range(0, 5):
        QC0 = [0,0,0,0,0]
        QC1 = [0,0,0,0,0]
        QC2 = [0,0,0,0,0]
        QC3 = [0,0,0,0,0]
        for y in range(0, 5):
          v0 = y*320+x*64+z
          v4 = y*320+((x+4)%5)*64+z
          v3 = y*320+((x+3)%5)*64+z
          #IN outputs
          _, QIt, QIf = self.IN_V[v0].Output_Q()
          self.THETA0_F3[v0].Renew_Qch(QIt)
          QC0[y] = QIf
          #RP0 outputs
          Q0_pr, Q0_ch = self.RP0_V[v0].Output_Q()
          self.THETA0_F3[(Keys.Fore[v0])].Renew_Qth(Q0_pr)
          self.CHI0_F[(y*64+z)].Renew_Qin(Q0_ch, x)
          #CH0 outputs
          Q0c, Q0t, Q0f = self.CH0_V[v0].Output_Q()
          self.CHI0_F[(y*64+z)].Renew_Qut(Q0c, x)
          self.THETA1_F3[v0].Renew_Qch(Q0t)
          QC1[y] = Q0f
          #RP1 outputs
          Q1_pr, Q1_ch = self.RP1_V[v0].Output_Q()
          self.THETA1_F3[(Keys.Fore[v0])].Renew_Qth(Q1_pr)
          self.CHI1_F[(y*64+z)].Renew_Qin(Q1_ch, x)
          #CH1 outputs
          Q1c, Q1t, Q1f = self.CH1_V[v0].Output_Q()
          self.CHI1_F[(y*64+z)].Renew_Qut(Q1c, x)
          self.THETA2_F3[v0].Renew_Qch(Q1t)
          QC2[y] = Q1f
          #RP2 outputs
          Q2_pr, Q2_ch = self.RP2_V[v0].Output_Q()
          self.THETA2_F3[(Keys.Fore[v0])].Renew_Qth(Q2_pr)
          self.CHI2_F[(y*64+z)].Renew_Qin(Q2_ch, x)
          #CH2 outputs
          Q2c, Q2t, Q2f = self.CH2_V[v0].Output_Q()
          self.CHI2_F[(y*64+z)].Renew_Qut(Q2c, x)
          self.THETA3_F3[v0].Renew_Qch(Q2t)
          QC3[y] = Q2f
          #RP3 outputs
          Q3_pr, Q3_ch = self.RP3_V[v0].Output_Q()
          self.THETA3_F3[(Keys.Fore[v0])].Renew_Qth(Q3_pr)
          self.CHI3_F[(y*64+z)].Renew_Qin(Q3_ch, x)
          #CH3 outputs
          Q3c, _, _ = self.CH3_V[v0].Output_Q()
          self.CHI3_F[(y*64+z)].Renew_Qut(Q3c, x)
        pl = x*64+z
        plc = ((x+1)%5)*64+z
        plp = ((x+4)%5)*64+((z+1)%64)
        #Round 0
        self.THETA0_F1[pl].Renew_Q0(QC0[0])
        self.THETA0_F1[pl].Renew_Q1(QC0[1])
        self.THETA0_F1[pl].Renew_Q2(QC0[2])
        self.THETA0_F1[pl].Renew_Q3(QC0[3])
        self.THETA0_F1[pl].Renew_Q4(QC0[4])
        #BC0 outputs
        qf, qc, qp = self.BC0_V[pl].Output_Q()
        self.THETA0_F1[pl].Renew_Qf(qf)
        self.THETA0_F2[plc].Renew_Qc(qc)
        self.THETA0_F2[plp].Renew_Qp(qp)
        #BD0 outputs
        q0, q1, q2, q3, q4, qf = self.BD0_V[pl].Output_Q()
        self.THETA0_F3[pl].Renew_Qbd(q0)
        self.THETA0_F3[(pl+320)].Renew_Qbd(q1)
        self.THETA0_F3[(pl+640)].Renew_Qbd(q2)
        self.THETA0_F3[(pl+960)].Renew_Qbd(q3)
        self.THETA0_F3[(pl+1280)].Renew_Qbd(q4)
        self.THETA0_F2[pl].Renew_Qb(qf)
        #Round 1
        self.THETA1_F1[pl].Renew_Q0(QC1[0])
        self.THETA1_F1[pl].Renew_Q1(QC1[1])
        self.THETA1_F1[pl].Renew_Q2(QC1[2])
        self.THETA1_F1[pl].Renew_Q3(QC1[3])
        self.THETA1_F1[pl].Renew_Q4(QC1[4])
        #BC1 outputs
        qf, qc, qp = self.BC1_V[pl].Output_Q()
        self.THETA1_F1[pl].Renew_Qf(qf)
        self.THETA1_F2[plc].Renew_Qc(qc)
        self.THETA1_F2[plp].Renew_Qp(qp)
        #BD1 outputs
        q0, q1, q2, q3, q4, qf = self.BD1_V[pl].Output_Q()
        self.THETA1_F3[pl].Renew_Qbd(q0)
        self.THETA1_F3[(pl+320)].Renew_Qbd(q1)
        self.THETA1_F3[(pl+640)].Renew_Qbd(q2)
        self.THETA1_F3[(pl+960)].Renew_Qbd(q3)
        self.THETA1_F3[(pl+1280)].Renew_Qbd(q4)
        self.THETA1_F2[pl].Renew_Qb(qf)
        #Round 2
        self.THETA2_F1[pl].Renew_Q0(QC2[0])
        self.THETA2_F1[pl].Renew_Q1(QC2[1])
        self.THETA2_F1[pl].Renew_Q2(QC2[2])
        self.THETA2_F1[pl].Renew_Q3(QC2[3])
        self.THETA2_F1[pl].Renew_Q4(QC2[4])
        #BC2 outputs
        qf, qc, qp = self.BC2_V[pl].Output_Q()
        self.THETA2_F1[pl].Renew_Qf(qf)
        self.THETA2_F2[plc].Renew_Qc(qc)
        self.THETA2_F2[plp].Renew_Qp(qp)
        #BD2 outputs
        q0, q1, q2, q3, q4, qf = self.BD2_V[pl].Output_Q()
        self.THETA2_F3[pl].Renew_Qbd(q0)
        self.THETA2_F3[(pl+320)].Renew_Qbd(q1)
        self.THETA2_F3[(pl+640)].Renew_Qbd(q2)
        self.THETA2_F3[(pl+960)].Renew_Qbd(q3)
        self.THETA2_F3[(pl+1280)].Renew_Qbd(q4)
        self.THETA2_F2[pl].Renew_Qb(qf)
        #Round 3
        self.THETA3_F1[pl].Renew_Q0(QC3[0])
        self.THETA3_F1[pl].Renew_Q1(QC3[1])
        self.THETA3_F1[pl].Renew_Q2(QC3[2])
        self.THETA3_F1[pl].Renew_Q3(QC3[3])
        self.THETA3_F1[pl].Renew_Q4(QC3[4])
        #BC3 outputs
        qf, qc, qp = self.BC3_V[pl].Output_Q()
        self.THETA3_F1[pl].Renew_Qf(qf)
        self.THETA3_F2[plc].Renew_Qc(qc)
        self.THETA3_F2[plp].Renew_Qp(qp)
        #BD3 outputs
        q0, q1, q2, q3, q4, qf = self.BD3_V[pl].Output_Q()
        self.THETA3_F3[pl].Renew_Qbd(q0)
        self.THETA3_F3[(pl+320)].Renew_Qbd(q1)
        self.THETA3_F3[(pl+640)].Renew_Qbd(q2)
        self.THETA3_F3[(pl+960)].Renew_Qbd(q3)
        self.THETA3_F3[(pl+1280)].Renew_Qbd(q4)
        self.THETA3_F2[pl].Renew_Qb(qf)
    return
  
  def Zeta_out(self, func, v):
    if func=='INP':
      tb = self.IN_V[v].Zeta()
    elif func=='C00':
      tb = self.BC0_V[v].Zeta()
    elif func=='D00':
      tb = self.BD0_V[v].Zeta()
    elif func=='A00':
      tb = self.RP0_V[v].Zeta()
    elif func=='B00':
      tb = self.CH0_V[v].Zeta()
    elif func=='C01':
      tb = self.BC1_V[v].Zeta()
    elif func=='D01':
      tb = self.BD1_V[v].Zeta()
    elif func=='A01':
      tb = self.RP1_V[v].Zeta()
    elif func=='B01':
      tb = self.CH1_V[v].Zeta()
    elif func=='C02':
      tb = self.BC2_V[v].Zeta()
    elif func=='D02':
      tb = self.BD2_V[v].Zeta()
    elif func=='A02':
      tb = self.RP2_V[v].Zeta()
    elif func=='B02':
      tb = self.CH2_V[v].Zeta()
    elif func=='C03':
      tb = self.BC3_V[v].Zeta()
    elif func=='D03':
      tb = self.BD3_V[v].Zeta()
    elif func=='A03':
      tb = self.RP3_V[v].Zeta()
    elif func=='B03':
      tb = self.CH3_V[v].Zeta()
    return tb.table

def State_Procedure(Tr, it_n):
  tname = "table_"+str(Tr).zfill(4)+".npy"
  INP_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_INP/"+tname))
  C00_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_C00/"+tname))
  D00_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_D00/"+tname))
  A00_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_A00/"+tname))
  B00_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_B00/"+tname))
  C01_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_C01/"+tname))
  D01_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_D01/"+tname))
  A01_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_A01/"+tname))
  B01_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_B01/"+tname))
  C02_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_C02/"+tname))
  D02_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_D02/"+tname))
  A02_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_A02/"+tname))
  B02_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_B02/"+tname))
  C03_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_C03/"+tname))
  D03_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_D03/"+tname))
  A03_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_A03/"+tname))
  B03_old = svm.Load(("../bit_table_generation/Bit_Tables/Tables_B03/"+tname))
  INP_table = [0]*1600
  A00_table = [0]*1600
  B00_table = [0]*1600
  A01_table = [0]*1600
  B01_table = [0]*1600
  A02_table = [0]*1600
  B02_table = [0]*1600
  A03_table = [0]*1600
  B03_table = [0]*1600
  SASCA = FourRounds_SASCA(INP_old,C00_old,D00_old,A00_old,B00_old,C01_old,D01_old,A01_old,B01_old,C02_old,D02_old,A02_old,B02_old,C03_old,D03_old,A03_old,B03_old)
  for t in range(0, it_n):
    print("Iteration #"+str(t))
    SASCA.R_renew()
    SASCA.Q_renew()
  for bit in range(0, 1600):
    INP_table[bit] = SASCA.Zeta_out('INP', bit)
    A00_table[bit] = SASCA.Zeta_out('A00', bit)
    B00_table[bit] = SASCA.Zeta_out('B00', bit)
    A01_table[bit] = SASCA.Zeta_out('A01', bit)
    B01_table[bit] = SASCA.Zeta_out('B01', bit)
    A02_table[bit] = SASCA.Zeta_out('A02', bit)
    B02_table[bit] = SASCA.Zeta_out('B02', bit)
    A03_table[bit] = SASCA.Zeta_out('A03', bit)
    B03_table[bit] = SASCA.Zeta_out('B03', bit)
  INPname = "New_Tables_Final/Tables_INP/table_"+str(Tr).zfill(4)+".npy"
  A00name = "New_Tables_Final/Tables_A00/table_"+str(Tr).zfill(4)+".npy"
  B00name = "New_Tables_Final/Tables_B00/table_"+str(Tr).zfill(4)+".npy"
  A01name = "New_Tables_Final/Tables_A01/table_"+str(Tr).zfill(4)+".npy"
  B01name = "New_Tables_Final/Tables_B01/table_"+str(Tr).zfill(4)+".npy"
  A02name = "New_Tables_Final/Tables_A02/table_"+str(Tr).zfill(4)+".npy"
  B02name = "New_Tables_Final/Tables_B02/table_"+str(Tr).zfill(4)+".npy"
  A03name = "New_Tables_Final/Tables_A03/table_"+str(Tr).zfill(4)+".npy"
  B03name = "New_Tables_Final/Tables_B03/table_"+str(Tr).zfill(4)+".npy"
  svm.Save(INPname, INP_table)
  svm.Save(A00name, A00_table)
  svm.Save(B00name, B00_table)
  svm.Save(A01name, A01_table)
  svm.Save(B01name, B01_table)
  svm.Save(A02name, A02_table)
  svm.Save(B02name, B02_table)
  svm.Save(A03name, A03_table)
  svm.Save(B03name, B03_table)
  return

if __name__=='__main__':
  #Ex: python3 SASCA_4R_CDAB_beta.py 40 0 3
  iterate_time = int(sys.argv[1])
  lower = int(sys.argv[2])
  upper = int(sys.argv[3])
  tS = time.time()
  for t in range(lower, upper):
    print("======================================")
    print(time.asctime())
    print("trace "+str(t).zfill(3))
    State_Procedure(t, iterate_time)
  tE = time.time()
  total_time = tE-tS
  print("======================================")
  print("finished!")
  print("Exe. time = "+str(total_time))

