import numpy as np
import chipwhisperer as cw
import time
import sys
import KECCAK
import ni_fgen
import ni_scope
import CW_KECCAK_connection_PLL as CW_Con
import random
class Test:
  def __init__(self):
    self.CW = CW_Con.CW_SHA3(256)
    self.nifgen = ni_fgen.NIFgen()
    self.nifgen.check_locked()
    time.sleep(1)
    self.niscope = ni_scope.NIScope(2, 2500000000, 7500000)
    self.niscope.check_locked()
    self.CW.init_part2()
    return

  def test1(self, Input, Outname):
    Output = KECCAK.SHA3_256(Input)
    self.CW.set_input(Input)
    self.CW.keccak_exec()
    self.niscope.record(Outname)
    time.sleep(1.0)
    self.CW.keccak_exec_done()
    Response = self.CW.get_output()
    #print("Input    : "+Input)
    #print("Output   : "+Output)
    #print("Response : "+Response)
    return Output, Response

  def close(self):
    print("Closing Ports.")
    self.CW.close()
    self.niscope.close()
    self.nifgen.close()
    return

def Record_training(tn):
  print(time.asctime())
  data_in = [""]*tn
  data_out = [""]*tn
  for t in range(0, tn):
    S = random.randint((136*1), (136*2-1))
    d_in = ""
    for bt in range(0, S):
      d_in += (hex(random.randint(0, 255))[2:]).zfill(2)
    if len(d_in)!=(2*S):
      print("Error: random input.")
    else:
      data_in[t] = d_in
  T1 = Test()
  for t in range(0, tn):
    #print("+++++++++++++++++++++++++++++++++++++++++++++++++")
    print("Input #", t)
    #print(time.asctime())
    Name = "./temp/trace_"+str(t).zfill(4)
    In = data_in[t]
    while True:
      Out = "ff"
      Res = "00"
      try:
        Out, Res = T1.test1(In, Name)
      except:
        continue
      if Out==Res:
        data_out[t] = Out
        break
      else:
        continue
  T1.close()
  np.save("./temp/data_in.npy", data_in)
  np.save("./temp/data_out.npy", data_out)
  return

if __name__=='__main__':
  rec_num = int(sys.argv[1])
  Record_training(rec_num)
