import matplotlib.pyplot as plt
import array
import sys
def read_wave(inname):
  input_file = open(inname, 'rb')
  float_array = array.array('d')
  float_array.frombytes(input_file.read())
  trace = []
  for t in range(0, len(float_array)):
    trace.append(float_array[t])
  return trace

if __name__=='__main__':
  T0_Name = "temp/trace_0000_0_ch0.bin"
  T1_Name = "temp/trace_0000_1_ch0.bin"
  T0_Trace = read_wave(T0_Name)
  T1_Trace = read_wave(T1_Name)
  plt.plot(T0_Trace, label='T0')
  plt.plot(T1_Trace, label='T1')
  plt.legend()
  plt.show()
  
