#include <stdint.h>

#define MCHP_ON     (1ul)
#define MCHP_OFF    (0ul)
#define PCR2_AESH_BPOS       (28u)
#define PCR2_SLP_EN_REG_OFS  (0x38u)
#define PCR_AESH  (((uint16_t)(PCR2_AESH_BPOS) << 8) + (uint16_t)(PCR2_SLP_EN_REG_OFS & 0xFFu))
#define MAKE_WORD(b0,b1,b2,b3) ((uint32_t)(b0) + ((uint32_t)(b1) << 8) + ((uint32_t)(b2) << 16) + ((uint32_t)(b3) << 24))
#define AES_MODE_ECB        (0ul)
#define AES_MODE_CBC        (1ul)
#define AES_MODE_CTR        (2ul)
#define AES_MODE_CFB        (3ul)
#define AES_MODE_OFB        (4ul)
#define AES_MODE_DECRYPT    (0x80ul)


#define AES_KEYLEN_128          (0ul)
#define AES_KEYLEN_192          (1ul)
#define AES_KEYLEN_256          (2ul)
#define AESHW_KEY_BITLEN      (256ul)

#define AESHW_KEY1_159_128_IDX  (0u)
#define AESHW_KEY1_191_160_IDX  (1u)
#define AESHW_KEY1_223_192_IDX  (2u)
#define AESHW_KEY1_255_224_IDX  (3u)
#define AESHW_KEY1_31_0_IDX     (4u)
#define AESHW_KEY1_63_32_IDX    (5u)
#define AESHW_KEY1_95_64_IDX    (6u)
#define AESHW_KEY1_127_96_IDX   (7u)
#define AESHW_KEY1_MAX_IDX      (8u)

#define AES_OK                          (0)
#define AES_ERR_BUSY                    (1)
#define AES_ERR_BAD_KEY_LEN             (2)
#define AES_ERR_BAD_POINTER             (3)
#define AES_ERR_MISALIGNED_DATA         (4)
#define AES_ERR_UNSUPPORTED_OP          (5)


#define AES_CMD_MASK                        (0x0001FF0Dul)
#define AES_CMD_MODE_BITPOS                 (8)
#define AES_CMD_MODE_BLEN                   (9)
#define AES_CMD_MODE_MASK                   (0x01FFul)
#define AES_CMD_MODE_ECB                    (1UL << 8)
#define AES_CMD_MODE_CBC                    (1UL << 9)
#define AES_CMD_MODE_CTR                    (1UL << 10)
#define AES_CMD_MODE_CFB                    (1UL << 11)
#define AES_CMD_MODE_OFB                    (1UL << 12)
#define AES_CMD_MODE_CCM                    (1UL << 13)
#define AES_CMD_MODE_GCM                    (1UL << 14)
#define AES_CMD_MODE_XTS                    (1UL << 15)
#define AES_CMD_MODE_CMAC                   (1UL << 16)
#define AES_CMD_KEYSIZE_BITPOS              (2)
#define AES_CMD_KEYSIZE_BLEN                (2)
#define AES_CMD_KEYSIZE_MASK                (0x0Cul)
#define AES_CMD_KEYSIZE_128BIT              (0ul << (AES_CMD_KEYSIZE_BITPOS))
#define AES_CMD_KEYSIZE_256BIT              (1ul << (AES_CMD_KEYSIZE_BITPOS))
#define AES_CMD_KEYSIZE_192BIT              (2ul << (AES_CMD_KEYSIZE_BITPOS))
#define AES_CMD_KEYSIZE_RSVD                (3ul << (AES_CMD_KEYSIZE_BITPOS))
#define AES_CMD_ENCRYPT                     (0UL << 0)
#define AES_CMD_DECRYPT                     (1UL << 0)