/*
    This file is part of the ChipWhisperer Example Targets
    Copyright (C) 2012-2017 NewAE Technology Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "hal.h"
#include <stdint.h>
#include <stdlib.h>
#include "KeccakP-1600.h"
#include "simpleserial.h"
#define BUF_LEN 2048
uint8_t I_Buf[BUF_LEN];
uint8_t O_Buf[BUF_LEN];
uint32_t State[50];
uint32_t Count_P = 0;
uint32_t Count_C = 0;
uint32_t Case = 0;
uint32_t D_len = 0;
uint32_t N_len = 0;
uint32_t D_block = 0;
uint32_t N_block = 0;
uint32_t KEC_C = 128;
uint32_t KEC_R = 72;
uint8_t C_Buf[8];

uint8_t set_pt(uint8_t* pt)
{
	/**********************************
	* Start user-specific code here. */
        if(Count_P==N_len) return 0x00;
	for(int32_t i=0; i<8; i=i+1) 
	{ 
	  I_Buf[Count_P]=pt[i];
          Count_P+=1;
          if(Count_P==N_len) return 0x00;
	}
	//16 hex bytes held in 'pt' were sent
	//from the computer. Store your response
	//back into 'pt', which will send 16 bytes
	//back to computer. Can ignore of course if
	//not needed
	/* End user-specific code here. *
	********************************/
	return 0x00;
}

uint8_t Sponge_Function(uint8_t* k)
{
  for(int32_t i=0; i<2000000; i=i+1) asm("nop");
  //Padding.
  if(Case==0) return 0x00;
  else if(Case<=4)
  {
     I_Buf[N_len] = 0x06;
     I_Buf[(N_block*KEC_R-1)] ^= 0x80;
  }
  else if(Case<=6)
  {
     I_Buf[N_len] = 0x1f;
     I_Buf[(N_block*KEC_R-1)] ^= 0x80;
  }
  else return 0x00;
  //Absorbing.
  for(int8_t Invoc=0; Invoc<N_block; Invoc=Invoc+1)
  {
    for(int32_t regi=0; regi<(KEC_R/4); regi=regi+1)
    {
      uint32_t temp = 0;
      for(int8_t t=0; t<4; t+=1)
      {
        uint32_t temp2 = 0;
	temp2 = (I_Buf[(Invoc*KEC_R+regi*4+t)]&0xff);
        temp2 <<= (8*t);
        temp ^= temp2;
      }
      State[regi] ^= temp;
    }
    KeccakP1600(State, 200);
  }
  //Squeezing.
  for(int8_t Invoc=0; Invoc<D_block; Invoc=Invoc+1)
  {
    for(int32_t regi=0; regi<(KEC_R/4); regi=regi+1)
    {
      uint32_t temp = State[regi];
      for(int8_t t=0; t<4; t+=1)
      {
        int32_t it = (Invoc*KEC_R+regi*4+t);
        if(it>=D_len) return 0x00;
        int8_t temp2 = temp&0xff;
        O_Buf[it] = temp2;
        temp >>= 8;
      }
    }
    KeccakP1600(State, 200);
  }
  
  return 0x00;
}

uint8_t get_response(uint8_t* c)
{
     if(Count_C==D_len) return 0x00;
     for(int8_t t=0; t<8; t=t+1) 
     {
        if(Count_C==D_len)
        {
          simpleserial_put('r', t, C_Buf);
          return 0x00;
        }
        C_Buf[t]=O_Buf[Count_C];
        Count_C += 1;
     }
     simpleserial_put('r', 8, C_Buf);
     return 0x00;
}

uint8_t reset(uint8_t* x)
{
     for(int32_t i=0; i<50; i=i+1) State[i]=0;
     for(int32_t i=0; i<BUF_LEN; i=i+1){I_Buf[i]=0; O_Buf[i]=0;}
     Count_P = 0;
     Count_C = 0;
     Case = x[0];
     //Case1: SHA3_224 
     if(Case==1)
     {
       KEC_C = 56;
       KEC_R = 200-KEC_C;
       N_len = x[2];
       N_len <<= 8;
       N_len += x[1];
       N_block = (N_len/KEC_R)+1;
       D_len = KEC_C/2;
       D_block = 1;
       putch('S');
       putch('H');
       putch('A');
       putch('3');
       putch('-');
       putch('2');
       putch('2');
       putch('4');
     }
     //Case2: SHA3_256
     else if(Case==2)
     {
       KEC_C = 64;
       KEC_R = 200-KEC_C;
       N_len = x[2];
       N_len <<= 8;
       N_len += x[1];
       N_block = (N_len/KEC_R)+1;
       D_len = KEC_C/2;
       D_block = 1;
       putch('S');
       putch('H');
       putch('A');
       putch('3');
       putch('-');
       putch('2');
       putch('5');
       putch('6');
     }
     //Case3: SHA3_384
     else if(Case==3)
     {
       KEC_C = 96;
       KEC_R = 200-KEC_C;
       N_len = x[2];
       N_len <<= 8;
       N_len += x[1];
       N_block = (N_len/KEC_R)+1;
       D_len = KEC_C/2;
       D_block = 1;
       putch('S');
       putch('H');
       putch('A');
       putch('3');
       putch('-');
       putch('3');
       putch('8');
       putch('4');
     }
     //Case4: SHA3_512
     else if(Case==4)
     {
       KEC_C = 128;
       KEC_R = 200-KEC_C;
       N_len = x[2];
       N_len <<= 8;
       N_len += x[1];
       N_block = (N_len/KEC_R)+1;
       D_len = KEC_C/2;
       D_block = 1;
       putch('S');
       putch('H');
       putch('A');
       putch('3');
       putch('-');
       putch('5');
       putch('1');
       putch('2');
     }
     //Case5: SHAKE128
     else if(Case==5)
     {
       KEC_C = 32;
       KEC_R = 200-KEC_C;
       N_len = x[2];
       N_len <<= 8;
       N_len += x[1];
       N_block = (N_len/KEC_R)+1;
       D_len = x[4];
       D_len <<= 8;
       D_len += x[3];
       D_block = (D_len-1/KEC_R)+1;
       putch('S');
       putch('H');
       putch('A');
       putch('K');
       putch('E');
       putch('1');
       putch('2');
       putch('8');
     }
     //Case6: SHAKE256
     else if(Case==6)
     {
       KEC_C = 64;
       KEC_R = 200-KEC_C;
       N_len = x[2];
       N_len <<= 8;
       N_len += x[1];
       N_block = (N_len/KEC_R)+1;
       D_len = x[4];
       D_len <<= 8;
       D_len += x[3];
       D_block = (D_len-1/KEC_R)+1;
       putch('S');
       putch('H');
       putch('A');
       putch('K');
       putch('E');
       putch('2');
       putch('5');
       putch('6');
     }
     else {D_len=0; N_len=0; D_block=0; N_block=0;}
     return 0x00;
}

int main(void)
{
    platform_init();
	init_uart();	
	trigger_setup();
	
 	/* Uncomment this to get a HELLO message for debug */
        	
	putch('K');
	putch('e');
	putch('c');
	putch('c');
	putch('a');
	putch('k');
	
		
	simpleserial_init();		
        simpleserial_addcmd('k', 0, Sponge_Function);
	simpleserial_addcmd('i', 8, set_pt);
	simpleserial_addcmd('o', 0, get_response);
        simpleserial_addcmd('x', 5, reset);

	while(1)
		simpleserial_get();
}
