/* jh_tables.c */
/*
    This file is part of the ARM-Crypto-Lib.
    Copyright (C) 2006-2010 Daniel Otte (daniel.otte@rub.de)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdint.h>
#include <avr/pgmspace.h>

const uint8_t jh_permutation_table[] PROGMEM = {
	0x00, 0x03, 0x04, 0x07, 0x08, 0x0B, 0x0C, 0x0F, 0x10, 0x13, 0x14, 0x17, 0x18, 0x1B, 0x1C, 0x1F,
	0x20, 0x23, 0x24, 0x27, 0x28, 0x2B, 0x2C, 0x2F, 0x30, 0x33, 0x34, 0x37, 0x38, 0x3B, 0x3C, 0x3F,
	0x40, 0x43, 0x44, 0x47, 0x48, 0x4B, 0x4C, 0x4F, 0x50, 0x53, 0x54, 0x57, 0x58, 0x5B, 0x5C, 0x5F,
	0x60, 0x63, 0x64, 0x67, 0x68, 0x6B, 0x6C, 0x6F, 0x70, 0x73, 0x74, 0x77, 0x78, 0x7B, 0x7C, 0x7F,
	0x80, 0x83, 0x84, 0x87, 0x88, 0x8B, 0x8C, 0x8F, 0x90, 0x93, 0x94, 0x97, 0x98, 0x9B, 0x9C, 0x9F,
	0xA0, 0xA3, 0xA4, 0xA7, 0xA8, 0xAB, 0xAC, 0xAF, 0xB0, 0xB3, 0xB4, 0xB7, 0xB8, 0xBB, 0xBC, 0xBF,
	0xC0, 0xC3, 0xC4, 0xC7, 0xC8, 0xCB, 0xCC, 0xCF, 0xD0, 0xD3, 0xD4, 0xD7, 0xD8, 0xDB, 0xDC, 0xDF,
	0xE0, 0xE3, 0xE4, 0xE7, 0xE8, 0xEB, 0xEC, 0xEF, 0xF0, 0xF3, 0xF4, 0xF7, 0xF8, 0xFB, 0xFC, 0xFF,
	0x02, 0x01, 0x06, 0x05, 0x0A, 0x09, 0x0E, 0x0D, 0x12, 0x11, 0x16, 0x15, 0x1A, 0x19, 0x1E, 0x1D,
	0x22, 0x21, 0x26, 0x25, 0x2A, 0x29, 0x2E, 0x2D, 0x32, 0x31, 0x36, 0x35, 0x3A, 0x39, 0x3E, 0x3D,
	0x42, 0x41, 0x46, 0x45, 0x4A, 0x49, 0x4E, 0x4D, 0x52, 0x51, 0x56, 0x55, 0x5A, 0x59, 0x5E, 0x5D,
	0x62, 0x61, 0x66, 0x65, 0x6A, 0x69, 0x6E, 0x6D, 0x72, 0x71, 0x76, 0x75, 0x7A, 0x79, 0x7E, 0x7D,
	0x82, 0x81, 0x86, 0x85, 0x8A, 0x89, 0x8E, 0x8D, 0x92, 0x91, 0x96, 0x95, 0x9A, 0x99, 0x9E, 0x9D,
	0xA2, 0xA1, 0xA6, 0xA5, 0xAA, 0xA9, 0xAE, 0xAD, 0xB2, 0xB1, 0xB6, 0xB5, 0xBA, 0xB9, 0xBE, 0xBD,
	0xC2, 0xC1, 0xC6, 0xC5, 0xCA, 0xC9, 0xCE, 0xCD, 0xD2, 0xD1, 0xD6, 0xD5, 0xDA, 0xD9, 0xDE, 0xDD,
	0xE2, 0xE1, 0xE6, 0xE5, 0xEA, 0xE9, 0xEE, 0xED, 0xF2, 0xF1, 0xF6, 0xF5, 0xFA, 0xF9, 0xFE, 0xFD
};

const uint8_t jh_lutbox[] PROGMEM = {
	0xA8, 0xB1, 0x35, 0xEA, 0x2C, 0x0D, 0xD2, 0x6E, 0x90, 0xCB, 0xF3, 0x77, 0x56, 0x14, 0x89, 0x4F,
	0x19, 0x00, 0x84, 0x5B, 0x9D, 0xBC, 0x63, 0xDF, 0x21, 0x7A, 0x42, 0xC6, 0xE7, 0xA5, 0x38, 0xFE,
	0x61, 0x78, 0xFC, 0x23, 0xE5, 0xC4, 0x1B, 0xA7, 0x59, 0x02, 0x3A, 0xBE, 0x9F, 0xDD, 0x40, 0x86,
	0x0C, 0x15, 0x91, 0x4E, 0x88, 0xA9, 0x76, 0xCA, 0x34, 0x6F, 0x57, 0xD3, 0xF2, 0xB0, 0x2D, 0xEB,
	0xD0, 0xC9, 0x4D, 0x92, 0x54, 0x75, 0xAA, 0x16, 0xE8, 0xB3, 0x8B, 0x0F, 0x2E, 0x6C, 0xF1, 0x37,
	0x82, 0x9B, 0x1F, 0xC0, 0x06, 0x27, 0xF8, 0x44, 0xBA, 0xE1, 0xD9, 0x5D, 0x7C, 0x3E, 0xA3, 0x65,
	0xEF, 0xF6, 0x72, 0xAD, 0x6B, 0x4A, 0x95, 0x29, 0xD7, 0x8C, 0xB4, 0x30, 0x11, 0x53, 0xCE, 0x08,
	0x74, 0x6D, 0xE9, 0x36, 0xF0, 0xD1, 0x0E, 0xB2, 0x4C, 0x17, 0x2F, 0xAB, 0x8A, 0xC8, 0x55, 0x93,
	0x4B, 0x52, 0xD6, 0x09, 0xCF, 0xEE, 0x31, 0x8D, 0x73, 0x28, 0x10, 0x94, 0xB5, 0xF7, 0x6A, 0xAC,
	0x5E, 0x47, 0xC3, 0x1C, 0xDA, 0xFB, 0x24, 0x98, 0x66, 0x3D, 0x05, 0x81, 0xA0, 0xE2, 0x7F, 0xB9,
	0xBD, 0xA4, 0x20, 0xFF, 0x39, 0x18, 0xC7, 0x7B, 0x85, 0xDE, 0xE6, 0x62, 0x43, 0x01, 0x9C, 0x5A,
	0xC5, 0xDC, 0x58, 0x87, 0x41, 0x60, 0xBF, 0x03, 0xFD, 0xA6, 0x9E, 0x1A, 0x3B, 0x79, 0xE4, 0x22,
	0x97, 0x8E, 0x0A, 0xD5, 0x13, 0x32, 0xED, 0x51, 0xAF, 0xF4, 0xCC, 0x48, 0x69, 0x2B, 0xB6, 0x70,
	0x33, 0x2A, 0xAE, 0x71, 0xB7, 0x96, 0x49, 0xF5, 0x0B, 0x50, 0x68, 0xEC, 0xCD, 0x8F, 0x12, 0xD4,
	0xFA, 0xE3, 0x67, 0xB8, 0x7E, 0x5F, 0x80, 0x3C, 0xC2, 0x99, 0xA1, 0x25, 0x04, 0x46, 0xDB, 0x1D,
	0x26, 0x3F, 0xBB, 0x64, 0xA2, 0x83, 0x5C, 0xE0, 0x1E, 0x45, 0x7D, 0xF9, 0xD8, 0x9A, 0x07, 0xC1,

/* SBOX1: */
	0xD2, 0x0D, 0x77, 0x2C, 0x14, 0x56, 0x90, 0xA8, 0x6E, 0xF3, 0xB1, 0x35, 0xEA, 0xCB, 0x4F, 0x89,
	0x63, 0xBC, 0xC6, 0x9D, 0xA5, 0xE7, 0x21, 0x19, 0xDF, 0x42, 0x00, 0x84, 0x5B, 0x7A, 0xFE, 0x38,
	0x1B, 0xC4, 0xBE, 0xE5, 0xDD, 0x9F, 0x59, 0x61, 0xA7, 0x3A, 0x78, 0xFC, 0x23, 0x02, 0x86, 0x40,
	0x76, 0xA9, 0xD3, 0x88, 0xB0, 0xF2, 0x34, 0x0C, 0xCA, 0x57, 0x15, 0x91, 0x4E, 0x6F, 0xEB, 0x2D,
	0xAA, 0x75, 0x0F, 0x54, 0x6C, 0x2E, 0xE8, 0xD0, 0x16, 0x8B, 0xC9, 0x4D, 0x92, 0xB3, 0x37, 0xF1,
	0xF8, 0x27, 0x5D, 0x06, 0x3E, 0x7C, 0xBA, 0x82, 0x44, 0xD9, 0x9B, 0x1F, 0xC0, 0xE1, 0x65, 0xA3,
	0x95, 0x4A, 0x30, 0x6B, 0x53, 0x11, 0xD7, 0xEF, 0x29, 0xB4, 0xF6, 0x72, 0xAD, 0x8C, 0x08, 0xCE,
	0x0E, 0xD1, 0xAB, 0xF0, 0xC8, 0x8A, 0x4C, 0x74, 0xB2, 0x2F, 0x6D, 0xE9, 0x36, 0x17, 0x93, 0x55,
	0x31, 0xEE, 0x94, 0xCF, 0xF7, 0xB5, 0x73, 0x4B, 0x8D, 0x10, 0x52, 0xD6, 0x09, 0x28, 0xAC, 0x6A,
	0x24, 0xFB, 0x81, 0xDA, 0xE2, 0xA0, 0x66, 0x5E, 0x98, 0x05, 0x47, 0xC3, 0x1C, 0x3D, 0xB9, 0x7F,
	0xC7, 0x18, 0x62, 0x39, 0x01, 0x43, 0x85, 0xBD, 0x7B, 0xE6, 0xA4, 0x20, 0xFF, 0xDE, 0x5A, 0x9C,
	0xBF, 0x60, 0x1A, 0x41, 0x79, 0x3B, 0xFD, 0xC5, 0x03, 0x9E, 0xDC, 0x58, 0x87, 0xA6, 0x22, 0xE4,
	0xED, 0x32, 0x48, 0x13, 0x2B, 0x69, 0xAF, 0x97, 0x51, 0xCC, 0x8E, 0x0A, 0xD5, 0xF4, 0x70, 0xB6,
	0x49, 0x96, 0xEC, 0xB7, 0x8F, 0xCD, 0x0B, 0x33, 0xF5, 0x68, 0x2A, 0xAE, 0x71, 0x50, 0xD4, 0x12,
	0x80, 0x5F, 0x25, 0x7E, 0x46, 0x04, 0xC2, 0xFA, 0x3C, 0xA1, 0xE3, 0x67, 0xB8, 0x99, 0x1D, 0xDB,
	0x5C, 0x83, 0xF9, 0xA2, 0x9A, 0xD8, 0x1E, 0x26, 0xE0, 0x7D, 0x3F, 0xBB, 0x64, 0x45, 0xC1, 0x07,

/* SBOX2: */
	0xEF, 0xF6, 0x72, 0xAD, 0x6B, 0x4A, 0x95, 0x29, 0xD7, 0x8C, 0xB4, 0x30, 0x11, 0x53, 0xCE, 0x08,
	0x82, 0x9B, 0x1F, 0xC0, 0x06, 0x27, 0xF8, 0x44, 0xBA, 0xE1, 0xD9, 0x5D, 0x7C, 0x3E, 0xA3, 0x65,
	0xC5, 0xDC, 0x58, 0x87, 0x41, 0x60, 0xBF, 0x03, 0xFD, 0xA6, 0x9E, 0x1A, 0x3B, 0x79, 0xE4, 0x22,
	0xD0, 0xC9, 0x4D, 0x92, 0x54, 0x75, 0xAA, 0x16, 0xE8, 0xB3, 0x8B, 0x0F, 0x2E, 0x6C, 0xF1, 0x37,
	0x33, 0x2A, 0xAE, 0x71, 0xB7, 0x96, 0x49, 0xF5, 0x0B, 0x50, 0x68, 0xEC, 0xCD, 0x8F, 0x12, 0xD4,
	0x97, 0x8E, 0x0A, 0xD5, 0x13, 0x32, 0xED, 0x51, 0xAF, 0xF4, 0xCC, 0x48, 0x69, 0x2B, 0xB6, 0x70,
	0x4B, 0x52, 0xD6, 0x09, 0xCF, 0xEE, 0x31, 0x8D, 0x73, 0x28, 0x10, 0x94, 0xB5, 0xF7, 0x6A, 0xAC,
	0xA8, 0xB1, 0x35, 0xEA, 0x2C, 0x0D, 0xD2, 0x6E, 0x90, 0xCB, 0xF3, 0x77, 0x56, 0x14, 0x89, 0x4F,
	0x74, 0x6D, 0xE9, 0x36, 0xF0, 0xD1, 0x0E, 0xB2, 0x4C, 0x17, 0x2F, 0xAB, 0x8A, 0xC8, 0x55, 0x93,
	0xBD, 0xA4, 0x20, 0xFF, 0x39, 0x18, 0xC7, 0x7B, 0x85, 0xDE, 0xE6, 0x62, 0x43, 0x01, 0x9C, 0x5A,
	0x19, 0x00, 0x84, 0x5B, 0x9D, 0xBC, 0x63, 0xDF, 0x21, 0x7A, 0x42, 0xC6, 0xE7, 0xA5, 0x38, 0xFE,
	0x61, 0x78, 0xFC, 0x23, 0xE5, 0xC4, 0x1B, 0xA7, 0x59, 0x02, 0x3A, 0xBE, 0x9F, 0xDD, 0x40, 0x86,
	0x0C, 0x15, 0x91, 0x4E, 0x88, 0xA9, 0x76, 0xCA, 0x34, 0x6F, 0x57, 0xD3, 0xF2, 0xB0, 0x2D, 0xEB,
	0x5E, 0x47, 0xC3, 0x1C, 0xDA, 0xFB, 0x24, 0x98, 0x66, 0x3D, 0x05, 0x81, 0xA0, 0xE2, 0x7F, 0xB9,
	0x26, 0x3F, 0xBB, 0x64, 0xA2, 0x83, 0x5C, 0xE0, 0x1E, 0x45, 0x7D, 0xF9, 0xD8, 0x9A, 0x07, 0xC1,
	0xFA, 0xE3, 0x67, 0xB8, 0x7E, 0x5F, 0x80, 0x3C, 0xC2, 0x99, 0xA1, 0x25, 0x04, 0x46, 0xDB, 0x1D,

/* SBOX3: */
	0x95, 0x4A, 0x30, 0x6B, 0x53, 0x11, 0xD7, 0xEF, 0x29, 0xB4, 0xF6, 0x72, 0xAD, 0x8C, 0x08, 0xCE,
	0xF8, 0x27, 0x5D, 0x06, 0x3E, 0x7C, 0xBA, 0x82, 0x44, 0xD9, 0x9B, 0x1F, 0xC0, 0xE1, 0x65, 0xA3,
	0xBF, 0x60, 0x1A, 0x41, 0x79, 0x3B, 0xFD, 0xC5, 0x03, 0x9E, 0xDC, 0x58, 0x87, 0xA6, 0x22, 0xE4,
	0xAA, 0x75, 0x0F, 0x54, 0x6C, 0x2E, 0xE8, 0xD0, 0x16, 0x8B, 0xC9, 0x4D, 0x92, 0xB3, 0x37, 0xF1,
	0x49, 0x96, 0xEC, 0xB7, 0x8F, 0xCD, 0x0B, 0x33, 0xF5, 0x68, 0x2A, 0xAE, 0x71, 0x50, 0xD4, 0x12,
	0xED, 0x32, 0x48, 0x13, 0x2B, 0x69, 0xAF, 0x97, 0x51, 0xCC, 0x8E, 0x0A, 0xD5, 0xF4, 0x70, 0xB6,
	0x31, 0xEE, 0x94, 0xCF, 0xF7, 0xB5, 0x73, 0x4B, 0x8D, 0x10, 0x52, 0xD6, 0x09, 0x28, 0xAC, 0x6A,
	0xD2, 0x0D, 0x77, 0x2C, 0x14, 0x56, 0x90, 0xA8, 0x6E, 0xF3, 0xB1, 0x35, 0xEA, 0xCB, 0x4F, 0x89,
	0x0E, 0xD1, 0xAB, 0xF0, 0xC8, 0x8A, 0x4C, 0x74, 0xB2, 0x2F, 0x6D, 0xE9, 0x36, 0x17, 0x93, 0x55,
	0xC7, 0x18, 0x62, 0x39, 0x01, 0x43, 0x85, 0xBD, 0x7B, 0xE6, 0xA4, 0x20, 0xFF, 0xDE, 0x5A, 0x9C,
	0x63, 0xBC, 0xC6, 0x9D, 0xA5, 0xE7, 0x21, 0x19, 0xDF, 0x42, 0x00, 0x84, 0x5B, 0x7A, 0xFE, 0x38,
	0x1B, 0xC4, 0xBE, 0xE5, 0xDD, 0x9F, 0x59, 0x61, 0xA7, 0x3A, 0x78, 0xFC, 0x23, 0x02, 0x86, 0x40,
	0x76, 0xA9, 0xD3, 0x88, 0xB0, 0xF2, 0x34, 0x0C, 0xCA, 0x57, 0x15, 0x91, 0x4E, 0x6F, 0xEB, 0x2D,
	0x24, 0xFB, 0x81, 0xDA, 0xE2, 0xA0, 0x66, 0x5E, 0x98, 0x05, 0x47, 0xC3, 0x1C, 0x3D, 0xB9, 0x7F,
	0x5C, 0x83, 0xF9, 0xA2, 0x9A, 0xD8, 0x1E, 0x26, 0xE0, 0x7D, 0x3F, 0xBB, 0x64, 0x45, 0xC1, 0x07,
	0x80, 0x5F, 0x25, 0x7E, 0x46, 0x04, 0xC2, 0xFA, 0x3C, 0xA1, 0xE3, 0x67, 0xB8, 0x99, 0x1D, 0xDB
};

const uint8_t jh_round_const[] PROGMEM = {
  /* C_00: */
  	0x6a, 0x09, 0xe6, 0x67, 0xf3, 0xbc, 0xc9, 0x08,
  	0xb2, 0xfb, 0x13, 0x66, 0xea, 0x95, 0x7d, 0x3e,
  	0x3a, 0xde, 0xc1, 0x75, 0x12, 0x77, 0x50, 0x99,
  	0xda, 0x2f, 0x59, 0x0b, 0x06, 0x67, 0x32, 0x2a,
  /* C_01: */
  	0xbb, 0x89, 0x6b, 0xf0, 0x59, 0x55, 0xab, 0xcd,
  	0x52, 0x81, 0x82, 0x8d, 0x66, 0xe7, 0xd9, 0x9a,
  	0xc4, 0x20, 0x34, 0x94, 0xf8, 0x9b, 0xf1, 0x28,
  	0x17, 0xde, 0xb4, 0x32, 0x88, 0x71, 0x22, 0x31,
  /* C_02: */
  	0x18, 0x36, 0xe7, 0x6b, 0x12, 0xd7, 0x9c, 0x55,
  	0x11, 0x8a, 0x11, 0x39, 0xd2, 0x41, 0x7d, 0xf5,
  	0x2a, 0x20, 0x21, 0x22, 0x5f, 0xf6, 0x35, 0x00,
  	0x63, 0xd8, 0x8e, 0x5f, 0x1f, 0x91, 0x63, 0x1c,
  /* C_03: */
  	0x26, 0x30, 0x85, 0xa7, 0x00, 0x0f, 0xa9, 0xc3,
  	0x31, 0x7c, 0x6c, 0xa8, 0xab, 0x65, 0xf7, 0xa7,
  	0x71, 0x3c, 0xf4, 0x20, 0x10, 0x60, 0xce, 0x88,
  	0x6a, 0xf8, 0x55, 0xa9, 0x0d, 0x6a, 0x4e, 0xed,
  /* C_04: */
  	0x1c, 0xeb, 0xaf, 0xd5, 0x1a, 0x15, 0x6a, 0xeb,
  	0x62, 0xa1, 0x1f, 0xb3, 0xbe, 0x2e, 0x14, 0xf6,
  	0x0b, 0x7e, 0x48, 0xde, 0x85, 0x81, 0x42, 0x70,
  	0xfd, 0x62, 0xe9, 0x76, 0x14, 0xd7, 0xb4, 0x41,
  /* C_05: */
  	0xe5, 0x56, 0x4c, 0xb5, 0x74, 0xf7, 0xe0, 0x9c,
  	0x75, 0xe2, 0xe2, 0x44, 0x92, 0x9e, 0x95, 0x49,
  	0x27, 0x9a, 0xb2, 0x24, 0xa2, 0x8e, 0x44, 0x5d,
  	0x57, 0x18, 0x5e, 0x7d, 0x7a, 0x09, 0xfd, 0xc1,
  /* C_06: */
  	0x58, 0x20, 0xf0, 0xf0, 0xd7, 0x64, 0xcf, 0xf3,
  	0xa5, 0x55, 0x2a, 0x5e, 0x41, 0xa8, 0x2b, 0x9e,
  	0xff, 0x6e, 0xe0, 0xaa, 0x61, 0x57, 0x73, 0xbb,
  	0x07, 0xe8, 0x60, 0x34, 0x24, 0xc3, 0xcf, 0x8a,
  /* C_07: */
  	0xb1, 0x26, 0xfb, 0x74, 0x17, 0x33, 0xc5, 0xbf,
  	0xce, 0xf6, 0xf4, 0x3a, 0x62, 0xe8, 0xe5, 0x70,
  	0x6a, 0x26, 0x65, 0x60, 0x28, 0xaa, 0x89, 0x7e,
  	0xc1, 0xea, 0x46, 0x16, 0xce, 0x8f, 0xd5, 0x10,
  /* C_08: */
  	0xdb, 0xf0, 0xde, 0x32, 0xbc, 0xa7, 0x72, 0x54,
  	0xbb, 0x4f, 0x56, 0x25, 0x81, 0xa3, 0xbc, 0x99,
  	0x1c, 0xf9, 0x4f, 0x22, 0x56, 0x52, 0xc2, 0x7f,
  	0x14, 0xea, 0xe9, 0x58, 0xae, 0x6a, 0xa6, 0x16,
  /* C_09: */
  	0xe6, 0x11, 0x3b, 0xe6, 0x17, 0xf4, 0x5f, 0x3d,
  	0xe5, 0x3c, 0xff, 0x03, 0x91, 0x9a, 0x94, 0xc3,
  	0x2c, 0x92, 0x7b, 0x09, 0x3a, 0xc8, 0xf2, 0x3b,
  	0x47, 0xf7, 0x18, 0x9a, 0xad, 0xb9, 0xbc, 0x67,
  /* C_10: */
  	0x80, 0xd0, 0xd2, 0x60, 0x52, 0xca, 0x45, 0xd5,
  	0x93, 0xab, 0x5f, 0xb3, 0x10, 0x25, 0x06, 0x39,
  	0x00, 0x83, 0xaf, 0xb5, 0xff, 0xe1, 0x07, 0xda,
  	0xcf, 0xcb, 0xa7, 0xdb, 0xe6, 0x01, 0xa1, 0x2b,
  /* C_11: */
  	0x43, 0xaf, 0x1c, 0x76, 0x12, 0x67, 0x14, 0xdf,
  	0xa9, 0x50, 0xc3, 0x68, 0x78, 0x7c, 0x81, 0xae,
  	0x3b, 0xee, 0xcf, 0x95, 0x6c, 0x85, 0xc9, 0x62,
  	0x08, 0x6a, 0xe1, 0x6e, 0x40, 0xeb, 0xb0, 0xb4,
  /* C_12: */
  	0x9a, 0xee, 0x89, 0x94, 0xd2, 0xd7, 0x4a, 0x5c,
  	0xdb, 0x7b, 0x1e, 0xf2, 0x94, 0xee, 0xd5, 0xc1,
  	0x52, 0x07, 0x24, 0xdd, 0x8e, 0xd5, 0x8c, 0x92,
  	0xd3, 0xf0, 0xe1, 0x74, 0xb0, 0xc3, 0x20, 0x45,
  /* C_13: */
  	0x0b, 0x2a, 0xa5, 0x8c, 0xeb, 0x3b, 0xdb, 0x9e,
  	0x1e, 0xef, 0x66, 0xb3, 0x76, 0xe0, 0xc5, 0x65,
  	0xd5, 0xd8, 0xfe, 0x7b, 0xac, 0xb8, 0xda, 0x86,
  	0x6f, 0x85, 0x9a, 0xc5, 0x21, 0xf3, 0xd5, 0x71,
  /* C_14: */
  	0x7a, 0x15, 0x23, 0xef, 0x3d, 0x97, 0x0a, 0x3a,
  	0x9b, 0x0b, 0x4d, 0x61, 0x0e, 0x02, 0x74, 0x9d,
  	0x37, 0xb8, 0xd5, 0x7c, 0x18, 0x85, 0xfe, 0x42,
  	0x06, 0xa7, 0xf3, 0x38, 0xe8, 0x35, 0x68, 0x66,
  /* C_15: */
  	0x2c, 0x2d, 0xb8, 0xf7, 0x87, 0x66, 0x85, 0xf2,
  	0xcd, 0x9a, 0x2e, 0x0d, 0xdb, 0x64, 0xc9, 0xd5,
  	0xbf, 0x13, 0x90, 0x53, 0x71, 0xfc, 0x39, 0xe0,
  	0xfa, 0x86, 0xe1, 0x47, 0x72, 0x34, 0xa2, 0x97,
  /* C_16: */
  	0x9d, 0xf0, 0x85, 0xeb, 0x25, 0x44, 0xeb, 0xf6,
  	0x2b, 0x50, 0x68, 0x6a, 0x71, 0xe6, 0xe8, 0x28,
  	0xdf, 0xed, 0x9d, 0xbe, 0x0b, 0x10, 0x6c, 0x94,
  	0x52, 0xce, 0xdd, 0xff, 0x3d, 0x13, 0x89, 0x90,
  /* C_17: */
  	0xe6, 0xe5, 0xc4, 0x2c, 0xb2, 0xd4, 0x60, 0xc9,
  	0xd6, 0xe4, 0x79, 0x1a, 0x16, 0x81, 0xbb, 0x2e,
  	0x22, 0x2e, 0x54, 0x55, 0x8e, 0xb7, 0x8d, 0x52,
  	0x44, 0xe2, 0x17, 0xd1, 0xbf, 0xcf, 0x50, 0x58,
  /* C_18: */
  	0x8f, 0x1f, 0x57, 0xe4, 0x4e, 0x12, 0x62, 0x10,
  	0xf0, 0x07, 0x63, 0xff, 0x57, 0xda, 0x20, 0x8a,
  	0x50, 0x93, 0xb8, 0xff, 0x79, 0x47, 0x53, 0x4a,
  	0x4c, 0x26, 0x0a, 0x17, 0x64, 0x2f, 0x72, 0xb2,
  /* C_19: */
  	0xae, 0x4e, 0xf4, 0x79, 0x2e, 0xa1, 0x48, 0x60,
  	0x8c, 0xf1, 0x16, 0xcb, 0x2b, 0xff, 0x66, 0xe8,
  	0xfc, 0x74, 0x81, 0x12, 0x66, 0xcd, 0x64, 0x11,
  	0x12, 0xcd, 0x17, 0x80, 0x1e, 0xd3, 0x8b, 0x59,
  /* C_20: */
  	0x91, 0xa7, 0x44, 0xef, 0xbf, 0x68, 0xb1, 0x92,
  	0xd0, 0x54, 0x9b, 0x60, 0x8b, 0xdb, 0x31, 0x91,
  	0xfc, 0x12, 0xa0, 0xe8, 0x35, 0x43, 0xce, 0xc5,
  	0xf8, 0x82, 0x25, 0x0b, 0x24, 0x4f, 0x78, 0xe4,
  /* C_21: */
  	0x4b, 0x5d, 0x27, 0xd3, 0x36, 0x8f, 0x9c, 0x17,
  	0xd4, 0xb2, 0xa2, 0xb2, 0x16, 0xc7, 0xe7, 0x4e,
  	0x77, 0x14, 0xd2, 0xcc, 0x03, 0xe1, 0xe4, 0x45,
  	0x88, 0xcd, 0x99, 0x36, 0xde, 0x74, 0x35, 0x7c,
  /* C_22: */
  	0x0e, 0xa1, 0x7c, 0xaf, 0xb8, 0x28, 0x61, 0x31,
  	0xbd, 0xa9, 0xe3, 0x75, 0x7b, 0x36, 0x10, 0xaa,
  	0x3f, 0x77, 0xa6, 0xd0, 0x57, 0x50, 0x53, 0xfc,
  	0x92, 0x6e, 0xea, 0x7e, 0x23, 0x7d, 0xf2, 0x89,
  /* C_23: */
  	0x84, 0x8a, 0xf9, 0xf5, 0x7e, 0xb1, 0xa6, 0x16,
  	0xe2, 0xc3, 0x42, 0xc8, 0xce, 0xa5, 0x28, 0xb8,
  	0xa9, 0x5a, 0x5d, 0x16, 0xd9, 0xd8, 0x7b, 0xe9,
  	0xbb, 0x37, 0x84, 0xd0, 0xc3, 0x51, 0xc3, 0x2b,
  /* C_24: */
  	0xc0, 0x43, 0x5c, 0xc3, 0x65, 0x4f, 0xb8, 0x5d,
  	0xd9, 0x33, 0x5b, 0xa9, 0x1a, 0xc3, 0xdb, 0xde,
  	0x1f, 0x85, 0xd5, 0x67, 0xd7, 0xad, 0x16, 0xf9,
  	0xde, 0x6e, 0x00, 0x9b, 0xca, 0x3f, 0x95, 0xb5,
  /* C_25: */
  	0x92, 0x75, 0x47, 0xfe, 0x5e, 0x5e, 0x45, 0xe2,
  	0xfe, 0x99, 0xf1, 0x65, 0x1e, 0xa1, 0xcb, 0xf0,
  	0x97, 0xdc, 0x3a, 0x3d, 0x40, 0xdd, 0xd2, 0x1c,
  	0xee, 0x26, 0x05, 0x43, 0xc2, 0x88, 0xec, 0x6b,
  /* C_26: */
  	0xc1, 0x17, 0xa3, 0x77, 0x0d, 0x3a, 0x34, 0x46,
  	0x9d, 0x50, 0xdf, 0xa7, 0xdb, 0x02, 0x03, 0x00,
  	0xd3, 0x06, 0xa3, 0x65, 0x37, 0x4f, 0xa8, 0x28,
  	0xc8, 0xb7, 0x80, 0xee, 0x1b, 0x9d, 0x7a, 0x34,
  /* C_27: */
  	0x8f, 0xf2, 0x17, 0x8a, 0xe2, 0xdb, 0xe5, 0xe8,
  	0x72, 0xfa, 0xc7, 0x89, 0xa3, 0x4b, 0xc2, 0x28,
  	0xde, 0xbf, 0x54, 0xa8, 0x82, 0x74, 0x3c, 0xaa,
  	0xd1, 0x4f, 0x3a, 0x55, 0x0f, 0xdb, 0xe6, 0x8f,
  /* C_28: */
  	0xab, 0xd0, 0x6c, 0x52, 0xed, 0x58, 0xff, 0x09,
  	0x12, 0x05, 0xd0, 0xf6, 0x27, 0x57, 0x4c, 0x8c,
  	0xbc, 0x1f, 0xe7, 0xcf, 0x79, 0x21, 0x0f, 0x5a,
  	0x22, 0x86, 0xf6, 0xe2, 0x3a, 0x27, 0xef, 0xa0,
  /* C_29: */
  	0x63, 0x1f, 0x4a, 0xcb, 0x8d, 0x3c, 0xa4, 0x25,
  	0x3e, 0x30, 0x18, 0x49, 0xf1, 0x57, 0x57, 0x1d,
  	0x32, 0x11, 0xb6, 0xc1, 0x04, 0x53, 0x47, 0xbe,
  	0xfb, 0x7c, 0x77, 0xdf, 0x3c, 0x6c, 0xa7, 0xbd,
  /* C_30: */
  	0xae, 0x88, 0xf2, 0x34, 0x2c, 0x23, 0x34, 0x45,
  	0x90, 0xbe, 0x20, 0x14, 0xfa, 0xb4, 0xf1, 0x79,
  	0xfd, 0x4b, 0xf7, 0xc9, 0x0d, 0xb1, 0x4f, 0xa4,
  	0x01, 0x8f, 0xcc, 0xe6, 0x89, 0xd2, 0x12, 0x7b,
  /* C_31: */
  	0x93, 0xb8, 0x93, 0x85, 0x54, 0x6d, 0x71, 0x37,
  	0x9f, 0xe4, 0x1c, 0x39, 0xbc, 0x60, 0x2e, 0x8b,
  	0x7c, 0x8b, 0x2f, 0x78, 0xee, 0x91, 0x4d, 0x1f,
  	0x0a, 0xf0, 0xd4, 0x37, 0xa1, 0x89, 0xa8, 0xa4,
  /* C_32: */
  	0x1d, 0x1e, 0x03, 0x6a, 0xbe, 0xef, 0x3f, 0x44,
  	0x84, 0x8c, 0xd7, 0x6e, 0xf6, 0xba, 0xa8, 0x89,
  	0xfc, 0xec, 0x56, 0xcd, 0x79, 0x67, 0xeb, 0x90,
  	0x9a, 0x46, 0x4b, 0xfc, 0x23, 0xc7, 0x24, 0x35,
  /* C_33: */
  	0xa8, 0xe4, 0xed, 0xe4, 0xc5, 0xfe, 0x5e, 0x88,
  	0xd4, 0xfb, 0x19, 0x2e, 0x0a, 0x08, 0x21, 0xe9,
  	0x35, 0xba, 0x14, 0x5b, 0xbf, 0xc5, 0x9c, 0x25,
  	0x08, 0x28, 0x27, 0x55, 0xa5, 0xdf, 0x53, 0xa5,
  /* C_34: */
  	0x8e, 0x4e, 0x37, 0xa3, 0xb9, 0x70, 0xf0, 0x79,
  	0xae, 0x9d, 0x22, 0xa4, 0x99, 0xa7, 0x14, 0xc8,
  	0x75, 0x76, 0x02, 0x73, 0xf7, 0x4a, 0x93, 0x98,
  	0x99, 0x5d, 0x32, 0xc0, 0x50, 0x27, 0xd8, 0x10,
  /* C_35: */
  	0x61, 0xcf, 0xa4, 0x27, 0x92, 0xf9, 0x3b, 0x9f,
  	0xde, 0x36, 0xeb, 0x16, 0x3e, 0x97, 0x87, 0x09,
  	0xfa, 0xfa, 0x76, 0x16, 0xec, 0x3c, 0x7d, 0xad,
  	0x01, 0x35, 0x80, 0x6c, 0x3d, 0x91, 0xa2, 0x1b,
  /* C_36: */
  	0xf0, 0x37, 0xc5, 0xd9, 0x16, 0x23, 0x28, 0x8b,
  	0x7d, 0x03, 0x02, 0xc1, 0xb9, 0x41, 0xb7, 0x26,
  	0x76, 0xa9, 0x43, 0xb3, 0x72, 0x65, 0x9d, 0xcd,
  	0x7d, 0x6e, 0xf4, 0x08, 0xa1, 0x1b, 0x40, 0xc0,
  /* C_37: */
  	0x2a, 0x30, 0x63, 0x54, 0xca, 0x3e, 0xa9, 0x0b,
  	0x0e, 0x97, 0xea, 0xeb, 0xce, 0xa0, 0xa6, 0xd7,
  	0xc6, 0x52, 0x23, 0x99, 0xe8, 0x85, 0xc6, 0x13,
  	0xde, 0x82, 0x49, 0x22, 0xc8, 0x92, 0xc4, 0x90,
  /* C_38: */
  	0x3c, 0xa6, 0xcd, 0xd7, 0x88, 0xa5, 0xbd, 0xc5,
  	0xef, 0x2d, 0xce, 0xeb, 0x16, 0xbc, 0xa3, 0x1e,
  	0x0a, 0x0d, 0x2c, 0x7e, 0x99, 0x21, 0xb6, 0xf7,
  	0x1d, 0x33, 0xe2, 0x5d, 0xd2, 0xf3, 0xcf, 0x53,
  /* C_39: */
  	0xf7, 0x25, 0x78, 0x72, 0x1d, 0xb5, 0x6b, 0xf8,
  	0xf4, 0x95, 0x38, 0xb0, 0xae, 0x6e, 0xa4, 0x70,
  	0xc2, 0xfb, 0x13, 0x39, 0xdd, 0x26, 0x33, 0x3f,
  	0x13, 0x5f, 0x7d, 0xef, 0x45, 0x37, 0x6e, 0xc0,
  /* C_40: */
  	0xe4, 0x49, 0xa0, 0x3e, 0xab, 0x35, 0x9e, 0x34,
  	0x09, 0x5f, 0x8b, 0x4b, 0x55, 0xcd, 0x7a, 0xc7,
  	0xc0, 0xec, 0x65, 0x10, 0xf2, 0xc4, 0xcc, 0x79,
  	0xfa, 0x6b, 0x1f, 0xee, 0x6b, 0x18, 0xc5, 0x9e,
  /* C_41: */
  	0x73, 0xbd, 0x69, 0x78, 0xc5, 0x9f, 0x2b, 0x21,
  	0x94, 0x49, 0xb3, 0x67, 0x70, 0xfb, 0x31, 0x3f,
  	0xbe, 0x2d, 0xa2, 0x8f, 0x6b, 0x04, 0x27, 0x5f,
  	0x07, 0x1a, 0x1b, 0x19, 0x3d, 0xde, 0x20, 0x72
};
