import numpy as np
import chipwhisperer as cw
import time
import sys
import KECCAK
class Test:
  def __init__(self, FCPU = 0):
    self.log = []
    self.scope = cw.scope()
    self.scope.default_setup()
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    cw.program_target(self.scope, cw.programmers.STM32FProgrammer, "./simpleserial-sha3-CWLITEARM.hex")
    time.sleep(1)
    self.scope.io.target_pwr = False
    self.scope.dis()
    self.scope = cw.scope()
    self.scope.default_setup()
    if FCPU!=0:
      self.scope.clock.clkgen_freq = FCPU
      print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    time.sleep(1)
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    self.scope.io.target_pwr = True
    self.target = cw.target(self.scope)
    self.scope.io.target_pwr = False
    time.sleep(0.5)
    self.scope.io.target_pwr = True
    time.sleep(0.1)
    print("HELLO?", self.target.read().strip('\n'))
    return

  def test1(self, p):
    P_size = int(len(p)/2)
    #print(P_size)
    size_tag = hex(P_size%256)[2:].zfill(2)+hex(P_size>>8)[2:].zfill(2)
    #print(size_tag)
    self.target.write(("x04"+size_tag+"0000\n"))
    time.sleep(0.1)
    discard = self.target.read()
    print(discard[0:8])
    print("Plain :", p)
    N_input = int(P_size/8)
    for p_frag in range(0, (N_input+1)):
      if p_frag==N_input:
        frag = "i"+(p[(p_frag*16):].ljust(16, '0'))+"\n"
      else:
        frag = "i"+p[(p_frag*16):(p_frag*16+16)]+"\n"
      #print("Set plaintext "+frag)     
      self.target.write(frag)
      time.sleep(0.1)
      discard = self.target.read()
      #print(discard)
    self.target.write("k\n")
    print("Executing Keccak")
    time.sleep(2.0)
    discard = (self.target.read())
    cipher = ""
    for c_frag in range(0, 8):
      self.target.write("o\n")
      #print("Find out cipher part "+str(c_frag))
      time.sleep(0.1)
      cccc = self.target.read()
      #print(cccc)
      cipher += cccc[1:17]
    print("Cipher:", cipher)
    self.log.append(cipher)
    return cipher.lower()

  def log_print(self):
    for t in self.log:
      print(t)
    return

  def close(self):
    self.scope.io.target_pwr = False
    time.sleep(2)
    self.scope.io.target_pwr = True
    self.target.dis()
    self.scope.dis()
    return

if __name__=='__main__':
  FC = 5000000
  Temp = Test(FC)
  print("=====================================================================================")
  plain = "11"
  cipher = "c53ccfbba4f3c48a789117ce0971b52bd971661350e1a68c28abe7ab10572e2c48a5767431bb94b174aea1c735dd2da74690da9de5dbb6bfa32d83516e6a9314"
  own = KECCAK.SHA3_512(plain)
  print(cipher == own)
  print(cipher == Temp.test1(plain))
  print("=====================================================================================")
  plain = "00"
  cipher = "7127aab211f82a18d06cf7578ff49d5089017944139aa60d8bee057811a15fb55a53887600a3eceba004de51105139f32506fe5b53e1913bfa6b32e716fe97da"
  own = KECCAK.SHA3_512(plain)
  print(cipher == own)
  print(cipher == Temp.test1(plain))
  print("=====================================================================================")
  plain = "00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566"
  cipher = "31b7542a5d87edfb7a41bdd72717ba337cdd69467b1edc217922ff4382acbd6107c2e0181dc950bd0128cbd4796dd3bac53f106fda7df1d989f16195841920d6"
  own = KECCAK.SHA3_512(plain)
  print(cipher == own)
  print(cipher == Temp.test1(plain))
  print("=====================================================================================")
  plain = "00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff00112233445566778899aabbccddeeff0011223344556677"
  cipher = "931539ba8faedd336603a833280eeb7b3fa4f9afcb0ae0cff8cd8699b4ac1a5eab171c853a2ea1579f3f5a4918a712f4c5820e31f2d2a81ce14264b7c1f20917"
  own = KECCAK.SHA3_512(plain)
  print(cipher == own)
  print(cipher == Temp.test1(plain))
  print("=====================================================================================")
  plain = "2580d82d0d1a4868e89f706d48aa6013137fc502e8dd3c8987c2ed333146dde0f5bec88672a3484ea6678d5c6530703c152b386071fb5cbd6ad6ef4a051730fc431e21cd1dd3eb054e3562e5ea827c6786cddf2707ff77de73c3834a3dbaa3794cb333cb5b53b3428dc5a2773697cf4510bb59627f2f26676cf337e06aeef7ef4b4594d042fbf010f6da257266c8b97b240bb9505d2c8a01b618cb3a824d08643bef7a9288c679fe8eb781185007bc569859bceb84496833eaaa5a3894e67a421968ab6643f055feed003c301274898748df4439081d2135dda1f04ce1cfaba6e3d5045de23e9617780cb524be1a5a29c83e4ceca91ee7ad1c18f282d5350524dccf79012044f1aa347306e9c54ffe2055b283161e3eda536609d209efe4971b29ffdd54a546bd1e19d0ade50128c57d0345af1127120c2824739e58d4352f24b1832cc8eb917a4b3ea6978fe27b143517797f57c39b80925f19894b0e97aa4ffad5124cb0ab236ca1865ce16e43421c06d021ae5ad49f8b8fa975fe9884cc8bbcc6c9ccb8873daca8547d524a2ca4a28151c3d4c24fa1647df1d264f9db81775d4636b1fd71e397b5c304d54f61640cabcb5d577fe2dc61ea804f0978db0ad4746e73e8fa4dd1541ad63a4540add493007f8ef44f1a4e6d25001a895ada9a7ee042ff1c2a2415f95d64600117997731c07b0825"
  cipher = "93b11b6c8e96abe104c7c867904dda90d7d89c76cbaf5e7d8276b55ce3b3045e3a5d5b60ce2acb462e4bb2785149bea3e5fcfb574009069977247ef11e3e6bf4"
  own = KECCAK.SHA3_512(plain)
  print(cipher == own)
  print(cipher == Temp.test1(plain))
  #Temp.log_print()
  Temp.close()

