import numpy as np
import chipwhisperer as cw
import time
import sys
import matplotlib.pyplot as plt
class Test:
  def __init__(self, FCPU = 0):
    self.log = []
    self.Waves = []
    self.scope = cw.scope()
    self.scope.default_setup()
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    cw.program_target(self.scope, cw.programmers.STM32FProgrammer, "./simpleserial-stream-CWLITEARM.hex")
    time.sleep(1)
    self.scope.io.target_pwr = False
    self.scope.dis()
    self.scope = cw.scope()
    self.scope.default_setup()
    self.scope.adc.samples = 1000
    if FCPU!=0:
      self.scope.clock.clkgen_freq = FCPU
      print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    time.sleep(1)
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    self.scope.io.target_pwr = True
    time.sleep(1)
    self.target = cw.target(self.scope)
    return

  def test1(self, k, p):
    self.scope.io.target_pwr = False
    time.sleep(1)
    self.scope.io.target_pwr = True
    time.sleep(3)
    print(self.target.read())
    print("Key   :", k)
    self.target.write(k)
    time.sleep(0.2)
    self.target.read()
    print("Plain :", p)
    self.scope.arm()
    self.target.write(p)
    ret = self.scope.capture()
    time.sleep(1.0)
    cipher = (self.target.read()).strip('z00\n')
    print("Cipher:", cipher)
    wave = self.scope.get_last_trace()
    #plt.plot(wave)
    #plt.show()
    self.Waves.append(wave)
    self.log.append(cipher)
    return

  def log_print(self):
    for t in range(0, len(self.Waves)):
      plt.plot(self.Waves[t])
      print(self.log[t])
    plt.show()
    return

  def close(self):
    self.scope.io.target_pwr = False
    time.sleep(2)
    self.scope.io.target_pwr = True
    self.target.dis()
    self.scope.dis()
    return

if __name__=='__main__':
  try:
    FC = int(sys.argv[1])
  except:
    FC = 0
  Temp = Test(FC)
  for t in range(0, 10):
    key   = "k"+str(t).zfill(2)+"01020304050607\n"
    plain = "p"+str(t).zfill(2)+"10203040506070\n"
    Temp.test1(key, plain)
  Temp.log_print()
  Temp.close()

