/*
    This file is part of the ChipWhisperer Example Targets
    Copyright (C) 2012-2017 NewAE Technology Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "hal.h"
#include <stdint.h>
#include <stdlib.h>
#include "ascon-aead.h"
#include "internal-ascon.h"
#include "simpleserial.h"
#define BUF_LEN 160
#define KEY_SIZE 16
#define NON_SIZE 16
uint8_t Key[KEY_SIZE];
uint8_t Nonce[NON_SIZE];
uint8_t I_Buf[BUF_LEN];
uint8_t O_Buf[BUF_LEN];
uint8_t A_Buf[BUF_LEN];
static unsigned int Count_I = 0;
static unsigned int Count_O = 0;
static unsigned int Count_A = 0;
uint16_t Case = 0;
static unsigned int I_len = 0;
static unsigned int O_len = 0;
static unsigned int A_len = 0;
uint8_t Res_Buf[16];

uint8_t set_text(uint8_t* text)
{
  if(Count_I==I_len) return 0x00;
  for(int32_t i=0; i<16; i=i+1) 
  { 
    I_Buf[Count_I]=text[i];
    Count_I+=1;
    if(Count_I==I_len) return 0x00;
  }
  return 0x00;
}

uint8_t set_ad(uint8_t* ad)
{
  if(Count_A==A_len) return 0x00;
  for(int32_t i=0; i<16; i=i+1)
  {
    A_Buf[Count_A]=ad[i];
    Count_A+=1;
    if(Count_A==A_len) return 0x00;
  }
  return 0x00;
}

uint8_t set_key(uint8_t* key)
{
  {
    for(int32_t i=0; i<KEY_SIZE; i=i+1)
    {
      Key[i]=key[i];
    }
  }
  return 0x00;
}  

uint8_t set_nonce(uint8_t* nonce)
{
  for(int32_t i=0; i<NON_SIZE; i=i+1)
  {
    Nonce[i]=nonce[i];
  }
  return 0x00;
}

uint8_t Encrypt(uint8_t* e)
{
  for(int32_t i=0; i<1000000; i=i+1) asm("nop");
  if(Case==1)
  {
    trigger_high();
    ascon128_aead_encrypt(O_Buf, &O_len, I_Buf, I_len, A_Buf, A_len, Nonce, (unsigned char*)Key);
    trigger_low();
  }
  if(Case==2)
  { 
    trigger_high();  
    ascon128_aead_decrypt(O_Buf, &O_len, I_Buf, I_len, A_Buf, A_len, Nonce, (unsigned char*)Key); 
    trigger_low();
  }
  if(Case==3)
  {
    trigger_high();
    ascon128a_aead_encrypt(O_Buf, &O_len, I_Buf, I_len, A_Buf, A_len, Nonce, (unsigned char*)Key);
    trigger_low();
  }
  if(Case==4)
  { 
    trigger_high();  
    ascon128a_aead_decrypt(O_Buf, &O_len, I_Buf, I_len, A_Buf, A_len, Nonce, (unsigned char*)Key); 
    trigger_low();
  }
  for(int32_t i=0; i<100; i=i+1) asm("nop");
  return 0x00;
}

uint8_t get_response(uint8_t* r)
{ 
     for(int8_t t=0; t<16; t=t+1) 
     {
        if(Count_O==O_len)
        {
          simpleserial_put('r', t, Res_Buf);
          return 0x00;
        }
        Res_Buf[t]=O_Buf[Count_O];
        Count_O += 1;
     }
     simpleserial_put('r', 16, Res_Buf);
     return 0x00;
}

uint8_t reset(uint8_t* x)
{
     for(int32_t i=0; i<BUF_LEN; i=i+1){I_Buf[i]=0; O_Buf[i]=0; A_Buf[i]=0;}
     for(int32_t i=0; i<KEY_SIZE; i=i+1){Key[i]=0;}
     for(int32_t i=0; i<NON_SIZE; i=i+1){Nonce[i]=0;}
     for(int32_t i=0; i<16; i=i+1){Res_Buf[i]=0;}
     Count_I = 0;
     Count_O = 0;
     Count_A = 0;
     Case = x[0];
     //Case1: AEAD_128_Enc
     if(Case==1)
     {
       A_len = x[1]; A_len *= 256; A_len += x[2];
       I_len = x[3]; I_len *= 256; I_len += x[4];
       O_len = 0;
       putch('E');
       putch('N');
       putch('C');
       putch('1');
       putch('2');
       putch('8');
     }
     //Case2: AEAD_128_Dec
     else if(Case==2)
     {
       A_len = x[1]; A_len *= 256; A_len += x[2];
       I_len = x[3]; I_len *= 256; I_len += x[4];
       O_len = 0;
       putch('D');
       putch('E');
       putch('C');
       putch('1');
       putch('2');
       putch('8');
     }
     //Case3: AEAD_128a_Enc
     else if(Case==3)
     {
       A_len = x[1]; A_len *= 256; A_len += x[2];
       I_len = x[3]; I_len *= 256; I_len += x[4];
       O_len = 0;
       putch('E');
       putch('N');
       putch('C');
       putch('1');
       putch('2');
       putch('8');
       putch('A');
     }
     //Case4: AEAD_128a_Dec
     else if(Case==4)
     {
       A_len = x[1]; A_len *= 256; A_len += x[2];
       I_len = x[3]; I_len *= 256; I_len += x[4];
       O_len = 0;
       putch('D');
       putch('E');
       putch('C');
       putch('1');
       putch('2');
       putch('8');
       putch('A');
     }
     else {I_len=0; O_len=0; A_len=0;}
     return 0x00;
}

int main(void)
{
    platform_init();
	init_uart();	
	trigger_setup();
	
 	/* Uncomment this to get a HELLO message for debug */
        	
	putch('A');
	putch('E');
	putch('A');
	putch('D');	
		
	simpleserial_init();		
        simpleserial_addcmd('e', 0, Encrypt);
        simpleserial_addcmd('k', 16, set_key);
        simpleserial_addcmd('n', 16, set_nonce);
        simpleserial_addcmd('a', 16, set_ad);
	simpleserial_addcmd('i', 16, set_text);
	simpleserial_addcmd('o', 0, get_response);
        simpleserial_addcmd('x', 5, reset);

	while(1)
		simpleserial_get();
}
