/*
 * Copyright (C) 2021 Southern Storm Software, Pty Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include "internal-ascon.h"

/* Determine which versions should be accelerated with assembly code */
#if defined(__AVR__)
#define ASCON_ASM_REGULAR 1
#define ASCON_ASM_SLICED 0
#elif defined(__ARM_ARCH_ISA_THUMB) && __ARM_ARCH == 7
#define ASCON_ASM_REGULAR 1
#define ASCON_ASM_SLICED 1
#else
#define ASCON_ASM_REGULAR 0
#define ASCON_ASM_SLICED 0
#endif

#if !ASCON_ASM_REGULAR

/* (SHIH-CHUN YOU) delete the unused codes */

#endif /* !ASCON_ASM_REGULAR */

#if ASCON_SLICED && !ASCON_ASM_SLICED

/* (SHIH-CHUN YOU) delete the unused codes */

#endif /* ASCON_SLICED */
