#include "ascon-aead.h"
#include "internal-ascon.h"
#include <stdio.h>
#include <string.h>

#include "kat-128.h"

int main(void)
{
  printf("ASCON AEAD 128 Enc:\n");
  size_t klen = sizeof(Key);
  size_t nlen = sizeof(Nonce);
  size_t adlen = sizeof(AD);
  size_t mlen = sizeof(PT);
  size_t clen = sizeof(CT);
  printf("Size of Key: %ld \n", klen);
  printf("Size of Nonce: %ld \n", nlen);
  printf("Size of A. Data: %ld \n", adlen);
  printf("Size of Plaintext: %ld \n", mlen);
  printf("Size of Ciphertext: %ld \n", clen);
  printf("\n");
  uint8_t OUTPUT[200];
  uint64_t Out = 0;
  ascon128_aead_encrypt(OUTPUT, &Out, PT, mlen, AD, adlen, Nonce, Key);
  for(int t=0; t<Out; t+=1) printf("Byte # %d: %d %d\n", t, CT[t], OUTPUT[t]);
  if (memcmp(OUTPUT, CT, sizeof(CT)) != 0) {
      printf("failed\n");
      //test_exit_result = 1;
  } 
  else {
      printf("ok\n");
  }

  return 0;
}

