import time
import niscope
import numpy as np
import matplotlib.pyplot as plt

class NIScope:
  def __init__(self, numb, S_rate, Nsample):
    self.numb = numb
    self.Nsample = Nsample
    self.session = niscope.Session('scope')
    self.session.input_clock_source = "VAL_PXI_CLK"
    self.session.channels[0].configure_vertical(range=0.1, coupling=niscope.VerticalCoupling.DC)
    self.session.channels[0].input_impedance = 50
    self.session.channels[1].configure_vertical(range=10.0, coupling=niscope.VerticalCoupling.DC, probe_attenuation=1.0)
    self.session.channels[1].input_impedance = 1000000
    self.session.configure_horizontal_timing(S_rate, Nsample, 1.0, self.numb, True)
    self.session.configure_trigger_edge(trigger_source='1', level=1.4, trigger_coupling=niscope.TriggerCoupling.DC)

  def check_locked(self):
    print(self.session.input_clock_source)
    print(self.session.ref_clk_rate)
    print("Locked: ", self.session.pll_lock_status)
    print("Imp ch0:", self.session.channels[0].input_impedance)
    print("Imp ch1:", self.session.channels[1].input_impedance)
    print("Max Freq ch0:", self.session.channels[0].max_input_frequency)
    print("Max Freq ch1:", self.session.channels[1].max_input_frequency)
    print("Trigger level (ch1):", self.session.trigger_level)

  def record(self):
    with self.session.initiate():
      #self.check_locked()
      Waves = np.ndarray(self.Nsample, dtype=np.float64)
      #waveforms = self.session.channels[0].fetch(num_records = self.numb, timeout = 20.0)
      waveforms = self.session.channels[0].fetch_into(Waves, num_records = self.numb, timeout = 20.0)
      #print(len(waveforms[0].samples))
      wfm = waveforms[0]
      print('ch'+wfm.channel, 'Gain:', wfm.gain, 'Offset:', wfm.offset)
    return wfm.samples, wfm.gain, wfm.offset
  
  def close(self):
    self.session.reset()


