import time
import nifgen
from array import array

class NIFgen:
  def __init__(self):
    self.session = nifgen.Session('awg', '0', True)
    self.session.reference_clock_source = nifgen.ReferenceClockSource.PXI_CLOCK
    self.session.output_mode = nifgen.OutputMode.FUNC
    self.session.configure_standard_waveform(nifgen.Waveform.SQUARE, 3.0, 5000000, 1.5, 0.0)
    self.session.initiate()

  def check_locked(self):
    print(self.session.reference_clock_source)
    print(self.session.ref_clock_frequency)

  def close(self):
    self.session.disable()

if __name__=='__main__':
    a = NIFgen()
    a.check_locked()
    time.sleep(20)
    a.close()

