import numpy as np
import chipwhisperer as cw
import time
import sys
import random
Type_dict = {'ENC_128':'x01', 'DEC_128':'x02'}

class CW_ASCON:
  def __init__(self, Type):
    self.type = Type
    self.x_tag = Type_dict[self.type]
    self.FCPU = 5000000
    self.scope = cw.scope()
    self.scope.default_setup()
    self.scope.io.target_pwr = False
    self.scope.io.hs2 = 'disabled'
    return
  
  def init_part2(self):
    self.scope.clock.clkgen_freq = self.FCPU
    print(self.scope.clock.clkgen_mul, self.scope.clock.clkgen_div)
    time.sleep(1)
    self.scope.clock.freq_ctr_src = 'clkgen'
    time.sleep(1)
    print(self.scope.clock.freq_ctr)
    self.scope.io.target_pwr = True
    self.target = cw.target(self.scope)
    self.scope.io.target_pwr = False
    time.sleep(0.5)
    self.scope.io.target_pwr = True
    time.sleep(0.1)
    print("HELLO?", self.target.read().strip('\n'))
    Counter_init = random.randint(0, 2**64-1)
    Counter_Str = 's'+hex(Counter_init)[2:].zfill(16)+'\n'
    print('Setting Counter: '+Counter_Str[1:-1])
    self.target.write(Counter_Str)
    time.sleep(0.2)
    discard = self.target.read()
    return

  def data_write(self, data, data_len, tag):
    N_input = int(np.ceil(data_len/16))
    for fr in range(0, N_input):
      if fr==(N_input-1):
        frag = tag+(data[(fr*32):].ljust(32, '0'))+"\n"
      else:
        frag = tag+data[(fr*32):(fr*32+32)]+"\n"
      #print("Set fragment "+frag)     
      self.target.write(frag)
      time.sleep(0.2)
      discard = self.target.read()
      #print(discard)
    return

  def set_data(self, key, nonce, a_data, text):
    A_size = len(a_data)//2
    T_size = len(text)//2
    if self.type[0:3]=='ENC':
      self.O_size = T_size+16
    elif self.type[0:3]=='DEC':
      self.O_size = T_size-16
    #print("AD_SIZE =", A_size)
    #print("TEXT_SIZE =", T_size)
    size_tag = self.x_tag+hex(A_size)[2:].zfill(4)+hex(T_size)[2:].zfill(4)+"\n"
    #print(size_tag)
    self.target.write(size_tag)
    time.sleep(0.1)
    discard = self.target.read()
    #print(discard)
    #print("Key:", key)
    self.data_write(key, 16, 'k')
    #print("Nonce:", nonce)
    self.data_write(nonce, 16, 'n')
    #print("A. Data:", a_data)
    self.data_write(a_data, A_size, 'a')
    #print("Text:", text)
    self.data_write(text, T_size, 'i')
    return
  
  def execute(self):
    self.target.write("e\n")
    #print("Executing (ASCON_AEAD_128_ENC)")
    return

  def exec_done(self):
    discard = (self.target.read())
    if discard=="z00\n":
      return True
    else:
      return False
  
  def get_response(self):
    cipher = ""
    while True:
      self.target.write("o\n")
      time.sleep(0.1)
      cccc = self.target.read()
      #print(cccc)
      size_left = (2*self.O_size)-len(cipher)
      if size_left>=32:
        cipher += cccc[1:33]
      else:
        cipher += cccc[1:(size_left)+1]
      if len(cipher)==(2*self.O_size):
        break
    #print("Cipher:", cipher)
    self.target.write('c\n')
    time.sleep(0.1)
    C_str = self.target.read()[1:17].lower()
    return cipher.lower(), C_str
  
  def close(self):
    self.scope.io.target_pwr = False
    time.sleep(2)
    self.scope.io.target_pwr = True
    self.target.dis()
    self.scope.dis()
    return


