import numpy as np
import matplotlib.pyplot as plt
import sys
import h5py

def Plot(tag, TL, TU):
  print('Figure Plotting...')
  plt.figure(figsize=(30, 8))
  FILE = h5py.File('Record_CPA.hdf5', 'r')
  print(np.shape(FILE[tag]))
  for t in range(TL, TU):
    trace = FILE[tag][t,:]
    plt.plot(trace, label=('trace '+str(t)))
  plt.legend()
  plt.show()
  return

if __name__=='__main__':
  TAG = sys.argv[1] # TAG = 'traces' or 'detects'
  TL = int(sys.argv[2])
  TU = int(sys.argv[3])
  Plot(TAG,TL, TU)

